/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom;

import ancestris.core.TextOptions;
import ancestris.gedcom.GedcomDirectory;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomOptions;
import genj.gedcom.Grammar;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyDate;
import genj.gedcom.TagPath;
import genj.gedcom.time.Delta;
import genj.gedcom.time.PointInTime;
import genj.util.Resources;
import java.text.Collator;
import java.util.Locale;
import javax.swing.ImageIcon;

public class PropertyAge
extends Property {
    public static final ImageIcon IMG = Grammar.V55.getMeta(new TagPath("INDI:BIRT:AGE")).getImage();
    private Delta age = new Delta(0, 0, 0);
    private int younger_exactly_older = 0;
    private String ageAsString;
    public static String[] PHRASES = new String[]{"CHILD", "INFANT", "STILLBORN"};

    public PropertyAge(String tag) {
        super(tag);
    }

    @Override
    public boolean isValid() {
        Collator c = this.getGedcom().getCollator();
        if (this.ageAsString == null) {
            return true;
        }
        for (int i = 0; i < PHRASES.length; ++i) {
            if (c.compare(PHRASES[i], this.ageAsString) != 0) continue;
            return true;
        }
        return super.isValid();
    }

    @Override
    void afterAddNotify() {
        super.afterAddNotify();
        if (GedcomOptions.getInstance().isAddAge() && GedcomDirectory.getDefault().isGedcomRegistered(this.getGedcom())) {
            this.updateAge(false);
        }
    }

    public static String getLabelForAge() {
        return Gedcom.getName("AGE");
    }

    @Override
    public String getValue() {
        if (this.ageAsString != null) {
            return this.ageAsString;
        }
        if (this.younger_exactly_older > 0) {
            return ">" + this.age.getValue();
        }
        if (this.younger_exactly_older < 0) {
            return "<" + this.age.getValue();
        }
        return this.age.getValue();
    }

    public Delta getAge() {
        return this.age;
    }

    @Override
    public String getDisplayValue() {
        return this.getDisplayValue(null);
    }

    private String getDisplayValue(Locale locale) {
        if (this.ageAsString != null) {
            String result = locale == null ? resources.getString("prop.age." + this.ageAsString, false) : Resources.get(Gedcom.class, locale).getString("prop.age." + this.ageAsString, false);
            if (result != null) {
                return result;
            }
            return this.ageAsString;
        }
        if (this.younger_exactly_older > 0) {
            return ">" + this.age.toString(locale);
        }
        if (this.younger_exactly_older < 0) {
            return "<" + this.age.toString(locale);
        }
        return this.age.toString(locale);
    }

    @Override
    public String getReportValue() {
        return this.getDisplayValue(TextOptions.getInstance().getOutputLocale());
    }

    @Override
    public void setValue(String newValue) {
        String old = this.getValue();
        if (newValue.startsWith(">")) {
            newValue = newValue.substring(1);
            this.younger_exactly_older = 1;
        } else if (newValue.startsWith("<")) {
            newValue = newValue.substring(1);
            this.younger_exactly_older = -1;
        }
        if (newValue != null && !newValue.isEmpty() && newValue.replaceAll("[^\\d]", "").equals(newValue)) {
            newValue = newValue + "y";
        }
        this.ageAsString = this.age.setValue(newValue) ? null : newValue;
        this.propagatePropertyChanged(this, old);
    }

    public void setValue(Delta age) {
        String old = this.getValue();
        this.age.setValue(age);
        this.younger_exactly_older = 0;
        this.ageAsString = null;
        this.propagatePropertyChanged(this, old);
    }

    public static Delta getAge(Indi indi, PointInTime pit) {
        PointInTime start = PropertyAge.getEarlier(indi, null);
        return start == null || start.compareTo(pit) > 0 ? null : Delta.get(start, pit);
    }

    public static PointInTime getStartPITOfAge(Indi indi) {
        return PropertyAge.getEarlier(indi, null);
    }

    public boolean updateAge(boolean overwriteString) {
        PointInTime start = this.getEarlier();
        PointInTime end = this.getLater();
        return this.updateAge(start == null || start.compareTo(end) > 0 ? null : Delta.get(start, end), overwriteString);
    }

    public boolean updateAge(Delta delta, boolean overwriteString) {
        if (delta == null) {
            return false;
        }
        if (this.ageAsString != null && !overwriteString) {
            return false;
        }
        this.setValue(delta);
        return true;
    }

    @Override
    public int compareTo(Property other) {
        if (!this.isValid() || !other.isValid()) {
            return super.compareTo(other);
        }
        return this.age.compareTo(((PropertyAge)other).age);
    }

    public PointInTime getEarlier() {
        return PropertyAge.getEarlier(this.getEntity(), this.getParent());
    }

    public static PointInTime getEarlier(Entity e, Property parent) {
        Property p;
        if (e instanceof Fam) {
            if (parent.getTag().equals("HUSB")) {
                e = ((Fam)e).getHusband();
            }
            if (parent.getTag().equals("WIFE")) {
                e = ((Fam)e).getWife();
            }
        }
        if (!(e instanceof Indi)) {
            return null;
        }
        PropertyDate birth = ((Indi)e).getBirthDate();
        if (birth == null && TextOptions.getInstance().isUseChr() && (p = ((Indi)e).getPropertyByPath("INDI:CHR:DATE")) != null && p instanceof PropertyDate) {
            birth = (PropertyDate)p;
        }
        return birth != null ? birth.getStart() : null;
    }

    public PointInTime getLater() {
        return this.getLater(this.getParent());
    }

    public PointInTime getLater(Property parent) {
        Property prop;
        if (parent.getTag().equals("HUSB") || parent.getTag().equals("WIFE")) {
            parent = parent.getParent();
        }
        if ((prop = parent.getProperty("DATE", true)) == null) {
            return null;
        }
        if (!(prop instanceof PropertyDate)) {
            return null;
        }
        PropertyDate date = (PropertyDate)prop;
        return date != null ? date.getStart() : null;
    }
}

