/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.gedcomconversion;

import ancestris.modules.editors.gedcomconversion.GedcomVersionConverter;
import ancestris.modules.editors.gedcomconversion.ResultPanel;
import ancestris.util.swing.DialogManager;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomConstants;
import genj.gedcom.GedcomException;
import genj.gedcom.Grammar;
import genj.gedcom.Property;
import genj.gedcom.TagPath;
import genj.gedcom.UnitOfWork;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.LayoutStyle;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class ConversionPanel
extends JPanel {
    private final Gedcom gedcom;
    private final Entity header;
    private final JButton confirmButton;
    private ButtonGroup buttonGroup1;
    private JLabel encodingDescriptionLabel;
    private JLabel formatCurrentLabel;
    private JLabel formatCurrentValue;
    private JLabel formatLabel;
    private JComboBox<GedcomConstants.Encodings> formatToComboBox;
    private JLabel formatToLabel;
    private JLabel gedcomCurrentLabel;
    private JLabel gedcomCurrentValue;
    private JLabel gedcomFutureLabel;
    private JLabel gedcomLabel;
    private JRadioButton norm551Button;
    private JRadioButton norm55Button;
    private JRadioButton norm7Button;
    private JSeparator separator;

    public ConversionPanel(Gedcom gedcom) {
        this.gedcom = gedcom;
        this.header = gedcom.getFirstEntity("HEAD");
        this.confirmButton = new JButton(NbBundle.getMessage(this.getClass(), (String)"OK_button"));
        this.initComponents();
        this.norm55Button.setText("5.5");
        this.norm551Button.setText("5.5.1");
        this.norm7Button.setText("7.0.5");
        this.load();
        this.displayInfo();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.gedcomLabel = new JLabel();
        this.gedcomCurrentLabel = new JLabel();
        this.gedcomCurrentValue = new JLabel();
        this.gedcomFutureLabel = new JLabel();
        this.norm55Button = new JRadioButton();
        this.norm551Button = new JRadioButton();
        this.norm7Button = new JRadioButton();
        this.separator = new JSeparator();
        this.formatLabel = new JLabel();
        this.formatCurrentLabel = new JLabel();
        this.formatCurrentValue = new JLabel();
        this.formatToLabel = new JLabel();
        this.formatToComboBox = new JComboBox<GedcomConstants.Encodings>(GedcomConstants.Encodings.values());
        this.encodingDescriptionLabel = new JLabel();
        this.gedcomLabel.setFont(new Font("Noto Sans", 1, 12));
        Mnemonics.setLocalizedText((JLabel)this.gedcomLabel, (String)NbBundle.getMessage(ConversionPanel.class, (String)"ConversionPanel.gedcomLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.gedcomCurrentLabel, (String)NbBundle.getMessage(ConversionPanel.class, (String)"ConversionPanel.gedcomCurrentLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.gedcomCurrentValue, (String)NbBundle.getMessage(ConversionPanel.class, (String)"ConversionPanel.gedcomCurrentValue.text"));
        Mnemonics.setLocalizedText((JLabel)this.gedcomFutureLabel, (String)NbBundle.getMessage(ConversionPanel.class, (String)"ConversionPanel.gedcomFutureLabel.text"));
        this.buttonGroup1.add(this.norm55Button);
        Mnemonics.setLocalizedText((AbstractButton)this.norm55Button, (String)NbBundle.getMessage(ConversionPanel.class, (String)"ConversionPanel.norm55Button.text"));
        this.norm55Button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConversionPanel.this.norm55ButtonActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.norm551Button);
        Mnemonics.setLocalizedText((AbstractButton)this.norm551Button, (String)NbBundle.getMessage(ConversionPanel.class, (String)"ConversionPanel.norm551Button.text"));
        this.norm551Button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConversionPanel.this.norm551ButtonActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.norm7Button);
        Mnemonics.setLocalizedText((AbstractButton)this.norm7Button, (String)NbBundle.getMessage(ConversionPanel.class, (String)"ConversionPanel.norm7Button.text"));
        this.norm7Button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConversionPanel.this.norm7ButtonActionPerformed(evt);
            }
        });
        this.formatLabel.setFont(new Font("Noto Sans", 1, 12));
        Mnemonics.setLocalizedText((JLabel)this.formatLabel, (String)NbBundle.getMessage(ConversionPanel.class, (String)"ConversionPanel.formatLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.formatCurrentLabel, (String)NbBundle.getMessage(ConversionPanel.class, (String)"ConversionPanel.formatCurrentLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.formatCurrentValue, (String)NbBundle.getMessage(ConversionPanel.class, (String)"ConversionPanel.formatCurrentValue.text"));
        Mnemonics.setLocalizedText((JLabel)this.formatToLabel, (String)NbBundle.getMessage(ConversionPanel.class, (String)"ConversionPanel.formatToLabel.text"));
        this.formatToComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ConversionPanel.this.formatToComboBoxItemStateChanged(evt);
            }
        });
        this.encodingDescriptionLabel.setFont(new Font("Noto Sans", 2, 12));
        Mnemonics.setLocalizedText((JLabel)this.encodingDescriptionLabel, (String)NbBundle.getMessage(ConversionPanel.class, (String)"ConversionPanel.encodingDescriptionLabel.text"));
        this.encodingDescriptionLabel.setVerticalAlignment(1);
        this.encodingDescriptionLabel.setPreferredSize(new Dimension(220, 94));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(30, 30, 30).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.formatLabel).addComponent(this.gedcomLabel)).addGap(0, 0, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addGap(6, 6, 6).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.formatCurrentLabel).addComponent(this.gedcomCurrentLabel)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.formatCurrentValue).addComponent(this.gedcomCurrentValue)).addGap(50, 50, 50).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.formatToLabel).addGap(18, 18, 18).addComponent(this.formatToComboBox, -2, 136, -2)).addGroup(layout.createSequentialGroup().addComponent(this.gedcomFutureLabel).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.norm55Button).addComponent(this.norm7Button).addComponent(this.norm551Button)))).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.encodingDescriptionLabel, -1, -1, Short.MAX_VALUE))).addComponent(this.separator)).addGap(30, 30, 30)))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.gedcomLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.gedcomCurrentValue).addComponent(this.gedcomCurrentLabel).addComponent(this.gedcomFutureLabel))).addGroup(layout.createSequentialGroup().addGap(35, 35, 35).addComponent(this.norm55Button))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.norm551Button).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.norm7Button).addGap(17, 17, 17).addComponent(this.separator, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.formatLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.formatCurrentValue).addComponent(this.formatCurrentLabel).addComponent(this.formatToLabel).addComponent(this.formatToComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.encodingDescriptionLabel, -1, 89, Short.MAX_VALUE).addGap(30, 30, 30)));
    }

    private void formatToComboBoxItemStateChanged(ItemEvent evt) {
        this.updateOK();
        this.displayInfo();
    }

    private void norm55ButtonActionPerformed(ActionEvent evt) {
        this.updateOK();
    }

    private void norm551ButtonActionPerformed(ActionEvent evt) {
        this.updateOK();
        if (this.norm7Button.isSelected()) {
            this.formatToComboBox.setSelectedItem(GedcomConstants.Encodings.UTF8);
            this.formatToComboBox.setEnabled(false);
        } else {
            this.formatToComboBox.setEnabled(true);
        }
    }

    private void norm7ButtonActionPerformed(ActionEvent evt) {
        this.updateOK();
    }

    private void load() {
        String grammar = this.getProperty(".:GEDC:VERS");
        this.gedcomCurrentValue.setText(grammar);
        switch (grammar) {
            case "5.5": {
                this.norm55Button.setSelected(true);
                this.norm7Button.setEnabled(false);
                break;
            }
            case "5.5.1": {
                this.norm551Button.setSelected(true);
                break;
            }
            case "7.0.5": {
                this.norm7Button.setSelected(true);
                this.norm55Button.setEnabled(false);
                break;
            }
        }
        String format = this.getProperty(".:CHAR");
        this.formatCurrentValue.setText(format);
        this.formatToComboBox.setSelectedItem(format);
        this.updateOK();
    }

    private void updateOK() {
        boolean isSame1 = this.gedcomCurrentValue.getText().equals(this.getNewGrammar());
        boolean isSame2 = this.formatCurrentValue.getText().equals(String.valueOf(this.formatToComboBox.getSelectedItem()));
        this.confirmButton.setEnabled(!isSame1 || !isSame2);
    }

    private void displayInfo() {
        this.encodingDescriptionLabel.setText("<html>" + NbBundle.getMessage(this.getClass(), (String)(this.formatToComboBox.getSelectedItem().toString() + "_label")) + "</html>");
    }

    private String getNewGrammar() {
        if (this.norm55Button.isSelected()) {
            return "5.5";
        }
        if (this.norm551Button.isSelected()) {
            return "5.5.1";
        }
        if (this.norm7Button.isSelected()) {
            return "7.0.5";
        }
        return "";
    }

    private String getProperty(String tag) {
        Property prop = this.header.getPropertyByPath(tag);
        return prop != null ? prop.getValue() : "";
    }

    private void setProperty(String tag, String text) {
        text = text.trim();
        Property prop = this.header.getPropertyByPath(tag);
        if (prop == null) {
            prop = this.header.setValue(new TagPath(tag), text);
        } else {
            prop.setValue(text);
        }
    }

    public void execute() {
        Object o = DialogManager.create((String)NbBundle.getMessage(this.getClass(), (String)"TITLE_update", (Object)this.gedcom.getDisplayName()), (JComponent)this).setMessageType(-1).setOptions(new Object[]{this.confirmButton, DialogManager.CANCEL_OPTION}).setDialogId("actionConversion").show();
        if (o == this.confirmButton) {
            try {
                this.gedcom.doUnitOfWork(new UnitOfWork(){

                    public void perform(Gedcom gedcom) throws GedcomException {
                        ConversionPanel.this.commit();
                    }
                });
            }
            catch (Throwable ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    public void commit() {
        String message = NbBundle.getMessage(ConversionPanel.class, (String)"RSLT_Title");
        boolean withVersionErrors = false;
        GedcomVersionConverter versionConverter = null;
        if (!this.gedcomCurrentValue.getText().equals(this.getNewGrammar())) {
            message = message + NbBundle.getMessage(ConversionPanel.class, (String)"RSLT_VersionChanged", (Object)this.gedcomCurrentValue.getText(), (Object)this.getNewGrammar());
            Grammar toGrammar = Grammar.V551;
            if (this.norm55Button.isSelected()) {
                toGrammar = Grammar.V55;
            } else if (this.norm551Button.isSelected()) {
                toGrammar = Grammar.V551;
            } else if (this.norm7Button.isSelected()) {
                toGrammar = Grammar.v70;
            }
            if (toGrammar.equals(Grammar.v70)) {
                message = message + NbBundle.getMessage(ConversionPanel.class, (String)"RSLT_VersionNotSupported");
            } else {
                this.gedcom.setGrammar(toGrammar);
                this.setProperty(".:GEDC:VERS", this.getNewGrammar());
                versionConverter = new GedcomVersionConverter(this.gedcom, this.gedcomCurrentValue.getText(), this.getNewGrammar());
                if (versionConverter.isConvertible() && versionConverter.convert()) {
                    message = message + NbBundle.getMessage(ConversionPanel.class, (String)"RSLT_VersionSuccessChanged");
                } else {
                    message = message + NbBundle.getMessage(ConversionPanel.class, (String)"RSLT_VersionFailureChanged");
                    withVersionErrors = true;
                }
            }
            message = message + "<br>";
        }
        if (!this.formatCurrentValue.getText().equals(String.valueOf(this.formatToComboBox.getSelectedItem()))) {
            message = message + NbBundle.getMessage(ConversionPanel.class, (String)"RSLT_FormatChanged", (Object)this.formatCurrentValue.getText(), (Object)this.formatToComboBox.getSelectedItem());
            message = message + "<br>";
            GedcomConstants.Encodings format = (GedcomConstants.Encodings)this.formatToComboBox.getSelectedItem();
            this.gedcom.setEncoding(format);
            this.setProperty(".:CHAR", format.toString());
        }
        message = message + NbBundle.getMessage(ConversionPanel.class, (String)"RSLT_EndOfMessage");
        ResultPanel jPanel = new ResultPanel(message, versionConverter);
        String title = NbBundle.getMessage(ConversionPanel.class, (String)"MSG_GedcomModificationResults");
        DialogManager.create((String)title, (JComponent)jPanel).setMessageType(withVersionErrors ? 0 : 1).setOptionType(10).show();
    }
}

