/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.imports.gedcom;

import ancestris.api.imports.Import;
import ancestris.api.imports.ImportFix;
import ancestris.modules.imports.gedcom.Bundle;
import ancestris.modules.imports.gedcom.FixesWindow;
import genj.gedcom.Context;
import genj.gedcom.Gedcom;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyFamilyChild;
import java.io.IOException;
import java.util.List;

public class ImportGenbox
extends Import {
    public boolean isGeneric() {
        return false;
    }

    public String toString() {
        return Bundle.importgenbox_name();
    }

    protected String getImportComment() {
        return Bundle.importgenbox_note();
    }

    public void showDetails(Context context, boolean extract) {
        new FixesWindow(this.summary, context, this.fixes).displayFixes(extract);
    }

    protected boolean process() throws IOException {
        if (this.input.getTag().equals("AGE")) {
            String valueBefore;
            String pathBefore = this.input.getPath().getShortName();
            String valueAfter = valueBefore = this.input.getValue();
            if (valueBefore.matches("\\d+")) {
                valueAfter = valueBefore + "y";
            }
            valueAfter = valueBefore.replace(" day", "d").replace("ds", "d").replace(" month", "m").replace(" mth", "m").replace("ms", "m").replace(" yr", "y").replace("ys", "y");
            this.output.writeLine(this.input.getLevel(), this.input.getTag(), valueAfter);
            this.fixes.add(new ImportFix(this.currentXref, "section.invalidAge.1", pathBefore, pathBefore, valueBefore, valueAfter));
            return true;
        }
        return super.process();
    }

    public boolean fixGedcom(Gedcom gedcom) {
        this.fixFAMC(gedcom);
        this.incrementProgress();
        return super.fixGedcom(gedcom);
    }

    private boolean fixFAMC(Gedcom gedcom) {
        for (Indi indi : gedcom.getIndis()) {
            PropertyFamilyChild famc;
            List famcs = indi.getProperties(PropertyFamilyChild.class);
            if (famcs.size() <= 1 || (famc = (PropertyFamilyChild)indi.getProperty("FAMC")) == null) continue;
            for (PropertyFamilyChild fc : famcs) {
                if (famc.equals(fc) || !famc.getFamily().equals(fc.getFamily())) continue;
                String pathBefore = fc.getPath(true).getShortName();
                String valueBefore = fc.getValue();
                fc.getParent().delProperty((Property)fc);
                this.fixes.add(new ImportFix(indi.getId(), "duplicateAssociations.1", pathBefore, "", valueBefore, ""));
            }
        }
        return true;
    }
}

