/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.gedcomcompare.tools;

import ancestris.modules.gedcomcompare.tools.STEvent;
import ancestris.modules.gedcomcompare.tools.STFactory;
import ancestris.modules.gedcomcompare.tools.STMapCapsule;
import ancestris.modules.gedcomcompare.tools.STObject;
import ancestris.modules.gedcomcompare.tools.STPoint;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class STMap {
    private static final int SIZE = 5;
    private String name = "";
    private Map<String, STObject> stObjectMap;
    private int overlap = 0;
    private int lastCityNb = 0;
    private int eventNb = 0;
    private boolean isRemote = false;
    private boolean isComplete = true;

    public STMap() {
        this.stObjectMap = new HashMap<String, STObject>();
    }

    public STMap(STMapCapsule mapCapsule) {
        this.isRemote = true;
        this.isComplete = false;
        this.name = mapCapsule.name;
        this.stObjectMap = new HashMap<String, STObject>();
        for (String key : mapCapsule.map.keySet()) {
            ArrayList<STEvent> events = new ArrayList<STEvent>();
            STObject sto = new STObject(key, events);
            sto.setNbEvents(mapCapsule.map.get(key));
            this.stObjectMap.put(key, sto);
        }
    }

    public boolean isRemote() {
        return this.isRemote;
    }

    public boolean isComplete() {
        return this.isComplete;
    }

    void setComplete(boolean b) {
        this.isComplete = b;
    }

    public void put(String key, STObject stObject) {
        this.stObjectMap.put(key, stObject);
    }

    public STObject get(String key) {
        return this.stObjectMap.get(key);
    }

    public Set<String> keySet() {
        return this.stObjectMap.keySet();
    }

    public void setName(String set) {
        this.name = set;
    }

    public String getName() {
        return this.name;
    }

    public void setOverlap(int set) {
        this.overlap = set;
    }

    public int getOverlap() {
        return this.overlap;
    }

    public void incrementLastCityNb(int increment) {
        this.lastCityNb += increment;
    }

    public int getLastCityNb() {
        return this.lastCityNb;
    }

    public void incrementEventNb(int increment) {
        this.eventNb += increment;
    }

    public int getEventNb() {
        return this.eventNb;
    }

    public Set<STPoint> getPoints(int type) {
        HashSet<STPoint> ret = new HashSet<STPoint>();
        for (STObject o : this.stObjectMap.values()) {
            if (o.lat == 0.0 && o.lon == 0.0) continue;
            STPoint point = new STPoint(type, o.lat, o.lon, o.getTime());
            ret.add(point);
        }
        return ret;
    }

    public Object[][] getData() {
        ArrayList<Object[]> lines = new ArrayList<Object[]>();
        Object[] line = null;
        for (String key : this.stObjectMap.keySet()) {
            STObject o = this.stObjectMap.get(key);
            int l1 = o.eventsCityNames1.size();
            if (l1 == 0) continue;
            lines.add(this.getBlankLine());
            lines.add(this.getLineFromKey(key));
            for (int l = 0; l < l1; ++l) {
                line = new Object[]{"2", o.eventsCityNames1.get((int)l).city, o.eventsCityNames2.get((int)l).city, "", ""};
                lines.add(line);
                line = new Object[]{"3", this.getNamesFromArray(o.eventsCityNames1.get((int)l).lastnames), this.getNamesFromArray(o.eventsCityNames2.get((int)l).lastnames), "", ""};
                lines.add(line);
                line = new Object[]{"4", o.eventsCityNames1.get((int)l).entity, o.eventsCityNames2.get((int)l).entity, "", ""};
                lines.add(line);
                line = new Object[5];
                line[0] = "5";
                if (o.eventsCityNames1.get(l).isSame(o.eventsCityNames2.get(l))) {
                    line[0] = "6";
                }
                line[1] = o.eventsCityNames1.get(l).getDisplayEvent();
                line[2] = o.eventsCityNames2.get(l).getDisplayEvent();
                line[3] = o.eventsCityNames1.get(l).getProperty();
                line[4] = o.eventsCityNames2.get(l).getProperty();
                lines.add(line);
            }
        }
        return (Object[][])lines.toArray((T[])new Object[lines.size()][5]);
    }

    private Object[] getBlankLine() {
        Object[] line = new Object[]{"0", "", "", "", ""};
        return line;
    }

    private Object[] getLineFromKey(String key) {
        Object[] line = new Object[]{"1", STFactory.getSTDisplayValue(key), "", "", ""};
        return line;
    }

    private String getNamesFromArray(String[] names) {
        String ret = "";
        for (String str : names) {
            ret = ret + str + " ";
        }
        return ret;
    }

    public String[] getTopSpaceKeys(int length) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (String key2 : this.stObjectMap.keySet()) {
            STObject sto = this.stObjectMap.get(key2);
            String space = key2.split("-")[0];
            Integer value = (Integer)map.get(space);
            if (value == null) {
                value = 0;
            }
            value = value + sto.nbEvents;
            map.put(space, value);
        }
        Map topMap = map.entrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.reverseOrder())).limit(length).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
        ArrayList list = new ArrayList();
        topMap.keySet().forEach(key -> list.add(key + "_(" + topMap.get(key) + ")"));
        return list.toArray(new String[list.size()]);
    }

    public List<String> getAreaCityNames() {
        ArrayList<String> ret = new ArrayList<String>();
        for (String key : this.stObjectMap.keySet()) {
            STObject o = this.stObjectMap.get(key);
            int l1 = o.eventsCityNames1.size();
            if (l1 == 0) continue;
            for (int l = 0; l < l1; ++l) {
                ret.add(STFactory.getSTDisplayValue(key) + " - " + o.eventsCityNames1.get((int)l).city + ": " + this.getNamesFromArray(o.eventsCityNames1.get((int)l).lastnames));
            }
        }
        return ret;
    }
}

