/*
 * Decompiled with CFR 0.152.
 */
package genj.edit.actions;

import ancestris.view.SelectionDispatcher;
import genj.edit.actions.CreateParent;
import genj.edit.actions.CreateRelationship;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Property;
import genj.gedcom.PropertyXRef;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.openide.util.Exceptions;

public class CreateXReference
extends CreateRelationship {
    private Property source;
    private String sourceTag;
    private PropertyXRef xref;
    private static final String CREATE_XREF_ACTION_SUBMENU = "Ancestris/Actions/GedcomProperty/AddOther";

    public CreateXReference(Property source, String sourceTag) {
        this.setTargetType(CreateXReference.getTargetType(this.getSource(), sourceTag));
        this.setText(CreateXReference.getName(this.getSource(), sourceTag));
        this.sourceTag = sourceTag;
        this.setContextProperties(this.getSource());
        this.contextChanged();
    }

    private Property getSource() {
        if (this.context != null) {
            return (Property)this.context.lookup(Property.class);
        }
        return null;
    }

    private static String getTargetType(Property source, String sourceTag) {
        if (source == null) {
            return null;
        }
        try {
            Property sample = source.getMetaProperty().getNested(sourceTag, false).create("@");
            if (!(sample instanceof PropertyXRef)) {
                return null;
            }
            return ((PropertyXRef)sample).getTargetType();
        }
        catch (GedcomException e) {
            Logger.getLogger("ancestris.edit.actions").log(Level.SEVERE, "couldn't determine target type", e);
            throw new RuntimeException("Couldn't determine target type for source tag " + sourceTag);
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    private static String getName(Property source, String sourceTag) {
        String targetType = CreateXReference.getTargetType(source, sourceTag);
        if (targetType == null) {
            return "";
        }
        return resources.getString("add." + targetType.toLowerCase());
    }

    protected final void contextChanged() {
        String tgtType;
        this.source = null;
        if (this.contextProperties.size() == 1) {
            this.source = (Property)this.contextProperties.get(0);
        }
        if (this.source != null && (tgtType = CreateXReference.getTargetType(this.source, this.sourceTag)) != null) {
            this.setEnabled(true);
            this.targetType = tgtType;
            this.setText(CreateXReference.getName(this.source, this.sourceTag));
            this.setTip(resources.getString("link", new Object[]{this.getDescription()}));
            return;
        }
        this.setText(Gedcom.getName((String)this.sourceTag));
        this.setEnabled(false);
        this.setTip(null);
    }

    @Override
    public String getDescription() {
        return resources.getString("add.xref.desc", new Object[]{Gedcom.getName((String)this.targetType), this.source.getEntity().toString()});
    }

    @Override
    protected Property change(Entity target, boolean targetIsNew) throws GedcomException {
        this.xref = (PropertyXRef)this.source.addProperty(this.sourceTag, '@' + target.getId() + '@');
        try {
            this.xref.link();
            this.xref.addDefaultProperties();
        }
        catch (GedcomException e) {
            this.source.delProperty((Property)this.xref);
            this.xref = null;
            Exceptions.printStackTrace((Throwable)e);
            throw e;
        }
        if (targetIsNew && target instanceof Fam) {
            PropertyXRef prop = this.xref.getTarget();
            SwingUtilities.invokeLater(new Runnable((Property)prop){
                final /* synthetic */ Property val$prop;
                {
                    this.val$prop = property;
                }

                @Override
                public void run() {
                    new CreateParent(this.val$prop.getEntity(), 1).actionPerformed(null);
                    SelectionDispatcher.fireSelection((Context)new Context(this.val$prop));
                    new CreateParent(this.val$prop.getEntity(), 2).actionPerformed(null);
                }
            });
        }
        return targetIsNew ? this.xref.getTarget() : this.xref;
    }

    public PropertyXRef getReference() {
        return this.xref;
    }

    public static CreateXReference addFamcFactory() {
        return new CreateXReference(null, "FAMC");
    }

    public static CreateXReference addObjeFactory() {
        return new CreateXReference(null, "OBJE");
    }

    public static CreateXReference addNoteFactory() {
        return new CreateXReference(null, "NOTE");
    }

    public static CreateXReference addSourFactory() {
        return new CreateXReference(null, "SOUR");
    }

    public static CreateXReference addRepoFactory() {
        return new CreateXReference(null, "REPO");
    }

    public static CreateXReference addSubmFactory() {
        return new CreateXReference(null, "SUBM");
    }
}

