/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.familygroups;

import ancestris.modules.familygroups.FamilyGroupsOptionsPanelController;
import ancestris.modules.familygroups.OpenFamilyGroupsAction;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

final class FamilyGroupsOptionPanel
extends JPanel {
    private final FamilyGroupsOptionsPanelController controller;
    private int minMin = 1;
    private int maxMin = 100;
    private int minMax = 5;
    private int maxMax = 500;
    private JCheckBox decujusForcedCheckBox;
    private JLabel familyLimitLabel;
    private JSpinner familyLimitSpinner;
    private JCheckBox hideNoteCheckBox;
    private JLabel maxGroupSizeLabel;
    private JSpinner maxGroupSizeSpinner;
    private JLabel minGroupSizeLabel;
    private JSpinner minGroupSizeSpinner;
    private JLabel placeLimitLabel;
    private JSpinner placeLimitSpinner;
    private JCheckBox separateAssosCheckBox;

    FamilyGroupsOptionPanel(FamilyGroupsOptionsPanelController controller) {
        this.controller = controller;
        this.initComponents();
    }

    private void initComponents() {
        this.minGroupSizeLabel = new JLabel();
        this.maxGroupSizeLabel = new JLabel();
        this.minGroupSizeSpinner = new JSpinner();
        this.maxGroupSizeSpinner = new JSpinner();
        this.separateAssosCheckBox = new JCheckBox();
        this.placeLimitLabel = new JLabel();
        this.placeLimitSpinner = new JSpinner();
        this.familyLimitLabel = new JLabel();
        this.familyLimitSpinner = new JSpinner();
        this.decujusForcedCheckBox = new JCheckBox();
        this.hideNoteCheckBox = new JCheckBox();
        Mnemonics.setLocalizedText((JLabel)this.minGroupSizeLabel, (String)(NbBundle.getMessage(FamilyGroupsOptionPanel.class, (String)"FamilyGroupsOptionPanel.minGroupSizeLabel.text") + " (" + this.minMin + "-" + this.maxMin + ")"));
        Mnemonics.setLocalizedText((JLabel)this.maxGroupSizeLabel, (String)(NbBundle.getMessage(FamilyGroupsOptionPanel.class, (String)"FamilyGroupsOptionPanel.maxGroupSizeLabel.text") + " (" + this.minMax + "-" + this.maxMax + ")"));
        this.minGroupSizeSpinner.setModel(new SpinnerNumberModel(2, this.minMin, this.maxMin, 1));
        this.minGroupSizeSpinner.setToolTipText(NbBundle.getMessage(FamilyGroupsOptionPanel.class, (String)"FamilyGroupsOptionPanel.minGroupSizeFormattedTextField.toolTipText"));
        this.maxGroupSizeSpinner.setModel(new SpinnerNumberModel(20, this.minMax, this.maxMax, 5));
        this.maxGroupSizeSpinner.setToolTipText(NbBundle.getMessage(FamilyGroupsOptionPanel.class, (String)"FamilyGroupsOptionPanel.maxGroupSizeFormattedTextField.toolTipText"));
        Mnemonics.setLocalizedText((AbstractButton)this.separateAssosCheckBox, (String)NbBundle.getMessage(FamilyGroupsOptionPanel.class, (String)"FamilyGroupsOptionPanel.separateAssosCheckBox.text"));
        Mnemonics.setLocalizedText((JLabel)this.placeLimitLabel, (String)NbBundle.getMessage(FamilyGroupsOptionPanel.class, (String)"FamilyGroupsOptionPanel.placeLimitLabel.text"));
        this.placeLimitSpinner.setModel(new SpinnerNumberModel((Number)10, Integer.valueOf(0), null, (Number)1));
        Mnemonics.setLocalizedText((JLabel)this.familyLimitLabel, (String)NbBundle.getMessage(FamilyGroupsOptionPanel.class, (String)"FamilyGroupsOptionPanel.familyLimitLabel.text"));
        this.familyLimitSpinner.setModel(new SpinnerNumberModel((Number)10, Integer.valueOf(0), null, (Number)1));
        Mnemonics.setLocalizedText((AbstractButton)this.decujusForcedCheckBox, (String)NbBundle.getMessage(FamilyGroupsOptionPanel.class, (String)"FamilyGroupsOptionPanel.decujusForcedCheckBox.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.hideNoteCheckBox, (String)NbBundle.getMessage(FamilyGroupsOptionPanel.class, (String)"FamilyGroupsOptionPanel.hideNoteCheckBox.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.maxGroupSizeLabel).addComponent(this.minGroupSizeLabel).addComponent(this.placeLimitLabel).addComponent(this.familyLimitLabel)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.maxGroupSizeSpinner, -1, 104, Short.MAX_VALUE).addComponent(this.minGroupSizeSpinner, -1, 104, Short.MAX_VALUE).addComponent(this.placeLimitSpinner).addComponent(this.familyLimitSpinner)).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.separateAssosCheckBox, -1, 546, Short.MAX_VALUE)).addContainerGap()).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.decujusForcedCheckBox).addComponent(this.hideNoteCheckBox)).addGap(0, 0, Short.MAX_VALUE)))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.minGroupSizeLabel).addComponent(this.minGroupSizeSpinner, -2, 28, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.maxGroupSizeLabel).addComponent(this.maxGroupSizeSpinner, -2, 28, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.placeLimitSpinner, -2, 28, -2).addComponent(this.placeLimitLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.familyLimitLabel).addComponent(this.familyLimitSpinner, -2, 28, -2)).addGap(18, 18, 18).addComponent(this.separateAssosCheckBox).addGap(18, 18, 18).addComponent(this.decujusForcedCheckBox).addGap(18, 18, 18).addComponent(this.hideNoteCheckBox).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private int getMin(boolean pref) {
        int min;
        try {
            min = pref ? Integer.valueOf(NbPreferences.forModule(OpenFamilyGroupsAction.class).get("minGroupSize", "2")).intValue() : ((Integer)this.minGroupSizeSpinner.getValue()).intValue();
            if (min > this.maxMin) {
                min = this.maxMin;
            }
            if (min < this.minMin) {
                min = this.minMin;
            }
        }
        catch (Exception e) {
            min = 2;
        }
        return min;
    }

    private int getMax(boolean pref) {
        int max;
        try {
            max = pref ? Integer.valueOf(NbPreferences.forModule(OpenFamilyGroupsAction.class).get("maxGroupSize", "20")).intValue() : ((Integer)this.maxGroupSizeSpinner.getValue()).intValue();
            if (max > this.maxMax) {
                max = this.maxMax;
            }
            if (max < this.minMax) {
                max = this.minMax;
            }
        }
        catch (Exception e) {
            max = 20;
        }
        return max;
    }

    public void load() {
        int min = this.getMin(true);
        int max = this.getMax(true);
        if (max < min) {
            this.maxGroupSizeSpinner.setValue((int)((Integer)this.minGroupSizeSpinner.getValue()));
        }
        this.minGroupSizeSpinner.setValue(min);
        this.maxGroupSizeSpinner.setValue(max);
        this.placeLimitSpinner.setValue(Integer.valueOf(NbPreferences.forModule(OpenFamilyGroupsAction.class).get("placeListLimit", "10")));
        this.familyLimitSpinner.setValue(Integer.valueOf(NbPreferences.forModule(OpenFamilyGroupsAction.class).get("familyListLimit", "10")));
        this.separateAssosCheckBox.setSelected(NbPreferences.forModule(OpenFamilyGroupsAction.class).getBoolean("separateAssos", false));
        this.decujusForcedCheckBox.setSelected(NbPreferences.forModule(OpenFamilyGroupsAction.class).getBoolean("decujusForced", false));
        this.hideNoteCheckBox.setSelected(NbPreferences.forModule(OpenFamilyGroupsAction.class).getBoolean("hideNote", false));
    }

    public void store() {
        int min = this.getMin(false);
        int max = this.getMax(false);
        if (max < min) {
            this.maxGroupSizeSpinner.setValue(min);
        }
        NbPreferences.forModule(FamilyGroupsOptionPanel.class).put("minGroupSize", String.valueOf(min));
        NbPreferences.forModule(FamilyGroupsOptionPanel.class).put("maxGroupSize", String.valueOf(max));
        NbPreferences.forModule(FamilyGroupsOptionPanel.class).put("placeListLimit", String.valueOf(this.placeLimitSpinner.getValue()));
        NbPreferences.forModule(FamilyGroupsOptionPanel.class).put("familyListLimit", String.valueOf(this.familyLimitSpinner.getValue()));
        NbPreferences.forModule(FamilyGroupsOptionPanel.class).putBoolean("separateAssos", this.separateAssosCheckBox.isSelected());
        NbPreferences.forModule(FamilyGroupsOptionPanel.class).putBoolean("decujusForced", this.decujusForcedCheckBox.isSelected());
        NbPreferences.forModule(FamilyGroupsOptionPanel.class).putBoolean("hideNote", this.hideNoteCheckBox.isSelected());
    }

    public boolean valid() {
        return (Integer)this.maxGroupSizeSpinner.getValue() >= (Integer)this.minGroupSizeSpinner.getValue();
    }
}

