/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.standard.tools;

import ancestris.modules.editors.standard.tools.Utils;
import genj.gedcom.AbstractNote;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.GedcomException;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyNote;
import genj.gedcom.PropertySharedNote;
import genj.gedcom.PropertyXRef;
import genj.renderer.MediaUtils;
import org.openide.util.Exceptions;

public class NoteWrapper {
    private boolean recordType = true;
    private Property hostingProperty = null;
    private Entity targetNote = null;
    private String text = "";

    public NoteWrapper(Property property) {
        if (property == null) {
            return;
        }
        this.hostingProperty = property;
        if (this.hostingProperty instanceof PropertyNote) {
            PropertyNote pnote = (PropertyNote)property;
            this.recordType = true;
            this.targetNote = (AbstractNote)pnote.getTargetEntity().get();
            this.setText(this.targetNote.getValue());
        } else if (this.hostingProperty instanceof PropertySharedNote) {
            PropertySharedNote pnote = (PropertySharedNote)property;
            this.recordType = true;
            this.targetNote = (AbstractNote)pnote.getTargetEntity().get();
            this.setText(this.targetNote.getValue());
        } else {
            this.recordType = false;
            this.targetNote = this.hostingProperty.getEntity();
            this.setText(property.getValue());
        }
    }

    public NoteWrapper(AbstractNote entity) {
        if (entity == null) {
            return;
        }
        this.recordType = true;
        this.targetNote = entity;
        this.setText(this.targetNote.getValue());
    }

    public NoteWrapper(String text) {
        this.setText(text);
    }

    public Property getHostingProperty() {
        return this.hostingProperty;
    }

    public void setHostingProperty(Property property) {
        this.hostingProperty = property;
    }

    public void update(Property mainProp) {
        String oldText;
        if (this.hostingProperty == null) {
            if (this.text.isEmpty()) {
                return;
            }
            try {
                if (this.targetNote == null) {
                    this.targetNote = mainProp.getGedcom().createEntity(mainProp.isGrammar7() ? "SNOTE" : "NOTE");
                }
                mainProp.addNote((AbstractNote)this.targetNote);
                Utils.setDistinctValue((Property)this.targetNote, this.text);
            }
            catch (GedcomException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            return;
        }
        Entity entity = this.hostingProperty.getEntity();
        String string = oldText = this.recordType ? this.targetNote.getValue() : this.hostingProperty.getValue();
        if (this.text.equals(oldText)) {
            return;
        }
        if ((entity instanceof Indi || entity instanceof Fam) && !(this.hostingProperty instanceof PropertyNote) && !(this.hostingProperty instanceof PropertySharedNote)) {
            Utils.setDistinctValue(this.hostingProperty, this.text);
        } else {
            try {
                if (this.targetNote == null) {
                    this.targetNote = mainProp.getGedcom().createEntity(mainProp.isGrammar7() ? "SNOTE" : "NOTE");
                }
            }
            catch (GedcomException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            if ((entity instanceof Indi || entity instanceof Fam) && this.hostingProperty instanceof PropertyNote) {
                Utils.setDistinctValue((Property)this.targetNote, this.text);
                PropertyNote pnote = (PropertyNote)this.hostingProperty;
                AbstractNote tne = pnote.getTargetEntity().orElse(null);
                if (!this.targetNote.equals(tne)) {
                    MediaUtils.replaceRef((PropertyXRef)pnote, (Entity)tne, (Entity)this.targetNote);
                }
            } else if ((entity instanceof Indi || entity instanceof Fam) && this.hostingProperty instanceof PropertySharedNote) {
                Utils.setDistinctValue((Property)this.targetNote, this.text);
                PropertySharedNote pnote = (PropertySharedNote)this.hostingProperty;
                AbstractNote tne = pnote.getTargetEntity().orElse(null);
                if (!this.targetNote.equals(tne)) {
                    MediaUtils.replaceRef((PropertyXRef)pnote, (Entity)tne, (Entity)this.targetNote);
                }
            } else if (entity instanceof AbstractNote) {
                Utils.setDistinctValue((Property)this.targetNote, this.text);
            }
        }
    }

    public void remove() {
        if (this.hostingProperty == null) {
            return;
        }
        this.hostingProperty.getParent().delProperty(this.hostingProperty);
    }

    public boolean isRecord() {
        return this.recordType;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String str) {
        this.text = str;
    }

    public void setTargetEntity(AbstractNote entity) {
        this.targetNote = entity;
    }

    public Entity getTargetNote() {
        return this.targetNote;
    }
}

