/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom;

import genj.gedcom.Property;
import java.util.Comparator;
import org.openide.util.Parameters;

public interface PropertyComparator2<P extends Property>
extends Comparator<P> {
    public String getSortGroup(P var1);

    public static class Default<P extends Property>
    implements PropertyComparator2<P> {
        private static final Default INSTANCE = new Default();

        public static PropertyComparator2 getInstance() {
            return INSTANCE;
        }

        @Override
        public int compare(P p1, P p2) {
            Parameters.notNull((CharSequence)"p1", p1);
            Parameters.notNull((CharSequence)"p2", p2);
            return ((Property)p1).getGedcom().getCollator().compare(((Property)p1).getDisplayValue(), ((Property)p2).getDisplayValue());
        }

        int compareNull(Property p1, Property p2) {
            if (p1 == p2) {
                return 0;
            }
            if (p1 == null) {
                return -1;
            }
            if (p2 == null) {
                return 1;
            }
            return Integer.MAX_VALUE;
        }

        @Override
        public String getSortGroup(P p) {
            return this.shortcut(((Property)p).getDisplayValue(), 1);
        }

        protected String shortcut(String s, int n) {
            if (s == null) {
                return "";
            }
            if ((s = s.trim()).isEmpty()) {
                return "";
            }
            return s.substring(0, Math.min(n, s.length()));
        }
    }
}

