/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.aries.panels;

import ancestris.modules.editors.aries.models.MultiMediaObjectsTableModel;
import ancestris.modules.editors.aries.table.EditorTable;
import ancestris.modules.editors.aries.utilities.AriesFilterPanel;
import ancestris.modules.editors.aries.utilities.FilterToolBar;
import genj.gedcom.Media;
import genj.gedcom.Property;
import genj.util.Registry;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.RowFilter;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;

public class MultimediaObjectTablePanel
extends JPanel
implements AriesFilterPanel {
    private final MultiMediaObjectsTableModel mMultiMediaObjectsTableModel = new MultiMediaObjectsTableModel();
    private final TableRowSorter<TableModel> objetTableSorter;
    private Registry registry = null;
    private JScrollPane MultimediaObjectTableScrollPane;
    private FilterToolBar filterToolBar;
    private EditorTable multimediaObjectsTable;

    public MultimediaObjectTablePanel(Property root, List<Media> multimediaObjectsList) {
        this.initComponents();
        this.registry = root.getGedcom().getRegistry();
        this.mMultiMediaObjectsTableModel.addAll(multimediaObjectsList);
        this.multimediaObjectsTable.setID(MultimediaObjectTablePanel.class.getName());
        this.objetTableSorter = new TableRowSorter<TableModel>(this.multimediaObjectsTable.getModel());
        this.loadSettings();
        this.multimediaObjectsTable.setRowSorter(this.objetTableSorter);
    }

    @Override
    public void saveFilterSettings() {
        StringBuilder sb = new StringBuilder();
        List<RowSorter.SortKey> sortKeys = this.objetTableSorter.getSortKeys();
        for (int i = 0; i < sortKeys.size(); ++i) {
            RowSorter.SortKey sk = sortKeys.get(i);
            sb.append(sk.getColumn());
            sb.append(',');
            sb.append(sk.getSortOrder().toString());
            sb.append(';');
        }
        this.registry.put("Aries.MObjectSortOrder", sb.toString());
    }

    private void loadSettings() {
        String sortOrder = this.registry.get("Aries.MObjectSortOrder", "");
        if ("".equals(sortOrder)) {
            return;
        }
        ArrayList<RowSorter.SortKey> sorts = new ArrayList<RowSorter.SortKey>();
        for (String columnInfo : sortOrder.split(";")) {
            String[] column = columnInfo.split(",");
            RowSorter.SortKey sk = new RowSorter.SortKey(Integer.valueOf(column[0]), SortOrder.valueOf(column[1]));
            sorts.add(sk);
        }
        if (sorts.size() > 0) {
            this.objetTableSorter.setSortKeys(sorts);
        }
    }

    private void initComponents() {
        this.filterToolBar = new FilterToolBar(this);
        this.MultimediaObjectTableScrollPane = new JScrollPane();
        this.multimediaObjectsTable = new EditorTable();
        this.multimediaObjectsTable.setModel(this.mMultiMediaObjectsTableModel);
        this.multimediaObjectsTable.setSelectionBackground(new Color(89, 142, 195));
        this.MultimediaObjectTableScrollPane.setViewportView(this.multimediaObjectsTable);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.MultimediaObjectTableScrollPane, GroupLayout.Alignment.TRAILING, -1, 539, Short.MAX_VALUE).addComponent(this.filterToolBar, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.filterToolBar, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.MultimediaObjectTableScrollPane, -1, 155, Short.MAX_VALUE)));
    }

    public Media getSelectedMultiMediaObject() {
        int selectedRow = this.multimediaObjectsTable.getSelectedRow();
        if (selectedRow != -1) {
            int rowIndex = this.multimediaObjectsTable.convertRowIndexToModel(selectedRow);
            return this.mMultiMediaObjectsTableModel.getValueAt(rowIndex);
        }
        return null;
    }

    @Override
    public ComboBoxModel<String> getComboBoxModel() {
        return new DefaultComboBoxModel<String>(this.mMultiMediaObjectsTableModel.getColumnsName());
    }

    @Override
    public void filter(int index, String searchFilter) {
        RowFilter rf;
        try {
            rf = RowFilter.regexFilter("(?i)" + searchFilter, index);
        }
        catch (PatternSyntaxException e) {
            return;
        }
        this.objetTableSorter.setRowFilter(rf);
    }
}

