/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer;

import java.lang.reflect.InvocationTargetException;
import java.util.Locale;
import org.eclipse.osgi.util.NLS;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.model.task.DBTTaskExecutionListener;
import org.jkiss.dbeaver.tools.transfer.DataTransferPipe;
import org.jkiss.dbeaver.tools.transfer.DataTransferSettings;
import org.jkiss.dbeaver.tools.transfer.IDataTransferConsumer;
import org.jkiss.dbeaver.tools.transfer.IDataTransferProcessor;
import org.jkiss.dbeaver.tools.transfer.IDataTransferProducer;
import org.jkiss.dbeaver.tools.transfer.IDataTransferSettings;
import org.jkiss.dbeaver.tools.transfer.internal.DTMessages;
import org.jkiss.utils.CommonUtils;

public class DataTransferJob
implements DBRRunnableWithProgress {
    private DataTransferSettings settings;
    private DBTTask task;
    private long elapsedTime;
    private boolean hasErrors;
    private Locale locale;
    private Log log;
    private DBTTaskExecutionListener listener;

    public DataTransferJob(DataTransferSettings settings, DBTTask task, Locale locale, Log log, DBTTaskExecutionListener listener) {
        this.settings = settings;
        this.task = task;
        this.locale = locale;
        this.log = log;
        this.listener = listener;
    }

    public DataTransferSettings getSettings() {
        return this.settings;
    }

    public long getElapsedTime() {
        return this.elapsedTime;
    }

    public boolean isHasErrors() {
        return this.hasErrors;
    }

    public void run(DBRProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        DataTransferPipe transferPipe;
        monitor.beginTask("Perform data transfer", 1);
        this.hasErrors = false;
        long startTime = System.currentTimeMillis();
        while (!monitor.isCanceled() && (transferPipe = this.settings.acquireDataPipe(monitor)) != null) {
            try {
                if (this.transferData(monitor, transferPipe)) continue;
                this.hasErrors = true;
            }
            catch (Exception e) {
                this.listener.subTaskFinished((Throwable)e);
                throw new InvocationTargetException(e);
            }
        }
        monitor.done();
        this.listener.subTaskFinished(null);
        this.elapsedTime = System.currentTimeMillis() - startTime;
    }

    private boolean transferData(DBRProgressMonitor monitor, DataTransferPipe transferPipe) throws Exception {
        IDataTransferProducer producer = transferPipe.getProducer();
        IDataTransferConsumer consumer = transferPipe.getConsumer();
        monitor.beginTask(NLS.bind((String)DTMessages.data_transfer_wizard_job_container_name, (Object)CommonUtils.truncateString((String)producer.getObjectName(), (int)200), (Object)CommonUtils.truncateString((String)consumer.getObjectName(), (int)200)), 1);
        IDataTransferSettings nodeSettings = this.settings.getNodeSettings(this.settings.getProducer());
        try {
            IDataTransferProcessor processor = this.settings.getProcessor() == null ? null : this.settings.getProcessor().getInstance();
            try {
                producer.transferData(monitor, consumer, processor, nodeSettings, this.task);
            }
            finally {
                consumer.finishTransfer(monitor, false);
            }
            return true;
        }
        catch (Exception e) {
            this.log.error((Object)("Error transfering data from " + producer.getObjectName() + " to " + consumer.getObjectName()), (Throwable)e);
            throw e;
        }
        finally {
            monitor.done();
        }
    }
}

