/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry;

import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.app.DBASecureStorage;
import org.jkiss.dbeaver.model.app.DBPApplication;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.impl.app.DefaultSecureStorage;
import org.jkiss.dbeaver.registry.EclipseApplicationImpl;
import org.jkiss.dbeaver.registry.ProjectSecureStorage;

public abstract class BaseApplicationImpl
implements IApplication,
DBPApplication {
    private static final Log log = Log.getLog(BaseApplicationImpl.class);
    private static DBPApplication INSTANCE;

    protected BaseApplicationImpl() {
        if (INSTANCE != null && !(INSTANCE instanceof EclipseApplicationImpl)) {
            log.error((Object)("Multiple application instances created: " + INSTANCE.getClass().getName() + ", " + this.getClass().getName()));
        }
        INSTANCE = this;
    }

    public static DBPApplication getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new EclipseApplicationImpl();
        }
        return INSTANCE;
    }

    public boolean isStandalone() {
        return true;
    }

    public boolean isPrimaryInstance() {
        return true;
    }

    public boolean isHeadlessMode() {
        return false;
    }

    public boolean isExclusiveMode() {
        return false;
    }

    @NotNull
    public DBASecureStorage getSecureStorage() {
        return DefaultSecureStorage.INSTANCE;
    }

    @NotNull
    public DBASecureStorage getProjectSecureStorage(DBPProject project) {
        return new ProjectSecureStorage(project);
    }

    public String getInfoDetails() {
        return "N/A";
    }

    public long getLastUserActivityTime() {
        return -1L;
    }

    public Object start(IApplicationContext context) throws Exception {
        return EXIT_OK;
    }

    public void stop() {
    }
}

