/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry;

import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceOrigin;
import org.jkiss.dbeaver.model.DBPDataSourceOriginProvider;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.auth.DBASessionContext;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.registry.DataSourceOriginLocal;
import org.jkiss.dbeaver.registry.DataSourceProviderRegistry;

class DataSourceOriginLazy
implements DBPDataSourceOrigin {
    private String originId;
    private Map<String, Object> originProperties;

    public DataSourceOriginLazy(String originId, Map<String, Object> originProperties) {
        this.originId = originId;
        this.originProperties = originProperties;
    }

    @NotNull
    public String getType() {
        return this.originId;
    }

    @Nullable
    public String getSubType() {
        return null;
    }

    @NotNull
    public String getDisplayName() {
        return this.originId;
    }

    @Nullable
    public DBPImage getIcon() {
        return DBIcon.TYPE_UNKNOWN;
    }

    public boolean isDynamic() {
        return false;
    }

    @NotNull
    public Map<String, Object> getConfiguration() {
        return this.originProperties;
    }

    @Nullable
    public DBPObject getObjectDetails(@NotNull DBRProgressMonitor monitor, @NotNull DBASessionContext sessionContext, @NotNull DBPDataSourceContainer dataSource) throws DBException {
        return this.resolveRealOrigin().getObjectDetails(monitor, sessionContext, (Object)dataSource);
    }

    public String toString() {
        return this.getType();
    }

    @NotNull
    DBPDataSourceOrigin resolveRealOrigin() {
        DBPDataSourceOrigin origin = null;
        DBPDataSourceOriginProvider originProvider = DataSourceProviderRegistry.getInstance().getDataSourceOriginProvider(this.originId);
        if (originProvider != null) {
            origin = originProvider.getOrigin(this.originProperties);
        }
        if (origin == null) {
            origin = DataSourceOriginLocal.INSTANCE;
        }
        return origin;
    }
}

