/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.ocient.model.plan;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ext.ocient.model.plan.OcientExecutionPlan;
import org.jkiss.dbeaver.ext.ocient.model.plan.OcientPlanNodeJson;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.plan.DBCPlan;
import org.jkiss.dbeaver.model.exec.plan.DBCPlanNode;
import org.jkiss.dbeaver.model.exec.plan.DBCPlanStyle;
import org.jkiss.dbeaver.model.exec.plan.DBCQueryPlanner;
import org.jkiss.dbeaver.model.exec.plan.DBCQueryPlannerConfiguration;
import org.jkiss.dbeaver.model.exec.plan.DBCQueryPlannerSerialInfo;
import org.jkiss.dbeaver.model.impl.plan.AbstractExecutionPlanSerializer;
import org.jkiss.dbeaver.model.impl.plan.ExecutionPlanDeserializer;
import org.jkiss.utils.CommonUtils;

public class OcientQueryPlaner
extends AbstractExecutionPlanSerializer
implements DBCQueryPlanner {
    private final DBPDataSource dataSource;

    public OcientQueryPlaner(DBPDataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DBPDataSource getDataSource() {
        return this.dataSource;
    }

    @NotNull
    public DBCPlan planQueryExecution(@NotNull DBCSession session, @NotNull String query, @NotNull DBCQueryPlannerConfiguration configuration) throws DBCException {
        OcientExecutionPlan plan = new OcientExecutionPlan(query);
        plan.explain(session);
        return plan;
    }

    @NotNull
    public DBCPlanStyle getPlanStyle() {
        return DBCPlanStyle.PLAN;
    }

    public void serialize(@NotNull Writer writer, @NotNull DBCPlan plan) throws IOException, InvocationTargetException {
        this.serializeJson(writer, plan, this.dataSource.getInfo().getDriverName(), new DBCQueryPlannerSerialInfo(){

            public String version() {
                return "json";
            }

            public void addNodeProperties(DBCPlanNode node, JsonObject nodeJson) {
                JsonObject attributes = new JsonObject();
                OcientPlanNodeJson jsNode = (OcientPlanNodeJson)node;
                for (Map.Entry<String, String> e : jsNode.getNodeProps().entrySet()) {
                    attributes.add(e.getKey(), (JsonElement)new JsonPrimitive(CommonUtils.notEmpty((String)e.getValue())));
                }
                nodeJson.add("attributes", (JsonElement)attributes);
            }
        });
    }

    private static Map<String, String> getNodeAttributes(JsonObject nodeObject) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        JsonObject attrs = nodeObject.getAsJsonObject("attributes");
        for (Map.Entry attr : attrs.entrySet()) {
            attributes.put((String)attr.getKey(), ((JsonElement)attr.getValue()).getAsString());
        }
        return attributes;
    }

    public DBCPlan deserialize(@NotNull Reader planData) throws IOException, InvocationTargetException {
        JsonObject jo = new JsonParser().parse(planData).getAsJsonObject();
        String query = this.getQuery(jo);
        ExecutionPlanDeserializer loader = new ExecutionPlanDeserializer();
        List rootNodes = loader.loadRoot(this.dataSource, jo, (datasource, node, parent) -> new OcientPlanNodeJson((OcientPlanNodeJson)parent, OcientQueryPlaner.getNodeAttributes(node)));
        return new OcientExecutionPlan(query, rootNodes);
    }
}

