/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.binary.pref;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.binary.HexEditControl;
import org.jkiss.dbeaver.ui.editors.binary.internal.BinaryEditorMessages;

public class HexPreferencesManager {
    private static final int itemsDisplayed = 9;
    private static final Set<Integer> scalableSizes = new TreeSet<Integer>(Arrays.asList(6, 7, 8, 9, 10, 11, 12, 13, 14, 16, 18, 22, 32, 72));
    private static final String TEXT_BOLD = BinaryEditorMessages.editor_binary_hex_font_style_bold;
    private static final String TEXT_BOLD_ITALIC = BinaryEditorMessages.editor_binary_hex_font_style_bold_italic;
    private static final String TEXT_ITALIC = BinaryEditorMessages.editor_binary_hex_font_style_italic;
    private static final String TEXT_REGULAR = BinaryEditorMessages.editor_binary_hex_font_style_regular;
    private static final String SAMPLE_TEXT = BinaryEditorMessages.editor_binary_hex_sample_text;
    private List<FontData> fontsListCurrent = null;
    private List<FontData> fontsNonScalable = null;
    private List<FontData> fontsScalable = null;
    private GC fontsGc = null;
    private Set<String> fontsRejected = null;
    private Map<String, Set<Integer>> fontsSorted = null;
    private FontData sampleFontData = null;
    private Composite composite = null;
    private Composite parent = null;
    private Text textName = null;
    private Text textStyle = null;
    private Text textSize = null;
    private org.eclipse.swt.widgets.List listFont = null;
    private org.eclipse.swt.widgets.List listStyle = null;
    private org.eclipse.swt.widgets.List listSize = null;
    private Font sampleFont = null;
    private Text sampleText = null;
    private Combo cmbByteWidth = null;
    private String defWidthValue;
    private static String[] arrDefValuetoIndex = new String[]{"4", "8", "16"};

    private static int fontStyleToInt(String styleString) {
        int style = 0;
        if (TEXT_BOLD.equals(styleString)) {
            style = 1;
        } else if (TEXT_ITALIC.equals(styleString)) {
            style = 2;
        } else if (TEXT_BOLD_ITALIC.equals(styleString)) {
            style = 3;
        }
        return style;
    }

    private static String fontStyleToString(int style) {
        switch (style) {
            case 1: {
                return TEXT_BOLD;
            }
            case 2: {
                return TEXT_ITALIC;
            }
            case 3: {
                return TEXT_BOLD_ITALIC;
            }
        }
        return TEXT_REGULAR;
    }

    HexPreferencesManager(FontData aFontData, String defWidth) {
        this.sampleFontData = aFontData;
        this.fontsSorted = new TreeMap<String, Set<Integer>>();
        this.defWidthValue = defWidth;
    }

    private void createComposite() {
        this.composite = new Composite(this.parent, 0);
        this.composite.setLayout((Layout)new GridLayout(1, true));
        Group fontGroup = UIUtils.createControlGroup((Composite)this.composite, (String)BinaryEditorMessages.editor_binary_hex_froup_font_selection, (int)3, (int)768, (int)0);
        Label label = UIUtils.createControlLabel((Composite)fontGroup, (String)BinaryEditorMessages.editor_binary_hex_label_available_fix_width_fonts);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 3;
        label.setLayoutData((Object)gridData);
        UIUtils.createControlLabel((Composite)fontGroup, (String)BinaryEditorMessages.editor_binary_hex_label_name);
        UIUtils.createControlLabel((Composite)fontGroup, (String)BinaryEditorMessages.editor_binary_hex_label_style);
        UIUtils.createControlLabel((Composite)fontGroup, (String)BinaryEditorMessages.editor_binary_hex_label_size);
        this.textName = new Text((Composite)fontGroup, 2052);
        GridData gridData4 = new GridData();
        gridData4.horizontalAlignment = 4;
        this.textName.setLayoutData((Object)gridData4);
        this.textStyle = new Text((Composite)fontGroup, 2048);
        GridData gridData5 = new GridData();
        gridData5.horizontalAlignment = 4;
        this.textStyle.setLayoutData((Object)gridData5);
        this.textStyle.setEnabled(false);
        this.textSize = new Text((Composite)fontGroup, 2048);
        GridData gridData6 = new GridData();
        gridData6.horizontalAlignment = 4;
        GC gc = new GC((Drawable)fontGroup);
        int averageCharWidth = gc.getFontMetrics().getAverageCharWidth();
        gc.dispose();
        gridData6.widthHint = averageCharWidth * 6;
        this.textSize.setLayoutData((Object)gridData6);
        this.listFont = new org.eclipse.swt.widgets.List((Composite)fontGroup, 2564);
        GridData gridData52 = new GridData();
        gridData52.heightHint = 9 * this.listFont.getItemHeight();
        gridData52.widthHint = averageCharWidth * 40;
        this.listFont.setLayoutData((Object)gridData52);
        this.listFont.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HexPreferencesManager.this.textName.setText(HexPreferencesManager.this.listFont.getSelection()[0]);
                HexPreferencesManager.this.updateSizeItemsAndGuessSelected();
                HexPreferencesManager.this.updateAndRefreshSample();
            }
        });
        this.listStyle = new org.eclipse.swt.widgets.List((Composite)fontGroup, 2052);
        GridData gridData21 = new GridData();
        gridData21.verticalAlignment = 4;
        gridData21.widthHint = averageCharWidth * TEXT_BOLD_ITALIC.length() * 2;
        this.listStyle.setLayoutData((Object)gridData21);
        this.listStyle.setItems(new String[]{TEXT_REGULAR, TEXT_BOLD, TEXT_ITALIC, TEXT_BOLD_ITALIC});
        this.listStyle.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HexPreferencesManager.this.textStyle.setText(HexPreferencesManager.this.listStyle.getSelection()[0]);
                HexPreferencesManager.this.updateAndRefreshSample();
            }
        });
        this.listSize = new org.eclipse.swt.widgets.List((Composite)fontGroup, 2564);
        GridData gridData7 = new GridData();
        gridData7.widthHint = gridData6.widthHint;
        gridData7.heightHint = gridData52.heightHint;
        this.listSize.setLayoutData((Object)gridData7);
        this.listSize.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HexPreferencesManager.this.textSize.setText(HexPreferencesManager.this.listSize.getSelection()[0]);
                HexPreferencesManager.this.updateAndRefreshSample();
            }
        });
        this.sampleText = new Text((Composite)fontGroup, 2634);
        this.sampleText.setText(SAMPLE_TEXT);
        this.sampleText.setEditable(false);
        GridData gridData8 = new GridData();
        gridData8.horizontalSpan = 3;
        gridData8.widthHint = gridData52.widthHint + gridData21.widthHint + gridData7.widthHint + 10;
        gridData8.heightHint = 50;
        gridData8.horizontalAlignment = 4;
        this.sampleText.setLayoutData((Object)gridData8);
        this.sampleText.addDisposeListener(e -> {
            if (this.sampleFont != null && !this.sampleFont.isDisposed()) {
                this.sampleFont.dispose();
            }
        });
        Group cmpByteSettings = UIUtils.createControlGroup((Composite)this.composite, (String)"Settings", (int)2, (int)768, (int)0);
        UIUtils.createControlLabel((Composite)cmpByteSettings, (String)"Default width");
        this.cmbByteWidth = new Combo((Composite)cmpByteSettings, 2048);
        this.cmbByteWidth.setItems(arrDefValuetoIndex);
        int index = Arrays.asList(arrDefValuetoIndex).indexOf(this.defWidthValue);
        this.cmbByteWidth.select(index);
    }

    String getDefWidth() {
        return this.cmbByteWidth.getText();
    }

    Composite createPreferencesPart(Composite aParent) {
        this.parent = aParent;
        this.createComposite();
        if (this.fontsSorted.size() < 1) {
            this.populateFixedCharWidthFonts();
        } else {
            this.listFont.setItems(this.fontsSorted.keySet().toArray(new String[this.fontsSorted.keySet().size()]));
            this.refreshWidgets();
        }
        return this.composite;
    }

    public FontData getFontData() {
        return new FontData(this.sampleFontData.getName(), this.sampleFontData.getHeight(), this.sampleFontData.getStyle());
    }

    private FontData getNextFontData() {
        if (this.fontsListCurrent.size() == 0) {
            this.fontsListCurrent = this.fontsScalable;
        }
        FontData aData = this.fontsListCurrent.get(0);
        this.fontsListCurrent.remove(0);
        while (this.fontsRejected.contains(aData.getName()) && this.fontsScalable.size() > 0) {
            if (this.fontsListCurrent.size() == 0) {
                this.fontsListCurrent = this.fontsScalable;
            }
            aData = this.fontsListCurrent.get(0);
            this.fontsListCurrent.remove(0);
        }
        return aData;
    }

    int getSize() {
        int size = 0;
        if (!"".equals(this.textSize.getText())) {
            try {
                size = Integer.parseInt(this.textSize.getText());
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (size == 1 || size == 2) {
            size = 3;
        }
        return size;
    }

    private void populateFixedCharWidthFonts() {
        this.fontsNonScalable = new ArrayList<FontData>(Arrays.asList(Display.getCurrent().getFontList(null, false)));
        this.fontsScalable = new ArrayList<FontData>(Arrays.asList(Display.getCurrent().getFontList(null, true)));
        if (this.fontsNonScalable.size() == 0 && this.fontsScalable.size() == 0) {
            this.fontsNonScalable = null;
            this.fontsScalable = null;
            return;
        }
        this.fontsListCurrent = this.fontsNonScalable;
        this.fontsRejected = new HashSet<String>();
        this.fontsGc = new GC((Drawable)this.parent);
        UIUtils.asyncExec(this::populateFixedCharWidthFontsAsync);
    }

    private void populateFixedCharWidthFontsAsync() {
        FontData fontData = this.getNextFontData();
        if (!this.fontsRejected.contains(fontData.getName())) {
            boolean isScalable = this.fontsListCurrent == this.fontsScalable;
            int height = 10;
            if (!isScalable) {
                height = fontData.getHeight();
            }
            Font font = new Font((Device)Display.getCurrent(), fontData.getName(), height, 0);
            this.fontsGc.setFont(font);
            int width = this.fontsGc.getAdvanceWidth(' ');
            boolean isFixedWidth = true;
            int j = 33;
            while (j < 256 && isFixedWidth) {
                if (((char)j != '.' || j == 46) && width != this.fontsGc.getAdvanceWidth((char)j)) {
                    isFixedWidth = false;
                }
                ++j;
            }
            font.dispose();
            if (isFixedWidth) {
                if (isScalable) {
                    this.fontsSorted.put(fontData.getName(), scalableSizes);
                } else {
                    Set<Integer> heights = this.fontsSorted.get(fontData.getName());
                    if (heights == null) {
                        heights = new TreeSet<Integer>();
                        this.fontsSorted.put(fontData.getName(), heights);
                    }
                    heights.add(fontData.getHeight());
                }
                if (!this.listFont.isDisposed()) {
                    this.listFont.setItems(this.fontsSorted.keySet().toArray(new String[this.fontsSorted.keySet().size()]));
                }
                this.refreshWidgets();
            } else {
                this.fontsRejected.add(fontData.getName());
            }
        }
        if (this.fontsNonScalable.size() == 0 && this.fontsScalable.size() == 0) {
            if (!this.parent.isDisposed()) {
                this.fontsGc.dispose();
            }
            this.fontsGc = null;
            this.fontsListCurrent = null;
            this.fontsScalable = null;
            this.fontsNonScalable = null;
            this.fontsRejected = null;
        } else {
            UIUtils.asyncExec(this::populateFixedCharWidthFontsAsync);
        }
    }

    private void refreshSample() {
        if (this.sampleFont != null && !this.sampleFont.isDisposed()) {
            this.sampleFont.dispose();
        }
        this.sampleFont = new Font((Device)Display.getCurrent(), this.sampleFontData);
        this.sampleText.setFont(this.sampleFont);
    }

    private void refreshWidgets() {
        if (this.composite.isDisposed() || this.textName == null) {
            return;
        }
        if (this.fontsSorted == null || !this.fontsSorted.containsKey(this.sampleFontData.getName())) {
            this.textName.setText(BinaryEditorMessages.editor_binary_hex_default_font);
        } else {
            this.textName.setText(this.sampleFontData.getName());
        }
        HexPreferencesManager.showSelected(this.listFont, this.sampleFontData.getName());
        this.textStyle.setText(HexPreferencesManager.fontStyleToString(this.sampleFontData.getStyle()));
        this.listStyle.select(this.listStyle.indexOf(HexPreferencesManager.fontStyleToString(this.sampleFontData.getStyle())));
        this.updateSizeItems();
        this.textSize.setText(Integer.toString(this.sampleFontData.getHeight()));
        HexPreferencesManager.showSelected(this.listSize, Integer.toString(this.sampleFontData.getHeight()));
        this.refreshSample();
    }

    void setFontData(FontData aFontData) {
        if (aFontData == null) {
            aFontData = HexEditControl.DEFAULT_FONT_DATA;
        }
        this.sampleFontData = aFontData;
        this.refreshWidgets();
    }

    private static void showSelected(org.eclipse.swt.widgets.List aList, String item) {
        int selected = aList.indexOf(item);
        if (selected >= 0) {
            aList.setSelection(selected);
            aList.setTopIndex(Math.max(0, selected - 9 + 1));
        } else {
            aList.deselectAll();
            aList.setTopIndex(0);
        }
    }

    private void updateAndRefreshSample() {
        this.sampleFontData = new FontData(this.textName.getText(), this.getSize(), HexPreferencesManager.fontStyleToInt(this.textStyle.getText()));
        this.refreshSample();
    }

    private void updateSizeItems() {
        Set<Integer> sizes = this.fontsSorted.get(this.textName.getText());
        if (sizes == null) {
            this.listSize.removeAll();
            return;
        }
        String[] items = new String[sizes.size()];
        int i = 0;
        Iterator<Integer> j = sizes.iterator();
        while (i < items.length) {
            items[i] = j.next().toString();
            ++i;
        }
        this.listSize.setItems(items);
    }

    private void updateSizeItemsAndGuessSelected() {
        int lastSize = this.getSize();
        this.updateSizeItems();
        int position = 0;
        String[] items = this.listSize.getItems();
        int i = 1;
        while (i < items.length) {
            if (lastSize >= Integer.parseInt(items[i])) {
                position = i;
            }
            ++i;
        }
        this.textSize.setText(items[position]);
        HexPreferencesManager.showSelected(this.listSize, items[position]);
    }
}

