/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.data.editors;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.ui.controls.CustomTimeEditor;
import org.jkiss.dbeaver.ui.data.IValueController;
import org.jkiss.dbeaver.ui.data.editors.BaseValueEditor;

public class DateTimeInlineEditor
extends BaseValueEditor<Control> {
    private CustomTimeEditor timeEditor;

    public DateTimeInlineEditor(IValueController controller) {
        super(controller);
    }

    @Override
    protected Control createControl(Composite editPlaceholder) {
        boolean inline = this.valueController.getEditType() == IValueController.EditType.INLINE;
        this.timeEditor = new CustomTimeEditor(this.valueController.getEditPlaceholder(), inline ? 2048 : 2);
        this.timeEditor.setEditable(!this.valueController.isReadOnly());
        return this.timeEditor.getControl();
    }

    @Override
    public Object extractEditorValue() throws DBException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (DBCSession session = this.valueController.getExecutionContext().openSession((DBRProgressMonitor)new VoidProgressMonitor(), DBCExecutionPurpose.UTIL, "Make datetime value from editor");){
            String strValue = this.timeEditor.getValue();
            return this.valueController.getValueHandler().getValueFromObject(session, this.valueController.getValueType(), (Object)strValue, false, false);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void primeEditorValue(@Nullable Object value) throws DBException {
        String strValue = value == null ? "" : this.valueController.getValueHandler().getValueDisplayString(this.valueController.getValueType(), value, DBDDisplayFormat.EDIT);
        this.timeEditor.setValue(strValue);
        if (this.valueController.getEditType() == IValueController.EditType.INLINE) {
            this.timeEditor.selectAll();
        }
    }
}

