/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.navigator.dialogs;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.navigator.DBNLocalFolder;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNResource;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.internal.UINavigatorMessages;
import org.jkiss.dbeaver.ui.navigator.actions.NavigatorObjectsDeleter;
import org.jkiss.utils.CommonUtils;

public class ConfirmNavigatorNodesDeleteDialog
extends MessageDialog {
    private final List<?> selectedObjects;
    private final NavigatorObjectsDeleter deleter;

    private ConfirmNavigatorNodesDeleteDialog(Shell shell, String title, String message, List<?> selectedObjects, @Nullable NavigatorObjectsDeleter deleter) {
        super(shell, title, DBeaverIcons.getImage((DBPImage)UIIcon.REJECT), message, 1, null, 0);
        this.selectedObjects = selectedObjects;
        this.deleter = deleter;
    }

    public static ConfirmNavigatorNodesDeleteDialog of(Shell shell, String title, String message, List<?> selectedObjects, NavigatorObjectsDeleter deleter) {
        return new ConfirmNavigatorNodesDeleteDialog(shell, title, message, selectedObjects, deleter);
    }

    public static ConfirmNavigatorNodesDeleteDialog of(Shell shell, List<?> selectedObjects, NavigatorObjectsDeleter deleter) {
        if (selectedObjects.size() > 1) {
            return new ConfirmNavigatorNodesDeleteDialog(shell, UINavigatorMessages.confirm_deleting_multiple_objects_title, NLS.bind((String)UINavigatorMessages.confirm_deleting_multiple_objects_message, (Object)selectedObjects.size()), selectedObjects, deleter);
        }
        DBNNode node = (DBNNode)selectedObjects.get(0);
        String title = NLS.bind((String)(node instanceof DBNLocalFolder ? UINavigatorMessages.confirm_local_folder_delete_title : UINavigatorMessages.confirm_entity_delete_title), (Object)node.getNodeType(), (Object)node.getNodeName());
        String message = NLS.bind((String)(node instanceof DBNLocalFolder ? UINavigatorMessages.confirm_local_folder_delete_message : UINavigatorMessages.confirm_entity_delete_message), (Object)node.getNodeType(), (Object)node.getNodeName());
        return new ConfirmNavigatorNodesDeleteDialog(shell, title, message, selectedObjects, deleter);
    }

    protected Control createCustomArea(Composite parent) {
        if (this.selectedObjects.size() > 1) {
            this.createObjectsTable(parent);
        }
        if (this.deleter != null) {
            this.createDeleteContents(parent);
            for (NavigatorObjectsDeleter.Option option : this.deleter.getSupportedOptions()) {
                this.createCheckbox(parent, option);
            }
        }
        return super.createCustomArea(parent);
    }

    private void createObjectsTable(Composite parent) {
        Composite placeholder = UIUtils.createComposite((Composite)parent, (int)1);
        placeholder.setLayoutData((Object)new GridData(1808));
        Group tableGroup = UIUtils.createControlGroup((Composite)placeholder, (String)UINavigatorMessages.confirm_deleting_multiple_objects_table_group_name, (int)1, (int)1808, (int)0);
        tableGroup.setLayoutData((Object)new GridData(1808));
        Table objectsTable = new Table((Composite)tableGroup, 67584);
        objectsTable.setHeaderVisible(false);
        objectsTable.setLinesVisible(true);
        GridData gd = new GridData(1808);
        int fontHeight = UIUtils.getFontHeight((Control)objectsTable);
        int rowCount = this.selectedObjects.size();
        gd.widthHint = fontHeight * 7;
        gd.heightHint = rowCount < 6 ? fontHeight * 2 * rowCount : fontHeight * 10;
        objectsTable.setLayoutData((Object)gd);
        UIUtils.createTableColumn((Table)objectsTable, (int)16384, (String)UINavigatorMessages.confirm_deleting_multiple_objects_column_name);
        UIUtils.createTableColumn((Table)objectsTable, (int)16384, (String)"Type");
        UIUtils.createTableColumn((Table)objectsTable, (int)16384, (String)UINavigatorMessages.confirm_deleting_multiple_objects_column_description);
        for (Object obj : this.selectedObjects) {
            if (!(obj instanceof DBNNode)) continue;
            DBNNode node = (DBNNode)obj;
            TableItem item = new TableItem(objectsTable, 0);
            item.setImage(DBeaverIcons.getImage((DBPImage)node.getNodeIcon()));
            if (node instanceof DBNResource && ((DBNResource)node).getResource() != null) {
                item.setText(0, node.getName());
                IResource resource = ((DBNResource)node).getResource();
                IPath resLocation = resource == null ? null : resource.getLocation();
                item.setText(1, "File");
                item.setText(2, resLocation == null ? "" : resLocation.toFile().getAbsolutePath());
                continue;
            }
            item.setText(0, node.getNodeFullName());
            item.setText(1, node.getNodeType());
            item.setText(2, CommonUtils.toString((Object)node.getNodeDescription()));
        }
        UIUtils.asyncExec(() -> UIUtils.packColumns((Table)objectsTable, (boolean)true));
    }

    private void createDeleteContents(Composite parent) {
        if (!this.deleter.supportsDeleteContents()) {
            return;
        }
        IProject project = this.deleter.getProjectToDelete();
        if (project == null) {
            return;
        }
        Composite ph = UIUtils.createPlaceholder((Composite)parent, (int)2, (int)5);
        final Button deleteContentsCheck = UIUtils.createCheckbox((Composite)ph, (String)UINavigatorMessages.confirm_deleting_delete_contents_checkbox, (String)UINavigatorMessages.confirm_deleting_delete_contents_checkbox_tooltip, (boolean)false, (int)2);
        deleteContentsCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConfirmNavigatorNodesDeleteDialog.this.deleter.setDeleteContents(deleteContentsCheck.getSelection());
            }
        });
        UIUtils.createLabelText((Composite)ph, (String)UINavigatorMessages.confirm_deleting_project_location_label, (String)project.getLocation().toFile().getAbsolutePath(), (int)8);
    }

    private void createCheckbox(Composite checkboxesComposite, final NavigatorObjectsDeleter.Option option) {
        Composite placeholder = UIUtils.createPlaceholder((Composite)checkboxesComposite, (int)1, (int)5);
        final Button checkbox = UIUtils.createCheckbox((Composite)placeholder, (String)option.getLabel(), (String)option.getTip(), (boolean)false, (int)0);
        checkbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (checkbox.getSelection()) {
                    ConfirmNavigatorNodesDeleteDialog.this.deleter.enableOption(option);
                } else {
                    ConfirmNavigatorNodesDeleteDialog.this.deleter.disableOption(option);
                }
            }
        });
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 2, IDialogConstants.YES_LABEL, false);
        this.createButton(parent, 3, IDialogConstants.NO_LABEL, true);
        if (this.deleter != null && this.deleter.supportsShowViewScript()) {
            this.createButton(parent, 13, UINavigatorMessages.actions_navigator_view_script_button, false);
        }
    }

    protected boolean isResizable() {
        return true;
    }
}

