/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.oracle.model.OracleConstants;
import org.jkiss.dbeaver.ext.oracle.model.OracleDataSource;
import org.jkiss.dbeaver.ext.oracle.model.dict.OracleConnectionType;
import org.jkiss.dbeaver.ext.oracle.oci.OCIUtils;
import org.jkiss.dbeaver.ext.oracle.oci.OracleHomeDescriptor;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPInformationProvider;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.auth.DBAUserCredentialsProvider;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.connection.DBPNativeClientLocation;
import org.jkiss.dbeaver.model.connection.DBPNativeClientLocationManager;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSourceProvider;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCURL;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.registry.DataSourceUtils;
import org.jkiss.utils.CommonUtils;

public class OracleDataSourceProvider
extends JDBCDataSourceProvider
implements DBAUserCredentialsProvider,
DBPNativeClientLocationManager,
DBPInformationProvider {
    public long getFeatures() {
        return 2L;
    }

    public String getConnectionURL(DBPDriver driver, DBPConnectionConfiguration connectionInfo) {
        OracleConstants.ConnectionType connectionType = this.getConnectionType(connectionInfo);
        if (connectionType == OracleConstants.ConnectionType.CUSTOM) {
            return JDBCURL.generateUrlByTemplate((String)connectionInfo.getUrl(), (DBPConnectionConfiguration)connectionInfo);
        }
        StringBuilder url = new StringBuilder(100);
        url.append("jdbc:oracle:thin:@");
        String databaseName = CommonUtils.notEmpty((String)connectionInfo.getDatabaseName());
        if (connectionType == OracleConstants.ConnectionType.TNS) {
            boolean checkTnsAdmin;
            File oraHomePath;
            String tnsPathProp = CommonUtils.toString((Object)connectionInfo.getProviderProperty("@dbeaver-tns-path@"));
            if (!CommonUtils.isEmpty((String)tnsPathProp)) {
                oraHomePath = new File(tnsPathProp);
                checkTnsAdmin = false;
            } else {
                String clientHomeId = connectionInfo.getClientHomeId();
                OracleHomeDescriptor oraHome = CommonUtils.isEmpty((String)clientHomeId) ? null : OCIUtils.getOraHome(clientHomeId);
                oraHomePath = oraHome == null ? null : oraHome.getPath();
                checkTnsAdmin = true;
            }
            Map<String, String> tnsNames = OCIUtils.readTnsNames(oraHomePath, checkTnsAdmin);
            String tnsDescription = tnsNames.get(databaseName);
            if (!CommonUtils.isEmpty((String)tnsDescription)) {
                url.append(tnsDescription);
            } else {
                File tnsNamesFile = OCIUtils.findTnsNamesFile(oraHomePath, checkTnsAdmin);
                if (tnsNamesFile != null && tnsNamesFile.exists()) {
                    System.setProperty("oracle.net.tns_admin", tnsNamesFile.getAbsolutePath());
                }
                url.append(databaseName);
            }
        } else {
            boolean isSID = OracleConnectionType.SID.name().equals(connectionInfo.getProviderProperty("@dbeaver-sid-service@"));
            if (!isSID) {
                url.append("//");
            }
            if (!CommonUtils.isEmpty((String)connectionInfo.getHostName())) {
                url.append(connectionInfo.getHostName());
            }
            if (!CommonUtils.isEmpty((String)connectionInfo.getHostPort())) {
                url.append(":");
                url.append(connectionInfo.getHostPort());
            }
            if (isSID) {
                url.append(":");
            } else {
                url.append("/");
            }
            if (!CommonUtils.isEmpty((String)databaseName)) {
                url.append(databaseName);
            }
        }
        return url.toString();
    }

    @NotNull
    private OracleConstants.ConnectionType getConnectionType(DBPConnectionConfiguration connectionInfo) {
        String conTypeProperty = connectionInfo.getProviderProperty("@dbeaver-connection-type@");
        OracleConstants.ConnectionType connectionType = conTypeProperty != null ? OracleConstants.ConnectionType.valueOf(CommonUtils.toString((Object)conTypeProperty)) : OracleConstants.ConnectionType.BASIC;
        return connectionType;
    }

    @NotNull
    public DBPDataSource openDataSource(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer container) throws DBException {
        return new OracleDataSource(monitor, container);
    }

    public List<DBPNativeClientLocation> findLocalClientLocations() {
        ArrayList<DBPNativeClientLocation> homeIds = new ArrayList<DBPNativeClientLocation>();
        for (OracleHomeDescriptor home : OCIUtils.getOraHomes()) {
            homeIds.add((DBPNativeClientLocation)home);
        }
        return homeIds;
    }

    public DBPNativeClientLocation getDefaultLocalClientLocation() {
        List<OracleHomeDescriptor> oraHomes = OCIUtils.getOraHomes();
        if (!oraHomes.isEmpty()) {
            return (DBPNativeClientLocation)oraHomes.get(0);
        }
        return null;
    }

    public String getProductName(DBPNativeClientLocation location) {
        Integer oraVersion = OracleDataSourceProvider.getOracleVersion(location);
        return "Oracle" + (oraVersion == null ? "" : " " + oraVersion);
    }

    public String getProductVersion(DBPNativeClientLocation location) {
        boolean isInstantClient = OCIUtils.isInstantClient(location.getName());
        return OCIUtils.getFullOraVersion(location.getName(), isInstantClient);
    }

    public static Integer getOracleVersion(DBPNativeClientLocation location) {
        File folder;
        File oraHome = location.getPath();
        boolean isInstantClient = OCIUtils.isInstantClient(location.getName());
        File file = folder = isInstantClient ? oraHome : new File(oraHome, "bin");
        if (!folder.exists()) {
            return null;
        }
        int counter = 7;
        while (counter <= 15) {
            String dllName = System.mapLibraryName("ocijdbc" + counter);
            File ociLibFile = new File(folder, dllName);
            if (ociLibFile.exists()) {
                return counter;
            }
            ++counter;
        }
        return null;
    }

    public String getConnectionUserName(@NotNull DBPConnectionConfiguration connectionInfo) {
        String userName = connectionInfo.getUserName();
        String authModelId = connectionInfo.getAuthModelId();
        if (!CommonUtils.isEmpty((String)authModelId) && !"native".equals(authModelId)) {
            return userName;
        }
        if (!CommonUtils.isEmpty((String)userName) && userName.contains(" AS ")) {
            return userName;
        }
        String role = connectionInfo.getProviderProperty("@dbeaver-internal-logon@");
        return role == null ? userName : String.valueOf(userName) + " AS " + role;
    }

    public String getConnectionUserPassword(@NotNull DBPConnectionConfiguration connectionInfo) {
        return connectionInfo.getUserPassword();
    }

    @Nullable
    public String getObjectInformation(@NotNull DBPObject object, @NotNull String infoType) {
        if (object instanceof DBPDataSourceContainer && infoType.equals("targetAddress")) {
            DBPConnectionConfiguration connectionInfo = ((DBPDataSourceContainer)object).getConnectionConfiguration();
            OracleConstants.ConnectionType connectionType = this.getConnectionType(connectionInfo);
            if (connectionType == OracleConstants.ConnectionType.CUSTOM) {
                return JDBCURL.generateUrlByTemplate((String)connectionInfo.getUrl(), (DBPConnectionConfiguration)connectionInfo);
            }
            String databaseName = CommonUtils.notEmpty((String)connectionInfo.getDatabaseName());
            if (connectionType == OracleConstants.ConnectionType.TNS) {
                return databaseName;
            }
            String hostName = DataSourceUtils.getTargetTunnelHostName((DBPConnectionConfiguration)connectionInfo);
            String hostPort = connectionInfo.getHostPort();
            if (CommonUtils.isEmpty((String)hostName)) {
                return null;
            }
            if (CommonUtils.isEmpty((String)hostPort)) {
                return hostName;
            }
            return String.valueOf(hostName) + ":" + hostPort;
        }
        return null;
    }
}

