/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mssql.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.mssql.SQLServerUtils;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerDataSource;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerDatabase;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerExecutionContext;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerObjectType;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerProcedure;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerSchema;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTable;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableCheckConstraint;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableForeignKey;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerView;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.struct.AbstractObjectReference;
import org.jkiss.dbeaver.model.impl.struct.RelationalObjectType;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectReference;
import org.jkiss.dbeaver.model.struct.DBSObjectType;
import org.jkiss.dbeaver.model.struct.DBSStructureAssistant;

public class SQLServerStructureAssistant
implements DBSStructureAssistant<SQLServerExecutionContext> {
    private final SQLServerDataSource dataSource;

    public SQLServerStructureAssistant(SQLServerDataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DBSObjectType[] getSupportedObjectTypes() {
        return new DBSObjectType[]{SQLServerObjectType.S, SQLServerObjectType.U, SQLServerObjectType.IT, SQLServerObjectType.V, SQLServerObjectType.SN, SQLServerObjectType.P, SQLServerObjectType.FN, SQLServerObjectType.FT, SQLServerObjectType.FS, SQLServerObjectType.X};
    }

    public DBSObjectType[] getSearchObjectTypes() {
        return new DBSObjectType[]{RelationalObjectType.TYPE_TABLE, RelationalObjectType.TYPE_VIEW, SQLServerObjectType.SN, RelationalObjectType.TYPE_PROCEDURE};
    }

    public DBSObjectType[] getHyperlinkObjectTypes() {
        return new DBSObjectType[]{SQLServerObjectType.S, SQLServerObjectType.U, SQLServerObjectType.IT, SQLServerObjectType.V, RelationalObjectType.TYPE_PROCEDURE};
    }

    public DBSObjectType[] getAutoCompleteObjectTypes() {
        return new DBSObjectType[]{SQLServerObjectType.U, SQLServerObjectType.V, SQLServerObjectType.P, SQLServerObjectType.FN, SQLServerObjectType.IF, SQLServerObjectType.TF, SQLServerObjectType.X};
    }

    @NotNull
    public List<DBSObjectReference> findObjectsByMask(@NotNull DBRProgressMonitor monitor, @NotNull SQLServerExecutionContext executionContext, @NotNull DBSStructureAssistant.ObjectsSearchParams params) throws DBException {
        SQLServerSchema schema;
        SQLServerDatabase database;
        DBSObject parentObject = params.getParentObject();
        SQLServerDatabase sQLServerDatabase = parentObject instanceof SQLServerDatabase ? (SQLServerDatabase)parentObject : (database = parentObject instanceof SQLServerSchema ? ((SQLServerSchema)parentObject).getDatabase() : null);
        if (database == null) {
            database = executionContext.getContextDefaults().getDefaultCatalog();
        }
        if (database == null) {
            database = executionContext.getDataSource().getDefaultDatabase(monitor);
        }
        if (database == null) {
            return Collections.emptyList();
        }
        SQLServerSchema sQLServerSchema = schema = parentObject instanceof SQLServerSchema ? (SQLServerSchema)parentObject : null;
        if (schema == null && !params.isGlobalSearch()) {
            schema = executionContext.getContextDefaults().getDefaultSchema();
        }
        Throwable throwable = null;
        Object var8_9 = null;
        try (JDBCSession session = executionContext.openSession(monitor, DBCExecutionPurpose.META, "Find objects by name");){
            ArrayList<DBSObjectReference> objects = new ArrayList<DBSObjectReference>();
            this.searchAllObjects(session, database, schema, params, objects);
            return objects;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void searchAllObjects(final JDBCSession session, final SQLServerDatabase database, SQLServerSchema schema, @NotNull DBSStructureAssistant.ObjectsSearchParams params, List<DBSObjectReference> objects) throws DBException {
        ArrayList<SQLServerObjectType> supObjectTypes = new ArrayList<SQLServerObjectType>(params.getObjectTypes().length + 2);
        DBSObjectType[] dBSObjectTypeArray = params.getObjectTypes();
        int n = dBSObjectTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            DBSObjectType objectType = dBSObjectTypeArray[n2];
            if (objectType instanceof SQLServerObjectType) {
                supObjectTypes.add((SQLServerObjectType)objectType);
            } else if (objectType == RelationalObjectType.TYPE_PROCEDURE) {
                supObjectTypes.addAll(SQLServerObjectType.getTypesForClass(SQLServerProcedure.class));
            } else if (objectType == RelationalObjectType.TYPE_TABLE) {
                supObjectTypes.addAll(SQLServerObjectType.getTypesForClass(SQLServerTable.class));
            } else if (objectType == RelationalObjectType.TYPE_CONSTRAINT) {
                supObjectTypes.addAll(SQLServerObjectType.getTypesForClass(SQLServerTableCheckConstraint.class));
                supObjectTypes.addAll(SQLServerObjectType.getTypesForClass(SQLServerTableForeignKey.class));
            } else if (objectType == RelationalObjectType.TYPE_VIEW) {
                supObjectTypes.addAll(SQLServerObjectType.getTypesForClass(SQLServerView.class));
            }
            ++n2;
        }
        if (supObjectTypes.isEmpty()) {
            return;
        }
        StringBuilder objectTypeClause = new StringBuilder(100);
        for (SQLServerObjectType objectType : supObjectTypes) {
            if (objectTypeClause.length() > 0) {
                objectTypeClause.append(",");
            }
            objectTypeClause.append("'").append(objectType.getTypeID()).append("'");
        }
        if (objectTypeClause.length() == 0) {
            return;
        }
        StringBuilder sql = new StringBuilder("SELECT TOP ").append(params.getMaxResults() - objects.size()).append(" * FROM ").append(SQLServerUtils.getSystemTableName(database, "all_objects")).append(" o ");
        if (params.isSearchInComments()) {
            sql.append("LEFT JOIN sys.extended_properties ep ON ((o.parent_object_id = 0 AND ep.minor_id = 0 AND o.object_id = ep.major_id) OR (o.parent_object_id <> 0 AND ep.minor_id = o.parent_object_id AND ep.major_id = o.object_id)) ");
        }
        sql.append("WHERE o.type IN (").append(objectTypeClause.toString()).append(") AND ");
        if (params.isSearchInComments()) {
            sql.append("(");
        }
        sql.append("o.name LIKE ? ");
        if (params.isSearchInComments()) {
            sql.append("OR (ep.name = 'MS_Description' AND CAST(ep.value AS nvarchar) LIKE ?)) ");
        }
        if (schema != null) {
            sql.append("AND o.schema_id = ? ");
        }
        sql.append("ORDER BY o.name");
        try {
            Object object = null;
            dBSObjectTypeArray = null;
            try (JDBCPreparedStatement dbStat = session.prepareStatement(sql.toString());){
                dbStat.setString(1, params.getMask());
                int schemaIdIdx = 2;
                if (params.isSearchInComments()) {
                    dbStat.setString(2, params.getMask());
                    ++schemaIdIdx;
                }
                if (schema != null) {
                    dbStat.setLong(schemaIdIdx, schema.getObjectId());
                }
                dbStat.setFetchSize(1000);
                Throwable throwable = null;
                Object var14_21 = null;
                try (JDBCResultSet dbResult = dbStat.executeQuery();){
                    while (dbResult.next() && !session.getProgressMonitor().isCanceled()) {
                        long schemaId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"schema_id");
                        final String objectName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"name");
                        final String objectTypeName = JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"type");
                        final SQLServerObjectType objectType = SQLServerObjectType.valueOf(objectTypeName);
                        final SQLServerSchema objectSchema = schemaId == 0L ? null : database.getSchema(session.getProgressMonitor(), schemaId);
                        objects.add((DBSObjectReference)new AbstractObjectReference(objectName, (DBSObject)(objectSchema != null ? objectSchema : database), null, objectType.getTypeClass(), objectType){

                            public DBSObject resolveObject(DBRProgressMonitor monitor) throws DBException {
                                DBSObject object = objectType.findObject(session.getProgressMonitor(), database, objectSchema, objectName);
                                if (object == null) {
                                    throw new DBException(String.valueOf(objectTypeName) + " '" + objectName + "' not found");
                                }
                                return object;
                            }
                        });
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Throwable throwable) {
                if (object == null) {
                    object = throwable;
                } else if (object != throwable) {
                    ((Throwable)object).addSuppressed(throwable);
                }
                throw object;
            }
        }
        catch (Throwable e) {
            throw new DBException("Error while searching in system catalog", e, (DBPDataSource)this.dataSource);
        }
    }
}

