/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.sqlite.edit;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.edit.GenericTableColumnManager;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.generic.model.GenericTableColumn;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPPersistedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectRenamer;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistActionComment;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBStructUtils;
import org.jkiss.utils.CommonUtils;

public class SQLiteTableColumnManager
extends GenericTableColumnManager
implements DBEObjectRenamer<GenericTableColumn> {
    protected void addObjectDeleteActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectDeleteCommand command, Map<String, Object> options) throws DBException {
        String tableDDL;
        String tableColumns;
        GenericTableColumn column = (GenericTableColumn)command.getObject();
        GenericTableBase table = (GenericTableBase)column.getTable();
        String tableName = DBUtils.getQuotedIdentifier((DBSObject)table);
        List attributes = table.getAttributes(monitor);
        if (CommonUtils.isEmpty((Collection)attributes)) {
            throw new DBException("Table has no attributes");
        }
        try {
            if (attributes.contains(column)) {
                table.removeAttribute(column);
            }
            tableColumns = attributes.stream().filter(DBPPersistedObject::isPersisted).map(DBUtils::getQuotedIdentifier).collect(Collectors.joining(",\n  "));
            tableDDL = DBStructUtils.generateTableDDL((DBRProgressMonitor)monitor, (DBSEntity)table, Collections.emptyMap(), (boolean)false);
        }
        finally {
            if (attributes.contains(column)) {
                table.addAttribute(column);
            }
        }
        actions.add((DBEPersistAction)new SQLDatabasePersistActionComment(table.getDataSource(), "Drop column " + DBUtils.getQuotedIdentifier((DBSObject)column)));
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Create temporary table from original table", "CREATE TEMPORARY TABLE temp AS\nSELECT\n  " + tableColumns + "\nFROM " + tableName));
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Drop original table", "\nDROP TABLE " + tableName + ";\n"));
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Create new table", tableDDL));
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Insert values from temporary table to new table", "INSERT INTO " + tableName + "\n (" + tableColumns + ")\nSELECT\n  " + tableColumns + "\nFROM temp"));
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Drop temporary table", "\nDROP TABLE temp"));
    }

    protected void addObjectRenameActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectRenameCommand command, Map<String, Object> options) {
        GenericTableColumn column = (GenericTableColumn)command.getObject();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Rename column", "ALTER TABLE " + DBUtils.getQuotedIdentifier((DBSObject)column.getTable()) + " RENAME COLUMN " + DBUtils.getQuotedIdentifier((DBPDataSource)column.getDataSource(), (String)command.getOldName()) + " TO " + DBUtils.getQuotedIdentifier((DBPDataSource)column.getDataSource(), (String)command.getNewName())));
    }

    public void renameObject(@NotNull DBECommandContext commandContext, @NotNull GenericTableColumn object, @NotNull Map<String, Object> options, @NotNull String newName) throws DBException {
        this.processObjectRename(commandContext, (DBSObject)object, options, newName);
    }
}

