/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.erd.ui.action;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.Action;
import org.jkiss.dbeaver.erd.ui.editor.ERDEditorEmbedded;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;

public class DiagramTogglePersistAction
extends Action {
    private final ERDEditorEmbedded editor;

    public DiagramTogglePersistAction(ERDEditorEmbedded editor) {
        super("Keep layout", 2);
        this.setImageDescriptor(DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.SAVE_TO_DATABASE));
        this.setDescription("Save diagram layout locally.\nOtherwise entities layout will be reverted on editor reopen.");
        this.setToolTipText(this.getDescription());
        this.editor = editor;
    }

    public boolean isChecked() {
        return this.editor.isStateSaved();
    }

    public void run() {
        if (this.isChecked()) {
            boolean refreshDiagram = UIUtils.confirmAction((String)"Refresh diagram", (String)"Diagram persisted state was reset.\nDo you want to reload diagram view?");
            this.editor.resetSavedState(refreshDiagram);
        } else {
            this.editor.doSave((IProgressMonitor)new NullProgressMonitor());
        }
    }
}

