/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.app.standalone;

import java.util.ArrayList;
import java.util.ResourceBundle;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.ISaveablePart2;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.IWorkbenchConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;
import org.eclipse.ui.internal.SaveableHelper;
import org.eclipse.ui.internal.ide.application.DelayedEventsProcessor;
import org.eclipse.ui.internal.ide.application.IDEWorkbenchAdvisor;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.DBeaverActivator;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.registry.DataSourceRegistry;
import org.jkiss.dbeaver.ui.actions.datasource.DataSourceHandler;
import org.jkiss.dbeaver.ui.app.standalone.ApplicationWorkbenchWindowAdvisor;
import org.jkiss.dbeaver.ui.app.standalone.internal.CoreApplicationActivator;
import org.jkiss.dbeaver.ui.app.standalone.update.DBeaverVersionChecker;
import org.jkiss.dbeaver.ui.dialogs.ConfirmationDialog;
import org.jkiss.dbeaver.ui.editors.EditorUtils;
import org.jkiss.dbeaver.ui.editors.content.ContentEditorInput;

public class ApplicationWorkbenchAdvisor
extends IDEWorkbenchAdvisor {
    private static final Log log = Log.getLog(ApplicationWorkbenchAdvisor.class);
    private static final String PERSPECTIVE_ID = "org.jkiss.dbeaver.core.perspective";
    public static final String DBEAVER_SCHEME_NAME = "org.jkiss.dbeaver.defaultKeyScheme";
    protected static final String WORKBENCH_PREF_PAGE_ID = "org.eclipse.ui.preferencePages.Workbench";
    protected static final String APPEARANCE_PREF_PAGE_ID = "org.eclipse.ui.preferencePages.Views";
    private static final String EDITORS_PREF_PAGE_ID = "org.eclipse.ui.preferencePages.Editors";
    private static final String[] EXCLUDE_PREF_PAGES = new String[]{"org.eclipse.ui.preferencePages.Workbench/org.eclipse.ui.preferencePages.Globalization", "org.eclipse.ui.preferencePages.Workbench/org.eclipse.ui.preferencePages.Perspectives", "org.eclipse.ui.preferencePages.Workbench/org.eclipse.ui.preferencePages.Views/org.eclipse.ui.preferencePages.Decorators", "org.eclipse.ui.preferencePages.Workbench/org.eclipse.ui.preferencePages.General.LinkHandlers"};
    private static final String[] UI_PREF_PAGES = new String[]{"org.eclipse.ui.preferencePages.Workbench/org.eclipse.ui.preferencePages.Views", "org.eclipse.ui.preferencePages.Workbench/org.eclipse.ui.preferencePages.Keys", "org.eclipse.ui.preferencePages.Workbench/org.eclipse.ui.browser.preferencePage", "org.eclipse.ui.preferencePages.Workbench/org.eclipse.search.preferences.SearchPreferencePage", "org.eclipse.ui.preferencePages.Workbench/org.eclipse.text.quicksearch.PreferencesPage", "org.eclipse.ui.preferencePages.Workbench/org.eclipse.ui.preferencePages.Editors", "org.eclipse.ui.preferencePages.Workbench/org.eclipse.ui.preferencePages.Editors/org.eclipse.ui.preferencePages.AutoSave", "org.eclipse.ui.preferencePages.Workbench/org.eclipse.ui.preferencePages.Editors/org.eclipse.ui.preferencePages.FileEditors"};
    private static final String[] EDITORS_PREF_PAGES = new String[]{"org.eclipse.ui.preferencePages.Workbench/org.eclipse.ui.preferencePages.Editors/org.eclipse.ui.preferencePages.GeneralTextEditor"};
    private static final String[] GENERAL_PREF_PAGES = new String[]{"org.eclipse.equinox.internal.p2.ui.sdk.ProvisioningPreferencePage", "org.eclipse.debug.ui.DebugPreferencePage"};
    private final DelayedEventsProcessor processor = new DelayedEventsProcessor(Display.getCurrent());

    protected ApplicationWorkbenchAdvisor() {
    }

    public WorkbenchWindowAdvisor createWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
        return new ApplicationWorkbenchWindowAdvisor(configurer);
    }

    public String getInitialWindowPerspectiveId() {
        return PERSPECTIVE_ID;
    }

    public void initialize(IWorkbenchConfigurer configurer) {
        super.initialize(configurer);
        DefaultScope.INSTANCE.getNode(CoreApplicationActivator.getDefault().getBundle().getSymbolicName());
        TrayDialog.setDialogHelpAvailable((boolean)false);
    }

    public void preStartup() {
        super.preStartup();
    }

    public void postStartup() {
        super.postStartup();
        this.filterPreferencePages();
        this.startVersionChecker();
    }

    public IAdaptable getDefaultPageInput() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    protected boolean isPropertyChangeRequiresRestart(String property) {
        return property.equals("logs.debug.enabled") || property.equals("logs.debug.location") || property.equals("platform.language");
    }

    private void filterPreferencePages() {
        PreferenceManager pm = PlatformUI.getWorkbench().getPreferenceManager();
        String[] stringArray = this.getExcludedPreferencePageIds();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String epp = stringArray[n2];
            pm.remove(epp);
            ++n2;
        }
        this.patchPreferencePages(pm, EDITORS_PREF_PAGES, "org.jkiss.dbeaver.preferences.editors");
        this.patchPreferencePages(pm, UI_PREF_PAGES, "org.jkiss.dbeaver.preferences.main");
        this.patchPreferencePages(pm, GENERAL_PREF_PAGES, WORKBENCH_PREF_PAGE_ID);
    }

    @NotNull
    protected String[] getExcludedPreferencePageIds() {
        return EXCLUDE_PREF_PAGES;
    }

    protected void patchPreferencePages(PreferenceManager pm, String[] preferencePages, String preferencePageId) {
        String[] stringArray = preferencePages;
        int n = preferencePages.length;
        int n2 = 0;
        while (n2 < n) {
            String pageId = stringArray[n2];
            IPreferenceNode uiPage = pm.remove(pageId);
            if (uiPage != null) {
                pm.addTo(preferencePageId, uiPage);
            }
            ++n2;
        }
    }

    private void startVersionChecker() {
        DBeaverVersionChecker checker = new DBeaverVersionChecker(false);
        checker.schedule(3000L);
    }

    public boolean preShutdown() {
        if (!this.saveAndCleanup()) {
            return false;
        }
        return super.preShutdown();
    }

    public void postShutdown() {
        super.postShutdown();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean saveAndCleanup() {
        try {
            IWorkbenchWindow window = this.getWorkbenchConfigurer().getWorkbench().getActiveWorkbenchWindow();
            if (window != null) {
                IEditorPart editorPart;
                IEditorReference editor;
                if (!"never".equals(ConfirmationDialog.getSavedPreference((String)"exit")) && !ConfirmationDialog.confirmAction((ResourceBundle)DBeaverActivator.getCoreResourceBundle(), (Shell)window.getShell(), (String)"exit")) {
                    return false;
                }
                IWorkbenchPage workbenchPage = window.getActivePage();
                IEditorReference[] editors = workbenchPage.getEditorReferences();
                ArrayList<IEditorPart> editorsToRevert = new ArrayList<IEditorPart>();
                IEditorReference[] iEditorReferenceArray = editors;
                int n = editors.length;
                int n2 = 0;
                while (n2 < n) {
                    editor = iEditorReferenceArray[n2];
                    editorPart = editor.getEditor(false);
                    if (editorPart != null && editorPart.getEditorInput() instanceof ContentEditorInput) {
                        workbenchPage.closeEditor(editorPart, false);
                    }
                    ++n2;
                }
                iEditorReferenceArray = editors;
                n = editors.length;
                n2 = 0;
                while (n2 < n) {
                    editor = iEditorReferenceArray[n2];
                    editorPart = editor.getEditor(false);
                    if (editorPart instanceof ISaveablePart2) {
                        if (!SaveableHelper.savePart((ISaveablePart)editorPart, (IWorkbenchPart)editorPart, (IWorkbenchWindow)window, (boolean)true)) {
                            return false;
                        }
                        editorsToRevert.add(editorPart);
                    }
                    ++n2;
                }
                for (IEditorPart editorPart2 : editorsToRevert) {
                    try {
                        EditorUtils.revertEditorChanges((IEditorPart)editorPart2);
                    }
                    catch (Exception e) {
                        log.debug((Object)e);
                    }
                }
            }
            return this.closeActiveTransactions();
        }
        catch (Throwable e) {
            e.printStackTrace();
            return true;
        }
    }

    private boolean closeActiveTransactions() {
        for (DBPDataSourceContainer dataSourceDescriptor : DataSourceRegistry.getAllDataSources()) {
            if (DataSourceHandler.checkAndCloseActiveTransaction((DBPDataSourceContainer)dataSourceDescriptor)) continue;
            return false;
        }
        return true;
    }

    public void eventLoopException(Throwable exception) {
        super.eventLoopException(exception);
        log.error((Object)"Event loop exception", exception);
    }

    public void eventLoopIdle(Display display) {
        this.processor.catchUp(display);
        super.eventLoopIdle(display);
    }
}

