/***************************************************************
 * Name:      dxsettings.cpp
 * Author:    David Vachulka (arch_dvx@users.sourceforge.net)
 * Copyright: 2020
 * License:   GPL3
 **************************************************************/

#include <wx/stdpaths.h>
#include <wx/fileconf.h>
#include <wx/accel.h>
#include <random>
#include "dxsettings.h"
#include "dxutils.h"
#include "data/event.h"
#include "dxdefs.h"

dxSettings::dxSettings()
{
    wxString iniPath = wxStandardPaths::Get().GetUserDataDir();
    if(!wxDirExists(iniPath))
    {
        wxMkdir(iniPath);
    }
    iniPath << wxFILE_SEP_PATH << "dxreminders.ini";
    wxFileConfig *conf = new wxFileConfig("APPNAME", "COMPANYNAME", iniPath);
    wxConfigBase::Set(conf);

    m_startOnLogin = false;
#if defined (__WXMAC__)
    m_startAtTray = true;
    m_hideTrayIcon = false;
#else
    m_startAtTray = false;
    m_hideTrayIcon = false;
#endif
    m_silentMode = false;
    m_encrypt = false;
    m_pk = makePK();
    m_closeDayDialog = false;
    m_rightclickNewevent = false;
    m_x = -1;
    m_y = -1;
#if defined (__WXMAC__)
    m_w = 275;
    m_h = 275;
#else
    m_w = 750;
    m_h = 450;
#endif
    m_iconize = false;
    m_notaskbar = false;
#if defined (__WXMAC__)
    m_look = 3;
#else
    m_look = 0;
#endif
    m_resize = true;
    m_showNote = false;
    m_daydialogW = -1;
    m_daydialogH = -1;
    m_calForeground = wxSystemSettings::GetColour(wxSYS_COLOUR_WINDOWTEXT);
    m_calBackground = wxSystemSettings::GetColour(wxSYS_COLOUR_WINDOW);
    m_calHighlightFg = wxSystemSettings::GetColour(wxSYS_COLOUR_HIGHLIGHTTEXT);
    m_calHighlightBg = wxSystemSettings::GetColour(wxSYS_COLOUR_HIGHLIGHT);
    m_calWeekendFg = *wxRED;
    m_calWeekendBg = wxSystemSettings::GetColour(wxSYS_COLOUR_WINDOW);
    m_calHolidayFg = wxColour(33, 105, 206);
    m_calHolidayBg = wxSystemSettings::GetColour(wxSYS_COLOUR_WINDOW);
    m_calReminder = wxColour(0,128,0);
    m_calRecurrence = wxColour(255,165,0);
    m_calFont = dxutils::fontToString(wxNORMAL_FONT->Larger());
    m_calMiniFont = dxutils::fontToString(wxNORMAL_FONT->Smaller());
    m_showWeekNumber = false;
    m_colEventWidth = 160;
    m_colDateWidth = 160;
    m_colDateShow = true;
    m_colReminderWidth = 160;
    m_colReminderShow = true;
    m_colRecurrenceWidth = 160;
    m_colRecurrenceShow = true;
    m_oddMonth = wxSystemSettings::GetColour(wxSYS_COLOUR_WINDOW);
    m_evenMonth = wxColour(200,200,200);
    m_highlightFg = *wxWHITE;
    m_highlightBg1 = *wxRED;
    m_highlightBg2 = wxColour(0,128,0);
    m_highlightBg3 = *wxBLUE;
    m_highlightBg4 = wxColour(255,165,0);
    m_highlightBg5 = wxColour(173,216,230);
    m_disableColors = false;
    m_eventsFont = dxutils::fontToString(*wxNORMAL_FONT);
    m_alwaysNone = false;
    m_alwaysOncenotdelete = false;
    m_hideDonotdelete = false;
    m_dateLayout = 0;
    m_dateFormat = "%x";
    m_timeFormat = "%X";
    m_useAMPM = false;
    m_easternMonday = false;
    m_easternFriday = false;
    m_remindHoliday = false;
    m_remindHolidayDays = 1;
    m_remindHolidayTime = wxDateTime(21, wxDateTime::Mar, 1976, 10);
    m_remindHolidayLast = wxDateTime(21, wxDateTime::Mar, 1976);
    m_easternMondayReminded = 2020;
    m_easternFridayReminded = 2020;
    m_reminderTime = 2;
    m_reminderPresetTime = wxDateTime(21, wxDateTime::Mar, 1976, 9);
    m_reminderMinutes = 15;
    m_calendarToday = true;
    m_filter = false;
    m_hidden = true;
    m_eventfilterAction = FA_CONTAINS;
    m_eventfilterValue = wxEmptyString;
    m_eventfilterUsage = false;
    m_datefilterAction = FA_GREATEREQUAL;
    m_datefilterValue = wxDateTime::Today();
    m_datefilterUsage = false;
    m_reminderfilterAction = FA_EQUAL;
    m_reminderfilterValue = Reminder(0);
    m_reminderfilterUsage = false;
    m_recurrencefilterValue = 0;
    m_recurrencefilterUsage = false;
    m_timefilterYears = 0;
    m_timefilterMonths = 0;
    m_timefilterWeeks = 0;
    m_timefilterDays = 0;
    m_timefilterHours = 0;
    m_timefilterMinutes = 0;
    m_timefilterUsage = false;
    m_hiddenfilterUsage = false;
    m_lastFilter = 0;
    m_defaultReminder = 0;
    m_defaultRecurrence = R_ONCE;
}

dxSettings::~dxSettings()
{
}

dxSettings &dxSettings::instance()
{
    static dxSettings s;
    return s;
}

void dxSettings::load()
{
#if !(defined (__WXMAC__))
    wxConfigBase::Get()->Read("General/startOnLogin", &m_startOnLogin, m_startOnLogin);
    wxConfigBase::Get()->Read("General/startAtTray", &m_startAtTray, m_startAtTray);
    wxConfigBase::Get()->Read("General/hideTrayIcon", &m_hideTrayIcon, m_hideTrayIcon);
#endif
    wxConfigBase::Get()->Read("General/silentMode", &m_silentMode, m_silentMode);
    wxConfigBase::Get()->Read("General/encrypt", &m_encrypt, m_encrypt);
    wxConfigBase::Get()->Read("General/pk", &m_pk, m_pk);
    wxConfigBase::Get()->Read("General/closeDayDialog", &m_closeDayDialog, m_closeDayDialog);
    wxConfigBase::Get()->Read("General/rightclickNewevent", &m_rightclickNewevent, m_rightclickNewevent);
    wxConfigBase::Get()->Read("GUI/x", &m_x, m_x);
    wxConfigBase::Get()->Read("GUI/y", &m_y, m_y);
    wxConfigBase::Get()->Read("GUI/w", &m_w, m_w);
    wxConfigBase::Get()->Read("GUI/h", &m_h, m_h);
    wxConfigBase::Get()->Read("GUI/iconize", &m_iconize, m_iconize);
    wxConfigBase::Get()->Read("GUI/notaskbar", &m_notaskbar, m_notaskbar);
    wxConfigBase::Get()->Read("GUI/daydialogW", &m_daydialogW, m_daydialogW);
    wxConfigBase::Get()->Read("GUI/daydialogH", &m_daydialogH, m_daydialogH);
    wxConfigBase::Get()->Read("LOOK/look", &m_look, m_look);
    if(m_look<0 || m_look>3)
    {
        m_look = 0;
    }
    wxConfigBase::Get()->Read("LOOK/resize", &m_resize, m_resize);
    wxConfigBase::Get()->Read("LOOK/showNote", &m_showNote, m_showNote);
    m_calForeground.Set(wxConfigBase::Get()->Read("CALENDAR/calForeground", m_calForeground.GetAsString()));
    m_calBackground.Set(wxConfigBase::Get()->Read("CALENDAR/calBackground", m_calBackground.GetAsString()));
    m_calHolidayFg.Set(wxConfigBase::Get()->Read("CALENDAR/calHolidayFg", m_calHolidayFg.GetAsString()));
    m_calHolidayBg.Set(wxConfigBase::Get()->Read("CALENDAR/calHolidayBg", m_calHolidayBg.GetAsString()));
    m_calHighlightFg.Set(wxConfigBase::Get()->Read("CALENDAR/calHighlightFg", m_calHighlightFg.GetAsString()));
    m_calHighlightBg.Set(wxConfigBase::Get()->Read("CALENDAR/calHighlightBg", m_calHighlightBg.GetAsString()));
    m_calReminder.Set(wxConfigBase::Get()->Read("CALENDAR/calReminder", m_calReminder.GetAsString()));
    m_calRecurrence.Set(wxConfigBase::Get()->Read("CALENDAR/calRecurrence", m_calRecurrence.GetAsString()));
    m_calWeekendFg.Set(wxConfigBase::Get()->Read("CALENDAR/calWeekendFg", m_calWeekendFg.GetAsString()));
    m_calWeekendBg.Set(wxConfigBase::Get()->Read("CALENDAR/calWeekendBg", m_calWeekendBg.GetAsString()));
    wxConfigBase::Get()->Read("CALENDAR/calFont", &m_calFont, m_calFont);
    wxConfigBase::Get()->Read("CALENDAR/calMiniFont", &m_calMiniFont, m_calMiniFont);
    wxConfigBase::Get()->Read("CALENDAR/calendarToday", &m_calendarToday, m_calendarToday);
    wxConfigBase::Get()->Read("CALENDAR/showWeekNumber", &m_showWeekNumber, m_showWeekNumber);
    wxConfigBase::Get()->Read("EVENTS/colEventWidth", &m_colEventWidth, m_colEventWidth);
    wxConfigBase::Get()->Read("EVENTS/colDateWidth", &m_colDateWidth, m_colDateWidth);
    wxConfigBase::Get()->Read("EVENTS/colDateShow", &m_colDateShow, m_colDateShow);
    wxConfigBase::Get()->Read("EVENTS/colReminderWidth", &m_colReminderWidth, m_colReminderWidth);
    wxConfigBase::Get()->Read("EVENTS/colReminderShow", &m_colReminderShow, m_colReminderShow);
    wxConfigBase::Get()->Read("EVENTS/colRecurrenceWidth", &m_colRecurrenceWidth, m_colRecurrenceWidth);
    wxConfigBase::Get()->Read("EVENTS/colRecurrenceShow", &m_colRecurrenceShow, m_colRecurrenceShow);
    m_oddMonth.Set(wxConfigBase::Get()->Read("EVENTS/oddMonth", m_oddMonth.GetAsString()));
    m_evenMonth.Set(wxConfigBase::Get()->Read("EVENTS/evenMonth", m_evenMonth.GetAsString()));
    m_highlightFg.Set(wxConfigBase::Get()->Read("EVENTS/highlightFg", m_highlightFg.GetAsString()));
    m_highlightBg1.Set(wxConfigBase::Get()->Read("EVENTS/highlightBg1", m_highlightBg1.GetAsString()));
    m_highlightBg2.Set(wxConfigBase::Get()->Read("EVENTS/highlightBg2", m_highlightBg2.GetAsString()));
    m_highlightBg3.Set(wxConfigBase::Get()->Read("EVENTS/highlightBg3", m_highlightBg3.GetAsString()));
    m_highlightBg4.Set(wxConfigBase::Get()->Read("EVENTS/highlightBg4", m_highlightBg4.GetAsString()));
    m_highlightBg5.Set(wxConfigBase::Get()->Read("EVENTS/highlightBg5", m_highlightBg5.GetAsString()));
    wxConfigBase::Get()->Read("EVENTS/disableColors", &m_disableColors, m_disableColors);
    wxConfigBase::Get()->Read("EVENTS/eventsFont", &m_eventsFont, m_eventsFont);
    wxConfigBase::Get()->Read("EVENTS/alwaysNone", &m_alwaysNone, m_alwaysNone);
    wxConfigBase::Get()->Read("EVENTS/alwaysOncenotdelete", &m_alwaysOncenotdelete, m_alwaysOncenotdelete);
    wxConfigBase::Get()->Read("EVENTS/hideDonotdelete", &m_hideDonotdelete, m_hideDonotdelete);
    wxConfigBase::Get()->Read("EVENTS/hidden", &m_hidden, m_hidden);
    if(m_colEventWidth < 50) m_colEventWidth = 55;
    if(m_colDateWidth < 50) m_colDateWidth = 55;
    if(m_colReminderWidth < 50) m_colReminderWidth = 55;
    if(m_colRecurrenceWidth < 50) m_colRecurrenceWidth = 55;
    wxConfigBase::Get()->Read("FORMAT/layout", &m_dateLayout, m_dateLayout);
    if(m_dateLayout<0 || m_dateLayout>3)
    {
        m_dateLayout = 0;
    }
    wxConfigBase::Get()->Read("FORMAT/date", &m_dateFormat, m_dateFormat);
    wxConfigBase::Get()->Read("FORMAT/time", &m_timeFormat, m_timeFormat);
    wxConfigBase::Get()->Read("FORMAT/useAMPM", &m_useAMPM, m_useAMPM);
    wxConfigBase::Get()->Read("HOLIDAYS/easternMonday", &m_easternMonday, m_easternMonday);
    wxConfigBase::Get()->Read("HOLIDAYS/easternFriday", &m_easternFriday, m_easternFriday);
    wxConfigBase::Get()->Read("HOLIDAYS/remindHoliday", &m_remindHoliday, m_remindHoliday);
    wxConfigBase::Get()->Read("HOLIDAYS/remindHolidayDays", &m_remindHolidayDays, m_remindHolidayDays);
    if(m_remindHolidayDays<0 || m_remindHolidayDays>31)
    {
        m_remindHolidayDays = 1;
    }
    wxString value = wxEmptyString;
    wxConfigBase::Get()->Read("HOLIDAYS/remindHolidayTime", &value, m_remindHolidayTime.FormatISOTime());
    m_remindHolidayTime.ParseISOTime(value);
    wxConfigBase::Get()->Read("HOLIDAYS/remindHolidayLast", &value, m_remindHolidayLast.FormatISODate());
    m_remindHolidayLast.ParseISODate(value);
    wxConfigBase::Get()->Read("HOLIDAYS/easternMondayReminded", &m_easternMondayReminded, m_easternMondayReminded);
    wxConfigBase::Get()->Read("HOLIDAYS/easternFridayReminded", &m_easternFridayReminded, m_easternFridayReminded);
    wxConfigBase::Get()->Read("REMINDER/reminderTime", &m_reminderTime, m_reminderTime);
    if(m_reminderTime<0 || m_reminderTime>2)
    {
        m_reminderTime = 0;
    }
    wxConfigBase::Get()->Read("REMINDER/reminderPresetTime", &value, m_reminderPresetTime.FormatISOTime());
    m_reminderPresetTime.ParseISOTime(value);
    wxConfigBase::Get()->Read("REMINDER/reminderMinutes", &m_reminderMinutes, m_reminderMinutes);
    wxConfigBase::Get()->Read("FILTER/filter", &m_filter, m_filter);
    wxConfigBase::Get()->Read("FILTER/eventfilterAction", &m_eventfilterAction, m_eventfilterAction);
    wxConfigBase::Get()->Read("FILTER/eventfilterValue", &m_eventfilterValue, m_eventfilterValue);
    wxConfigBase::Get()->Read("FILTER/eventfilterUsage", &m_eventfilterUsage, m_eventfilterUsage);
    wxConfigBase::Get()->Read("FILTER/datefilterAction", &m_datefilterAction, m_datefilterAction);
    wxConfigBase::Get()->Read("FILTER/datefilterValue", &value, m_datefilterValue.FormatISODate());
    m_datefilterValue.ParseISODate(value);
    wxConfigBase::Get()->Read("FILTER/datefilterUsage", &m_datefilterUsage, m_datefilterUsage);
    wxConfigBase::Get()->Read("FILTER/reminderfilterAction", &m_reminderfilterAction, m_reminderfilterAction);
    wxConfigBase::Get()->Read("FILTER/reminderfilterValue", &value, m_reminderfilterValue.towxString());
    m_reminderfilterValue.fromwxString(value);
    wxConfigBase::Get()->Read("FILTER/reminderfilterUsage", &m_reminderfilterUsage, m_reminderfilterUsage);
    wxConfigBase::Get()->Read("FILTER/recurrencefilterValue", &m_recurrencefilterValue, m_recurrencefilterValue);
    wxConfigBase::Get()->Read("FILTER/recurrencefilterUsage", &m_recurrencefilterUsage, m_recurrencefilterUsage);
    wxConfigBase::Get()->Read("FILTER/timefilterYears", &m_timefilterYears, m_timefilterYears);
    wxConfigBase::Get()->Read("FILTER/timefilterMonths", &m_timefilterMonths, m_timefilterMonths);
    wxConfigBase::Get()->Read("FILTER/timefilterWeeks", &m_timefilterWeeks, m_timefilterWeeks);
    wxConfigBase::Get()->Read("FILTER/timefilterDays", &m_timefilterDays, m_timefilterDays);
    wxConfigBase::Get()->Read("FILTER/timefilterHours", &m_timefilterHours, m_timefilterHours);
    wxConfigBase::Get()->Read("FILTER/timefilterMinutes", &m_timefilterMinutes, m_timefilterMinutes);
    wxConfigBase::Get()->Read("FILTER/timefilterUsage", &m_timefilterUsage, m_timefilterUsage);
    wxConfigBase::Get()->Read("FILTER/hiddenfilterUsage", &m_hiddenfilterUsage, m_hiddenfilterUsage);
    wxConfigBase::Get()->Read("FILTER/lastFilter", &m_lastFilter, m_lastFilter);
    wxConfigBase::Get()->Read("EVENT/defaultReminder", &m_defaultReminder, m_defaultReminder);
    if(m_defaultReminder < 0 || m_defaultReminder >= static_cast<int>(dxutils::reminders().size()))
    {
        m_defaultReminder = 0;
    }
    wxConfigBase::Get()->Read("EVENT/defaultRecurrence", &m_defaultRecurrence, m_defaultRecurrence);
    if(m_defaultRecurrence < 0 || m_defaultRecurrence > R_NONE)
    {
        m_defaultRecurrence = R_ONCE;
    }
}

void dxSettings::save()
{
#if !(defined (__WXMAC__))
    wxConfigBase::Get()->Write("General/startOnLogin", m_startOnLogin);
    wxConfigBase::Get()->Write("General/startAtTray", m_startAtTray);
    wxConfigBase::Get()->Write("General/hideTrayIcon", m_hideTrayIcon);
#endif
    wxConfigBase::Get()->Write("General/silentMode", m_silentMode);
    wxConfigBase::Get()->Write("General/encrypt", m_encrypt);
    wxConfigBase::Get()->Write("General/pk", m_pk);
    wxConfigBase::Get()->Write("General/closeDayDialog", m_closeDayDialog);
    wxConfigBase::Get()->Write("General/rightclickNewevent", m_rightclickNewevent);
    wxConfigBase::Get()->Write("GUI/x", m_x);
    wxConfigBase::Get()->Write("GUI/y", m_y);
    wxConfigBase::Get()->Write("GUI/w", m_w);
    wxConfigBase::Get()->Write("GUI/h", m_h);
    wxConfigBase::Get()->Write("GUI/iconize", m_iconize);
    wxConfigBase::Get()->Write("GUI/notaskbar", m_notaskbar);
    wxConfigBase::Get()->Write("GUI/daydialogW", m_daydialogW);
    wxConfigBase::Get()->Write("GUI/daydialogH", m_daydialogH);
    wxConfigBase::Get()->Write("LOOK/look", m_look);
    wxConfigBase::Get()->Write("LOOK/resize", m_resize);
    wxConfigBase::Get()->Write("LOOK/showNote", m_showNote);
    wxConfigBase::Get()->Write("CALENDAR/calForeground", m_calForeground.GetAsString());
    wxConfigBase::Get()->Write("CALENDAR/calBackground", m_calBackground.GetAsString());
    wxConfigBase::Get()->Write("CALENDAR/calHolidayFg", m_calHolidayFg.GetAsString());
    wxConfigBase::Get()->Write("CALENDAR/calHolidayBg", m_calHolidayBg.GetAsString());
    wxConfigBase::Get()->Write("CALENDAR/calHighlightFg", m_calHighlightFg.GetAsString());
    wxConfigBase::Get()->Write("CALENDAR/calHighlightBg", m_calHighlightBg.GetAsString());
    wxConfigBase::Get()->Write("CALENDAR/calReminder", m_calReminder.GetAsString());
    wxConfigBase::Get()->Write("CALENDAR/calRecurrence", m_calRecurrence.GetAsString());
    wxConfigBase::Get()->Write("CALENDAR/calWeekendFg", m_calWeekendFg.GetAsString());
    wxConfigBase::Get()->Write("CALENDAR/calWeekendBg", m_calWeekendBg.GetAsString());
    wxConfigBase::Get()->Write("CALENDAR/calFont", m_calFont);
    wxConfigBase::Get()->Write("CALENDAR/calMiniFont", m_calMiniFont);
    wxConfigBase::Get()->Write("CALENDAR/calendarToday", m_calendarToday);
    wxConfigBase::Get()->Write("CALENDAR/showWeekNumber", m_showWeekNumber);
    wxConfigBase::Get()->Write("EVENTS/colEventWidth", m_colEventWidth);
    wxConfigBase::Get()->Write("EVENTS/colDateWidth", m_colDateWidth);
    wxConfigBase::Get()->Write("EVENTS/colDateShow", m_colDateShow);
    wxConfigBase::Get()->Write("EVENTS/colReminderWidth", m_colReminderWidth);
    wxConfigBase::Get()->Write("EVENTS/colReminderShow", m_colReminderShow);
    wxConfigBase::Get()->Write("EVENTS/colRecurrenceWidth", m_colRecurrenceWidth);
    wxConfigBase::Get()->Write("EVENTS/colRecurrenceShow", m_colRecurrenceShow);
    wxConfigBase::Get()->Write("EVENTS/oddMonth", m_oddMonth.GetAsString());
    wxConfigBase::Get()->Write("EVENTS/evenMonth", m_evenMonth.GetAsString());
    wxConfigBase::Get()->Write("EVENTS/highlightFg", m_highlightFg.GetAsString());
    wxConfigBase::Get()->Write("EVENTS/highlightBg1", m_highlightBg1.GetAsString());
    wxConfigBase::Get()->Write("EVENTS/highlightBg2", m_highlightBg2.GetAsString());
    wxConfigBase::Get()->Write("EVENTS/highlightBg3", m_highlightBg3.GetAsString());
    wxConfigBase::Get()->Write("EVENTS/highlightBg4", m_highlightBg4.GetAsString());
    wxConfigBase::Get()->Write("EVENTS/highlightBg5", m_highlightBg5.GetAsString());
    wxConfigBase::Get()->Write("EVENTS/disableColors", m_disableColors);
    wxConfigBase::Get()->Write("EVENTS/eventsFont", m_eventsFont);
    wxConfigBase::Get()->Write("EVENTS/alwaysNone", m_alwaysNone);
    wxConfigBase::Get()->Write("EVENTS/alwaysOncenotdelete", m_alwaysOncenotdelete);
    wxConfigBase::Get()->Write("EVENTS/hideDonotdelete", m_hideDonotdelete);
    wxConfigBase::Get()->Write("EVENTS/hidden", m_hidden);
    wxConfigBase::Get()->Write("FORMAT/layout", m_dateLayout);
    wxConfigBase::Get()->Write("FORMAT/date", m_dateFormat);
    wxConfigBase::Get()->Write("FORMAT/time", m_timeFormat);
    wxConfigBase::Get()->Write("FORMAT/useAMPM", m_useAMPM);
    wxConfigBase::Get()->Write("HOLIDAYS/easternMonday", m_easternMonday);
    wxConfigBase::Get()->Write("HOLIDAYS/easternFriday", m_easternFriday);
    wxConfigBase::Get()->Write("HOLIDAYS/remindHoliday", m_remindHoliday);
    wxConfigBase::Get()->Write("HOLIDAYS/remindHolidayDays", m_remindHolidayDays);
    wxConfigBase::Get()->Write("HOLIDAYS/remindHolidayTime", m_remindHolidayTime.FormatISOTime());
    wxConfigBase::Get()->Write("HOLIDAYS/remindHolidayLast", m_remindHolidayLast.FormatISODate());
    wxConfigBase::Get()->Write("HOLIDAYS/easternMondayReminded", m_easternMondayReminded);
    wxConfigBase::Get()->Write("HOLIDAYS/easternFridayReminded", m_easternFridayReminded);
    wxConfigBase::Get()->Write("REMINDER/reminderTime", m_reminderTime);
    wxConfigBase::Get()->Write("REMINDER/reminderPresetTime", m_reminderPresetTime.FormatISOTime());
    wxConfigBase::Get()->Write("REMINDER/reminderMinutes", m_reminderMinutes);
    wxConfigBase::Get()->Write("FILTER/filter", m_filter);
    wxConfigBase::Get()->Write("FILTER/eventfilterAction", m_eventfilterAction);
    wxConfigBase::Get()->Write("FILTER/eventfilterValue", m_eventfilterValue);
    wxConfigBase::Get()->Write("FILTER/eventfilterUsage", m_eventfilterUsage);
    wxConfigBase::Get()->Write("FILTER/datefilterAction", m_datefilterAction);
    wxConfigBase::Get()->Write("FILTER/datefilterValue", m_datefilterValue.FormatISODate());
    wxConfigBase::Get()->Write("FILTER/datefilterUsage", m_datefilterUsage);
    wxConfigBase::Get()->Write("FILTER/reminderfilterAction", m_reminderfilterAction);
    wxConfigBase::Get()->Write("FILTER/reminderfilterValue", m_reminderfilterValue.towxString());
    wxConfigBase::Get()->Write("FILTER/reminderfilterUsage", m_reminderfilterUsage);
    wxConfigBase::Get()->Write("FILTER/recurrencefilterValue", static_cast<long>(m_recurrencefilterValue));
    wxConfigBase::Get()->Write("FILTER/recurrencefilterUsage", m_recurrencefilterUsage);
    wxConfigBase::Get()->Write("FILTER/timefilterYears", m_timefilterYears);
    wxConfigBase::Get()->Write("FILTER/timefilterMonths", m_timefilterMonths);
    wxConfigBase::Get()->Write("FILTER/timefilterWeeks", m_timefilterWeeks);
    wxConfigBase::Get()->Write("FILTER/timefilterDays", m_timefilterDays);
    wxConfigBase::Get()->Write("FILTER/timefilterHours", m_timefilterHours);
    wxConfigBase::Get()->Write("FILTER/timefilterMinutes", m_timefilterMinutes);
    wxConfigBase::Get()->Write("FILTER/timefilterUsage", m_timefilterUsage);
    wxConfigBase::Get()->Write("FILTER/hiddenfilterUsage", m_hiddenfilterUsage);
    wxConfigBase::Get()->Write("FILTER/lastFilter", m_lastFilter);
    wxConfigBase::Get()->Write("EVENT/defaultReminder", m_defaultReminder);
    wxConfigBase::Get()->Write("EVENT/defaultRecurrence", m_defaultRecurrence);
    wxConfigBase::Get()->Flush();
}

bool dxSettings::startOnLogin() const
{
    return m_startOnLogin;
}

void dxSettings::setStartOnLogin(bool startOnLogin)
{
    m_startOnLogin = startOnLogin;
}

bool dxSettings::startAtTray() const
{
    return m_startAtTray;
}

void dxSettings::setStartAtTray(bool startAtTray)
{
    m_startAtTray = startAtTray;
}

bool dxSettings::hideTrayIcon() const
{
    return m_hideTrayIcon;
}

void dxSettings::setHideTrayIcon(bool hideTrayIcon)
{
    m_hideTrayIcon = hideTrayIcon;
}

int dxSettings::x() const
{
    return m_x;
}

void dxSettings::setX(int x)
{
    m_x = x;
}

int dxSettings::y() const
{
    return m_y;
}

void dxSettings::setY(int y)
{
    m_y = y;
}

int dxSettings::w() const
{
    return m_w;
}

void dxSettings::setW(int w)
{
    m_w = w;
}

int dxSettings::h() const
{
    return m_h;
}

void dxSettings::setH(int h)
{
    m_h = h;
}

int dxSettings::look() const
{
    return m_look;
}

void dxSettings::setLook(int look)
{
    m_look = look;
}

wxColour dxSettings::calForeground() const
{
    return m_calForeground;
}

void dxSettings::setCalForeground(const wxColour &calForeground)
{
    m_calForeground = calForeground;
}

wxColour dxSettings::calBackground() const
{
    return m_calBackground;
}

void dxSettings::setCalBackground(const wxColour &calBackground)
{
    m_calBackground = calBackground;
}

wxColour dxSettings::calHighlightFg() const
{
    return m_calHighlightFg;
}

void dxSettings::setCalHighlightFg(const wxColour &calHighlightFg)
{
    m_calHighlightFg = calHighlightFg;
}

wxColour dxSettings::calHighlightBg() const
{
    return m_calHighlightBg;
}

void dxSettings::setCalHighlightBg(const wxColour &calHighlightBg)
{
    m_calHighlightBg = calHighlightBg;
}

wxColour dxSettings::calHolidayFg() const
{
    return m_calHolidayFg;
}

void dxSettings::setCalHolidayFg(const wxColour &calHolidayFg)
{
    m_calHolidayFg = calHolidayFg;
}

wxColour dxSettings::calHolidayBg() const
{
    return m_calHolidayBg;
}

void dxSettings::setCalHolidayBg(const wxColour &calHolidayBg)
{
    m_calHolidayBg = calHolidayBg;
}

bool dxSettings::iconize() const
{
    return m_iconize;
}

void dxSettings::setIconize(bool iconize)
{
    m_iconize = iconize;
}

wxColour dxSettings::calReminder() const
{
    return m_calReminder;
}

void dxSettings::setCalReminder(const wxColour &calReminder)
{
    m_calReminder = calReminder;
}

int dxSettings::colDateWidth() const
{
    return m_colDateWidth;
}

void dxSettings::setColDateWidth(int colDateWidth)
{
    m_colDateWidth = colDateWidth;
}

bool dxSettings::colDateShow() const
{
    return m_colDateShow;
}

void dxSettings::setColDateShow(bool colDateShow)
{
    m_colDateShow = colDateShow;
}

int dxSettings::colReminderWidth() const
{
    return m_colReminderWidth;
}

void dxSettings::setColReminderWidth(int colReminderWidth)
{
    m_colReminderWidth = colReminderWidth;
}

bool dxSettings::colReminderShow() const
{
    return m_colReminderShow;
}

void dxSettings::setColReminderShow(bool colReminderShow)
{
    m_colReminderShow = colReminderShow;
}

int dxSettings::colRecurrenceWidth() const
{
    return m_colRecurrenceWidth;
}

void dxSettings::setColRecurrenceWidth(int colRecurrenceWidth)
{
    m_colRecurrenceWidth = colRecurrenceWidth;
}

bool dxSettings::colRecurrenceShow() const
{
    return m_colRecurrenceShow;
}

void dxSettings::setColRecurrenceShow(bool colRecurrenceShow)
{
    m_colRecurrenceShow = colRecurrenceShow;
}

wxString dxSettings::dateFormat() const
{
    return m_dateFormat;
}

void dxSettings::setDateFormat(const wxString &dateFormat)
{
    m_dateFormat = dateFormat;
}

wxString dxSettings::timeFormat() const
{
    return m_timeFormat;
}

void dxSettings::setTimeFormat(const wxString &timeFormat)
{
    m_timeFormat = timeFormat;
}

bool dxSettings::useAMPM() const
{
    return m_useAMPM;
}

void dxSettings::setUseAMPM(bool useAMPM)
{
    m_useAMPM = useAMPM;
}

bool dxSettings::resize() const
{
    return m_resize;
}

void dxSettings::setResize(bool resize)
{
    m_resize = resize;
}

int dxSettings::dateLayout() const
{
    return m_dateLayout;
}

void dxSettings::setDateLayout(int dateLayout)
{
    m_dateLayout = dateLayout;
}

wxColour dxSettings::calRecurrence() const
{
    return m_calRecurrence;
}

void dxSettings::setCalRecurrence(const wxColour &calRecurrence)
{
    m_calRecurrence = calRecurrence;
}

bool dxSettings::encrypt() const
{
    return m_encrypt;
}

void dxSettings::setEncrypt(bool encrypt)
{
    m_encrypt = encrypt;
}

bool dxSettings::showNote() const
{
    return m_showNote;
}

void dxSettings::setShowNote(bool showNote)
{
    m_showNote = showNote;
}

wxString dxSettings::pk() const
{
    return m_pk;
}

void dxSettings::setPk(const wxString &pk)
{
    m_pk = pk;
}

bool dxSettings::easternMonday() const
{
    return m_easternMonday;
}

void dxSettings::setEasternMonday(bool easternMonday)
{
    m_easternMonday = easternMonday;
}

bool dxSettings::easternFriday() const
{
    return m_easternFriday;
}

void dxSettings::setEasternFriday(bool easternFriday)
{
    m_easternFriday = easternFriday;
}

wxColour dxSettings::calWeekendFg() const
{
    return m_calWeekendFg;
}

void dxSettings::setCalWeekendFg(const wxColour &calWeekendFg)
{
    m_calWeekendFg = calWeekendFg;
}

wxColour dxSettings::calWeekendBg() const
{
    return m_calWeekendBg;
}

void dxSettings::setCalWeekendBg(const wxColour &calWeekendBg)
{
    m_calWeekendBg = calWeekendBg;
}

wxString dxSettings::locale() const
{
    return m_locale;
}

void dxSettings::setLocale(const wxString &locale)
{
    m_locale = locale;
}

int dxSettings::colEventWidth() const
{
    return m_colEventWidth;
}

void dxSettings::setColEventWidth(int colEventWidth)
{
    m_colEventWidth = colEventWidth;
}

bool dxSettings::remindHoliday() const
{
    return m_remindHoliday;
}

void dxSettings::setRemindHoliday(bool remindHoliday)
{
    m_remindHoliday = remindHoliday;
}

int dxSettings::remindHolidayDays() const
{
    return m_remindHolidayDays;
}

void dxSettings::setRemindHolidayDays(int remindHolidayDays)
{
    m_remindHolidayDays = remindHolidayDays;
}

wxDateTime dxSettings::remindHolidayTime() const
{
    return m_remindHolidayTime;
}

void dxSettings::setRemindHolidayTime(const wxDateTime &remindHolidayTime)
{
    m_remindHolidayTime = remindHolidayTime;
}

wxDateTime dxSettings::remindHolidayLast() const
{
    return m_remindHolidayLast;
}

void dxSettings::setRemindHolidayLast(const wxDateTime &remindHolidayLast)
{
    m_remindHolidayLast = remindHolidayLast;
}

int dxSettings::easternMondayReminded() const
{
    return m_easternMondayReminded;
}

void dxSettings::setEasternMondayReminded(int easternMondayReminded)
{
    m_easternMondayReminded = easternMondayReminded;
}

int dxSettings::easternFridayReminded() const
{
    return m_easternFridayReminded;
}

void dxSettings::setEasternFridayReminded(int easternFridayReminded)
{
    m_easternFridayReminded = easternFridayReminded;
}

wxString dxSettings::calFont() const
{
    return m_calFont;
}

void dxSettings::setCalFont(const wxString &calFont)
{
    m_calFont = calFont;
}

wxString dxSettings::calMiniFont() const
{
    return m_calMiniFont;
}

void dxSettings::setCalMiniFont(const wxString &calMiniFont)
{
    m_calMiniFont = calMiniFont;
}

wxColour dxSettings::oddMonth() const
{
    return m_oddMonth;
}

void dxSettings::setOddMonth(const wxColour &oddMonth)
{
    m_oddMonth = oddMonth;
}

wxColour dxSettings::evenMonth() const
{
    return m_evenMonth;
}

void dxSettings::setEvenMonth(const wxColour &evenMonth)
{
    m_evenMonth = evenMonth;
}

bool dxSettings::disableColors() const
{
    return m_disableColors;
}

void dxSettings::setDisableColors(bool disableColors)
{
    m_disableColors = disableColors;
}

wxString dxSettings::eventsFont() const
{
    return m_eventsFont;
}

void dxSettings::setEventsFont(const wxString &eventsFont)
{
    m_eventsFont = eventsFont;
}

bool dxSettings::silentMode() const
{
    return m_silentMode;
}

void dxSettings::setSilentMode(bool silentMode)
{
    m_silentMode = silentMode;
}

bool dxSettings::notaskbar() const
{
    return m_notaskbar;
}

void dxSettings::setNotaskbar(bool notaskbar)
{
    m_notaskbar = notaskbar;
}

wxColour dxSettings::highlightFg() const
{
    return m_highlightFg;
}

void dxSettings::setHighlightFg(const wxColour &highlightFg)
{
    m_highlightFg = highlightFg;
}

wxColour dxSettings::highlightBg1() const
{
    return m_highlightBg1;
}

void dxSettings::setHighlightBg1(const wxColour &highlightBg1)
{
    m_highlightBg1 = highlightBg1;
}

bool dxSettings::closeDayDialog() const
{
    return m_closeDayDialog;
}

void dxSettings::setCloseDayDialog(bool closeDayDialog)
{
    m_closeDayDialog = closeDayDialog;
}

int dxSettings::reminderTime() const
{
    return m_reminderTime;
}

void dxSettings::setReminderTime(int reminderTime)
{
    m_reminderTime = reminderTime;
}

wxDateTime dxSettings::reminderPresetTime() const
{
    return m_reminderPresetTime;
}

void dxSettings::setReminderPresetTime(const wxDateTime &reminderPresetTime)
{
    m_reminderPresetTime = reminderPresetTime;
}

int dxSettings::reminderMinutes() const
{
    return m_reminderMinutes;
}

void dxSettings::setReminderMinutes(int reminderMinutes)
{
    m_reminderMinutes = reminderMinutes;
}

bool dxSettings::rightclickNewevent() const
{
    return m_rightclickNewevent;
}

void dxSettings::setRightclickNewevent(bool rightclickNewevent)
{
    m_rightclickNewevent = rightclickNewevent;
}

int dxSettings::daydialogW() const
{
    return m_daydialogW;
}

void dxSettings::setDaydialogW(int daydialogW)
{
    m_daydialogW = daydialogW;
}

int dxSettings::daydialogH() const
{
    return m_daydialogH;
}

void dxSettings::setDaydialogH(int daydialogH)
{
    m_daydialogH = daydialogH;
}

bool dxSettings::calendarToday() const
{
    return m_calendarToday;
}

void dxSettings::setCalendarToday(bool calendarToday)
{
    m_calendarToday = calendarToday;
}

bool dxSettings::showWeekNumber() const
{
    return m_showWeekNumber;
}

void dxSettings::setShowWeekNumber(bool showWeekNumber)
{
    m_showWeekNumber = showWeekNumber;
}

wxColour dxSettings::highlightBg2() const
{
    return m_highlightBg2;
}

void dxSettings::setHighlightBg2(const wxColour &highlightBg2)
{
    m_highlightBg2 = highlightBg2;
}

wxColour dxSettings::highlightBg3() const
{
    return m_highlightBg3;
}

void dxSettings::setHighlightBg3(const wxColour &highlightBg3)
{
    m_highlightBg3 = highlightBg3;
}

wxColour dxSettings::highlightBg4() const
{
    return m_highlightBg4;
}

void dxSettings::setHighlightBg4(const wxColour &highlightBg4)
{
    m_highlightBg4 = highlightBg4;
}

bool dxSettings::filter() const
{
    return m_filter;
}

void dxSettings::setFilter(bool filter)
{
    m_filter = filter;
}

wxString dxSettings::eventfilterValue() const
{
    return m_eventfilterValue;
}

void dxSettings::setEventfilterValue(const wxString &eventfilterValue)
{
    m_eventfilterValue = eventfilterValue;
}

bool dxSettings::eventfilterUsage() const
{
    return m_eventfilterUsage;
}

void dxSettings::setEventfilterUsage(bool eventfilterUsage)
{
    m_eventfilterUsage = eventfilterUsage;
}

wxDateTime dxSettings::datefilterValue() const
{
    return m_datefilterValue;
}

void dxSettings::setDatefilterValue(const wxDateTime &datefilterValue)
{
    m_datefilterValue = datefilterValue;
}

bool dxSettings::datefilterUsage() const
{
    return m_datefilterUsage;
}

void dxSettings::setDatefilterUsage(bool datefilterUsage)
{
    m_datefilterUsage = datefilterUsage;
}

bool dxSettings::reminderfilterUsage() const
{
    return m_reminderfilterUsage;
}

void dxSettings::setReminderfilterUsage(bool reminderfilterUsage)
{
    m_reminderfilterUsage = reminderfilterUsage;
}

bool dxSettings::recurrencefilterUsage() const
{
    return m_recurrencefilterUsage;
}

void dxSettings::setRecurrencefilterUsage(bool recurrencefilterUsage)
{
    m_recurrencefilterUsage = recurrencefilterUsage;
}

int dxSettings::eventfilterAction() const
{
    return m_eventfilterAction;
}

void dxSettings::setEventfilterAction(int eventfilterAction)
{
    m_eventfilterAction = eventfilterAction;
}

int dxSettings::datefilterAction() const
{
    return m_datefilterAction;
}

void dxSettings::setDatefilterAction(int datefilterAction)
{
    m_datefilterAction = datefilterAction;
}

int dxSettings::recurrencefilterValue() const
{
    return m_recurrencefilterValue;
}

void dxSettings::setRecurrencefilterValue(int recurrencefilterValue)
{
    m_recurrencefilterValue = recurrencefilterValue;
}

Reminder dxSettings::reminderfilterValue() const
{
    return m_reminderfilterValue;
}

void dxSettings::setReminderfilterValue(const Reminder &reminderfilterValue)
{
    m_reminderfilterValue = reminderfilterValue;
}

int dxSettings::reminderfilterAction() const
{
    return m_reminderfilterAction;
}

void dxSettings::setReminderfilterAction(int reminderfilterAction)
{
    m_reminderfilterAction = reminderfilterAction;
}

int dxSettings::timefilterYears() const
{
    return m_timefilterYears;
}

void dxSettings::setTimefilterYears(int timefilterYears)
{
    m_timefilterYears = timefilterYears;
}

int dxSettings::timefilterMonths() const
{
    return m_timefilterMonths;
}

void dxSettings::setTimefilterMonths(int timefilterMonths)
{
    m_timefilterMonths = timefilterMonths;
}

int dxSettings::timefilterWeeks() const
{
    return m_timefilterWeeks;
}

void dxSettings::setTimefilterWeeks(int timefilterWeeks)
{
    m_timefilterWeeks = timefilterWeeks;
}

int dxSettings::timefilterDays() const
{
    return m_timefilterDays;
}

void dxSettings::setTimefilterDays(int timefilterDays)
{
    m_timefilterDays = timefilterDays;
}

int dxSettings::timefilterHours() const
{
    return m_timefilterHours;
}

void dxSettings::setTimefilterHours(int timefilterHours)
{
    m_timefilterHours = timefilterHours;
}

int dxSettings::timefilterMinutes() const
{
    return m_timefilterMinutes;
}

void dxSettings::setTimefilterMinutes(int timefilterMinutes)
{
    m_timefilterMinutes = timefilterMinutes;
}

bool dxSettings::timefilterUsage() const
{
    return m_timefilterUsage;
}

void dxSettings::setTimefilterUsage(bool timefilterUsage)
{
    m_timefilterUsage = timefilterUsage;
}

wxColour dxSettings::highlightBg5() const
{
    return m_highlightBg5;
}

void dxSettings::setHighlightBg5(const wxColour &highlightBg5)
{
    m_highlightBg5 = highlightBg5;
}

bool dxSettings::hiddenfilterUsage() const
{
    return m_hiddenfilterUsage;
}

void dxSettings::setHiddenfilterUsage(bool hiddenfilterUsage)
{
    m_hiddenfilterUsage = hiddenfilterUsage;
}

bool dxSettings::alwaysNone() const
{
    return m_alwaysNone;
}

void dxSettings::setAlwaysNone(bool alwaysNone)
{
    m_alwaysNone = alwaysNone;
}

int dxSettings::defaultReminder() const
{
    return m_defaultReminder;
}

void dxSettings::setDefaultReminder(int defaultReminder)
{
    m_defaultReminder = defaultReminder;
}

int dxSettings::defaultRecurrence() const
{
    return m_defaultRecurrence;
}

void dxSettings::setDefaultRecurrence(int defaultRecurrence)
{
    m_defaultRecurrence = defaultRecurrence;
}

int dxSettings::lastFilter() const
{
    return m_lastFilter;
}

void dxSettings::setLastFilter(int lastFilter)
{
    m_lastFilter = lastFilter;
}

bool dxSettings::alwaysOncenotdelete() const
{
    return m_alwaysOncenotdelete;
}

void dxSettings::setAlwaysOncenotdelete(bool alwaysOncenotdelete)
{
    m_alwaysOncenotdelete = alwaysOncenotdelete;
}

bool dxSettings::hideDonotdelete() const
{
    return m_hideDonotdelete;
}

void dxSettings::setHideDonotdelete(bool hideDonotdelete)
{
    m_hideDonotdelete = hideDonotdelete;
}

wxString dxSettings::shortcutKey(int id)
{
    switch(id){
    case ID_MENU_NEWEVENT: return "Ctrl-N";
#if defined (__WXMSW__)
    case ID_MENU_REMOVEALLEVENTS: return "Alt-Delete";
#else
    case ID_MENU_REMOVEALLEVENTS: return "Ctrl-Delete";
#endif
    case ID_MENU_SAVEDB: return "Ctrl-S";
    case ID_MENU_LOADDB: return "Ctrl-O";
    case ID_MENU_SHOWHIDENOTE: return "Ctrl-T";
    case ID_BTN_FILTER: return "Ctrl-F";
    case ID_BTN_FILTERCLEAR: return "Ctrl-Shift-F";
    case ID_MENU_SHOWEVENTS: return "Ctrl-E";
    case ID_MENU_SHOWNOTDELETE: return "Ctrl-D";
    case ID_MENU_FULLSCREEN: return "F11";
    case ID_MENU_CALENDARFOCUS: return wxAcceleratorEntry(wxACCEL_CTRL, (int)'R').ToString();
    case ID_MENU_EVENTLISTFOCUS: return wxAcceleratorEntry(wxACCEL_CTRL, (int)'L').ToString();
    default: return "";
    }
}

bool dxSettings::hidden() const
{
    return m_hidden;
}

void dxSettings::setHidden(bool newHidden)
{
    m_hidden = newHidden;
}

wxString dxSettings::makePK()
{
    wxString result = "";
    const std::string CHARACTERS = "0123456789!@#$%^&*ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    std::random_device random_device;
    std::mt19937 generator(random_device());
    std::uniform_int_distribution<> distribution(0, CHARACTERS.size() - 1);
    for (std::size_t i = 0; i < 11; ++i)
    {
        result += CHARACTERS[distribution(generator)];
    }
    return result;
}
