.TH WATSUP 1 2022-10-01 "Linux" "watsup man page"

.SH NAME
   watsup - compact display of system resources and top processes

.SH DESCRIPTION
   Watsup provides a detailed real-time report of total system and top process 
   resource loadings. Watsup has two kinds of report:
     - a tiny window with basic system load data: CPU, disk, network.
     - a resizable window showing more system loading details and details
       for the highest resource processes fitting within the window. 

.SH SYNOPSIS
   $ watsup - start the tiny report
   $ watsup details - start the detailed process report
   
   The tiny report window can be dragged from its edges to position where 
   wanted (e.g. top right screen corner). It remembers its position for 
   the next time it is started. 
   
   Click on the window to get a popup menu:
      quit        quit the application
      details     start detailed report
      user guide  view the user guide

   The detailed report displays resource loadings for the entire system 
   and for the top processes using those resources:
      • Overall system and top process resources are shown on one page 
      • CPU, memory, disk I/O, network I/O, page fault rates are shown
      • The topmost-ranked processes fitting within the window are shown 
      • Process rank is a weighted sum of recent CPU, fault rate, I/O rate
      • Minimal movement between samples (a process can be easily watched) 
      • Overhead is low, so sub-second sampling periods are practical
      • Optionally filter for desired users, PIDs, or program names
      • Optional omission of idle processes momentarily using no resources
      • A process can be selected with the mouse and killed
      • Window size is adjustable - show only a few processes or 50+

   The report has toolbar buttons for the following functions:
      parms  set sample period and filters for detail process report
      start  start sampling and reporting
      stop   stop sampling and reporting (window is frozen)
      sort   sort process list by descending resource usage
      save   save current window to a file
      quit   terminate the detailed report - panel remains
      help   display the man page (this page)
 
   A process can be killed by clicking it with the mouse. 
   A confirmation dialog follows.
 
   You can reduce the process list to a desired subset by adding filters
   using the [parms] button. Enter text strings to match desired users,
   programs, or PIDs. Wildcards may be used, e.g. 'gnome*' would cause 
   the many gnome-xxxx daemons to be monitored. The last 20 filters are 
   saved and made available for re-selection.
   
   To include root processes, start watsup with 'sudo watsup'.

.SH UNINSTALL
   Debian package: use command: sudo apt remove watsup
   Source tarball: use command: sudo make uninstall
   Appimage package: use command: watsup -uninstall
 
.SH SEE ALSO
   The README file has instructions to build watsup from source code.
 
.SH AUTHORS
   Written by Michael Cornelison <mkornelix@gmail.com>
   https://kornelix.net/

