#!/bin/sh


BASEDIR=../panel-plugin
WDIR=`pwd`


echo -n 'Preparing desktop file...'
cd ${BASEDIR}
rm -f dxreminders.desktop.in
cp dxreminders.desktop dxreminders.desktop.in
sed -e '/Name\[/ d' \
    -e '/Comment\[/ d' \
    -e 's/Name/_Name/' \
    -e 's/Comment/_Comment/' \
    -i dxreminders.desktop.in
cd ${WDIR}
echo ' DONE'


echo -n 'Updating translations... '
for POFILE in *.po;
do
    POLANG="${POFILE%%.*}"
    echo -n "$POLANG "
    msgmerge --quiet --update --backup=none \
        $POFILE xfce4-dxreminders-plugin.pot
done
echo 'DONE'


echo -n 'Merging desktop file translations...'
cd ${BASEDIR}
intltool-merge --quiet --desktop-style ${WDIR} dxreminders.desktop.in dxreminders.desktop
rm -f dxreminders.desktop.in
echo ' DONE'
