/*
 * This file is generated by gdbus-codegen, do not modify it.
 *
 * The license of this code is the same as for the D-Bus interface description
 * it was derived from. Note that it links to GLib, so must comply with the
 * LGPL linking clauses.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "xfconf-gdbus-bindings.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

#ifdef G_ENABLE_DEBUG
#define g_marshal_value_peek_boolean(v)  g_value_get_boolean (v)
#define g_marshal_value_peek_char(v)     g_value_get_schar (v)
#define g_marshal_value_peek_uchar(v)    g_value_get_uchar (v)
#define g_marshal_value_peek_int(v)      g_value_get_int (v)
#define g_marshal_value_peek_uint(v)     g_value_get_uint (v)
#define g_marshal_value_peek_long(v)     g_value_get_long (v)
#define g_marshal_value_peek_ulong(v)    g_value_get_ulong (v)
#define g_marshal_value_peek_int64(v)    g_value_get_int64 (v)
#define g_marshal_value_peek_uint64(v)   g_value_get_uint64 (v)
#define g_marshal_value_peek_enum(v)     g_value_get_enum (v)
#define g_marshal_value_peek_flags(v)    g_value_get_flags (v)
#define g_marshal_value_peek_float(v)    g_value_get_float (v)
#define g_marshal_value_peek_double(v)   g_value_get_double (v)
#define g_marshal_value_peek_string(v)   (char*) g_value_get_string (v)
#define g_marshal_value_peek_param(v)    g_value_get_param (v)
#define g_marshal_value_peek_boxed(v)    g_value_get_boxed (v)
#define g_marshal_value_peek_pointer(v)  g_value_get_pointer (v)
#define g_marshal_value_peek_object(v)   g_value_get_object (v)
#define g_marshal_value_peek_variant(v)  g_value_get_variant (v)
#else /* !G_ENABLE_DEBUG */
/* WARNING: This code accesses GValues directly, which is UNSUPPORTED API.
 *          Do not access GValues directly in your code. Instead, use the
 *          g_value_get_*() functions
 */
#define g_marshal_value_peek_boolean(v)  (v)->data[0].v_int
#define g_marshal_value_peek_char(v)     (v)->data[0].v_int
#define g_marshal_value_peek_uchar(v)    (v)->data[0].v_uint
#define g_marshal_value_peek_int(v)      (v)->data[0].v_int
#define g_marshal_value_peek_uint(v)     (v)->data[0].v_uint
#define g_marshal_value_peek_long(v)     (v)->data[0].v_long
#define g_marshal_value_peek_ulong(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_int64(v)    (v)->data[0].v_int64
#define g_marshal_value_peek_uint64(v)   (v)->data[0].v_uint64
#define g_marshal_value_peek_enum(v)     (v)->data[0].v_long
#define g_marshal_value_peek_flags(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_float(v)    (v)->data[0].v_float
#define g_marshal_value_peek_double(v)   (v)->data[0].v_double
#define g_marshal_value_peek_string(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_param(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_boxed(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_pointer(v)  (v)->data[0].v_pointer
#define g_marshal_value_peek_object(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_variant(v)  (v)->data[0].v_pointer
#endif /* !G_ENABLE_DEBUG */

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  guint use_gvariant : 1;
  guint emits_changed_signal : 1;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

static void
_g_dbus_codegen_marshal_VOID__STRING_STRING_VARIANT (
    GClosure     *closure,
    GValue       *return_value G_GNUC_UNUSED,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef void (*_GDbusCodegenMarshalVoid_StringStringVariantFunc)
       (void *data1,
        const gchar *arg_channel,
        const gchar *arg_property,
        GVariant *arg_value,
        void *data2);
  _GDbusCodegenMarshalVoid_StringStringVariantFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;

  g_return_if_fail (n_param_values == 4);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalVoid_StringStringVariantFunc)
    (marshal_data ? marshal_data : cc->callback);

  callback (data1,
            g_marshal_value_peek_string (param_values + 1),
            g_marshal_value_peek_string (param_values + 2),
            g_marshal_value_peek_variant (param_values + 3),
            data2);
}

static void
_g_dbus_codegen_marshal_VOID__STRING_STRING (
    GClosure     *closure,
    GValue       *return_value G_GNUC_UNUSED,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef void (*_GDbusCodegenMarshalVoid_StringStringFunc)
       (void *data1,
        const gchar *arg_channel,
        const gchar *arg_property,
        void *data2);
  _GDbusCodegenMarshalVoid_StringStringFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;

  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalVoid_StringStringFunc)
    (marshal_data ? marshal_data : cc->callback);

  callback (data1,
            g_marshal_value_peek_string (param_values + 1),
            g_marshal_value_peek_string (param_values + 2),
            data2);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING_VARIANT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectStringStringVariantFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_channel,
        const gchar *arg_property,
        GVariant *arg_value,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectStringStringVariantFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 5);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectStringStringVariantFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_string (param_values + 2),
              g_marshal_value_peek_string (param_values + 3),
              g_marshal_value_peek_variant (param_values + 4),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectStringStringFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_channel,
        const gchar *arg_property,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectStringStringFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 4);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectStringStringFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_string (param_values + 2),
              g_marshal_value_peek_string (param_values + 3),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING_BOOLEAN (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectStringStringBooleanFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_channel,
        const gchar *arg_property,
        gboolean arg_recursive,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectStringStringBooleanFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 5);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectStringStringBooleanFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_string (param_values + 2),
              g_marshal_value_peek_string (param_values + 3),
              g_marshal_value_peek_boolean (param_values + 4),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 2);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              data2);

  g_value_set_boolean (return_value, v_return);
}

/* ------------------------------------------------------------------------
 * Code for interface org.xfce.Xfconf
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:XfconfExported
 * @title: XfconfExported
 * @short_description: Generated C code for the org.xfce.Xfconf D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-xfce-Xfconf.top_of_page">org.xfce.Xfconf</link> D-Bus interface in C.
 */

enum
{
  XFCONF__EXPORTED_PROPERTY_CHANGED,
  XFCONF__EXPORTED_PROPERTY_REMOVED,
};

static unsigned XFCONF__EXPORTED_SIGNALS[2] = { 0 };

/* ---- Introspection data for org.xfce.Xfconf ---- */

static const _ExtendedGDBusArgInfo _xfconf_exported_method_info_set_property_IN_ARG_channel =
{
  {
    -1,
    (gchar *) "channel",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xfconf_exported_method_info_set_property_IN_ARG_property =
{
  {
    -1,
    (gchar *) "property",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xfconf_exported_method_info_set_property_IN_ARG_value =
{
  {
    -1,
    (gchar *) "value",
    (gchar *) "v",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xfconf_exported_method_info_set_property_IN_ARG_pointers[] =
{
  &_xfconf_exported_method_info_set_property_IN_ARG_channel.parent_struct,
  &_xfconf_exported_method_info_set_property_IN_ARG_property.parent_struct,
  &_xfconf_exported_method_info_set_property_IN_ARG_value.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xfconf_exported_method_info_set_property =
{
  {
    -1,
    (gchar *) "SetProperty",
    (GDBusArgInfo **) &_xfconf_exported_method_info_set_property_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-set-property",
  FALSE
};

static const _ExtendedGDBusArgInfo _xfconf_exported_method_info_get_property_IN_ARG_channel =
{
  {
    -1,
    (gchar *) "channel",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xfconf_exported_method_info_get_property_IN_ARG_property =
{
  {
    -1,
    (gchar *) "property",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xfconf_exported_method_info_get_property_IN_ARG_pointers[] =
{
  &_xfconf_exported_method_info_get_property_IN_ARG_channel.parent_struct,
  &_xfconf_exported_method_info_get_property_IN_ARG_property.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xfconf_exported_method_info_get_property_OUT_ARG_value =
{
  {
    -1,
    (gchar *) "value",
    (gchar *) "v",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xfconf_exported_method_info_get_property_OUT_ARG_pointers[] =
{
  &_xfconf_exported_method_info_get_property_OUT_ARG_value.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xfconf_exported_method_info_get_property =
{
  {
    -1,
    (gchar *) "GetProperty",
    (GDBusArgInfo **) &_xfconf_exported_method_info_get_property_IN_ARG_pointers,
    (GDBusArgInfo **) &_xfconf_exported_method_info_get_property_OUT_ARG_pointers,
    NULL
  },
  "handle-get-property",
  FALSE
};

static const _ExtendedGDBusArgInfo _xfconf_exported_method_info_get_all_properties_IN_ARG_channel =
{
  {
    -1,
    (gchar *) "channel",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xfconf_exported_method_info_get_all_properties_IN_ARG_property_base =
{
  {
    -1,
    (gchar *) "property_base",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xfconf_exported_method_info_get_all_properties_IN_ARG_pointers[] =
{
  &_xfconf_exported_method_info_get_all_properties_IN_ARG_channel.parent_struct,
  &_xfconf_exported_method_info_get_all_properties_IN_ARG_property_base.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xfconf_exported_method_info_get_all_properties_OUT_ARG_properties =
{
  {
    -1,
    (gchar *) "properties",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xfconf_exported_method_info_get_all_properties_OUT_ARG_pointers[] =
{
  &_xfconf_exported_method_info_get_all_properties_OUT_ARG_properties.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xfconf_exported_method_info_get_all_properties =
{
  {
    -1,
    (gchar *) "GetAllProperties",
    (GDBusArgInfo **) &_xfconf_exported_method_info_get_all_properties_IN_ARG_pointers,
    (GDBusArgInfo **) &_xfconf_exported_method_info_get_all_properties_OUT_ARG_pointers,
    NULL
  },
  "handle-get-all-properties",
  FALSE
};

static const _ExtendedGDBusArgInfo _xfconf_exported_method_info_property_exists_IN_ARG_channel =
{
  {
    -1,
    (gchar *) "channel",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xfconf_exported_method_info_property_exists_IN_ARG_property =
{
  {
    -1,
    (gchar *) "property",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xfconf_exported_method_info_property_exists_IN_ARG_pointers[] =
{
  &_xfconf_exported_method_info_property_exists_IN_ARG_channel.parent_struct,
  &_xfconf_exported_method_info_property_exists_IN_ARG_property.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xfconf_exported_method_info_property_exists_OUT_ARG_exists =
{
  {
    -1,
    (gchar *) "exists",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xfconf_exported_method_info_property_exists_OUT_ARG_pointers[] =
{
  &_xfconf_exported_method_info_property_exists_OUT_ARG_exists.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xfconf_exported_method_info_property_exists =
{
  {
    -1,
    (gchar *) "PropertyExists",
    (GDBusArgInfo **) &_xfconf_exported_method_info_property_exists_IN_ARG_pointers,
    (GDBusArgInfo **) &_xfconf_exported_method_info_property_exists_OUT_ARG_pointers,
    NULL
  },
  "handle-property-exists",
  FALSE
};

static const _ExtendedGDBusArgInfo _xfconf_exported_method_info_reset_property_IN_ARG_channel =
{
  {
    -1,
    (gchar *) "channel",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xfconf_exported_method_info_reset_property_IN_ARG_property =
{
  {
    -1,
    (gchar *) "property",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xfconf_exported_method_info_reset_property_IN_ARG_recursive =
{
  {
    -1,
    (gchar *) "recursive",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xfconf_exported_method_info_reset_property_IN_ARG_pointers[] =
{
  &_xfconf_exported_method_info_reset_property_IN_ARG_channel.parent_struct,
  &_xfconf_exported_method_info_reset_property_IN_ARG_property.parent_struct,
  &_xfconf_exported_method_info_reset_property_IN_ARG_recursive.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xfconf_exported_method_info_reset_property =
{
  {
    -1,
    (gchar *) "ResetProperty",
    (GDBusArgInfo **) &_xfconf_exported_method_info_reset_property_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-reset-property",
  FALSE
};

static const _ExtendedGDBusArgInfo _xfconf_exported_method_info_list_channels_OUT_ARG_channels =
{
  {
    -1,
    (gchar *) "channels",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xfconf_exported_method_info_list_channels_OUT_ARG_pointers[] =
{
  &_xfconf_exported_method_info_list_channels_OUT_ARG_channels.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xfconf_exported_method_info_list_channels =
{
  {
    -1,
    (gchar *) "ListChannels",
    NULL,
    (GDBusArgInfo **) &_xfconf_exported_method_info_list_channels_OUT_ARG_pointers,
    NULL
  },
  "handle-list-channels",
  FALSE
};

static const _ExtendedGDBusArgInfo _xfconf_exported_method_info_is_property_locked_IN_ARG_channel =
{
  {
    -1,
    (gchar *) "channel",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xfconf_exported_method_info_is_property_locked_IN_ARG_property =
{
  {
    -1,
    (gchar *) "property",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xfconf_exported_method_info_is_property_locked_IN_ARG_pointers[] =
{
  &_xfconf_exported_method_info_is_property_locked_IN_ARG_channel.parent_struct,
  &_xfconf_exported_method_info_is_property_locked_IN_ARG_property.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xfconf_exported_method_info_is_property_locked_OUT_ARG_locked =
{
  {
    -1,
    (gchar *) "locked",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xfconf_exported_method_info_is_property_locked_OUT_ARG_pointers[] =
{
  &_xfconf_exported_method_info_is_property_locked_OUT_ARG_locked.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xfconf_exported_method_info_is_property_locked =
{
  {
    -1,
    (gchar *) "IsPropertyLocked",
    (GDBusArgInfo **) &_xfconf_exported_method_info_is_property_locked_IN_ARG_pointers,
    (GDBusArgInfo **) &_xfconf_exported_method_info_is_property_locked_OUT_ARG_pointers,
    NULL
  },
  "handle-is-property-locked",
  FALSE
};

static const GDBusMethodInfo * const _xfconf_exported_method_info_pointers[] =
{
  &_xfconf_exported_method_info_set_property.parent_struct,
  &_xfconf_exported_method_info_get_property.parent_struct,
  &_xfconf_exported_method_info_get_all_properties.parent_struct,
  &_xfconf_exported_method_info_property_exists.parent_struct,
  &_xfconf_exported_method_info_reset_property.parent_struct,
  &_xfconf_exported_method_info_list_channels.parent_struct,
  &_xfconf_exported_method_info_is_property_locked.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xfconf_exported_signal_info_property_changed_ARG_channel =
{
  {
    -1,
    (gchar *) "channel",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xfconf_exported_signal_info_property_changed_ARG_property =
{
  {
    -1,
    (gchar *) "property",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xfconf_exported_signal_info_property_changed_ARG_value =
{
  {
    -1,
    (gchar *) "value",
    (gchar *) "v",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xfconf_exported_signal_info_property_changed_ARG_pointers[] =
{
  &_xfconf_exported_signal_info_property_changed_ARG_channel.parent_struct,
  &_xfconf_exported_signal_info_property_changed_ARG_property.parent_struct,
  &_xfconf_exported_signal_info_property_changed_ARG_value.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _xfconf_exported_signal_info_property_changed =
{
  {
    -1,
    (gchar *) "PropertyChanged",
    (GDBusArgInfo **) &_xfconf_exported_signal_info_property_changed_ARG_pointers,
    NULL
  },
  "property-changed"
};

static const _ExtendedGDBusArgInfo _xfconf_exported_signal_info_property_removed_ARG_channel =
{
  {
    -1,
    (gchar *) "channel",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xfconf_exported_signal_info_property_removed_ARG_property =
{
  {
    -1,
    (gchar *) "property",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xfconf_exported_signal_info_property_removed_ARG_pointers[] =
{
  &_xfconf_exported_signal_info_property_removed_ARG_channel.parent_struct,
  &_xfconf_exported_signal_info_property_removed_ARG_property.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _xfconf_exported_signal_info_property_removed =
{
  {
    -1,
    (gchar *) "PropertyRemoved",
    (GDBusArgInfo **) &_xfconf_exported_signal_info_property_removed_ARG_pointers,
    NULL
  },
  "property-removed"
};

static const GDBusSignalInfo * const _xfconf_exported_signal_info_pointers[] =
{
  &_xfconf_exported_signal_info_property_changed.parent_struct,
  &_xfconf_exported_signal_info_property_removed.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _xfconf_exported_interface_info =
{
  {
    -1,
    (gchar *) "org.xfce.Xfconf",
    (GDBusMethodInfo **) &_xfconf_exported_method_info_pointers,
    (GDBusSignalInfo **) &_xfconf_exported_signal_info_pointers,
    NULL,
    NULL
  },
  "exported",
};


/**
 * xfconf_exported_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-xfce-Xfconf.top_of_page">org.xfce.Xfconf</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
xfconf_exported_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_xfconf_exported_interface_info.parent_struct;
}

/**
 * xfconf_exported_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #XfconfExported interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
xfconf_exported_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}


inline static void
xfconf_exported_signal_marshal_property_changed (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_VOID__STRING_STRING_VARIANT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
xfconf_exported_signal_marshal_property_removed (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_VOID__STRING_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
xfconf_exported_method_marshal_set_property (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING_VARIANT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
xfconf_exported_method_marshal_get_property (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
xfconf_exported_method_marshal_get_all_properties (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
xfconf_exported_method_marshal_property_exists (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
xfconf_exported_method_marshal_reset_property (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING_BOOLEAN (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
xfconf_exported_method_marshal_list_channels (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
xfconf_exported_method_marshal_is_property_locked (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * XfconfExported:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-xfce-Xfconf.top_of_page">org.xfce.Xfconf</link>.
 */

/**
 * XfconfExportedIface:
 * @parent_iface: The parent interface.
 * @handle_get_all_properties: Handler for the #XfconfExported::handle-get-all-properties signal.
 * @handle_get_property: Handler for the #XfconfExported::handle-get-property signal.
 * @handle_is_property_locked: Handler for the #XfconfExported::handle-is-property-locked signal.
 * @handle_list_channels: Handler for the #XfconfExported::handle-list-channels signal.
 * @handle_property_exists: Handler for the #XfconfExported::handle-property-exists signal.
 * @handle_reset_property: Handler for the #XfconfExported::handle-reset-property signal.
 * @handle_set_property: Handler for the #XfconfExported::handle-set-property signal.
 * @property_changed: Handler for the #XfconfExported::property-changed signal.
 * @property_removed: Handler for the #XfconfExported::property-removed signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-xfce-Xfconf.top_of_page">org.xfce.Xfconf</link>.
 */

typedef XfconfExportedIface XfconfExportedInterface;
G_DEFINE_INTERFACE (XfconfExported, xfconf_exported, G_TYPE_OBJECT)

static void
xfconf_exported_default_init (XfconfExportedIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * XfconfExported::handle-set-property:
   * @object: A #XfconfExported.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_channel: Argument passed by remote caller.
   * @arg_property: Argument passed by remote caller.
   * @arg_value: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-xfce-Xfconf.SetProperty">SetProperty()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xfconf_exported_complete_set_property() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-property",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XfconfExportedIface, handle_set_property),
    g_signal_accumulator_true_handled,
    NULL,
      xfconf_exported_method_marshal_set_property,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_VARIANT);

  /**
   * XfconfExported::handle-get-property:
   * @object: A #XfconfExported.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_channel: Argument passed by remote caller.
   * @arg_property: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-xfce-Xfconf.GetProperty">GetProperty()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xfconf_exported_complete_get_property() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-property",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XfconfExportedIface, handle_get_property),
    g_signal_accumulator_true_handled,
    NULL,
      xfconf_exported_method_marshal_get_property,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * XfconfExported::handle-get-all-properties:
   * @object: A #XfconfExported.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_channel: Argument passed by remote caller.
   * @arg_property_base: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-xfce-Xfconf.GetAllProperties">GetAllProperties()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xfconf_exported_complete_get_all_properties() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-all-properties",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XfconfExportedIface, handle_get_all_properties),
    g_signal_accumulator_true_handled,
    NULL,
      xfconf_exported_method_marshal_get_all_properties,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * XfconfExported::handle-property-exists:
   * @object: A #XfconfExported.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_channel: Argument passed by remote caller.
   * @arg_property: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-xfce-Xfconf.PropertyExists">PropertyExists()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xfconf_exported_complete_property_exists() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-property-exists",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XfconfExportedIface, handle_property_exists),
    g_signal_accumulator_true_handled,
    NULL,
      xfconf_exported_method_marshal_property_exists,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * XfconfExported::handle-reset-property:
   * @object: A #XfconfExported.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_channel: Argument passed by remote caller.
   * @arg_property: Argument passed by remote caller.
   * @arg_recursive: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-xfce-Xfconf.ResetProperty">ResetProperty()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xfconf_exported_complete_reset_property() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-reset-property",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XfconfExportedIface, handle_reset_property),
    g_signal_accumulator_true_handled,
    NULL,
      xfconf_exported_method_marshal_reset_property,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_BOOLEAN);

  /**
   * XfconfExported::handle-list-channels:
   * @object: A #XfconfExported.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-xfce-Xfconf.ListChannels">ListChannels()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xfconf_exported_complete_list_channels() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-list-channels",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XfconfExportedIface, handle_list_channels),
    g_signal_accumulator_true_handled,
    NULL,
      xfconf_exported_method_marshal_list_channels,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * XfconfExported::handle-is-property-locked:
   * @object: A #XfconfExported.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_channel: Argument passed by remote caller.
   * @arg_property: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-xfce-Xfconf.IsPropertyLocked">IsPropertyLocked()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xfconf_exported_complete_is_property_locked() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-is-property-locked",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XfconfExportedIface, handle_is_property_locked),
    g_signal_accumulator_true_handled,
    NULL,
      xfconf_exported_method_marshal_is_property_locked,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING);

  /* GObject signals for received D-Bus signals: */
  /**
   * XfconfExported::property-changed:
   * @object: A #XfconfExported.
   * @arg_channel: Argument.
   * @arg_property: Argument.
   * @arg_value: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-xfce-Xfconf.PropertyChanged">"PropertyChanged"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  XFCONF__EXPORTED_SIGNALS[XFCONF__EXPORTED_PROPERTY_CHANGED] =
    g_signal_new ("property-changed",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (XfconfExportedIface, property_changed),
      NULL,
      NULL,
      xfconf_exported_signal_marshal_property_changed,
      G_TYPE_NONE,
      3, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_VARIANT);

  /**
   * XfconfExported::property-removed:
   * @object: A #XfconfExported.
   * @arg_channel: Argument.
   * @arg_property: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-xfce-Xfconf.PropertyRemoved">"PropertyRemoved"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  XFCONF__EXPORTED_SIGNALS[XFCONF__EXPORTED_PROPERTY_REMOVED] =
    g_signal_new ("property-removed",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (XfconfExportedIface, property_removed),
      NULL,
      NULL,
      xfconf_exported_signal_marshal_property_removed,
      G_TYPE_NONE,
      2, G_TYPE_STRING, G_TYPE_STRING);

}

/**
 * xfconf_exported_emit_property_changed:
 * @object: A #XfconfExported.
 * @arg_channel: Argument to pass with the signal.
 * @arg_property: Argument to pass with the signal.
 * @arg_value: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-xfce-Xfconf.PropertyChanged">"PropertyChanged"</link> D-Bus signal.
 */
void
xfconf_exported_emit_property_changed (
    XfconfExported *object,
    const gchar *arg_channel,
    const gchar *arg_property,
    GVariant *arg_value)
{
  g_signal_emit (object, XFCONF__EXPORTED_SIGNALS[XFCONF__EXPORTED_PROPERTY_CHANGED], 0, arg_channel, arg_property, arg_value);
}

/**
 * xfconf_exported_emit_property_removed:
 * @object: A #XfconfExported.
 * @arg_channel: Argument to pass with the signal.
 * @arg_property: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-xfce-Xfconf.PropertyRemoved">"PropertyRemoved"</link> D-Bus signal.
 */
void
xfconf_exported_emit_property_removed (
    XfconfExported *object,
    const gchar *arg_channel,
    const gchar *arg_property)
{
  g_signal_emit (object, XFCONF__EXPORTED_SIGNALS[XFCONF__EXPORTED_PROPERTY_REMOVED], 0, arg_channel, arg_property);
}

/**
 * xfconf_exported_call_set_property:
 * @proxy: A #XfconfExportedProxy.
 * @arg_channel: Argument to pass with the method invocation.
 * @arg_property: Argument to pass with the method invocation.
 * @arg_value: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-xfce-Xfconf.SetProperty">SetProperty()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xfconf_exported_call_set_property_finish() to get the result of the operation.
 *
 * See xfconf_exported_call_set_property_sync() for the synchronous, blocking version of this method.
 */
void
xfconf_exported_call_set_property (
    XfconfExported *proxy,
    const gchar *arg_channel,
    const gchar *arg_property,
    GVariant *arg_value,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetProperty",
    g_variant_new ("(ss@v)",
                   arg_channel,
                   arg_property,
                   arg_value),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xfconf_exported_call_set_property_finish:
 * @proxy: A #XfconfExportedProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xfconf_exported_call_set_property().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xfconf_exported_call_set_property().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfconf_exported_call_set_property_finish (
    XfconfExported *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfconf_exported_call_set_property_sync:
 * @proxy: A #XfconfExportedProxy.
 * @arg_channel: Argument to pass with the method invocation.
 * @arg_property: Argument to pass with the method invocation.
 * @arg_value: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-xfce-Xfconf.SetProperty">SetProperty()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xfconf_exported_call_set_property() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfconf_exported_call_set_property_sync (
    XfconfExported *proxy,
    const gchar *arg_channel,
    const gchar *arg_property,
    GVariant *arg_value,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetProperty",
    g_variant_new ("(ss@v)",
                   arg_channel,
                   arg_property,
                   arg_value),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfconf_exported_call_get_property:
 * @proxy: A #XfconfExportedProxy.
 * @arg_channel: Argument to pass with the method invocation.
 * @arg_property: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-xfce-Xfconf.GetProperty">GetProperty()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xfconf_exported_call_get_property_finish() to get the result of the operation.
 *
 * See xfconf_exported_call_get_property_sync() for the synchronous, blocking version of this method.
 */
void
xfconf_exported_call_get_property (
    XfconfExported *proxy,
    const gchar *arg_channel,
    const gchar *arg_property,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetProperty",
    g_variant_new ("(ss)",
                   arg_channel,
                   arg_property),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xfconf_exported_call_get_property_finish:
 * @proxy: A #XfconfExportedProxy.
 * @out_value: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xfconf_exported_call_get_property().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xfconf_exported_call_get_property().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfconf_exported_call_get_property_finish (
    XfconfExported *proxy,
    GVariant **out_value,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@v)",
                 out_value);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfconf_exported_call_get_property_sync:
 * @proxy: A #XfconfExportedProxy.
 * @arg_channel: Argument to pass with the method invocation.
 * @arg_property: Argument to pass with the method invocation.
 * @out_value: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-xfce-Xfconf.GetProperty">GetProperty()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xfconf_exported_call_get_property() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfconf_exported_call_get_property_sync (
    XfconfExported *proxy,
    const gchar *arg_channel,
    const gchar *arg_property,
    GVariant **out_value,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetProperty",
    g_variant_new ("(ss)",
                   arg_channel,
                   arg_property),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@v)",
                 out_value);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfconf_exported_call_get_all_properties:
 * @proxy: A #XfconfExportedProxy.
 * @arg_channel: Argument to pass with the method invocation.
 * @arg_property_base: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-xfce-Xfconf.GetAllProperties">GetAllProperties()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xfconf_exported_call_get_all_properties_finish() to get the result of the operation.
 *
 * See xfconf_exported_call_get_all_properties_sync() for the synchronous, blocking version of this method.
 */
void
xfconf_exported_call_get_all_properties (
    XfconfExported *proxy,
    const gchar *arg_channel,
    const gchar *arg_property_base,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetAllProperties",
    g_variant_new ("(ss)",
                   arg_channel,
                   arg_property_base),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xfconf_exported_call_get_all_properties_finish:
 * @proxy: A #XfconfExportedProxy.
 * @out_properties: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xfconf_exported_call_get_all_properties().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xfconf_exported_call_get_all_properties().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfconf_exported_call_get_all_properties_finish (
    XfconfExported *proxy,
    GVariant **out_properties,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a{sv})",
                 out_properties);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfconf_exported_call_get_all_properties_sync:
 * @proxy: A #XfconfExportedProxy.
 * @arg_channel: Argument to pass with the method invocation.
 * @arg_property_base: Argument to pass with the method invocation.
 * @out_properties: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-xfce-Xfconf.GetAllProperties">GetAllProperties()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xfconf_exported_call_get_all_properties() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfconf_exported_call_get_all_properties_sync (
    XfconfExported *proxy,
    const gchar *arg_channel,
    const gchar *arg_property_base,
    GVariant **out_properties,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetAllProperties",
    g_variant_new ("(ss)",
                   arg_channel,
                   arg_property_base),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a{sv})",
                 out_properties);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfconf_exported_call_property_exists:
 * @proxy: A #XfconfExportedProxy.
 * @arg_channel: Argument to pass with the method invocation.
 * @arg_property: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-xfce-Xfconf.PropertyExists">PropertyExists()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xfconf_exported_call_property_exists_finish() to get the result of the operation.
 *
 * See xfconf_exported_call_property_exists_sync() for the synchronous, blocking version of this method.
 */
void
xfconf_exported_call_property_exists (
    XfconfExported *proxy,
    const gchar *arg_channel,
    const gchar *arg_property,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "PropertyExists",
    g_variant_new ("(ss)",
                   arg_channel,
                   arg_property),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xfconf_exported_call_property_exists_finish:
 * @proxy: A #XfconfExportedProxy.
 * @out_exists: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xfconf_exported_call_property_exists().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xfconf_exported_call_property_exists().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfconf_exported_call_property_exists_finish (
    XfconfExported *proxy,
    gboolean *out_exists,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_exists);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfconf_exported_call_property_exists_sync:
 * @proxy: A #XfconfExportedProxy.
 * @arg_channel: Argument to pass with the method invocation.
 * @arg_property: Argument to pass with the method invocation.
 * @out_exists: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-xfce-Xfconf.PropertyExists">PropertyExists()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xfconf_exported_call_property_exists() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfconf_exported_call_property_exists_sync (
    XfconfExported *proxy,
    const gchar *arg_channel,
    const gchar *arg_property,
    gboolean *out_exists,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "PropertyExists",
    g_variant_new ("(ss)",
                   arg_channel,
                   arg_property),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_exists);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfconf_exported_call_reset_property:
 * @proxy: A #XfconfExportedProxy.
 * @arg_channel: Argument to pass with the method invocation.
 * @arg_property: Argument to pass with the method invocation.
 * @arg_recursive: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-xfce-Xfconf.ResetProperty">ResetProperty()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xfconf_exported_call_reset_property_finish() to get the result of the operation.
 *
 * See xfconf_exported_call_reset_property_sync() for the synchronous, blocking version of this method.
 */
void
xfconf_exported_call_reset_property (
    XfconfExported *proxy,
    const gchar *arg_channel,
    const gchar *arg_property,
    gboolean arg_recursive,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ResetProperty",
    g_variant_new ("(ssb)",
                   arg_channel,
                   arg_property,
                   arg_recursive),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xfconf_exported_call_reset_property_finish:
 * @proxy: A #XfconfExportedProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xfconf_exported_call_reset_property().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xfconf_exported_call_reset_property().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfconf_exported_call_reset_property_finish (
    XfconfExported *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfconf_exported_call_reset_property_sync:
 * @proxy: A #XfconfExportedProxy.
 * @arg_channel: Argument to pass with the method invocation.
 * @arg_property: Argument to pass with the method invocation.
 * @arg_recursive: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-xfce-Xfconf.ResetProperty">ResetProperty()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xfconf_exported_call_reset_property() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfconf_exported_call_reset_property_sync (
    XfconfExported *proxy,
    const gchar *arg_channel,
    const gchar *arg_property,
    gboolean arg_recursive,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ResetProperty",
    g_variant_new ("(ssb)",
                   arg_channel,
                   arg_property,
                   arg_recursive),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfconf_exported_call_list_channels:
 * @proxy: A #XfconfExportedProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-xfce-Xfconf.ListChannels">ListChannels()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xfconf_exported_call_list_channels_finish() to get the result of the operation.
 *
 * See xfconf_exported_call_list_channels_sync() for the synchronous, blocking version of this method.
 */
void
xfconf_exported_call_list_channels (
    XfconfExported *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ListChannels",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xfconf_exported_call_list_channels_finish:
 * @proxy: A #XfconfExportedProxy.
 * @out_channels: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xfconf_exported_call_list_channels().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xfconf_exported_call_list_channels().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfconf_exported_call_list_channels_finish (
    XfconfExported *proxy,
    gchar ***out_channels,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^as)",
                 out_channels);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfconf_exported_call_list_channels_sync:
 * @proxy: A #XfconfExportedProxy.
 * @out_channels: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-xfce-Xfconf.ListChannels">ListChannels()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xfconf_exported_call_list_channels() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfconf_exported_call_list_channels_sync (
    XfconfExported *proxy,
    gchar ***out_channels,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ListChannels",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^as)",
                 out_channels);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfconf_exported_call_is_property_locked:
 * @proxy: A #XfconfExportedProxy.
 * @arg_channel: Argument to pass with the method invocation.
 * @arg_property: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-xfce-Xfconf.IsPropertyLocked">IsPropertyLocked()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xfconf_exported_call_is_property_locked_finish() to get the result of the operation.
 *
 * See xfconf_exported_call_is_property_locked_sync() for the synchronous, blocking version of this method.
 */
void
xfconf_exported_call_is_property_locked (
    XfconfExported *proxy,
    const gchar *arg_channel,
    const gchar *arg_property,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "IsPropertyLocked",
    g_variant_new ("(ss)",
                   arg_channel,
                   arg_property),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xfconf_exported_call_is_property_locked_finish:
 * @proxy: A #XfconfExportedProxy.
 * @out_locked: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xfconf_exported_call_is_property_locked().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xfconf_exported_call_is_property_locked().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfconf_exported_call_is_property_locked_finish (
    XfconfExported *proxy,
    gboolean *out_locked,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_locked);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfconf_exported_call_is_property_locked_sync:
 * @proxy: A #XfconfExportedProxy.
 * @arg_channel: Argument to pass with the method invocation.
 * @arg_property: Argument to pass with the method invocation.
 * @out_locked: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-xfce-Xfconf.IsPropertyLocked">IsPropertyLocked()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xfconf_exported_call_is_property_locked() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfconf_exported_call_is_property_locked_sync (
    XfconfExported *proxy,
    const gchar *arg_channel,
    const gchar *arg_property,
    gboolean *out_locked,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "IsPropertyLocked",
    g_variant_new ("(ss)",
                   arg_channel,
                   arg_property),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_locked);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfconf_exported_complete_set_property:
 * @object: A #XfconfExported.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-xfce-Xfconf.SetProperty">SetProperty()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xfconf_exported_complete_set_property (
    XfconfExported *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * xfconf_exported_complete_get_property:
 * @object: A #XfconfExported.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @value: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-xfce-Xfconf.GetProperty">GetProperty()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xfconf_exported_complete_get_property (
    XfconfExported *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GVariant *value)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@v)",
                   value));
}

/**
 * xfconf_exported_complete_get_all_properties:
 * @object: A #XfconfExported.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @properties: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-xfce-Xfconf.GetAllProperties">GetAllProperties()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xfconf_exported_complete_get_all_properties (
    XfconfExported *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GVariant *properties)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@a{sv})",
                   properties));
}

/**
 * xfconf_exported_complete_property_exists:
 * @object: A #XfconfExported.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @exists: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-xfce-Xfconf.PropertyExists">PropertyExists()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xfconf_exported_complete_property_exists (
    XfconfExported *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    gboolean exists)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(b)",
                   exists));
}

/**
 * xfconf_exported_complete_reset_property:
 * @object: A #XfconfExported.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-xfce-Xfconf.ResetProperty">ResetProperty()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xfconf_exported_complete_reset_property (
    XfconfExported *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * xfconf_exported_complete_list_channels:
 * @object: A #XfconfExported.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @channels: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-xfce-Xfconf.ListChannels">ListChannels()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xfconf_exported_complete_list_channels (
    XfconfExported *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *const *channels)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(^as)",
                   channels));
}

/**
 * xfconf_exported_complete_is_property_locked:
 * @object: A #XfconfExported.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @locked: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-xfce-Xfconf.IsPropertyLocked">IsPropertyLocked()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xfconf_exported_complete_is_property_locked (
    XfconfExported *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    gboolean locked)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(b)",
                   locked));
}

/* ------------------------------------------------------------------------ */

/**
 * XfconfExportedProxy:
 *
 * The #XfconfExportedProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XfconfExportedProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XfconfExportedProxy.
 */

struct _XfconfExportedProxyPrivate
{
  GData *qdata;
};

static void xfconf_exported_proxy_iface_init (XfconfExportedIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XfconfExportedProxy, xfconf_exported_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (XfconfExportedProxy)
                         G_IMPLEMENT_INTERFACE (XFCONF_TYPE_EXPORTED, xfconf_exported_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XfconfExportedProxy, xfconf_exported_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (XFCONF_TYPE_EXPORTED, xfconf_exported_proxy_iface_init))

#endif
static void
xfconf_exported_proxy_finalize (GObject *object)
{
  XfconfExportedProxy *proxy = XFCONF_EXPORTED_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (xfconf_exported_proxy_parent_class)->finalize (object);
}

static void
xfconf_exported_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
xfconf_exported_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
xfconf_exported_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_xfconf_exported_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], XFCONF_TYPE_EXPORTED);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XFCONF_TYPE_EXPORTED);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
xfconf_exported_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  XfconfExportedProxy *proxy = XFCONF_EXPORTED_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xfconf_exported_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xfconf_exported_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
xfconf_exported_proxy_init (XfconfExportedProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = xfconf_exported_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, XFCONF_TYPE_EXPORTED_PROXY, XfconfExportedProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), xfconf_exported_interface_info ());
}

static void
xfconf_exported_proxy_class_init (XfconfExportedProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = xfconf_exported_proxy_finalize;
  gobject_class->get_property = xfconf_exported_proxy_get_property;
  gobject_class->set_property = xfconf_exported_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = xfconf_exported_proxy_g_signal;
  proxy_class->g_properties_changed = xfconf_exported_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XfconfExportedProxyPrivate));
#endif
}

static void
xfconf_exported_proxy_iface_init (XfconfExportedIface *iface G_GNUC_UNUSED)
{
}

/**
 * xfconf_exported_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-xfce-Xfconf.top_of_page">org.xfce.Xfconf</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xfconf_exported_proxy_new_finish() to get the result of the operation.
 *
 * See xfconf_exported_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
xfconf_exported_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XFCONF_TYPE_EXPORTED_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.xfce.Xfconf", NULL);
}

/**
 * xfconf_exported_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xfconf_exported_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xfconf_exported_proxy_new().
 *
 * Returns: (transfer full) (type XfconfExportedProxy): The constructed proxy object or %NULL if @error is set.
 */
XfconfExported *
xfconf_exported_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XFCONF_EXPORTED (ret);
  else
    return NULL;
}

/**
 * xfconf_exported_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-xfce-Xfconf.top_of_page">org.xfce.Xfconf</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xfconf_exported_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XfconfExportedProxy): The constructed proxy object or %NULL if @error is set.
 */
XfconfExported *
xfconf_exported_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XFCONF_TYPE_EXPORTED_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.xfce.Xfconf", NULL);
  if (ret != NULL)
    return XFCONF_EXPORTED (ret);
  else
    return NULL;
}


/**
 * xfconf_exported_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like xfconf_exported_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xfconf_exported_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See xfconf_exported_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
xfconf_exported_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XFCONF_TYPE_EXPORTED_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.xfce.Xfconf", NULL);
}

/**
 * xfconf_exported_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xfconf_exported_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xfconf_exported_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type XfconfExportedProxy): The constructed proxy object or %NULL if @error is set.
 */
XfconfExported *
xfconf_exported_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XFCONF_EXPORTED (ret);
  else
    return NULL;
}

/**
 * xfconf_exported_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like xfconf_exported_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xfconf_exported_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XfconfExportedProxy): The constructed proxy object or %NULL if @error is set.
 */
XfconfExported *
xfconf_exported_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XFCONF_TYPE_EXPORTED_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.xfce.Xfconf", NULL);
  if (ret != NULL)
    return XFCONF_EXPORTED (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * XfconfExportedSkeleton:
 *
 * The #XfconfExportedSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XfconfExportedSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XfconfExportedSkeleton.
 */

struct _XfconfExportedSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_xfconf_exported_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  XfconfExportedSkeleton *skeleton = XFCONF_EXPORTED_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], XFCONF_TYPE_EXPORTED);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XFCONF_TYPE_EXPORTED);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_xfconf_exported_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  XfconfExportedSkeleton *skeleton = XFCONF_EXPORTED_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xfconf_exported_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_xfconf_exported_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  XfconfExportedSkeleton *skeleton = XFCONF_EXPORTED_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xfconf_exported_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _xfconf_exported_skeleton_vtable =
{
  _xfconf_exported_skeleton_handle_method_call,
  _xfconf_exported_skeleton_handle_get_property,
  _xfconf_exported_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
xfconf_exported_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return xfconf_exported_interface_info ();
}

static GDBusInterfaceVTable *
xfconf_exported_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_xfconf_exported_skeleton_vtable;
}

static GVariant *
xfconf_exported_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  XfconfExportedSkeleton *skeleton = XFCONF_EXPORTED_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_xfconf_exported_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _xfconf_exported_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _xfconf_exported_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _xfconf_exported_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.xfce.Xfconf", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
xfconf_exported_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void
_xfconf_exported_on_signal_property_changed (
    XfconfExported *object,
    const gchar *arg_channel,
    const gchar *arg_property,
    GVariant *arg_value)
{
  XfconfExportedSkeleton *skeleton = XFCONF_EXPORTED_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(ss@v)",
                   arg_channel,
                   arg_property,
                   arg_value));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.xfce.Xfconf", "PropertyChanged",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_xfconf_exported_on_signal_property_removed (
    XfconfExported *object,
    const gchar *arg_channel,
    const gchar *arg_property)
{
  XfconfExportedSkeleton *skeleton = XFCONF_EXPORTED_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(ss)",
                   arg_channel,
                   arg_property));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.xfce.Xfconf", "PropertyRemoved",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void xfconf_exported_skeleton_iface_init (XfconfExportedIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XfconfExportedSkeleton, xfconf_exported_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (XfconfExportedSkeleton)
                         G_IMPLEMENT_INTERFACE (XFCONF_TYPE_EXPORTED, xfconf_exported_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XfconfExportedSkeleton, xfconf_exported_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (XFCONF_TYPE_EXPORTED, xfconf_exported_skeleton_iface_init))

#endif
static void
xfconf_exported_skeleton_finalize (GObject *object)
{
  XfconfExportedSkeleton *skeleton = XFCONF_EXPORTED_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (xfconf_exported_skeleton_parent_class)->finalize (object);
}

static void
xfconf_exported_skeleton_init (XfconfExportedSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = xfconf_exported_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, XFCONF_TYPE_EXPORTED_SKELETON, XfconfExportedSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
xfconf_exported_skeleton_class_init (XfconfExportedSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = xfconf_exported_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = xfconf_exported_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = xfconf_exported_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = xfconf_exported_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = xfconf_exported_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XfconfExportedSkeletonPrivate));
#endif
}

static void
xfconf_exported_skeleton_iface_init (XfconfExportedIface *iface)
{
  iface->property_changed = _xfconf_exported_on_signal_property_changed;
  iface->property_removed = _xfconf_exported_on_signal_property_removed;
}

/**
 * xfconf_exported_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-xfce-Xfconf.top_of_page">org.xfce.Xfconf</link>.
 *
 * Returns: (transfer full) (type XfconfExportedSkeleton): The skeleton object.
 */
XfconfExported *
xfconf_exported_skeleton_new (void)
{
  return XFCONF_EXPORTED (g_object_new (XFCONF_TYPE_EXPORTED_SKELETON, NULL));
}

