/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.webdav.core.servlet;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Optional;
import java.util.function.Function;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.DavResourceFactory;
import org.apache.jackrabbit.webdav.DavResourceLocator;
import org.apache.jackrabbit.webdav.DavServletRequest;
import org.apache.jackrabbit.webdav.DavServletResponse;
import org.apache.jackrabbit.webdav.DavSession;
import org.apache.jackrabbit.webdav.lock.LockManager;
import org.cryptomator.webdav.core.servlet.ByteRange;
import org.cryptomator.webdav.core.servlet.DavFile;
import org.cryptomator.webdav.core.servlet.DavFileWithRange;
import org.cryptomator.webdav.core.servlet.DavFolder;
import org.cryptomator.webdav.core.servlet.DavLocatorImpl;
import org.cryptomator.webdav.core.servlet.ExclusiveSharedLockManager;

class DavResourceFactoryImpl
implements DavResourceFactory {
    private static final String RANGE_HEADER = "Range";
    private static final String IF_RANGE_HEADER = "If-Range";
    private final LockManager lockManager = new ExclusiveSharedLockManager();
    private final Function<String, Path> urlResolver;

    public DavResourceFactoryImpl(Function<String, Path> urlResolver) {
        this.urlResolver = urlResolver;
    }

    private Path resolveUrl(String relativeUrl) throws DavException {
        try {
            return this.urlResolver.apply(relativeUrl);
        }
        catch (IllegalArgumentException e) {
            throw new DavException(404, e.getMessage(), (Throwable)e, null);
        }
    }

    public DavResource createResource(DavResourceLocator locator, DavServletRequest request, DavServletResponse response) throws DavException {
        if (locator instanceof DavLocatorImpl && locator.equals(request.getRequestLocator())) {
            return this.createRequestResource((DavLocatorImpl)locator, request, response);
        }
        if (locator instanceof DavLocatorImpl && locator.equals(request.getDestinationLocator())) {
            return this.createDestinationResource((DavLocatorImpl)locator, request, response);
        }
        throw new IllegalArgumentException("Unsupported locator of type " + locator.getClass());
    }

    private DavResource createRequestResource(DavLocatorImpl locator, DavServletRequest request, DavServletResponse response) throws DavException {
        assert (locator.equals(request.getRequestLocator()));
        Path p = this.resolveUrl(locator.getResourcePath());
        Optional<BasicFileAttributes> attr = this.readBasicFileAttributes(p);
        if ("PUT".equals(request.getMethod())) {
            this.checkPreconditionsForPut(p, attr);
            return this.createFile(locator, p, Optional.empty(), request.getDavSession());
        }
        if ("MKCOL".equals(request.getMethod())) {
            this.checkPreconditionsForMkcol(p, attr);
            return this.createFolder(locator, p, Optional.empty(), request.getDavSession());
        }
        if (!attr.isPresent() && "LOCK".equals(request.getMethod())) {
            return this.createFile(locator, p, Optional.empty(), request.getDavSession());
        }
        if (!attr.isPresent()) {
            throw new DavException(404);
        }
        if (attr.get().isDirectory()) {
            return this.createFolder(locator, p, attr, request.getDavSession());
        }
        if (attr.get().isRegularFile() && "GET".equals(request.getMethod()) && request.getHeader(RANGE_HEADER) != null) {
            return this.createFileRange(locator, p, attr.get(), request.getDavSession(), request, response);
        }
        if (attr.get().isRegularFile()) {
            return this.createFile(locator, p, attr, request.getDavSession());
        }
        throw new DavException(404, "Node not a file or directory: " + p);
    }

    private void checkPreconditionsForPut(Path p, Optional<BasicFileAttributes> attr) throws DavException {
        if (attr.isPresent() && !attr.get().isRegularFile()) {
            throw new DavException(409, p + " already exists.");
        }
    }

    private void checkPreconditionsForMkcol(Path p, Optional<BasicFileAttributes> attr) throws DavException {
        if (attr.isPresent()) {
            throw new DavException(405, p + " already exists.");
        }
    }

    private DavResource createDestinationResource(DavLocatorImpl locator, DavServletRequest request, DavServletResponse response) throws DavException {
        assert (locator.equals(request.getDestinationLocator()));
        assert (ImmutableSet.of((Object)"MOVE", (Object)"COPY").contains((Object)request.getMethod()));
        Path srcP = this.resolveUrl(request.getRequestLocator().getResourcePath());
        Path dstP = this.resolveUrl(locator.getResourcePath());
        Optional<BasicFileAttributes> srcAttr = this.readBasicFileAttributes(srcP);
        Optional<BasicFileAttributes> dstAttr = this.readBasicFileAttributes(dstP);
        if (!srcAttr.isPresent()) {
            throw new DavException(404);
        }
        if (srcAttr.get().isDirectory()) {
            return this.createFolder(locator, dstP, dstAttr, request.getDavSession());
        }
        return this.createFile(locator, dstP, dstAttr, request.getDavSession());
    }

    public DavResource createResource(DavResourceLocator locator, DavSession session) throws DavException {
        if (locator instanceof DavLocatorImpl) {
            return this.createResourceInternal((DavLocatorImpl)locator, session);
        }
        throw new IllegalArgumentException("Unsupported locator of type " + locator.getClass());
    }

    private DavResource createResourceInternal(DavLocatorImpl locator, DavSession session) throws DavException {
        Path p = this.resolveUrl(locator.getResourcePath());
        Optional<BasicFileAttributes> attr = this.readBasicFileAttributes(p);
        if (!attr.isPresent()) {
            throw new DavException(404);
        }
        if (attr.get().isDirectory()) {
            return this.createFolder(locator, p, attr, session);
        }
        return this.createFile(locator, p, attr, session);
    }

    private Optional<BasicFileAttributes> readBasicFileAttributes(Path path) throws DavException {
        try {
            return Optional.of(Files.readAttributes(path, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS));
        }
        catch (NoSuchFileException e) {
            return Optional.empty();
        }
        catch (IOException e) {
            throw new DavException(500, (Throwable)e);
        }
    }

    DavFolder createFolder(DavLocatorImpl locator, Path path, Optional<BasicFileAttributes> attr, DavSession session) {
        return new DavFolder(this, this.lockManager, locator, path, attr, session);
    }

    DavFile createFile(DavLocatorImpl locator, Path path, Optional<BasicFileAttributes> attr, DavSession session) {
        return new DavFile(this, this.lockManager, locator, path, attr, session);
    }

    private DavFile createFileRange(DavLocatorImpl locator, Path path, BasicFileAttributes attr, DavSession session, DavServletRequest request, DavServletResponse response) throws DavException {
        String ifRangeHeader = request.getHeader(IF_RANGE_HEADER);
        if (!this.isIfRangeHeaderSatisfied(attr, ifRangeHeader)) {
            return this.createFile(locator, path, Optional.of(attr), session);
        }
        String rangeHeader = request.getHeader(RANGE_HEADER);
        try {
            ByteRange byteRange = ByteRange.parse(rangeHeader);
            response.setStatus(206);
            return new DavFileWithRange(this, this.lockManager, locator, path, attr, session, byteRange);
        }
        catch (ByteRange.UnsupportedRangeException ex) {
            return this.createFile(locator, path, Optional.of(attr), session);
        }
        catch (ByteRange.MalformedByteRangeException e) {
            throw new DavException(400, "Malformed range header: " + rangeHeader);
        }
    }

    private boolean isIfRangeHeaderSatisfied(BasicFileAttributes attr, String ifRangeHeader) throws DavException {
        if (ifRangeHeader == null) {
            return true;
        }
        try {
            Instant expectedTime = Instant.from(DateTimeFormatter.RFC_1123_DATE_TIME.parse(ifRangeHeader));
            Instant actualTime = attr.lastModifiedTime().toInstant();
            return expectedTime.compareTo(actualTime) == 0;
        }
        catch (DateTimeParseException e) {
            throw new DavException(400, "Unsupported If-Range header: " + ifRangeHeader);
        }
    }
}

