/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.common.mountpoint;

import java.nio.file.Path;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.commons.lang3.SystemUtils;
import org.cryptomator.common.mountpoint.MountPointChooser;
import org.cryptomator.common.mountpoint.MountPointHelper;
import org.cryptomator.common.settings.VaultSettings;
import org.cryptomator.common.vaults.Volume;

class MacVolumeMountChooser
implements MountPointChooser {
    private static final Path VOLUME_PATH = Path.of("/Volumes", new String[0]);
    private final VaultSettings vaultSettings;
    private final MountPointHelper helper;

    @Inject
    public MacVolumeMountChooser(VaultSettings vaultSettings, MountPointHelper helper) {
        this.vaultSettings = vaultSettings;
        this.helper = helper;
    }

    @Override
    public boolean isApplicable(Volume caller) {
        return SystemUtils.IS_OS_MAC;
    }

    @Override
    public Optional<Path> chooseMountPoint(Volume caller) {
        return Optional.of(this.helper.chooseTemporaryMountPoint(this.vaultSettings, VOLUME_PATH));
    }

    @Override
    public boolean prepare(Volume caller, Path mountPoint) {
        return false;
    }
}

