/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.common.vaults;

import dagger.Module;
import dagger.Provides;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.atomic.AtomicReference;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javax.inject.Named;
import org.apache.commons.lang3.SystemUtils;
import org.cryptomator.common.Nullable;
import org.cryptomator.common.settings.Settings;
import org.cryptomator.common.settings.VaultSettings;
import org.cryptomator.common.settings.VolumeImpl;
import org.cryptomator.common.vaults.DefaultMountFlags;
import org.cryptomator.common.vaults.DokanyVolume;
import org.cryptomator.common.vaults.FuseVolume;
import org.cryptomator.common.vaults.PerVault;
import org.cryptomator.common.vaults.Volume;
import org.cryptomator.common.vaults.WebDavVolume;
import org.cryptomator.cryptofs.CryptoFileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Module
public class VaultModule {
    private static final Logger LOG = LoggerFactory.getLogger(VaultModule.class);

    @Provides
    @PerVault
    public AtomicReference<CryptoFileSystem> provideCryptoFileSystemReference() {
        return new AtomicReference<CryptoFileSystem>();
    }

    @Provides
    @Named(value="lastKnownException")
    @PerVault
    public ObjectProperty<Exception> provideLastKnownException(@Named(value="lastKnownException") @Nullable Exception initialErrorCause) {
        return new SimpleObjectProperty((Object)initialErrorCause);
    }

    @Provides
    public Volume provideVolume(Settings settings, WebDavVolume webDavVolume, FuseVolume fuseVolume, DokanyVolume dokanyVolume) {
        VolumeImpl preferredImpl = (VolumeImpl)((Object)settings.preferredVolumeImpl().get());
        if (VolumeImpl.DOKANY == preferredImpl && dokanyVolume.isSupported()) {
            return dokanyVolume;
        }
        if (VolumeImpl.FUSE == preferredImpl && fuseVolume.isSupported()) {
            return fuseVolume;
        }
        if (VolumeImpl.WEBDAV != preferredImpl) {
            LOG.warn("Using WebDAV, because {} is not supported.", (Object)preferredImpl.getDisplayName());
        }
        assert (webDavVolume.isSupported());
        return webDavVolume;
    }

    @Provides
    @PerVault
    @DefaultMountFlags
    public StringBinding provideDefaultMountFlags(Settings settings, VaultSettings vaultSettings) {
        ObjectProperty<VolumeImpl> preferredVolumeImpl = settings.preferredVolumeImpl();
        StringBinding mountName = vaultSettings.mountName();
        BooleanProperty readOnly = vaultSettings.usesReadOnlyMode();
        return Bindings.createStringBinding(() -> {
            VolumeImpl v = (VolumeImpl)((Object)((Object)preferredVolumeImpl.get()));
            if (v == VolumeImpl.FUSE && SystemUtils.IS_OS_MAC) {
                return this.getMacFuseDefaultMountFlags(mountName, (ReadOnlyBooleanProperty)readOnly);
            }
            if (v == VolumeImpl.FUSE && SystemUtils.IS_OS_LINUX) {
                return this.getLinuxFuseDefaultMountFlags((ReadOnlyBooleanProperty)readOnly);
            }
            if (v == VolumeImpl.FUSE && SystemUtils.IS_OS_WINDOWS) {
                return this.getWindowsFuseDefaultMountFlags(mountName, (ReadOnlyBooleanProperty)readOnly);
            }
            if (v == VolumeImpl.DOKANY && SystemUtils.IS_OS_WINDOWS) {
                return this.getDokanyDefaultMountFlags((ReadOnlyBooleanProperty)readOnly);
            }
            return "--flags-supported-on-FUSE-or-DOKANY-only";
        }, (Observable[])new Observable[]{mountName, readOnly, preferredVolumeImpl});
    }

    private String getMacFuseDefaultMountFlags(StringBinding mountName, ReadOnlyBooleanProperty readOnly) {
        assert (SystemUtils.IS_OS_MAC_OSX);
        StringBuilder flags = new StringBuilder();
        if (readOnly.get()) {
            flags.append(" -ordonly");
        }
        flags.append(" -ovolname=").append('\"').append(mountName.get()).append('\"');
        flags.append(" -oatomic_o_trunc");
        flags.append(" -oauto_xattr");
        flags.append(" -oauto_cache");
        flags.append(" -onoappledouble");
        flags.append(" -odefault_permissions");
        try {
            Path userHome = Paths.get(System.getProperty("user.home"), new String[0]);
            int uid = (Integer)Files.getAttribute(userHome, "unix:uid", new LinkOption[0]);
            int gid = (Integer)Files.getAttribute(userHome, "unix:gid", new LinkOption[0]);
            flags.append(" -ouid=").append(uid);
            flags.append(" -ogid=").append(gid);
        }
        catch (IOException e) {
            LOG.error("Could not read uid/gid from USER_HOME", (Throwable)e);
        }
        return flags.toString().strip();
    }

    private String getLinuxFuseDefaultMountFlags(ReadOnlyBooleanProperty readOnly) {
        assert (SystemUtils.IS_OS_LINUX);
        StringBuilder flags = new StringBuilder();
        if (readOnly.get()) {
            flags.append(" -oro");
        }
        flags.append(" -oauto_unmount");
        try {
            Path userHome = Paths.get(System.getProperty("user.home"), new String[0]);
            int uid = (Integer)Files.getAttribute(userHome, "unix:uid", new LinkOption[0]);
            int gid = (Integer)Files.getAttribute(userHome, "unix:gid", new LinkOption[0]);
            flags.append(" -ouid=").append(uid);
            flags.append(" -ogid=").append(gid);
        }
        catch (IOException e) {
            LOG.error("Could not read uid/gid from USER_HOME", (Throwable)e);
        }
        return flags.toString().strip();
    }

    private String getWindowsFuseDefaultMountFlags(StringBinding mountName, ReadOnlyBooleanProperty readOnly) {
        assert (SystemUtils.IS_OS_WINDOWS);
        StringBuilder flags = new StringBuilder();
        if (!readOnly.get()) {
            flags.append(" -ouid=-1");
            flags.append(" -ogid=11");
        }
        flags.append(" -ovolname=").append('\"').append(mountName.get()).append('\"');
        return flags.toString().strip();
    }

    private String getDokanyDefaultMountFlags(ReadOnlyBooleanProperty readOnly) {
        assert (SystemUtils.IS_OS_WINDOWS);
        StringBuilder flags = new StringBuilder();
        flags.append(" --options CURRENT_SESSION");
        if (readOnly.get()) {
            flags.append(",WRITE_PROTECTION");
        }
        flags.append(" --thread-count 5");
        flags.append(" --timeout 10000");
        flags.append(" --allocation-unit-size 4096");
        flags.append(" --sector-size 4096");
        return flags.toString().strip();
    }
}

