/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.common.vaults;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.SystemUtils;

@Singleton
public final class WindowsDriveLetters {
    private static final Set<String> A_TO_Z;

    @Inject
    public WindowsDriveLetters() {
    }

    public Set<String> getAllDriveLetters() {
        return A_TO_Z;
    }

    public Set<String> getOccupiedDriveLetters() {
        if (!SystemUtils.IS_OS_WINDOWS) {
            return Set.of();
        }
        Iterable<Path> rootDirs = FileSystems.getDefault().getRootDirectories();
        return StreamSupport.stream(rootDirs.spliterator(), false).map(p -> p.toString().substring(0, 1)).collect(Collectors.toSet());
    }

    public Set<String> getAvailableDriveLetters() {
        return Sets.difference(this.getAllDriveLetters(), this.getOccupiedDriveLetters());
    }

    public Optional<String> getAvailableDriveLetter() {
        return this.getAvailableDriveLetters().stream().findFirst();
    }

    public Optional<Path> getAvailableDriveLetterPath() {
        return this.getAvailableDriveLetter().map(this::toPath);
    }

    public Optional<String> getDesiredAvailableDriveLetter() {
        Set<String> availableDriveLetters = this.getAvailableDriveLetters();
        Optional<String> optString = availableDriveLetters.stream().filter(s -> !s.equals("A") && !s.equals("B")).findFirst();
        return optString.or(() -> availableDriveLetters.stream().findFirst());
    }

    public Optional<Path> getDesiredAvailableDriveLetterPath() {
        return this.getDesiredAvailableDriveLetter().map(this::toPath);
    }

    public Path toPath(String driveLetter) {
        return Path.of(driveLetter + ":\\", new String[0]);
    }

    static {
        try (IntStream stream = IntStream.rangeClosed(65, 90);){
            A_TO_Z = (Set)stream.mapToObj(i -> String.valueOf((char)i)).collect(ImmutableSet.toImmutableSet());
        }
    }
}

