/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.common;

import dagger.Binds;
import dagger.Module;
import dagger.Provides;
import dagger.multibindings.IntoMap;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.ResourceBundle;
import javafx.scene.Scene;
import javax.inject.Named;
import javax.inject.Provider;
import org.cryptomator.common.ErrorCode;
import org.cryptomator.ui.common.DefaultSceneFactory;
import org.cryptomator.ui.common.ErrorController;
import org.cryptomator.ui.common.FxController;
import org.cryptomator.ui.common.FxControllerKey;
import org.cryptomator.ui.common.FxmlFile;
import org.cryptomator.ui.common.FxmlLoaderFactory;
import org.cryptomator.ui.common.FxmlScene;

@Module
abstract class ErrorModule {
    ErrorModule() {
    }

    @Provides
    static FxmlLoaderFactory provideFxmlLoaderFactory(Map<Class<? extends FxController>, Provider<FxController>> factories, DefaultSceneFactory sceneFactory, ResourceBundle resourceBundle) {
        return new FxmlLoaderFactory(factories, sceneFactory, resourceBundle);
    }

    @Provides
    @Named(value="stackTrace")
    static String provideStackTrace(Throwable cause) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        cause.printStackTrace(new PrintStream(baos));
        return baos.toString(StandardCharsets.UTF_8);
    }

    @Provides
    static ErrorCode provideErrorCode(Throwable cause) {
        return ErrorCode.of(cause);
    }

    @Binds
    @IntoMap
    @FxControllerKey(value=ErrorController.class)
    abstract FxController bindErrorController(ErrorController var1);

    @Provides
    @FxmlScene(value=FxmlFile.ERROR)
    static Scene provideErrorScene(FxmlLoaderFactory fxmlLoaders) {
        return fxmlLoaders.createScene(FxmlFile.ERROR);
    }
}

