/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.health;

import java.io.IOException;
import java.io.UncheckedIOException;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.util.Callback;
import javax.inject.Inject;
import org.cryptomator.ui.common.FxmlLoaderFactory;
import org.cryptomator.ui.health.Check;
import org.cryptomator.ui.health.CheckListCellController;
import org.cryptomator.ui.health.HealthCheckWindow;

public class CheckListCellFactory
implements Callback<ListView<Check>, ListCell<Check>> {
    private final FxmlLoaderFactory fxmlLoaders;

    @Inject
    CheckListCellFactory(@HealthCheckWindow FxmlLoaderFactory fxmlLoaders) {
        this.fxmlLoaders = fxmlLoaders;
    }

    public ListCell<Check> call(ListView<Check> param) {
        try {
            FXMLLoader fxmlLoader = this.fxmlLoaders.load("/fxml/health_check_listcell.fxml");
            return new Cell((Parent)fxmlLoader.getRoot(), (CheckListCellController)fxmlLoader.getController());
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to load /fxml/health_check_listcell.fxml.", e);
        }
    }

    private static class Cell
    extends ListCell<Check> {
        private final Parent node;
        private final CheckListCellController controller;

        public Cell(Parent node, CheckListCellController controller) {
            this.node = node;
            this.controller = controller;
        }

        protected void updateItem(Check item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (item == null || empty) {
                this.setText(null);
                this.setGraphic(null);
            } else {
                this.controller.setCheck(item);
                this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
                this.setGraphic((Node)this.node);
            }
        }
    }
}

