/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.health;

import com.google.common.base.Preconditions;
import java.nio.file.Path;
import java.security.SecureRandom;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import javafx.application.Platform;
import javax.inject.Inject;
import org.cryptomator.common.vaults.Vault;
import org.cryptomator.cryptofs.VaultConfig;
import org.cryptomator.cryptofs.health.api.DiagnosticResult;
import org.cryptomator.cryptolib.api.Cryptor;
import org.cryptomator.cryptolib.api.CryptorProvider;
import org.cryptomator.cryptolib.api.Masterkey;
import org.cryptomator.ui.health.HealthCheckScoped;
import org.cryptomator.ui.health.HealthCheckWindow;
import org.cryptomator.ui.health.Result;

@HealthCheckScoped
class ResultFixApplier {
    private final Path vaultPath;
    private final SecureRandom csprng;
    private final Masterkey masterkey;
    private final VaultConfig vaultConfig;
    private final ExecutorService sequentialExecutor;

    @Inject
    public ResultFixApplier(@HealthCheckWindow Vault vault, AtomicReference<Masterkey> masterkeyRef, AtomicReference<VaultConfig> vaultConfigRef, SecureRandom csprng) {
        this.vaultPath = vault.getPath();
        this.masterkey = masterkeyRef.get();
        this.vaultConfig = vaultConfigRef.get();
        this.csprng = csprng;
        this.sequentialExecutor = Executors.newSingleThreadExecutor();
    }

    public CompletionStage<Void> fix(Result result) {
        Preconditions.checkArgument((result.getState() == Result.FixState.FIXABLE ? 1 : 0) != 0);
        result.setState(Result.FixState.FIXING);
        return CompletableFuture.runAsync(() -> this.fix(result.diagnosis()), this.sequentialExecutor).whenCompleteAsync((unused, throwable) -> {
            Result.FixState fixed = throwable == null ? Result.FixState.FIXED : Result.FixState.FIX_FAILED;
            result.setState(fixed);
        }, Platform::runLater);
    }

    public void fix(DiagnosticResult diagnosis) {
        Preconditions.checkArgument((diagnosis.getSeverity() == DiagnosticResult.Severity.WARN ? 1 : 0) != 0, (Object)"Unfixable result");
        try (Masterkey masterkeyClone = this.masterkey.copy();
             Cryptor cryptor = CryptorProvider.forScheme((CryptorProvider.Scheme)this.vaultConfig.getCipherCombo()).provide(masterkeyClone, this.csprng);){
            diagnosis.fix(this.vaultPath, this.vaultConfig, masterkeyClone, cryptor);
        }
        catch (Exception e) {
            throw new FixFailedException(e);
        }
    }

    public static class FixFailedException
    extends CompletionException {
        private FixFailedException(Throwable cause) {
            super(cause);
        }
    }
}

