/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.recoverykey;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
class WordEncoder {
    private static final String DEFAULT_WORD_FILE = "/i18n/4096words_en.txt";
    private static final int WORD_COUNT = 4096;
    private static final char DELIMITER = ' ';
    private final List<String> words;
    private final Map<String, Integer> indices;

    @Inject
    public WordEncoder() {
        this(DEFAULT_WORD_FILE);
    }

    public List<String> getWords() {
        return this.words;
    }

    public WordEncoder(String wordFile) {
        try (InputStream in = this.getClass().getResourceAsStream(wordFile);
             InputStreamReader reader = new InputStreamReader(in, StandardCharsets.US_ASCII.newDecoder());
             BufferedReader bufferedReader = new BufferedReader(reader);){
            this.words = bufferedReader.lines().limit(4096L).collect(Collectors.toUnmodifiableList());
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unreadable file: " + wordFile, e);
        }
        if (this.words.size() < 4096) {
            throw new IllegalArgumentException("Insufficient input file: " + wordFile);
        }
        this.indices = Map.ofEntries((Map.Entry[])IntStream.range(0, 4096).mapToObj(i -> Map.entry(this.words.get(i), i)).toArray(Map.Entry[]::new));
    }

    public String encodePadded(byte[] input) {
        Preconditions.checkArgument((input.length % 3 == 0 ? 1 : 0) != 0, (Object)"input needs to be padded to a multiple of three");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < input.length; i += 3) {
            byte b1 = input[i];
            byte b2 = input[i + 1];
            byte b3 = input[i + 2];
            int firstWordIndex = (0xFF0 & b1 << 4) + (0xF & b2 >> 4);
            int secondWordIndex = (0xF00 & b2 << 8) + (0xFF & b3);
            assert (firstWordIndex < 4096);
            assert (secondWordIndex < 4096);
            sb.append(this.words.get(firstWordIndex)).append(' ');
            sb.append(this.words.get(secondWordIndex)).append(' ');
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    public byte[] decode(String encoded) {
        List split = Splitter.on((char)' ').omitEmptyStrings().splitToList((CharSequence)Strings.nullToEmpty((String)encoded));
        Preconditions.checkArgument((split.size() % 2 == 0 ? 1 : 0) != 0, (String)"%s needs to be a multiple of two words", (Object)encoded);
        byte[] result = new byte[split.size() / 2 * 3];
        for (int i = 0; i < split.size(); i += 2) {
            String w1 = (String)split.get(i);
            String w2 = (String)split.get(i + 1);
            int firstWordIndex = this.indices.getOrDefault(w1, -1);
            int secondWordIndex = this.indices.getOrDefault(w2, -1);
            Preconditions.checkArgument((firstWordIndex != -1 ? 1 : 0) != 0, (String)"%s not in dictionary", (Object)w1);
            Preconditions.checkArgument((secondWordIndex != -1 ? 1 : 0) != 0, (String)"%s not in dictionary", (Object)w2);
            byte b1 = (byte)(0xFF & firstWordIndex >> 4);
            byte b2 = (byte)((0xF0 & firstWordIndex << 4) + (0xF & secondWordIndex >> 8));
            byte b3 = (byte)(0xFF & secondWordIndex);
            result[i / 2 * 3] = b1;
            result[i / 2 * 3 + 1] = b2;
            result[i / 2 * 3 + 2] = b3;
        }
        return result;
    }
}

