; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=aarch64-linux-gnu -mattr=+sve < %s 2>%t | FileCheck %s
; RUN: FileCheck --check-prefix=WARN --allow-empty %s <%t

; If this check fails please read test/CodeGen/AArch64/README for instructions on how to resolve it.
; WARN-NOT: warning

;
; CTPOP
;

define <vscale x 16 x i1> @ctpop_nxv16i1(<vscale x 16 x i1> %a) {
; CHECK-LABEL: ctpop_nxv16i1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ret
  %res = call <vscale x 16 x i1> @llvm.ctpop.nxv16i1(<vscale x 16 x i1> %a)
  ret <vscale x 16 x i1> %res
}

define <vscale x 8 x i1> @ctpop_nxv8i1(<vscale x 8 x i1> %a) {
; CHECK-LABEL: ctpop_nxv8i1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ret
  %res = call <vscale x 8 x i1> @llvm.ctpop.nxv8i1(<vscale x 8 x i1> %a)
  ret <vscale x 8 x i1> %res
}

define <vscale x 4 x i1> @ctpop_nxv4i1(<vscale x 4 x i1> %a) {
; CHECK-LABEL: ctpop_nxv4i1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ret
  %res = call <vscale x 4 x i1> @llvm.ctpop.nxv4i1(<vscale x 4 x i1> %a)
  ret <vscale x 4 x i1> %res
}

define <vscale x 2 x i1> @ctpop_nxv2i1(<vscale x 2 x i1> %a) {
; CHECK-LABEL: ctpop_nxv2i1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ret
  %res = call <vscale x 2 x i1> @llvm.ctpop.nxv2i1(<vscale x 2 x i1> %a)
  ret <vscale x 2 x i1> %res
}

; CTLZ

define <vscale x 16 x i1> @ctlz_nxv16i1(<vscale x 16 x i1> %a) {
; CHECK-LABEL: ctlz_nxv16i1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p1.b
; CHECK-NEXT:    not p0.b, p1/z, p0.b
; CHECK-NEXT:    ret
  %res = call <vscale x 16 x i1> @llvm.ctlz.nxv16i1(<vscale x 16 x i1> %a)
  ret <vscale x 16 x i1> %res
}

define <vscale x 8 x i1> @ctlz_nxv8i1(<vscale x 8 x i1> %a) {
; CHECK-LABEL: ctlz_nxv8i1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p1.h
; CHECK-NEXT:    not p0.b, p1/z, p0.b
; CHECK-NEXT:    ret
  %res = call <vscale x 8 x i1> @llvm.ctlz.nxv8i1(<vscale x 8 x i1> %a)
  ret <vscale x 8 x i1> %res
}

define <vscale x 4 x i1> @ctlz_nxv4i1(<vscale x 4 x i1> %a) {
; CHECK-LABEL: ctlz_nxv4i1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p1.s
; CHECK-NEXT:    not p0.b, p1/z, p0.b
; CHECK-NEXT:    ret
  %res = call <vscale x 4 x i1> @llvm.ctlz.nxv4i1(<vscale x 4 x i1> %a)
  ret <vscale x 4 x i1> %res
}

define <vscale x 2 x i1> @ctlz_nxv2i1(<vscale x 2 x i1> %a) {
; CHECK-LABEL: ctlz_nxv2i1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p1.d
; CHECK-NEXT:    not p0.b, p1/z, p0.b
; CHECK-NEXT:    ret
  %res = call <vscale x 2 x i1> @llvm.ctlz.nxv2i1(<vscale x 2 x i1> %a)
  ret <vscale x 2 x i1> %res
}

; CTTZ

define <vscale x 16 x i1> @cttz_nxv16i1(<vscale x 16 x i1> %a) {
; CHECK-LABEL: cttz_nxv16i1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p1.b
; CHECK-NEXT:    not p0.b, p1/z, p0.b
; CHECK-NEXT:    ret
  %res = call <vscale x 16 x i1> @llvm.cttz.nxv16i1(<vscale x 16 x i1> %a)
  ret <vscale x 16 x i1> %res
}

define <vscale x 8 x i1> @cttz_nxv8i1(<vscale x 8 x i1> %a) {
; CHECK-LABEL: cttz_nxv8i1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p1.h
; CHECK-NEXT:    not p0.b, p1/z, p0.b
; CHECK-NEXT:    ret
  %res = call <vscale x 8 x i1> @llvm.cttz.nxv8i1(<vscale x 8 x i1> %a)
  ret <vscale x 8 x i1> %res
}

define <vscale x 4 x i1> @cttz_nxv4i1(<vscale x 4 x i1> %a) {
; CHECK-LABEL: cttz_nxv4i1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p1.s
; CHECK-NEXT:    not p0.b, p1/z, p0.b
; CHECK-NEXT:    ret
  %res = call <vscale x 4 x i1> @llvm.cttz.nxv4i1(<vscale x 4 x i1> %a)
  ret <vscale x 4 x i1> %res
}

define <vscale x 2 x i1> @cttz_nxv2i1(<vscale x 2 x i1> %a) {
; CHECK-LABEL: cttz_nxv2i1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p1.d
; CHECK-NEXT:    not p0.b, p1/z, p0.b
; CHECK-NEXT:    ret
  %res = call <vscale x 2 x i1> @llvm.cttz.nxv2i1(<vscale x 2 x i1> %a)
  ret <vscale x 2 x i1> %res
}

declare <vscale x 16 x i1> @llvm.ctpop.nxv16i1(<vscale x 16 x i1>)
declare <vscale x 8 x i1> @llvm.ctpop.nxv8i1(<vscale x 8 x i1>)
declare <vscale x 4 x i1> @llvm.ctpop.nxv4i1(<vscale x 4 x i1>)
declare <vscale x 2 x i1> @llvm.ctpop.nxv2i1(<vscale x 2 x i1>)

declare <vscale x 16 x i1> @llvm.ctlz.nxv16i1(<vscale x 16 x i1>)
declare <vscale x 8 x i1> @llvm.ctlz.nxv8i1(<vscale x 8 x i1>)
declare <vscale x 4 x i1> @llvm.ctlz.nxv4i1(<vscale x 4 x i1>)
declare <vscale x 2 x i1> @llvm.ctlz.nxv2i1(<vscale x 2 x i1>)

declare <vscale x 16 x i1> @llvm.cttz.nxv16i1(<vscale x 16 x i1>)
declare <vscale x 8 x i1> @llvm.cttz.nxv8i1(<vscale x 8 x i1>)
declare <vscale x 4 x i1> @llvm.cttz.nxv4i1(<vscale x 4 x i1>)
declare <vscale x 2 x i1> @llvm.cttz.nxv2i1(<vscale x 2 x i1>)
