/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.services.ec2.model.GroupIdentifier;
import com.amazonaws.services.ec2.model.NetworkInterfaceAssociation;
import com.amazonaws.services.ec2.model.NetworkInterfaceAttachment;
import com.amazonaws.services.ec2.model.PrivateIpAddress;
import com.amazonaws.services.ec2.model.Tag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class NetworkInterface {
    private String networkInterfaceId;
    private String subnetId;
    private String vpcId;
    private String availabilityZone;
    private String description;
    private String ownerId;
    private String requesterId;
    private Boolean requesterManaged;
    private String status;
    private String macAddress;
    private String privateIpAddress;
    private String privateDnsName;
    private Boolean sourceDestCheck;
    private List<GroupIdentifier> groups;
    private NetworkInterfaceAttachment attachment;
    private NetworkInterfaceAssociation association;
    private List<Tag> tagSet;
    private List<PrivateIpAddress> privateIpAddresses;

    public String getNetworkInterfaceId() {
        return this.networkInterfaceId;
    }

    public void setNetworkInterfaceId(String networkInterfaceId) {
        this.networkInterfaceId = networkInterfaceId;
    }

    public NetworkInterface withNetworkInterfaceId(String networkInterfaceId) {
        this.networkInterfaceId = networkInterfaceId;
        return this;
    }

    public String getSubnetId() {
        return this.subnetId;
    }

    public void setSubnetId(String subnetId) {
        this.subnetId = subnetId;
    }

    public NetworkInterface withSubnetId(String subnetId) {
        this.subnetId = subnetId;
        return this;
    }

    public String getVpcId() {
        return this.vpcId;
    }

    public void setVpcId(String vpcId) {
        this.vpcId = vpcId;
    }

    public NetworkInterface withVpcId(String vpcId) {
        this.vpcId = vpcId;
        return this;
    }

    public String getAvailabilityZone() {
        return this.availabilityZone;
    }

    public void setAvailabilityZone(String availabilityZone) {
        this.availabilityZone = availabilityZone;
    }

    public NetworkInterface withAvailabilityZone(String availabilityZone) {
        this.availabilityZone = availabilityZone;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public NetworkInterface withDescription(String description) {
        this.description = description;
        return this;
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    public void setOwnerId(String ownerId) {
        this.ownerId = ownerId;
    }

    public NetworkInterface withOwnerId(String ownerId) {
        this.ownerId = ownerId;
        return this;
    }

    public String getRequesterId() {
        return this.requesterId;
    }

    public void setRequesterId(String requesterId) {
        this.requesterId = requesterId;
    }

    public NetworkInterface withRequesterId(String requesterId) {
        this.requesterId = requesterId;
        return this;
    }

    public Boolean isRequesterManaged() {
        return this.requesterManaged;
    }

    public void setRequesterManaged(Boolean requesterManaged) {
        this.requesterManaged = requesterManaged;
    }

    public NetworkInterface withRequesterManaged(Boolean requesterManaged) {
        this.requesterManaged = requesterManaged;
        return this;
    }

    public Boolean getRequesterManaged() {
        return this.requesterManaged;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public NetworkInterface withStatus(String status) {
        this.status = status;
        return this;
    }

    public String getMacAddress() {
        return this.macAddress;
    }

    public void setMacAddress(String macAddress) {
        this.macAddress = macAddress;
    }

    public NetworkInterface withMacAddress(String macAddress) {
        this.macAddress = macAddress;
        return this;
    }

    public String getPrivateIpAddress() {
        return this.privateIpAddress;
    }

    public void setPrivateIpAddress(String privateIpAddress) {
        this.privateIpAddress = privateIpAddress;
    }

    public NetworkInterface withPrivateIpAddress(String privateIpAddress) {
        this.privateIpAddress = privateIpAddress;
        return this;
    }

    public String getPrivateDnsName() {
        return this.privateDnsName;
    }

    public void setPrivateDnsName(String privateDnsName) {
        this.privateDnsName = privateDnsName;
    }

    public NetworkInterface withPrivateDnsName(String privateDnsName) {
        this.privateDnsName = privateDnsName;
        return this;
    }

    public Boolean isSourceDestCheck() {
        return this.sourceDestCheck;
    }

    public void setSourceDestCheck(Boolean sourceDestCheck) {
        this.sourceDestCheck = sourceDestCheck;
    }

    public NetworkInterface withSourceDestCheck(Boolean sourceDestCheck) {
        this.sourceDestCheck = sourceDestCheck;
        return this;
    }

    public Boolean getSourceDestCheck() {
        return this.sourceDestCheck;
    }

    public List<GroupIdentifier> getGroups() {
        if (this.groups == null) {
            this.groups = new ArrayList<GroupIdentifier>();
        }
        return this.groups;
    }

    public void setGroups(Collection<GroupIdentifier> groups) {
        if (groups == null) {
            this.groups = null;
            return;
        }
        ArrayList<GroupIdentifier> groupsCopy = new ArrayList<GroupIdentifier>(groups.size());
        groupsCopy.addAll(groups);
        this.groups = groupsCopy;
    }

    public NetworkInterface withGroups(GroupIdentifier ... groups) {
        if (this.getGroups() == null) {
            this.setGroups(new ArrayList<GroupIdentifier>(groups.length));
        }
        for (GroupIdentifier value : groups) {
            this.getGroups().add(value);
        }
        return this;
    }

    public NetworkInterface withGroups(Collection<GroupIdentifier> groups) {
        if (groups == null) {
            this.groups = null;
        } else {
            ArrayList<GroupIdentifier> groupsCopy = new ArrayList<GroupIdentifier>(groups.size());
            groupsCopy.addAll(groups);
            this.groups = groupsCopy;
        }
        return this;
    }

    public NetworkInterfaceAttachment getAttachment() {
        return this.attachment;
    }

    public void setAttachment(NetworkInterfaceAttachment attachment) {
        this.attachment = attachment;
    }

    public NetworkInterface withAttachment(NetworkInterfaceAttachment attachment) {
        this.attachment = attachment;
        return this;
    }

    public NetworkInterfaceAssociation getAssociation() {
        return this.association;
    }

    public void setAssociation(NetworkInterfaceAssociation association) {
        this.association = association;
    }

    public NetworkInterface withAssociation(NetworkInterfaceAssociation association) {
        this.association = association;
        return this;
    }

    public List<Tag> getTagSet() {
        if (this.tagSet == null) {
            this.tagSet = new ArrayList<Tag>();
        }
        return this.tagSet;
    }

    public void setTagSet(Collection<Tag> tagSet) {
        if (tagSet == null) {
            this.tagSet = null;
            return;
        }
        ArrayList<Tag> tagSetCopy = new ArrayList<Tag>(tagSet.size());
        tagSetCopy.addAll(tagSet);
        this.tagSet = tagSetCopy;
    }

    public NetworkInterface withTagSet(Tag ... tagSet) {
        if (this.getTagSet() == null) {
            this.setTagSet(new ArrayList<Tag>(tagSet.length));
        }
        for (Tag value : tagSet) {
            this.getTagSet().add(value);
        }
        return this;
    }

    public NetworkInterface withTagSet(Collection<Tag> tagSet) {
        if (tagSet == null) {
            this.tagSet = null;
        } else {
            ArrayList<Tag> tagSetCopy = new ArrayList<Tag>(tagSet.size());
            tagSetCopy.addAll(tagSet);
            this.tagSet = tagSetCopy;
        }
        return this;
    }

    public List<PrivateIpAddress> getPrivateIpAddresses() {
        if (this.privateIpAddresses == null) {
            this.privateIpAddresses = new ArrayList<PrivateIpAddress>();
        }
        return this.privateIpAddresses;
    }

    public void setPrivateIpAddresses(Collection<PrivateIpAddress> privateIpAddresses) {
        if (privateIpAddresses == null) {
            this.privateIpAddresses = null;
            return;
        }
        ArrayList<PrivateIpAddress> privateIpAddressesCopy = new ArrayList<PrivateIpAddress>(privateIpAddresses.size());
        privateIpAddressesCopy.addAll(privateIpAddresses);
        this.privateIpAddresses = privateIpAddressesCopy;
    }

    public NetworkInterface withPrivateIpAddresses(PrivateIpAddress ... privateIpAddresses) {
        if (this.getPrivateIpAddresses() == null) {
            this.setPrivateIpAddresses(new ArrayList<PrivateIpAddress>(privateIpAddresses.length));
        }
        for (PrivateIpAddress value : privateIpAddresses) {
            this.getPrivateIpAddresses().add(value);
        }
        return this;
    }

    public NetworkInterface withPrivateIpAddresses(Collection<PrivateIpAddress> privateIpAddresses) {
        if (privateIpAddresses == null) {
            this.privateIpAddresses = null;
        } else {
            ArrayList<PrivateIpAddress> privateIpAddressesCopy = new ArrayList<PrivateIpAddress>(privateIpAddresses.size());
            privateIpAddressesCopy.addAll(privateIpAddresses);
            this.privateIpAddresses = privateIpAddressesCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.networkInterfaceId != null) {
            sb.append("NetworkInterfaceId: " + this.networkInterfaceId + ", ");
        }
        if (this.subnetId != null) {
            sb.append("SubnetId: " + this.subnetId + ", ");
        }
        if (this.vpcId != null) {
            sb.append("VpcId: " + this.vpcId + ", ");
        }
        if (this.availabilityZone != null) {
            sb.append("AvailabilityZone: " + this.availabilityZone + ", ");
        }
        if (this.description != null) {
            sb.append("Description: " + this.description + ", ");
        }
        if (this.ownerId != null) {
            sb.append("OwnerId: " + this.ownerId + ", ");
        }
        if (this.requesterId != null) {
            sb.append("RequesterId: " + this.requesterId + ", ");
        }
        if (this.requesterManaged != null) {
            sb.append("RequesterManaged: " + this.requesterManaged + ", ");
        }
        if (this.status != null) {
            sb.append("Status: " + this.status + ", ");
        }
        if (this.macAddress != null) {
            sb.append("MacAddress: " + this.macAddress + ", ");
        }
        if (this.privateIpAddress != null) {
            sb.append("PrivateIpAddress: " + this.privateIpAddress + ", ");
        }
        if (this.privateDnsName != null) {
            sb.append("PrivateDnsName: " + this.privateDnsName + ", ");
        }
        if (this.sourceDestCheck != null) {
            sb.append("SourceDestCheck: " + this.sourceDestCheck + ", ");
        }
        if (this.groups != null) {
            sb.append("Groups: " + this.groups + ", ");
        }
        if (this.attachment != null) {
            sb.append("Attachment: " + this.attachment + ", ");
        }
        if (this.association != null) {
            sb.append("Association: " + this.association + ", ");
        }
        if (this.tagSet != null) {
            sb.append("TagSet: " + this.tagSet + ", ");
        }
        if (this.privateIpAddresses != null) {
            sb.append("PrivateIpAddresses: " + this.privateIpAddresses + ", ");
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNetworkInterfaceId() == null ? 0 : this.getNetworkInterfaceId().hashCode());
        hashCode = 31 * hashCode + (this.getSubnetId() == null ? 0 : this.getSubnetId().hashCode());
        hashCode = 31 * hashCode + (this.getVpcId() == null ? 0 : this.getVpcId().hashCode());
        hashCode = 31 * hashCode + (this.getAvailabilityZone() == null ? 0 : this.getAvailabilityZone().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getOwnerId() == null ? 0 : this.getOwnerId().hashCode());
        hashCode = 31 * hashCode + (this.getRequesterId() == null ? 0 : this.getRequesterId().hashCode());
        hashCode = 31 * hashCode + (this.isRequesterManaged() == null ? 0 : this.isRequesterManaged().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getMacAddress() == null ? 0 : this.getMacAddress().hashCode());
        hashCode = 31 * hashCode + (this.getPrivateIpAddress() == null ? 0 : this.getPrivateIpAddress().hashCode());
        hashCode = 31 * hashCode + (this.getPrivateDnsName() == null ? 0 : this.getPrivateDnsName().hashCode());
        hashCode = 31 * hashCode + (this.isSourceDestCheck() == null ? 0 : this.isSourceDestCheck().hashCode());
        hashCode = 31 * hashCode + (this.getGroups() == null ? 0 : this.getGroups().hashCode());
        hashCode = 31 * hashCode + (this.getAttachment() == null ? 0 : this.getAttachment().hashCode());
        hashCode = 31 * hashCode + (this.getAssociation() == null ? 0 : this.getAssociation().hashCode());
        hashCode = 31 * hashCode + (this.getTagSet() == null ? 0 : this.getTagSet().hashCode());
        hashCode = 31 * hashCode + (this.getPrivateIpAddresses() == null ? 0 : this.getPrivateIpAddresses().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkInterface)) {
            return false;
        }
        NetworkInterface other = (NetworkInterface)obj;
        if (other.getNetworkInterfaceId() == null ^ this.getNetworkInterfaceId() == null) {
            return false;
        }
        if (other.getNetworkInterfaceId() != null && !other.getNetworkInterfaceId().equals(this.getNetworkInterfaceId())) {
            return false;
        }
        if (other.getSubnetId() == null ^ this.getSubnetId() == null) {
            return false;
        }
        if (other.getSubnetId() != null && !other.getSubnetId().equals(this.getSubnetId())) {
            return false;
        }
        if (other.getVpcId() == null ^ this.getVpcId() == null) {
            return false;
        }
        if (other.getVpcId() != null && !other.getVpcId().equals(this.getVpcId())) {
            return false;
        }
        if (other.getAvailabilityZone() == null ^ this.getAvailabilityZone() == null) {
            return false;
        }
        if (other.getAvailabilityZone() != null && !other.getAvailabilityZone().equals(this.getAvailabilityZone())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getOwnerId() == null ^ this.getOwnerId() == null) {
            return false;
        }
        if (other.getOwnerId() != null && !other.getOwnerId().equals(this.getOwnerId())) {
            return false;
        }
        if (other.getRequesterId() == null ^ this.getRequesterId() == null) {
            return false;
        }
        if (other.getRequesterId() != null && !other.getRequesterId().equals(this.getRequesterId())) {
            return false;
        }
        if (other.isRequesterManaged() == null ^ this.isRequesterManaged() == null) {
            return false;
        }
        if (other.isRequesterManaged() != null && !other.isRequesterManaged().equals(this.isRequesterManaged())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getMacAddress() == null ^ this.getMacAddress() == null) {
            return false;
        }
        if (other.getMacAddress() != null && !other.getMacAddress().equals(this.getMacAddress())) {
            return false;
        }
        if (other.getPrivateIpAddress() == null ^ this.getPrivateIpAddress() == null) {
            return false;
        }
        if (other.getPrivateIpAddress() != null && !other.getPrivateIpAddress().equals(this.getPrivateIpAddress())) {
            return false;
        }
        if (other.getPrivateDnsName() == null ^ this.getPrivateDnsName() == null) {
            return false;
        }
        if (other.getPrivateDnsName() != null && !other.getPrivateDnsName().equals(this.getPrivateDnsName())) {
            return false;
        }
        if (other.isSourceDestCheck() == null ^ this.isSourceDestCheck() == null) {
            return false;
        }
        if (other.isSourceDestCheck() != null && !other.isSourceDestCheck().equals(this.isSourceDestCheck())) {
            return false;
        }
        if (other.getGroups() == null ^ this.getGroups() == null) {
            return false;
        }
        if (other.getGroups() != null && !other.getGroups().equals(this.getGroups())) {
            return false;
        }
        if (other.getAttachment() == null ^ this.getAttachment() == null) {
            return false;
        }
        if (other.getAttachment() != null && !other.getAttachment().equals(this.getAttachment())) {
            return false;
        }
        if (other.getAssociation() == null ^ this.getAssociation() == null) {
            return false;
        }
        if (other.getAssociation() != null && !other.getAssociation().equals(this.getAssociation())) {
            return false;
        }
        if (other.getTagSet() == null ^ this.getTagSet() == null) {
            return false;
        }
        if (other.getTagSet() != null && !other.getTagSet().equals(this.getTagSet())) {
            return false;
        }
        if (other.getPrivateIpAddresses() == null ^ this.getPrivateIpAddresses() == null) {
            return false;
        }
        return other.getPrivateIpAddresses() == null || other.getPrivateIpAddresses().equals(this.getPrivateIpAddresses());
    }
}

