/* GStreamer
 * Copyright (C) <2009> Sebastian Dröge <sebastian.droege@collabora.co.uk>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "mxfquark.h"

static const gchar *_quark_strings[] = {
  "instance-uid",
  "generation-uid",
  "other-tags",
  "tag",
  "data",
  "preface",
  "last-modified-date",
  "version",
  "object-model-version",
  "primary-package",
  "identifications",
  "content-storage",
  "operational-pattern",
  "essence-containers",
  "dm-schemes",
  "identification",
  "this-generation-uid",
  "company-name",
  "product-name",
  "product-version",
  "version-string",
  "product-uid",
  "modification-date",
  "toolkit-version",
  "platform",
  "packages",
  "essence-container-data",
  "linked-package",
  "index-sid",
  "body-sid",
  "package-uid",
  "name",
  "package-creation-date",
  "package-modified-date",
  "tracks",
  "material-package",
  "source-package",
  "descriptor",
  "track-id",
  "track-number",
  "track-name",
  "sequence",
  "timeline-track",
  "edit-rate",
  "origin",
  "event-track",
  "event-edit-rate",
  "event-origin",
  "static-track",
  "data-definition",
  "duration",
  "structural-components",
  "timecode-component",
  "start-timecode",
  "rounded-timecode-base",
  "drop-frame",
  "source-clip",
  "start-position",
  "source-track-id",
  "dm-source-clip",
  "track-ids",
  "dm-segment",
  "event-start-position",
  "event-comment",
  "dm-framework",
  "locators",
  "file-descriptor",
  "linked-track-id",
  "sample-rate",
  "container-duration",
  "essence-container",
  "codec",
  "generic-picture-essence-descriptor",
  "signal-standard",
  "frame-layout",
  "stored-width",
  "stored-height",
  "stored-f2-offset",
  "sampled-width",
  "sampled-height",
  "sampled-x-offset",
  "sampled-y-offset",
  "display-height",
  "display-width",
  "display-x-offset",
  "display-y-offset",
  "display-f2-offset",
  "aspect-ratio",
  "active-format-descriptor",
  "video-line-map-0",
  "video-line-map-1",
  "alpha-transparency",
  "capture-gamma",
  "image-alignment-offset",
  "image-start-offset",
  "image-end-offset",
  "field-dominance",
  "picture-essence-coding",
  "cdci-picture-essence-descriptor",
  "component-depth",
  "horizontal-subsampling",
  "vertical-subsampling",
  "color-siting",
  "reversed-byte-order",
  "padding-bits",
  "alpha-sample-depth",
  "black-ref-level",
  "white-ref-level",
  "color-range",
  "rgba-picture-essence-descriptor",
  "component-max-ref",
  "component-min-ref",
  "alpha-max-ref",
  "alpha-min-ref",
  "scanning-direction",
  "pixel-layout",
  "generic-sound-essence-descriptor",
  "audio-sampling-rate",
  "locked",
  "audio-ref-level",
  "electro-spatial-formulation",
  "channel-count",
  "quantization-bits",
  "dial-norm",
  "sound-essence-compression",
  "generic-data-essence-descriptor",
  "data-essence-coding",
  "multiple-descriptor",
  "sub-descriptors",
  "text-locator",
  "locator-name",
  "network-locator",
  "url-string",
  "wave-audio-essence-descriptor",
  "block-align",
  "sequence-offset",
  "avg-bps",
  "channel-assignment",
  "peak-envelope-version",
  "peak-envelope-format",
  "points-per-peak-value",
  "peak-envelope-block-size",
  "peak-channels",
  "peak-frames",
  "peak-of-peaks-position",
  "peak-envelope-timestamp",
  "peak-envelope-data",
  "aes3-audio-essence-descriptor",
  "emphasis",
  "block-start-offset",
  "auxiliary-bits-mode",
  "channel-status-mode",
  "fixed-channel-status-data",
  "user-data-mode",
  "fixed-user-data",
  "linked-timecode-track-id",
  "stream-number",
  "mpeg-video-descriptor",
  "single-sequence",
  "const-b-frames",
  "coded-content-type",
  "low-delay",
  "closed-gop",
  "identical-gop",
  "max-gop",
  "b-picture-count",
  "bitrate",
  "profile-and-level",
};

GQuark _mxf_quark_table[MXF_QUARK_MAX];

void
mxf_quark_initialize (void)
{
  gint i;

  if (G_N_ELEMENTS (_quark_strings) != MXF_QUARK_MAX)
    g_warning ("the quark table is not consistent! %d != %d",
        (int) G_N_ELEMENTS (_quark_strings), MXF_QUARK_MAX);

  for (i = 0; i < MXF_QUARK_MAX; i++) {
    _mxf_quark_table[i] = g_quark_from_static_string (_quark_strings[i]);
  }
}
