/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding;

import htsjdk.samtools.cram.encoding.AbstractBitCodec;
import htsjdk.samtools.cram.encoding.BitCodec;
import htsjdk.samtools.cram.encoding.DataSeriesType;
import htsjdk.samtools.cram.encoding.Encoding;
import htsjdk.samtools.cram.encoding.EncodingFactory;
import htsjdk.samtools.cram.io.BitInputStream;
import htsjdk.samtools.cram.io.BitOutputStream;
import htsjdk.samtools.cram.io.ExposedByteArrayOutputStream;
import htsjdk.samtools.cram.io.ITF8;
import htsjdk.samtools.cram.structure.EncodingID;
import htsjdk.samtools.cram.structure.EncodingParams;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Map;

public class ByteArrayLenEncoding
implements Encoding<byte[]> {
    private static final EncodingID ID = EncodingID.BYTE_ARRAY_LEN;
    private Encoding<Integer> lenEncoding;
    private Encoding<byte[]> byteEncoding;

    @Override
    public EncodingID id() {
        return ID;
    }

    public static EncodingParams toParam(EncodingParams lenParams, EncodingParams byteParams) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byteArrayOutputStream.write((byte)lenParams.id.ordinal());
            ITF8.writeUnsignedITF8(lenParams.params.length, byteArrayOutputStream);
            byteArrayOutputStream.write(lenParams.params);
            byteArrayOutputStream.write((byte)byteParams.id.ordinal());
            ITF8.writeUnsignedITF8(byteParams.params.length, byteArrayOutputStream);
            byteArrayOutputStream.write(byteParams.params);
        }
        catch (IOException e) {
            throw new RuntimeException("It never happened. ");
        }
        return new EncodingParams(ID, byteArrayOutputStream.toByteArray());
    }

    @Override
    public byte[] toByteArray() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byteArrayOutputStream.write((byte)this.lenEncoding.id().ordinal());
            byte[] lenBytes = this.lenEncoding.toByteArray();
            ITF8.writeUnsignedITF8(lenBytes.length, byteArrayOutputStream);
            byteArrayOutputStream.write(lenBytes);
            byteArrayOutputStream.write((byte)this.byteEncoding.id().ordinal());
            byte[] byteBytes = this.byteEncoding.toByteArray();
            ITF8.writeUnsignedITF8(byteBytes.length, byteArrayOutputStream);
            byteArrayOutputStream.write(byteBytes);
        }
        catch (IOException e) {
            throw new RuntimeException("It never happened. ");
        }
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    public void fromByteArray(byte[] data) {
        ByteBuffer buffer = ByteBuffer.wrap(data);
        EncodingFactory encodingFactory = new EncodingFactory();
        EncodingID lenID = EncodingID.values()[buffer.get()];
        this.lenEncoding = encodingFactory.createEncoding(DataSeriesType.INT, lenID);
        int length = ITF8.readUnsignedITF8(buffer);
        byte[] bytes = new byte[length];
        buffer.get(bytes);
        this.lenEncoding.fromByteArray(bytes);
        EncodingID byteID = EncodingID.values()[buffer.get()];
        this.byteEncoding = encodingFactory.createEncoding(DataSeriesType.BYTE_ARRAY, byteID);
        length = ITF8.readUnsignedITF8(buffer);
        bytes = new byte[length];
        buffer.get(bytes);
        this.byteEncoding.fromByteArray(bytes);
    }

    @Override
    public BitCodec<byte[]> buildCodec(Map<Integer, InputStream> inputMap, Map<Integer, ExposedByteArrayOutputStream> outputMap) {
        return new ByteArrayLenCodec(this.lenEncoding.buildCodec(inputMap, outputMap), this.byteEncoding.buildCodec(inputMap, outputMap));
    }

    private static class ByteArrayLenCodec
    extends AbstractBitCodec<byte[]> {
        private final BitCodec<Integer> lenCodec;
        private final BitCodec<byte[]> byteCodec;

        public ByteArrayLenCodec(BitCodec<Integer> lenCodec, BitCodec<byte[]> byteCodec) {
            this.lenCodec = lenCodec;
            this.byteCodec = byteCodec;
        }

        @Override
        public byte[] read(BitInputStream bitInputStream) throws IOException {
            int length = this.lenCodec.read(bitInputStream);
            return this.byteCodec.read(bitInputStream, length);
        }

        @Override
        public byte[] read(BitInputStream bitInputStream, int length) throws IOException {
            throw new RuntimeException("Not implemented.");
        }

        @Override
        public long write(BitOutputStream bitOutputStream, byte[] object) throws IOException {
            long length = this.lenCodec.write(bitOutputStream, object.length);
            return length += this.byteCodec.write(bitOutputStream, object);
        }

        @Override
        public long numberOfBits(byte[] object) {
            return this.lenCodec.numberOfBits(object.length) + this.byteCodec.numberOfBits(object);
        }
    }
}

