/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.tribble.index;

public class Block {
    private final long startPosition;
    private long size;

    public Block(long startPosition, long size) {
        this.startPosition = startPosition;
        this.size = size;
    }

    public long getStartPosition() {
        return this.startPosition;
    }

    public long getEndPosition() {
        return this.startPosition + this.size;
    }

    public void setEndPosition(long endPosition) {
        if (endPosition < this.startPosition) {
            throw new IllegalArgumentException("Attempting to set block end position to " + endPosition + " which is before the start of " + this.startPosition);
        }
        this.size = endPosition - this.startPosition;
    }

    public long getSize() {
        return this.size;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Block)) {
            return false;
        }
        Block otherBlock = (Block)obj;
        return this.startPosition == otherBlock.startPosition && this.size == otherBlock.size;
    }
}

