/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.content.impl;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IContentVisitor;
import org.eclipse.birt.report.engine.content.IImageContent;
import org.eclipse.birt.report.engine.content.IPageContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.content.impl.AbstractContent;
import org.eclipse.birt.report.engine.content.impl.ReportContent;
import org.eclipse.birt.report.engine.ir.DimensionType;
import org.eclipse.birt.report.engine.ir.MasterPageDesign;
import org.eclipse.birt.report.engine.ir.SimpleMasterPageDesign;

public class PageContent
extends AbstractContent
implements IPageContent {
    protected String orientation;
    protected String pageType;
    protected DimensionType pageHeight;
    protected DimensionType pageWidth;
    protected DimensionType headerHeight;
    protected DimensionType footerHeight;
    protected DimensionType leftWidth;
    protected DimensionType rightWidth;
    protected DimensionType marginTop;
    protected DimensionType marginLeft;
    protected DimensionType marginRight;
    protected DimensionType marginBottom;
    protected transient IImageContent waterMark;
    protected long pageNumber = -1L;
    protected static final short FIELD_ORIENTATION = 700;
    protected static final short FIELD_PAGETYPE = 701;
    protected static final short FIELD_PAGEHEIGHT = 702;
    protected static final short FIELD_PAGEWIDTH = 703;
    protected static final short FIELD_HEADERHEIGHT = 704;
    protected static final short FIELD_FOOTERHEIGHT = 705;
    protected static final short FIELD_LEFTWIDTH = 706;
    protected static final short FIELD_RIGHTWIDTH = 707;
    protected static final short FIELD_MARGINTOP = 708;
    protected static final short FIELD_MARGINLEFT = 709;
    protected static final short FIELD_MARGINRIGHT = 710;
    protected static final short FIELD_MARGINBUTTOM = 711;
    protected static final short FIELD_PAGENUMBER = 712;

    @Override
    public int getContentType() {
        return 7;
    }

    protected PageContent(ReportContent report) {
        super(report);
        this.children = new ArrayList();
    }

    protected PageContent(IPageContent page) {
        super(page);
        this.orientation = page.getOrientation();
        this.pageType = page.getPageType();
        this.pageHeight = page.getPageHeight();
        this.pageWidth = page.getPageWidth();
        this.headerHeight = page.getHeaderHeight();
        this.footerHeight = page.getFooterHeight();
        this.leftWidth = page.getLeftWidth();
        this.rightWidth = page.getRightWidth();
        this.marginTop = page.getMarginTop();
        this.marginLeft = page.getMarginLeft();
        this.marginRight = page.getMarginRight();
        this.marginBottom = page.getMarginBottom();
        this.waterMark = page.getWaterMark();
        this.pageNumber = page.getPageNumber();
    }

    @Override
    public void setGenerateBy(Object design) {
        super.setGenerateBy(design);
        if (design instanceof MasterPageDesign) {
            MasterPageDesign page = (MasterPageDesign)design;
            this.orientation = page.getOrientation();
            this.pageType = page.getPageType();
            this.pageHeight = page.getPageHeight();
            this.pageWidth = page.getPageWidth();
            this.marginTop = page.getTopMargin();
            this.marginLeft = page.getLeftMargin();
            this.marginRight = page.getRightMargin();
            this.marginBottom = page.getBottomMargin();
            if (page instanceof SimpleMasterPageDesign) {
                this.headerHeight = ((SimpleMasterPageDesign)page).getHeaderHeight();
                this.footerHeight = ((SimpleMasterPageDesign)page).getFooterHeight();
            }
            if (this.headerHeight == null) {
                this.headerHeight = new DimensionType(0.25, "in");
            }
            if (this.footerHeight == null) {
                this.footerHeight = new DimensionType(0.25, "in");
            }
        }
    }

    @Override
    public Object accept(IContentVisitor visitor, Object value) throws BirtException {
        return visitor.visitPage(this, value);
    }

    MasterPageDesign getMasterPage() {
        return (MasterPageDesign)this.generateBy;
    }

    @Override
    public String getOrientation() {
        return this.orientation;
    }

    @Override
    public String getPageType() {
        return this.pageType;
    }

    @Override
    public DimensionType getPageHeight() {
        return this.pageHeight;
    }

    @Override
    public DimensionType getPageWidth() {
        return this.pageWidth;
    }

    @Override
    public IImageContent getWaterMark() {
        return this.waterMark;
    }

    @Override
    public Collection getHeader() {
        IContent header = this.getPageHeader();
        if (header != null) {
            return header.getChildren();
        }
        return null;
    }

    @Override
    public Collection getFooter() {
        IContent footer = this.getPageFooter();
        if (footer != null) {
            return footer.getChildren();
        }
        return null;
    }

    @Override
    public void setPageHeader(IContent header) {
        ArrayList cs = (ArrayList)this.children;
        if (cs.size() >= 1) {
            cs.set(0, header);
        } else {
            cs.ensureCapacity(1);
            cs.add(0, header);
        }
    }

    @Override
    public void setPageBody(IContent body) {
        ArrayList cs = (ArrayList)this.children;
        if (cs.size() >= 2) {
            cs.set(1, body);
        } else {
            cs.ensureCapacity(2);
            cs.add(1, body);
        }
    }

    @Override
    public void setPageFooter(IContent footer) {
        ArrayList cs = (ArrayList)this.children;
        if (cs.size() >= 3) {
            cs.set(2, footer);
        } else {
            cs.ensureCapacity(3);
            cs.add(2, footer);
        }
    }

    @Override
    public IContent getPageHeader() {
        return (IContent)((ArrayList)this.children).get(0);
    }

    @Override
    public IContent getPageBody() {
        return (IContent)((ArrayList)this.children).get(1);
    }

    @Override
    public IContent getPageFooter() {
        return (IContent)((ArrayList)this.children).get(2);
    }

    public void setOrientation(String orientation) {
        this.orientation = orientation;
    }

    public void setPageHeight(DimensionType pageHeight) {
        this.pageHeight = pageHeight;
    }

    public void setPageType(String pageType) {
        this.pageType = pageType;
    }

    public void setPageWidth(DimensionType pageWidth) {
        this.pageWidth = pageWidth;
    }

    public void setWaterMark(IImageContent waterMark) {
        this.waterMark = waterMark;
    }

    @Override
    public DimensionType getMarginTop() {
        return this.marginTop;
    }

    @Override
    public DimensionType getMarginBottom() {
        return this.marginBottom;
    }

    @Override
    public DimensionType getMarginLeft() {
        return this.marginLeft;
    }

    @Override
    public DimensionType getMarginRight() {
        return this.marginRight;
    }

    @Override
    public DimensionType getHeaderHeight() {
        return this.headerHeight;
    }

    @Override
    public DimensionType getFooterHeight() {
        return this.footerHeight;
    }

    @Override
    public DimensionType getLeftWidth() {
        return this.leftWidth;
    }

    @Override
    public DimensionType getRightWidth() {
        return this.rightWidth;
    }

    @Override
    public IStyle getContentComputedStyle() {
        IContent body = this.getPageBody();
        return body.getComputedStyle();
    }

    @Override
    public IStyle getContentStyle() {
        IContent body = this.getPageBody();
        return body.getStyle();
    }

    @Override
    public void setPageNumber(long pn) {
        this.pageNumber = pn;
    }

    @Override
    public long getPageNumber() {
        return this.pageNumber;
    }

    @Override
    protected void writeFields(DataOutputStream out) throws IOException {
        super.writeFields(out);
        if (this.orientation != null) {
            IOUtil.writeShort((OutputStream)out, (short)700);
            IOUtil.writeString((DataOutputStream)out, (String)this.orientation);
        }
        if (this.pageType != null) {
            IOUtil.writeShort((OutputStream)out, (short)701);
            IOUtil.writeString((DataOutputStream)out, (String)this.pageType);
        }
        if (this.pageHeight != null) {
            IOUtil.writeShort((OutputStream)out, (short)702);
            this.pageHeight.writeObject(out);
        }
        if (this.pageWidth != null) {
            IOUtil.writeShort((OutputStream)out, (short)703);
            this.pageWidth.writeObject(out);
        }
        if (this.headerHeight != null) {
            IOUtil.writeShort((OutputStream)out, (short)704);
            this.headerHeight.writeObject(out);
        }
        if (this.footerHeight != null) {
            IOUtil.writeShort((OutputStream)out, (short)705);
            this.footerHeight.writeObject(out);
        }
        if (this.leftWidth != null) {
            IOUtil.writeShort((OutputStream)out, (short)706);
            this.leftWidth.writeObject(out);
        }
        if (this.rightWidth != null) {
            IOUtil.writeShort((OutputStream)out, (short)707);
            this.rightWidth.writeObject(out);
        }
        if (this.marginTop != null) {
            IOUtil.writeShort((OutputStream)out, (short)708);
            this.marginTop.writeObject(out);
        }
        if (this.marginLeft != null) {
            IOUtil.writeShort((OutputStream)out, (short)709);
            this.marginLeft.writeObject(out);
        }
        if (this.marginRight != null) {
            IOUtil.writeShort((OutputStream)out, (short)710);
            this.marginRight.writeObject(out);
        }
        if (this.marginBottom != null) {
            IOUtil.writeShort((OutputStream)out, (short)711);
            this.marginBottom.writeObject(out);
        }
        if (this.pageNumber != -1L) {
            IOUtil.writeShort((OutputStream)out, (short)712);
            IOUtil.writeLong((DataOutputStream)out, (long)this.pageNumber);
        }
    }

    @Override
    public boolean needSave() {
        return true;
    }

    @Override
    protected void readField(int version, int filedId, DataInputStream in, ClassLoader loader) throws IOException {
        switch (filedId) {
            case 700: {
                this.orientation = IOUtil.readString((DataInputStream)in);
                break;
            }
            case 701: {
                this.pageType = IOUtil.readString((DataInputStream)in);
                break;
            }
            case 702: {
                this.pageHeight = new DimensionType();
                this.pageHeight.readObject(in);
                break;
            }
            case 703: {
                this.pageWidth = new DimensionType();
                this.pageWidth.readObject(in);
                break;
            }
            case 704: {
                this.headerHeight = new DimensionType();
                this.headerHeight.readObject(in);
                break;
            }
            case 705: {
                this.footerHeight = new DimensionType();
                this.footerHeight.readObject(in);
                break;
            }
            case 706: {
                this.leftWidth = new DimensionType();
                this.leftWidth.readObject(in);
                break;
            }
            case 707: {
                this.rightWidth = new DimensionType();
                this.rightWidth.readObject(in);
                break;
            }
            case 708: {
                this.marginTop = new DimensionType();
                this.marginTop.readObject(in);
                break;
            }
            case 709: {
                this.marginLeft = new DimensionType();
                this.marginLeft.readObject(in);
                break;
            }
            case 710: {
                this.marginRight = new DimensionType();
                this.marginRight.readObject(in);
                break;
            }
            case 711: {
                this.marginBottom = new DimensionType();
                this.marginBottom.readObject(in);
                break;
            }
            case 712: {
                this.pageNumber = IOUtil.readLong((DataInputStream)in);
                break;
            }
            default: {
                super.readField(version, filedId, in, loader);
            }
        }
    }

    @Override
    protected IContent cloneContent() {
        return new PageContent(this);
    }
}

