/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.actions;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.egit.core.internal.job.JobUtil;
import org.eclipse.egit.core.op.IEGitOperation;
import org.eclipse.egit.core.op.ResetOperation;
import org.eclipse.egit.ui.JobFamilies;
import org.eclipse.egit.ui.internal.UIIcons;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.services.IServiceLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResetMenu {
    public static final String RESET = "org.eclipse.egit.ui.history.Reset";
    public static final String RESET_MODE = "org.eclipse.egit.ui.history.ResetMode";

    public static MenuManager createMenu(IWorkbenchSite site) {
        MenuManager resetManager = new MenuManager(UIText.GitHistoryPage_ResetMenuLabel, UIIcons.RESET, "Reset");
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put(RESET_MODE, ResetCommand.ResetType.SOFT.name());
        resetManager.add((IContributionItem)ResetMenu.getCommandContributionItem(RESET, UIText.GitHistoryPage_ResetSoftMenuLabel, parameters, site));
        parameters = new HashMap();
        parameters.put(RESET_MODE, ResetCommand.ResetType.MIXED.name());
        resetManager.add((IContributionItem)ResetMenu.getCommandContributionItem(RESET, UIText.GitHistoryPage_ResetMixedMenuLabel, parameters, site));
        parameters = new HashMap();
        parameters.put(RESET_MODE, ResetCommand.ResetType.HARD.name());
        resetManager.add((IContributionItem)ResetMenu.getCommandContributionItem(RESET, UIText.GitHistoryPage_ResetHardMenuLabel, parameters, site));
        return resetManager;
    }

    private static CommandContributionItem getCommandContributionItem(String commandId, String menuLabel, Map<String, String> parameters, IWorkbenchSite site) {
        CommandContributionItemParameter parameter = new CommandContributionItemParameter((IServiceLocator)site, commandId, commandId, 8);
        parameter.label = menuLabel;
        parameter.parameters = parameters;
        return new CommandContributionItem(parameter);
    }

    public static void performReset(ExecutionEvent event, Repository repo, ObjectId commitId, String resetMode) throws ExecutionException {
        String jobName;
        ResetCommand.ResetType resetType = ResetCommand.ResetType.valueOf((String)resetMode);
        switch (resetType) {
            case HARD: {
                if (!MessageDialog.openQuestion((Shell)HandlerUtil.getActiveShellChecked((ExecutionEvent)event), (String)UIText.ResetTargetSelectionDialog_ResetQuestion, (String)UIText.ResetTargetSelectionDialog_ResetConfirmQuestion)) {
                    return;
                }
                jobName = UIText.HardResetToRevisionAction_hardReset;
                break;
            }
            case SOFT: {
                jobName = UIText.SoftResetToRevisionAction_softReset;
                break;
            }
            case MIXED: {
                jobName = UIText.MixedResetToRevisionAction_mixedReset;
                break;
            }
            default: {
                return;
            }
        }
        ResetOperation operation = new ResetOperation(repo, commitId.getName(), resetType);
        JobUtil.scheduleUserWorkspaceJob((IEGitOperation)operation, (String)jobName, (Object)JobFamilies.RESET);
    }
}

