/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.filters;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.ui.internal.navigator.extensions.NavigatorContentRegistryReader;
import org.eclipse.ui.internal.navigator.filters.CommonFilterDescriptor;
import org.eclipse.ui.navigator.INavigatorContentService;

public class CommonFilterDescriptorManager {
    private static final CommonFilterDescriptorManager INSTANCE = new CommonFilterDescriptorManager();
    private static final CommonFilterDescriptor[] NO_FILTER_DESCRIPTORS = new CommonFilterDescriptor[0];
    private final Map filters = new HashMap();
    public static final boolean FOR_UI = true;

    public static CommonFilterDescriptorManager getInstance() {
        return INSTANCE;
    }

    private CommonFilterDescriptorManager() {
        new CommonFilterDescriptorRegistry().readRegistry();
    }

    public CommonFilterDescriptor[] findVisibleFilters(INavigatorContentService contentService) {
        return this.findVisibleFilters(contentService, false);
    }

    public CommonFilterDescriptor[] findVisibleFilters(INavigatorContentService contentService, boolean forUI) {
        ArrayList<CommonFilterDescriptor> visibleFilters = new ArrayList<CommonFilterDescriptor>();
        Iterator filtersItr = this.filters.entrySet().iterator();
        while (filtersItr.hasNext()) {
            CommonFilterDescriptor descriptor = (CommonFilterDescriptor)filtersItr.next().getValue();
            if (forUI && !descriptor.isVisibleInUi() || !contentService.isVisible(descriptor.getId())) continue;
            visibleFilters.add(descriptor);
        }
        if (visibleFilters.size() == 0) {
            return NO_FILTER_DESCRIPTORS;
        }
        return visibleFilters.toArray(new CommonFilterDescriptor[visibleFilters.size()]);
    }

    public CommonFilterDescriptor getFilterById(String id) {
        return (CommonFilterDescriptor)this.filters.get(id);
    }

    private void addCommonFilter(CommonFilterDescriptor aDescriptor) {
        this.filters.put(aDescriptor.getId(), aDescriptor);
    }

    private class CommonFilterDescriptorRegistry
    extends NavigatorContentRegistryReader {
        private CommonFilterDescriptorRegistry() {
        }

        protected boolean readElement(IConfigurationElement element) {
            if ("commonFilter".equals(element.getName())) {
                CommonFilterDescriptorManager.this.addCommonFilter(new CommonFilterDescriptor(element));
                return true;
            }
            return super.readElement(element);
        }
    }
}

