/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.ui;

import com.nvidia.cuda.ide.util.ColumnsDragSupport;
import com.nvidia.viper.BandwidthFormatter;
import com.nvidia.viper.ByteSizeFormatter;
import com.nvidia.viper.FlopsFormatter;
import com.nvidia.viper.FrequencyFormatter;
import com.nvidia.viper.PowerFormatter;
import com.nvidia.viper.StringUtils;
import com.nvidia.viper.TimeFormatter;
import com.nvidia.viper.ViewUtils;
import com.nvidia.viper.ViperComputeDictionary;
import com.nvidia.viper.ViperExceptionHandler;
import com.nvidia.viper.ViperImages;
import com.nvidia.viper.activity.CuptiActivityComputeApiKind;
import com.nvidia.viper.activity.CuptiActivityFlag;
import com.nvidia.viper.activity.CuptiActivityMarkerData;
import com.nvidia.viper.activity.CuptiActivityMemoryKind;
import com.nvidia.viper.activity.CuptiActivityPartitionedGlobalCacheConfigKind;
import com.nvidia.viper.activity.CuptiActivityUvmAccessKind;
import com.nvidia.viper.activity.CuptiActivityUvmCounter;
import com.nvidia.viper.activity.CuptiActivityUvmMigrationCause;
import com.nvidia.viper.activity.CuptiActivityUvmRemoteMapCause;
import com.nvidia.viper.activity.CuptiDeviceAttribute;
import com.nvidia.viper.activity.CuptiEnvironmentClocksThrottleReason;
import com.nvidia.viper.activity.CuptiLaunchType;
import com.nvidia.viper.analysis.AnalysisDescriptor;
import com.nvidia.viper.analysis.AnalysisResult;
import com.nvidia.viper.analysis.AnalysisResultGPUCompute;
import com.nvidia.viper.analysis.AnalysisResultGPUComputeEfficiency;
import com.nvidia.viper.analysis.AnalysisResultGPUOverlap;
import com.nvidia.viper.analysis.AnalysisResultGlobalMemoryEfficiency;
import com.nvidia.viper.analysis.AnalysisResultInterval;
import com.nvidia.viper.analysis.AnalysisResultKernelConcurrency;
import com.nvidia.viper.analysis.AnalysisResultKernelExecutionEfficiency;
import com.nvidia.viper.analysis.AnalysisResultKernelOccupancy;
import com.nvidia.viper.analysis.AnalysisResultLocalMemoryOverhead;
import com.nvidia.viper.analysis.AnalysisResultMemcpyOverlap;
import com.nvidia.viper.analysis.AnalysisResultMemcpySize;
import com.nvidia.viper.analysis.AnalysisResultMemcpyThroughput;
import com.nvidia.viper.analysis.AnalysisResultOccupancy;
import com.nvidia.viper.analysis.AnalysisResultSharedMemoryEfficiency;
import com.nvidia.viper.analysis.AnalysisResultWarpExecutionEfficiency;
import com.nvidia.viper.analysis.AnalysisStage;
import com.nvidia.viper.analysis.OccupancyCalculator;
import com.nvidia.viper.fs.LocalFileSystem;
import com.nvidia.viper.jni.ChironException;
import com.nvidia.viper.jni.CuCacheConfig;
import com.nvidia.viper.jni.CuptiMetricValueKind;
import com.nvidia.viper.jni.NativeChiron;
import com.nvidia.viper.model.Analysis;
import com.nvidia.viper.model.CriticalPath;
import com.nvidia.viper.model.Executable;
import com.nvidia.viper.model.IModel;
import com.nvidia.viper.model.ISessionPropertyChangeListener;
import com.nvidia.viper.model.ITimelineInterval;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.model.SourceLocation;
import com.nvidia.viper.model.Timeline;
import com.nvidia.viper.model.TimelineContext;
import com.nvidia.viper.model.TimelineDevice;
import com.nvidia.viper.model.TimelineIntervalAPI;
import com.nvidia.viper.model.TimelineIntervalEnvironment;
import com.nvidia.viper.model.TimelineIntervalHierarchy;
import com.nvidia.viper.model.TimelineIntervalKernel;
import com.nvidia.viper.model.TimelineIntervalKind;
import com.nvidia.viper.model.TimelineIntervalMarker;
import com.nvidia.viper.model.TimelineIntervalMemcpy;
import com.nvidia.viper.model.TimelineIntervalMemset;
import com.nvidia.viper.model.TimelineIntervalNvlink;
import com.nvidia.viper.model.TimelineIntervalOpenAcc;
import com.nvidia.viper.model.TimelineIntervalPThread;
import com.nvidia.viper.model.TimelineIntervalPair;
import com.nvidia.viper.model.TimelineIntervalRange;
import com.nvidia.viper.model.TimelineIntervalUVM;
import com.nvidia.viper.model.TimelineKernel;
import com.nvidia.viper.model.TimelineKind;
import com.nvidia.viper.model.TimelineMemcpy;
import com.nvidia.viper.model.TimelineNvlink;
import com.nvidia.viper.model.TimelineOverhead;
import com.nvidia.viper.model.TimelineUVM;
import com.nvidia.viper.model.UvmManager;
import com.nvidia.viper.ui.NVLinkPropertyLegendControl;
import com.nvidia.viper.ui.PreciseTimeFormatter;
import com.nvidia.viper.ui.UIUtils;
import com.nvidia.viper.ui.UVMColorLegendControl;
import com.nvidia.viper.ui.UVMThrashingLegendControl;
import com.nvidia.viper.value.IValue;
import com.nvidia.viper.value.ValueBandwidth;
import com.nvidia.viper.value.ValueByteSize;
import com.nvidia.viper.value.ValuePercent;
import java.io.File;
import java.nio.file.Paths;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;

public class TimelinePropertyComposite
extends Composite
implements ISessionPropertyChangeListener {
    private static NumberFormat percentFormatter = NumberFormat.getPercentInstance();
    private static NumberFormat percentIntegerFormatter = NumberFormat.getPercentInstance();
    private static NumberFormat numberFormatter = NumberFormat.getInstance();
    private Session activeSession;
    protected TimelineIntervalPair input;
    private final Map<TreeItem, String> nodeTooltips = new HashMap<TreeItem, String>();
    private final Label title;
    private final Label note;
    private final Tree tree;
    private final TreeColumn nameColumn;
    private final TreeColumn valueColumn;
    private SashForm sashForm;
    private Composite treeControl;
    private SashForm nestedSashForm;
    private UVMColorLegendControl uvmLegendControl;
    private UVMThrashingLegendControl uvmThrashingLegendControl;
    NVLinkPropertyLegendControl nvlinkLegendControl;
    private static String NOTE_NO_SELECTION;
    private static String NOTE_UVM_SELECTION;
    private static String NOTE_SELECT_UVM_EXE;
    private static String UVM_SOURCE_KEY;
    private static String UVM_EXE_TOOLTIP;
    private static String SYMBOL_DEGREE_CELSIUS;

    static {
        numberFormatter.setMaximumFractionDigits(32);
        numberFormatter.setGroupingUsed(false);
        percentFormatter.setMaximumFractionDigits(32);
        percentFormatter.setGroupingUsed(false);
        percentIntegerFormatter.setMaximumFractionDigits(0);
        percentIntegerFormatter.setGroupingUsed(false);
        NOTE_NO_SELECTION = "Select or highlight a single interval to see properties";
        NOTE_UVM_SELECTION = "The segment mode is used for this timeline. In this mode the timeline is split into equal width segments and only aggregated data values for each time segment are shown.";
        NOTE_SELECT_UVM_EXE = "Browse for executable...";
        UVM_SOURCE_KEY = "uvm-source";
        UVM_EXE_TOOLTIP = "Double click to select the executable file, which is required to find ";
        SYMBOL_DEGREE_CELSIUS = "\u00b0C";
    }

    public TimelinePropertyComposite(Composite parent, int style) {
        super(parent, style);
        GridLayout gl = new GridLayout(1, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        this.setLayout((Layout)gl);
        this.sashForm = new SashForm((Composite)this, 512);
        this.sashForm.setLayout((Layout)new RowLayout());
        this.sashForm.setLayoutData((Object)new GridData(4, 4, true, true));
        this.treeControl = new Composite((Composite)this.sashForm, 0);
        this.treeControl.setLayout((Layout)gl);
        this.title = new Label(this.treeControl, 0);
        GridData gd = new GridData(4, 128, true, false);
        gd.verticalIndent = 5;
        gd.horizontalIndent = 5;
        this.title.setLayoutData((Object)gd);
        UIUtils.boldFont((Control)this.title);
        this.note = new Label(this.treeControl, 64);
        this.note.setLayoutData((Object)new GridData(4, 128, true, false));
        this.note.setText(NOTE_NO_SELECTION);
        this.tree = new Tree(this.treeControl, 2816);
        this.tree.setLayoutData((Object)new GridData(4, 4, true, true));
        this.tree.setLinesVisible(true);
        this.tree.setHeaderVisible(false);
        new ColumnsDragSupport(this.tree);
        this.nameColumn = new TreeColumn(this.tree, 0);
        this.nameColumn.setText("Name");
        this.valueColumn = new TreeColumn(this.tree, 0);
        this.valueColumn.setText("Value");
        this.tree.addMouseTrackListener(new MouseTrackListener(){

            public void mouseHover(MouseEvent e) {
                TreeItem item = TimelinePropertyComposite.this.tree.getItem(new Point(e.x, e.y));
                String toolTip = (String)TimelinePropertyComposite.this.nodeTooltips.get(item);
                if (item != null && toolTip != null) {
                    TimelinePropertyComposite.this.tree.setToolTipText((String)TimelinePropertyComposite.this.nodeTooltips.get(item));
                } else {
                    TimelinePropertyComposite.this.tree.setToolTipText(null);
                }
            }

            public void mouseExit(MouseEvent e) {
                TimelinePropertyComposite.this.tree.setToolTipText(null);
            }

            public void mouseEnter(MouseEvent e) {
                TimelinePropertyComposite.this.tree.setToolTipText(null);
            }
        });
        this.tree.addListener(17, new Listener(){

            public void handleEvent(Event event) {
                TreeItem item = (TreeItem)event.item;
                if (item.getText().equals("Memory operations") && item.getData() instanceof TimelineIntervalUVM) {
                    TreeItem[] children;
                    TimelineIntervalUVM interval = (TimelineIntervalUVM)item.getData();
                    interval.computePC(TimelinePropertyComposite.this.activeSession);
                    TreeItem[] treeItemArray = children = item.getItems();
                    int n = children.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TreeItem child = treeItemArray[n2];
                        if (child.getText(0).equals("Allocation")) {
                            TimelinePropertyComposite.this.setMemoryItemText(child, interval.hasAllocPC(), interval.getAllocLocation());
                        } else if (child.getText(0).equals("Free")) {
                            TimelinePropertyComposite.this.setMemoryItemText(child, interval.hasFreePC(), interval.getFreeLocation());
                        }
                        ++n2;
                    }
                }
            }
        });
        this.tree.addListener(8, new Listener(){

            public void handleEvent(Event event) {
                Object uvmData;
                Point point = new Point(event.x, event.y);
                TreeItem item = TimelinePropertyComposite.this.tree.getItem(point);
                if (item != null && item.getText(0).equals("Source File")) {
                    Object dataObj = item.getData("openacc-source");
                    if (dataObj != null && dataObj instanceof TimelineIntervalOpenAcc) {
                        TimelineIntervalOpenAcc oaccObj = (TimelineIntervalOpenAcc)dataObj;
                        String oaccFileName = Paths.get(oaccObj.getFullFilePath(), new String[0]).getFileName().toString();
                        ViewUtils.openSourceView(TimelinePropertyComposite.this.activeSession, PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), oaccObj.getRelativeFilePath(), oaccObj.getFullFilePath(), oaccObj.getLineNo());
                        ViewUtils.addMarker(TimelinePropertyComposite.this.activeSession, oaccFileName, oaccObj.getFullFilePath(), oaccObj.getLineNo(), oaccObj.getDisplayName());
                    }
                } else if (item != null && item.getText(1).equals(NOTE_SELECT_UVM_EXE)) {
                    String path = LocalFileSystem.browseForFileOpen(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Executable", "", "");
                    if (path != null) {
                        Executable exe = new Executable();
                        exe.setFilename(path);
                        TimelinePropertyComposite.this.activeSession.setExecutable(exe);
                        TimelinePropertyComposite.this.activeSession.getUvmManager().correlatePageFaultPcOffsets();
                        Object uvmData2 = item.getData(UVM_SOURCE_KEY);
                        if (uvmData2 instanceof TimelineIntervalUVM) {
                            TimelineIntervalUVM interval = (TimelineIntervalUVM)uvmData2;
                            TimelinePropertyComposite.this.tree.removeAll();
                            TimelinePropertyComposite.this.showUVMInterval(TimelinePropertyComposite.this.input.getTimeline(), interval, null);
                        }
                    }
                } else if (item != null && item.getText(0).equals("Source Location")) {
                    Object uvmData3 = item.getData(UVM_SOURCE_KEY);
                    if (uvmData3 instanceof TimelineIntervalUVM) {
                        TimelineIntervalUVM interval = (TimelineIntervalUVM)uvmData3;
                        ViewUtils.openSourceView(TimelinePropertyComposite.this.activeSession, PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), interval.getFileName(), interval.getFilePath(), interval.getLineNumber());
                        ViewUtils.addMarker(TimelinePropertyComposite.this.activeSession, interval.getFileName(), interval.getFilePath(), interval.getLineNumber(), "CPU page fault");
                    }
                } else if (item != null && (uvmData = item.getData()) instanceof TimelineIntervalUVM) {
                    TimelineIntervalUVM interval = (TimelineIntervalUVM)uvmData;
                    SourceLocation location = null;
                    String tooltip = null;
                    if (item.getText(0).equals("Allocation")) {
                        location = interval.getAllocLocation();
                        tooltip = interval.getAllocTooltipString();
                    } else if (item.getText(0).equals("Free")) {
                        location = interval.getFreeLocation();
                        tooltip = interval.getFreeTooltipString();
                    } else {
                        return;
                    }
                    ViewUtils.openSourceView(TimelinePropertyComposite.this.activeSession, PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), location.getFileName(), location.getFilePath(), location.getLineNumber());
                    ViewUtils.addMarker(TimelinePropertyComposite.this.activeSession, location.getFileName(), location.getFilePath(), location.getLineNumber(), tooltip);
                }
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (TimelinePropertyComposite.this.activeSession != null) {
                    TimelinePropertyComposite.this.activeSession.removePropertyChangeListener(TimelinePropertyComposite.this);
                }
            }
        });
        this.nestedSashForm = new SashForm((Composite)this.sashForm, 512);
        this.uvmLegendControl = new UVMColorLegendControl((Composite)this.nestedSashForm, 2048);
        this.uvmLegendControl.setLayoutData(new GridData(4, 4, true, true));
        this.uvmThrashingLegendControl = new UVMThrashingLegendControl((Composite)this.nestedSashForm, 2048);
        this.uvmThrashingLegendControl.setLayoutData(new GridData(4, 4, true, true));
        this.nvlinkLegendControl = new NVLinkPropertyLegendControl((Composite)this.nestedSashForm, 2048);
        this.nvlinkLegendControl.setLayoutData(new GridData(4, 4, true, true));
        this.sashForm.setMaximizedControl((Control)this.treeControl);
    }

    protected void checkSubclass() {
        assert (this.getClass() == TimelinePropertyComposite.class);
    }

    protected void appendDependencyInfo(Timeline timeline, ITimelineInterval interval) {
        CriticalPath criticalPath = this.activeSession.getCriticalPath();
        if (criticalPath != null) {
            long criticalPathTime = 0L;
            long waitingTime = 0L;
            try {
                long chironId;
                long pdm = this.activeSession.getTimelinePdms().get(0).getNativeHandle();
                NativeChiron.ParadigmKind kind = NativeChiron.ParadigmKind.ParadigmCuda;
                long nativeId = interval.getID();
                if (interval instanceof TimelineIntervalPThread) {
                    kind = NativeChiron.ParadigmKind.ParadigmPThread;
                    nativeId = ((TimelineIntervalPThread)interval).getPThreadId();
                }
                if ((chironId = NativeChiron.getIdForActivity(pdm, kind.getCode(), nativeId)) != 0L) {
                    criticalPathTime = NativeChiron.getTimeOnCriticalPath(pdm, chironId);
                    waitingTime = NativeChiron.getWaitingTime(pdm, chironId);
                    TreeItem analysisNode = this.addNode(null, "Dependency Analysis", null, null, null);
                    this.addNode(analysisNode, "Time on Critical Path", new PreciseTimeFormatter(criticalPathTime), null, "The time the interval is on critical execution path");
                    this.addNode(analysisNode, "Waiting Time", new PreciseTimeFormatter(waitingTime), null, "The time the interval is stalled waiting on some concurrent activity");
                    analysisNode.setExpanded(true);
                }
            }
            catch (ChironException e) {
                ViperExceptionHandler.logError(e.getMessage());
            }
        }
    }

    protected void setInput(TimelineIntervalPair pair, boolean force) {
        boolean changed;
        boolean bl = !force && (this.input == null ? pair == null : this.input.equals(pair)) ? false : (changed = true);
        if (changed) {
            this.input = pair;
            this.setTitle(null, null);
            this.tree.removeAll();
            this.sashForm.setMaximizedControl((Control)this.treeControl);
            if (this.input == null) {
                this.note.setText(NOTE_NO_SELECTION);
                ((GridData)this.note.getLayoutData()).exclude = false;
                this.note.setVisible(true);
            } else {
                ((GridData)this.note.getLayoutData()).exclude = true;
                this.note.setVisible(false);
                ITimelineInterval interval = this.input.getInterval(this.activeSession);
                Timeline timeline = this.input.getTimeline();
                this.handleNestedSashForm(interval, timeline);
                if (interval != null) {
                    if (interval instanceof TimelineIntervalAPI) {
                        this.showAPIInterval(timeline, (TimelineIntervalAPI)interval);
                    } else if (interval instanceof TimelineIntervalKernel) {
                        this.showKernelInterval(timeline, (TimelineIntervalKernel)interval, null);
                    } else if (interval instanceof TimelineIntervalMemcpy) {
                        this.showMemcpyInterval(timeline, (TimelineIntervalMemcpy)interval, null);
                    } else if (interval instanceof TimelineIntervalMemset) {
                        this.showMemsetInterval(timeline, (TimelineIntervalMemset)interval, null);
                    } else if (interval instanceof TimelineIntervalMarker) {
                        this.showMarkerInterval(timeline, (TimelineIntervalMarker)interval);
                    } else if (interval instanceof TimelineIntervalRange) {
                        this.showRangeInterval(timeline, (TimelineIntervalRange)interval);
                    } else if (interval instanceof TimelineIntervalEnvironment) {
                        this.showEnvironmentInterval(timeline, (TimelineIntervalEnvironment)interval);
                    } else if (interval instanceof TimelineIntervalUVM) {
                        this.showUVMInterval(timeline, (TimelineIntervalUVM)interval, null);
                    } else if (interval instanceof TimelineIntervalOpenAcc) {
                        this.showOpenAccInterval(timeline, (TimelineIntervalOpenAcc)interval);
                    } else if (interval instanceof TimelineIntervalNvlink) {
                        this.showNvlinkInterval(timeline, (TimelineIntervalNvlink)interval);
                    } else {
                        this.showInterval(timeline, interval);
                    }
                    this.appendDependencyInfo(timeline, interval);
                } else if (timeline != null) {
                    if (TimelineKind.KERNELS.equals((Object)timeline.getKind())) {
                        this.showComputeTimeline(timeline);
                    } else if (timeline instanceof TimelineKernel) {
                        this.showKernelTimeline((TimelineKernel)timeline);
                    } else if (timeline instanceof TimelineMemcpy) {
                        this.showMemcpyTimeline((TimelineMemcpy)timeline);
                    } else if (timeline instanceof TimelineOverhead) {
                        this.showOverheadTimeline((TimelineOverhead)timeline);
                    } else if (timeline instanceof TimelineUVM) {
                        this.showUVMTimeline((TimelineUVM)timeline);
                    } else if (timeline instanceof TimelineDevice) {
                        this.showDeviceTimeline((TimelineDevice)timeline);
                    } else if (timeline.getKind().isAPI()) {
                        this.showAPITimeline(timeline);
                    } else if (timeline instanceof TimelineNvlink) {
                        this.showNvlinkTimeline((TimelineNvlink)timeline);
                    } else {
                        this.showTimeline(timeline);
                    }
                }
                if (this.nameColumn.getWidth() == 0 || this.valueColumn.getWidth() == 0) {
                    int width = this.tree.getClientArea().width;
                    this.nameColumn.setWidth((int)(0.7 * (double)width));
                    this.valueColumn.setWidth(width - this.nameColumn.getWidth());
                }
            }
            this.tree.getParent().layout(true);
        }
    }

    private void handleNestedSashForm(ITimelineInterval interval, Timeline timeline) {
        if (interval != null) {
            if (interval instanceof TimelineIntervalUVM) {
                if (((TimelineIntervalUVM)interval).isSegmented()) {
                    this.uvmSegmentSelection((TimelineIntervalUVM)interval);
                } else {
                    switch (interval.getKind()) {
                        case UVM_PAGE_THROTTLING: 
                        case UVM_THRASHING: 
                        case UVM_REMOTE_MAP: {
                            this.uvmThrashingSelection();
                            break;
                        }
                        default: {
                            this.sashForm.setMaximizedControl((Control)this.treeControl);
                            break;
                        }
                    }
                }
            } else if (interval instanceof TimelineIntervalNvlink) {
                this.nvLinkSelection();
            } else {
                this.sashForm.setMaximizedControl((Control)this.treeControl);
            }
        } else if (timeline != null) {
            if (timeline instanceof TimelineUVM) {
                if (((TimelineUVM)timeline).isSegmented()) {
                    this.uvmSegmentSelection(((TimelineUVM)timeline).getFirstInterval());
                } else if (timeline.getKind().equals((Object)TimelineKind.UVM_THRASHING_THROTTLING)) {
                    this.uvmThrashingSelection();
                } else {
                    this.sashForm.setMaximizedControl((Control)this.treeControl);
                }
            } else if (timeline instanceof TimelineNvlink) {
                this.nvLinkSelection();
            } else {
                this.sashForm.setMaximizedControl((Control)this.treeControl);
            }
        }
    }

    private void uvmSegmentSelection(TimelineIntervalUVM interval) {
        this.sashForm.setMaximizedControl(null);
        this.nestedSashForm.setMaximizedControl((Control)this.uvmLegendControl);
        this.uvmLegendControl.updateLegend(interval);
        this.note.setText(NOTE_UVM_SELECTION);
        ((GridData)this.note.getLayoutData()).exclude = false;
        this.note.setVisible(true);
    }

    private void uvmThrashingSelection() {
        this.sashForm.setMaximizedControl(null);
        this.nestedSashForm.setMaximizedControl((Control)this.uvmThrashingLegendControl);
        this.uvmThrashingLegendControl.layout();
    }

    private void nvLinkSelection() {
        this.sashForm.setMaximizedControl(null);
        this.nestedSashForm.setMaximizedControl((Control)this.nvlinkLegendControl);
        this.nvlinkLegendControl.layout();
    }

    protected void setTitle(String name, String tooltip) {
        if (name != null) {
            name = StringUtils.getBoundedText(name, new Dimension(this.title.getSize()), this.title.getFont(), 1);
        }
        this.title.setText(name == null ? "" : name);
        this.title.setToolTipText(tooltip);
    }

    protected void showInterval(Timeline timeline, ITimelineInterval interval) {
        this.setTitle(interval.getDisplayName(), interval.getDisplayName());
        this.addNode(null, "Start", new PreciseTimeFormatter(interval.getStart()), null, "The start time for the timeline interval");
        this.addNode(null, "End", new PreciseTimeFormatter(interval.getEnd()), null, "The end time for the timeline interval");
        this.addNode(null, "Duration", new PreciseTimeFormatter(interval.getDuration()), null, "The duration of the timeline interval");
    }

    private void showEnvironmentInterval(Timeline timeline, TimelineIntervalEnvironment interval) {
        this.setTitle(interval.getDisplayName(), interval.getDisplayName());
        this.addNode(null, "Timestamp", new PreciseTimeFormatter(interval.getStart()), null, null);
        switch (interval.getEnvironmentKind()) {
            case CUPTI_ACTIVITY_ENVIRONMENT_SPEED: {
                if (interval.getSmClock() > -1) {
                    this.addNode(null, "SM clock", new FrequencyFormatter().format((long)interval.getSmClock() * 1000000L), null, null);
                }
                if (interval.getMemoryClock() > -1) {
                    this.addNode(null, "Memory Clock", new FrequencyFormatter().format((long)interval.getMemoryClock() * 1000000L), null, null);
                }
                if (interval.getPcieLinkGen() > -1) {
                    this.addNode(null, "PCIe Link Gen", interval.getPcieLinkGen(), null, null);
                }
                if (interval.getPcieLinkWidth() > -1) {
                    this.addNode(null, "PCIe Link Width", interval.getPcieLinkWidth(), null, null);
                }
                if (interval.getClocksThrottleReasons() == null) break;
                String str = "";
                CuptiEnvironmentClocksThrottleReason[] cuptiEnvironmentClocksThrottleReasonArray = interval.getClocksThrottleReasons();
                int n = cuptiEnvironmentClocksThrottleReasonArray.length;
                int n2 = 0;
                while (n2 < n) {
                    CuptiEnvironmentClocksThrottleReason cuptiEnvironmentClocksThrottleReason = cuptiEnvironmentClocksThrottleReasonArray[n2];
                    if (!cuptiEnvironmentClocksThrottleReason.equals((Object)CuptiEnvironmentClocksThrottleReason.CUPTI_CLOCKS_THROTTLE_REASON_UNSUPPORTED) && !cuptiEnvironmentClocksThrottleReason.equals((Object)CuptiEnvironmentClocksThrottleReason.CUPTI_CLOCKS_THROTTLE_REASON_UNKNOWN)) {
                        str = String.valueOf(str) + (str.isEmpty() ? "" : ", ") + cuptiEnvironmentClocksThrottleReason.getName();
                    }
                    ++n2;
                }
                if (str.isEmpty()) break;
                this.addNode(null, "Clocks Throttle Reasons", str, null, null);
                break;
            }
            case CUPTI_ACTIVITY_ENVIRONMENT_POWER: {
                if (interval.getPower() > -1) {
                    this.addNode(null, "Power", new PowerFormatter().format((double)interval.getPower() / 1000.0), null, null);
                }
                if (interval.getPowerLimit() <= -1) break;
                this.addNode(null, "Power limit", new PowerFormatter().format((double)interval.getPowerLimit() / 1000.0), null, null);
                break;
            }
            case CUPTI_ACTIVITY_ENVIRONMENT_TEMPERATURE: {
                if (interval.getGpuTemperature() <= -1) break;
                this.addNode(null, "Temperature", String.valueOf(interval.getGpuTemperature()) + " " + SYMBOL_DEGREE_CELSIUS, null, null);
                break;
            }
            case CUPTI_ACTIVITY_ENVIRONMENT_COOLING: {
                if (interval.getFanSpeed() <= -1) break;
                this.addNode(null, "Fan", percentIntegerFormatter.format((double)interval.getFanSpeed() / 100.0), null, null);
                break;
            }
        }
    }

    private void showUVMInterval(Timeline timeline, TimelineIntervalUVM interval, TreeItem subTree) {
        String title = interval.getKind().equals((Object)TimelineIntervalKind.UVM_GPU_PAGE_FAULT) ? "GPU Page Fault groups" : interval.getDisplayName();
        String toolTip = interval.getKind().equals((Object)TimelineIntervalKind.UVM_GPU_PAGE_FAULT) ? "The group of GPU page faults with same virtual address" : interval.getDisplayName();
        this.setTitle(title, toolTip);
        if (interval.isSegmented()) {
            this.addNode(subTree, "Start", new PreciseTimeFormatter(interval.getStart()), null, "The start time for the interval");
            this.addNode(subTree, "End", new PreciseTimeFormatter(interval.getEnd()), null, "The end time for the interval");
            this.addNode(subTree, "Duration", new PreciseTimeFormatter(interval.getDuration()), null, "The time duration for the interval");
            switch (interval.getKind()) {
                case UVM_MEMCPY_HTOD: 
                case UVM_MEMCPY_DTOH: 
                case UVM_MEMCPY_DTOD: {
                    this.addNode(subTree, "Size", new ValueByteSize(ByteSizeFormatter.Base.KILOBYTE, interval.getCounterValue()), null, "The bytes transferred from device to host");
                    TreeItem tpNode = this.addNode(subTree, "Throughput", null, null, null);
                    this.addNode(tpNode, "Min", interval.getMinThroughput(), null, null);
                    this.addNode(tpNode, "Max", interval.getMaxThroughput(), null, null);
                    tpNode.setExpanded(true);
                    break;
                }
            }
            String hexAddress = "0x" + Long.toHexString(interval.getStartAddress()) + " - 0x" + Long.toHexString(interval.getEndAddress());
            this.addNode(subTree, "Virtual Address Range", hexAddress, null, "The virtual base address range of the page(s) being transferred in this segment");
            if (interval.getKind().equals((Object)TimelineIntervalKind.UVM_GPU_PAGE_FAULT)) {
                this.addNode(subTree, "GPU Page Faults", interval.getCounterValue(), null, "Number of GPU page faults in this segment");
                this.addNode(subTree, "GPU Page Fault groups", interval.getNumRecords(), null, "Number of GPU page fault groups in this segment");
            }
            if (!interval.getKind().equals((Object)TimelineIntervalKind.UVM_PAGE_FAULT)) {
                Long value = interval.getTotalDurationTimeWithoutOverlap();
                this.addNode(subTree, interval.getTitle(), new TimeFormatter().format(value), null, interval.getLegendTitle());
            } else {
                this.addNode(subTree, "Number of CPU page faults", interval.getNumRecords(), null, "Number of CPU page faults in this segment");
            }
        } else if (interval.isNew()) {
            String strStart = interval.isStartOnly() ? "Timestamp" : "Start";
            this.addNode(subTree, strStart, new PreciseTimeFormatter(interval.getStart()), null, "The start time for the interval");
            if (!interval.isStartOnly()) {
                this.addNode(subTree, "End", new PreciseTimeFormatter(interval.getEnd()), null, "The end time for the interval");
                this.addNode(subTree, "Duration", new PreciseTimeFormatter(interval.getDuration()), null, "The time duration for the interval");
            }
            switch (interval.getKind()) {
                case UVM_MEMCPY_HTOD: 
                case UVM_MEMCPY_DTOH: 
                case UVM_MEMCPY_DTOD: {
                    this.addNode(subTree, "Size", new ValueByteSize(ByteSizeFormatter.Base.KILOBYTE, interval.getCounterValue()), null, "The bytes transferred from device to host");
                    String causeTooltip = CuptiActivityUvmMigrationCause.valueOf(interval.getFlags()) == CuptiActivityUvmMigrationCause.CUPTI_ACTIVITY_UVM_MIGRATION_CAUSE_UNKNOWN ? "The migration reason is unknown" : "The reason for migration of data";
                    this.addNode(subTree, "Migration Cause", CuptiActivityUvmMigrationCause.valueOf(interval.getFlags()).getName(), null, causeTooltip);
                    ValueBandwidth bwValue = new ValueBandwidth(ByteSizeFormatter.Base.KILOBYTE, interval.getCounterValue(), interval.getDuration());
                    this.addNode(subTree, "Throughput", bwValue, null, null);
                    if (!interval.getKind().equals((Object)TimelineIntervalKind.UVM_MEMCPY_DTOD)) break;
                    String deviceName = (long)interval.getSrcId() == CuptiActivityUvmCounter.cpuId ? "CPU" : this.activeSession.getDeviceTimeline(interval.getSrcId()).getDisplayName(true);
                    this.addNode(subTree, "Source", deviceName, null, null);
                    deviceName = (long)interval.getDstId() == CuptiActivityUvmCounter.cpuId ? "CPU" : this.activeSession.getDeviceTimeline(interval.getDstId()).getDisplayName(true);
                    this.addNode(subTree, "Destination", deviceName, null, null);
                    break;
                }
                case UVM_THRASHING: {
                    this.addNode(subTree, "Size", new ValueByteSize(ByteSizeFormatter.Base.KILOBYTE, interval.getCounterValue()), null, "The size of the thrashed memory in bytes");
                    ArrayList<String> deviceNameList = new ArrayList<String>();
                    for (int deviceId : interval.getDeviceIdList()) {
                        deviceNameList.add(this.activeSession.getDeviceTimeline(deviceId).getDisplayName(true));
                    }
                    if (interval.isCpu()) {
                        deviceNameList.add("CPU");
                    }
                    String deviceNames = StringUtils.join(deviceNameList, ", ");
                    this.addNode(subTree, "Devices", deviceNames, null, "The devices that have thrashed");
                    break;
                }
                case UVM_REMOTE_MAP: {
                    this.addNode(subTree, "Size", new ValueByteSize(ByteSizeFormatter.Base.KILOBYTE, interval.getCounterValue()), null, "The size of the mapped memory in bytes");
                    this.addNode(subTree, "Remote Mapping Cause", CuptiActivityUvmRemoteMapCause.valueOf(interval.getFlags()).getName(), null, "The reason for mapping of unified memory");
                    String deviceName = (long)interval.getSrcId() == CuptiActivityUvmCounter.cpuId ? "CPU" : this.activeSession.getDeviceTimeline(interval.getSrcId()).getDisplayName(true);
                    this.addNode(subTree, "Source", deviceName, null, null);
                    deviceName = (long)interval.getDstId() == CuptiActivityUvmCounter.cpuId ? "CPU" : this.activeSession.getDeviceTimeline(interval.getDstId()).getDisplayName(true);
                    this.addNode(subTree, "Destination", deviceName, null, null);
                    break;
                }
                case UVM_PAGE_FAULT: 
                case UVM_GPU_PAGE_FAULT: {
                    this.addNode(subTree, "Memory Acccess Type", CuptiActivityUvmAccessKind.valueOf(interval.getFlags()).getName(), null, "The access type of the Unified Memory counter");
                }
            }
            String hexAddress = "0x" + Long.toHexString(interval.getAddress());
            this.addNode(subTree, "Virtual Address", hexAddress, null, "The virtual base address of the page(s) being transferred");
            if (interval.getKind().equals((Object)TimelineIntervalKind.UVM_PAGE_FAULT)) {
                String label = "Source Location";
                if (!this.isExecutablePresent()) {
                    TreeItem node = this.addNode(subTree, label, NOTE_SELECT_UVM_EXE, null, String.valueOf(UVM_EXE_TOOLTIP) + "CPU page fault " + "locations in source code");
                    node.setForeground(this.getDisplay().getSystemColor(36));
                    node.setData(UVM_SOURCE_KEY, (Object)interval);
                } else if (interval.getSourceLocation() == null) {
                    this.addNode(subTree, label, "Unknown", null, "The location of the page fault in source code couldn't be found. The executable may not have been compiled with debug information, or the fault-causing source code may be located in a dynamically loaded library.");
                } else {
                    String loc = interval.getSourceLocationString();
                    TreeItem node = this.addNode(subTree, label, loc, null, String.valueOf(interval.getFilePath()) + "\n\nDouble click to open the " + "location in source code");
                    node.setData(UVM_SOURCE_KEY, (Object)interval);
                    node.setForeground(this.getDisplay().getSystemColor(36));
                }
            }
            if (interval.getKind().equals((Object)TimelineIntervalKind.UVM_GPU_PAGE_FAULT)) {
                this.addNode(subTree, "GPU Page Faults", interval.getCounterValue(), null, "Number of GPU page faults with same virtual address");
            }
            this.addMemoryInfoNode(subTree, interval);
        } else {
            this.addNode(subTree, "Sample Start", new PreciseTimeFormatter(interval.getStart()), null, "The start time for the sampling of unified memory data migration");
            this.addNode(subTree, "Sample End", new PreciseTimeFormatter(interval.getEnd()), null, "The end time for the sampling of unified memory data migration");
            this.addNode(subTree, "Sample Duration", new PreciseTimeFormatter(interval.getDuration()), null, "The time duration of the sampling of unified memory data migration");
            switch (interval.getKind()) {
                case UVM_MEMCPY_HTOD: 
                case UVM_MEMCPY_DTOH: 
                case UVM_MEMCPY_DTOD: {
                    this.addNode(subTree, "Size", new ValueByteSize(ByteSizeFormatter.Base.KILOBYTE, interval.getCounterValue()), null, "The bytes transferred during the sampling of unified memory data migration");
                    break;
                }
                case UVM_PAGE_FAULT: {
                    this.addNode(subTree, "CPU Page Faults", interval.getCounterValue(), null, "The cpu page faults occurred during the sampling of unified memory data migration");
                    break;
                }
                case UVM_GPU_PAGE_FAULT: {
                    this.addNode(subTree, "GPU Page Faults", interval.getCounterValue(), null, "The gpu page faults occurred during the sampling of unified memory data migration");
                    break;
                }
            }
        }
        this.addNode(subTree, "Process", interval.getProcessId(), null, "The process id of the interval");
    }

    private void setMemoryItemText(TreeItem item, boolean hasPC, SourceLocation location) {
        if (hasPC) {
            if (location != null) {
                item.setText(1, location.toString());
                this.nodeTooltips.put(item, String.valueOf(location.getFilePath()) + "\n\nDouble click to open the " + "location in source code");
            } else {
                item.setText(1, "Unknown");
                this.nodeTooltips.put(item, "The location in source code couldn't be found. The executable may not have been compiled with debug information, or the corresponding source code may be located in a dynamically loaded library.");
            }
        } else {
            item.setText(1, "N/A");
        }
    }

    private boolean isExecutablePresent() {
        Executable exec;
        return this.activeSession != null && (exec = this.activeSession.getExecutable()) != null && exec.getLocalFilename() != null && new File(exec.getLocalFilename()).isFile();
    }

    private void addMemoryInfoNode(TreeItem subTree, TimelineIntervalUVM interval) {
        UvmManager uvmManager = this.activeSession.getUvmManager();
        if (!uvmManager.hasAddressSourceCorrelationInfo()) {
            return;
        }
        String label = "Memory operations";
        if (!this.isExecutablePresent()) {
            TreeItem memoryItem = this.addNode(subTree, label, NOTE_SELECT_UVM_EXE, null, String.valueOf(UVM_EXE_TOOLTIP) + "allocation and free " + "locations in source code");
            memoryItem.setForeground(this.getDisplay().getSystemColor(36));
            memoryItem.setData(UVM_SOURCE_KEY, (Object)interval);
            return;
        }
        TreeItem memoryItem = this.addNode(subTree, "Memory operations", null, null, "");
        memoryItem.setData((Object)interval);
        TreeItem allocationItem = this.addNode(memoryItem, "Allocation", null, null, "");
        allocationItem.setData((Object)interval);
        TreeItem freeItem = this.addNode(memoryItem, "Free", null, null, "");
        freeItem.setData((Object)interval);
        if (interval.hasAllocPC() || interval.hasFreePC()) {
            memoryItem.setExpanded(true);
            this.setMemoryItemText(allocationItem, interval.hasAllocPC(), interval.getAllocLocation());
            this.setMemoryItemText(freeItem, interval.hasFreePC(), interval.getFreeLocation());
        } else {
            memoryItem.setExpanded(false);
        }
    }

    protected void showMarkerInterval(Timeline timeline, TimelineIntervalMarker marker) {
        this.setTitle(marker.getDisplayName(), marker.getDisplayName());
        this.addNode(null, "Timestamp", new PreciseTimeFormatter(marker.getStart()), null, "The marker timestamp");
        this.addNode(null, "Domain", marker.getDomain(), null, "The marker Domain");
        if (marker.getMarkerData() != null) {
            this.addMarkerData(null, marker.getMarkerData());
        }
    }

    protected void showRangeInterval(Timeline timeline, TimelineIntervalRange range) {
        this.setTitle(range.getDisplayName(), range.getDisplayName());
        this.addNode(null, "Start", new PreciseTimeFormatter(range.getStart()), null, "The start time for the range");
        this.addNode(null, "End", new PreciseTimeFormatter(range.getEnd()), null, "The end time for the range");
        this.addNode(null, "Duration", new PreciseTimeFormatter(range.getDuration()), null, "The duration of the range");
        this.addNode(null, "Domain", range.getDomain(), null, "The marker Domain");
        if (CuptiActivityFlag.CUPTI_ACTIVITY_FLAG_MARKER_SYNC_ACQUIRE.isSet(range.getStartMarker().flags)) {
            this.addNode(null, "Start Marker", "Sync Acquire", null, "The Start Marker");
        } else if (CuptiActivityFlag.CUPTI_ACTIVITY_FLAG_MARKER_SYNC_ACQUIRE_SUCCESS.isSet(range.getStartMarker().flags)) {
            this.addNode(null, "Start Marker", "Sync Acquire Success", null, "The Start Marker");
        }
        if (CuptiActivityFlag.CUPTI_ACTIVITY_FLAG_MARKER_SYNC_ACQUIRE_FAILED.isSet(range.getEndMarker().flags)) {
            this.addNode(null, "End Marker", "Sync Acquire Failed", null, "The End Marker");
        } else if (CuptiActivityFlag.CUPTI_ACTIVITY_FLAG_MARKER_SYNC_ACQUIRE_SUCCESS.isSet(range.getEndMarker().flags)) {
            this.addNode(null, "End Marker", "Sync Acquire Success", null, "The End Marker");
        } else if (CuptiActivityFlag.CUPTI_ACTIVITY_FLAG_MARKER_SYNC_RELEASE.isSet(range.getEndMarker().flags)) {
            this.addNode(null, "End Marker", "Sync Release", null, "The End Marker");
        }
        if (range.getMarkerData() != null) {
            this.addMarkerData(null, range.getMarkerData());
        }
    }

    protected void showAPIInterval(Timeline timeline, TimelineIntervalAPI api) {
        this.addNode(null, "Start", new PreciseTimeFormatter(api.getStart()), null, "The start time for the CUDA API call");
        this.addNode(null, "End", new PreciseTimeFormatter(api.getEnd()), null, "The end time for the CUDA API call");
        this.addNode(null, "Duration", new PreciseTimeFormatter(api.getDuration()), null, "The duration of the CUDA API call");
        HashSet<TimelineIntervalHierarchy> family = new HashSet<TimelineIntervalHierarchy>();
        TimelineIntervalHierarchy oldest = api.getOldestAncestor();
        this.activeSession.getHostLaunchedDescendants(oldest, family);
        this.setTitle(api.getDisplayName(), api.getDisplayName());
        for (TimelineIntervalHierarchy corr : family) {
            Timeline corrTimeline;
            if (corr instanceof TimelineIntervalKernel) {
                Dimension bounds = FigureUtilities.getStringExtents((String)"W", (Font)this.getFont());
                bounds.height = Integer.MAX_VALUE;
                bounds.width *= 100;
                String tooltip = StringUtils.getBoundedText("CUDA API call that launches kernel " + corr.getDisplayName(), bounds, this.getFont(), 100);
                this.setTitle("Launch " + corr.getDisplayName(), tooltip);
            }
            if (corr == null || (corrTimeline = corr.getPrimaryTimeline()) == null) continue;
            if (corr instanceof TimelineIntervalMemcpy) {
                TreeItem memcpy = this.addNode(null, "Memory Copy", null, null, null);
                this.showMemcpyInterval(corrTimeline, (TimelineIntervalMemcpy)corr, memcpy);
                memcpy.setExpanded(true);
                continue;
            }
            if (corr instanceof TimelineIntervalKernel) {
                TreeItem kernel = this.addNode(null, "Kernel", null, null, null);
                this.showKernelInterval(corrTimeline, (TimelineIntervalKernel)corr, kernel);
                kernel.setExpanded(true);
                TreeItem[] treeItemArray = kernel.getItems();
                int n = treeItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem ti = treeItemArray[n2];
                    ti.setExpanded(true);
                    ++n2;
                }
                continue;
            }
            if (!(corr instanceof TimelineIntervalMemset)) continue;
            TreeItem memset = this.addNode(null, "Memory Set", null, null, null);
            this.showMemsetInterval(corrTimeline, (TimelineIntervalMemset)corr, memset);
            memset.setExpanded(true);
        }
    }

    protected void showOpenAccInterval(Timeline timeline, TimelineIntervalOpenAcc oacc) {
        this.addNode(null, "Start", new PreciseTimeFormatter(oacc.getStart()), null, "The start time for this OpenACC region");
        this.addNode(null, "End", new PreciseTimeFormatter(oacc.getEnd()), null, "The end time for this OpenACC region");
        this.addNode(null, "Duration", new PreciseTimeFormatter(oacc.getDuration()), null, "The duration of this OpenACC region");
        this.addNode(null, "Event Kind", oacc.getEventKind(), null, "The OpenACC event kind of this region");
        this.addNode(null, "Parent Construct", oacc.getParentConstruct(), null, "The OpenACC parent construct that emitted this region");
        this.addNode(null, "Version", oacc.getVersion(), null, "The OpenACC version of this region");
        this.addNode(null, "Implicit", oacc.getImplicit(), null, "If this OpenACC region is an implicit event");
        this.addNode(null, "Device Type", oacc.getDeviceType(), null, "The OpenACC device type of this region");
        this.addNode(null, "Device Number", oacc.getDeviceNumber(), null, "The OpenACC device number of this region");
        this.addNode(null, "Thread ID", oacc.getThreadId(), null, "The OpenACC thread ID of this region");
        this.addNode(null, "Async", oacc.getAsync(), null, "Value of OpenACC async() clause of the corresponding directive");
        this.addNode(null, "Async Map", oacc.getAsyncMap(), null, "Internal asynchronous OpenACC queue number used");
        TreeItem sourceNode = this.addNode(null, "Source Information", null, null, null);
        String srcFile = oacc.getRelativeFilePath();
        String srcFileTip = "The source filename of the OpenACC directive";
        if (srcFile == null) {
            srcFile = "<unknown>";
        } else {
            srcFileTip = String.valueOf(srcFileTip) + " (double-click to open)";
        }
        TreeItem sourceNodeItem = this.addNode(sourceNode, "Source File", srcFile, null, srcFileTip);
        if (oacc.getRelativeFilePath() != null) {
            sourceNodeItem.setData("openacc-source", (Object)oacc);
            sourceNodeItem.setForeground(this.getDisplay().getSystemColor(36));
        } else {
            sourceNodeItem.setForeground(this.getDisplay().getSystemColor(33));
        }
        String funcName = oacc.getFuncName();
        if (funcName == null) {
            funcName = "<unknown>";
        }
        this.addNode(sourceNode, "Function Name", funcName, null, "The function name of the activity");
        this.addNode(sourceNode, "Start Line Number", oacc.getLineNo(), null, "The line number of the directive or program construct or the starting line number of the OpenACC construct corresponding to the event");
        this.addNode(sourceNode, "End Line Number", oacc.getEndLineNo(), null, "For an OpenACC construct, this contains the line number of the end of the construct");
        this.addNode(sourceNode, "Function Start Line Number", oacc.getFuncLineNo(), null, "The line number of the first line of the function named in 'Function Name'");
        this.addNode(sourceNode, "Function End Line Number", oacc.getFuncEndLineNo(), null, "The last line number of the function named in 'Function Name'");
        sourceNode.setExpanded(true);
        TreeItem cudaNode = this.addNode(null, "CUDA", null, null, null);
        this.addNode(cudaNode, "CUDA Device ID", oacc.getCuDeviceId(), null, "The CUDA device ID of this region");
        this.addNode(cudaNode, "CUDA Context ID", oacc.getCuContextId(), null, "The CUDA context ID of this region");
        this.addNode(cudaNode, "CUDA Stream ID", oacc.getCuStreamId(), null, "The CUDA stream ID of this region");
        cudaNode.setExpanded(true);
        if (oacc.isOpenAccDataInterval()) {
            TreeItem dataNode = this.addNode(null, "Data", null, null, null);
            String varName = oacc.getVarName();
            if (varName == null) {
                varName = "<unknown>";
            }
            this.addNode(dataNode, "Variable Name", varName, null, "The name of the variable for which this event is triggered, if known");
            this.addNode(dataNode, "Bytes", oacc.getBytes(), null, "Number of bytes");
            this.addNode(dataNode, "Host Pointer", oacc.getHostPtr(), null, "Host pointer (if available)");
            this.addNode(dataNode, "Device Pointer", oacc.getDevicePtr(), null, "Device pointer (if available)");
            dataNode.setExpanded(true);
        }
        if (oacc.isOpenAccLaunchInterval()) {
            TreeItem launchNode = this.addNode(null, "Launch", null, null, null);
            String kernelName = oacc.getKernelName();
            if (kernelName == null) {
                kernelName = "<unknown>";
            }
            this.addNode(launchNode, "Kernel Name", kernelName, null, "The name of the kernel being launched, if known");
            this.addNode(launchNode, "Gangs", oacc.getNumGangs(), null, "The number of gangs created for this kernel launch");
            this.addNode(launchNode, "Workers", oacc.getNumWorkers(), null, "The number of workers created for this kernel launch");
            this.addNode(launchNode, "Vector Length", oacc.getVectorLength(), null, "The number of vector lanes created for this kernel launch");
            launchNode.setExpanded(true);
        }
        this.setTitle(oacc.getDisplayName(), oacc.getDisplayName());
    }

    protected void showNvlinkInterval(Timeline timeline, TimelineIntervalNvlink nvlinkInterval) {
        this.setTitle("NVlink", "NVlink transmit and receive throughput ");
        this.addNode(null, "Start", new PreciseTimeFormatter(nvlinkInterval.getStart()), null, "The start time of the nvlink interval");
        this.addNode(null, "End", new PreciseTimeFormatter(nvlinkInterval.getEnd()), null, "The end time of the nvlink interval");
        this.addNode(null, "Duration", new PreciseTimeFormatter(nvlinkInterval.getEnd() - nvlinkInterval.getStart()), null, "The end time of the nvlink interval");
    }

    protected void showKernelInterval(Timeline timeline, TimelineIntervalKernel kernel, TreeItem subTree) {
        Integer[] block;
        Integer[] grid;
        Object submitted_val;
        Object queued_val;
        CuptiActivityComputeApiKind computeKind = CuptiActivityComputeApiKind.CUPTI_ACTIVITY_COMPUTE_API_CUDA;
        TimelineContext ctxTimeline = (TimelineContext)timeline.getAncestor(TimelineKind.CONTEXT);
        if (ctxTimeline != null) {
            computeKind = ctxTimeline.getComputeKind();
        }
        TimelineDevice deviceTimeline = (TimelineDevice)timeline.getAncestor(TimelineKind.DEVICE);
        String name = kernel.getDisplayName();
        String tooltip = "Kernel " + name;
        if (subTree == null) {
            this.setTitle(name, tooltip);
        } else {
            this.addNode(subTree, "Name", name, null, null);
        }
        Long queued = kernel.getQueued();
        String queued_tooltip = "The time when the kernel launch command was queued into the CPU command buffer";
        if (queued == null) {
            queued_val = "n/a";
            queued_tooltip = String.valueOf(queued_tooltip) + ". To collect this, use the nvprof option\"--kernel-latency-timestamps on\" while profiling the application.";
        } else {
            queued_val = new PreciseTimeFormatter(queued);
        }
        this.addNode(subTree, "Queued", queued_val, null, queued_tooltip);
        Long submitted = kernel.getSubmitted();
        String submitted_tooltip = "The time when the CPU command buffer containing the kernel launch was submitted to the GPU";
        if (submitted == null) {
            submitted_val = "n/a";
            submitted_tooltip = String.valueOf(submitted_tooltip) + ". To collect this, use the nvprof option\"--kernel-latency-timestamps on\" while profiling the application.";
        } else {
            submitted_val = new PreciseTimeFormatter(submitted);
        }
        this.addNode(subTree, "Submitted", submitted_val, null, submitted_tooltip);
        this.addNode(subTree, "Start", new PreciseTimeFormatter(kernel.getStart()), null, "The time that the first thread begins executing the kernel");
        this.addNode(subTree, "End", new PreciseTimeFormatter(kernel.getEnd()), null, "The time that the last thread finishes executing the kernel");
        Long minCompleted = kernel.getCompleted(true);
        if (minCompleted != null) {
            this.addNode(subTree, "Completion", new PreciseTimeFormatter(minCompleted), null, "The latest end time for all descendant kernels launched by this kernel");
        }
        this.addNode(subTree, "Duration", new PreciseTimeFormatter(kernel.getDuration()), null, "The duration of the kernel execution (end time - start time)");
        if (minCompleted != null) {
            this.addNode(subTree, "Completion Duration", new PreciseTimeFormatter(minCompleted - kernel.getEnd()), null, "The duration of the kernel completion (completion time - end time)");
        }
        this.addNode(subTree, "Stream", kernel.getStreamName(), null, "The stream on which this kernel was launched");
        if (System.getenv("VIPER_DEBUG") != null) {
            TreeItem schedNode = this.addNode(subTree, "Scheduler", null, null, null);
            Long completed = kernel.getCompleted(false);
            if (completed != null) {
                this.addNode(schedNode, "Completed", new PreciseTimeFormatter(completed), null, "The time when the scheduler reports the kernel as completed");
            }
            if (schedNode.getItemCount() > 0) {
                schedNode.setExpanded(true);
            } else {
                schedNode.dispose();
            }
        }
        if ((grid = kernel.getGrid()) != null && grid[0] != null && grid[1] != null && grid[2] != null) {
            this.addNode(subTree, String.valueOf(ViperComputeDictionary.GRID.getLabel(computeKind)) + " Size", "[ " + grid[0] + "," + grid[1] + "," + grid[2] + " ]", null, "The grid dimensions for the kernel launch");
        }
        if ((block = kernel.getBlock()) != null && block[0] != null && block[1] != null && block[2] != null) {
            this.addNode(subTree, String.valueOf(ViperComputeDictionary.BLOCK.getLabel(computeKind)) + " Size", "[ " + block[0] + "," + block[1] + "," + block[2] + " ]", null, "The block dimensions for the kernel launch");
        }
        if (kernel.getRegistersPerThread() != null) {
            this.addNode(subTree, "Registers/" + ViperComputeDictionary.THREAD.getLabel(computeKind), kernel.getRegistersPerThread(), null, "The number of registers required for each thread executing the kernel");
        }
        if (kernel.getStaticSharedMemory() != null && kernel.getDynamicSharedMemory() != null) {
            ValueByteSize sharedMemPerBlock = new ValueByteSize(ByteSizeFormatter.Base.KIBIBYTE, kernel.getStaticSharedMemory() + kernel.getDynamicSharedMemory());
            this.addNode(subTree, String.valueOf(ViperComputeDictionary.SHARED.getLabel(computeKind)) + "  Memory/" + ViperComputeDictionary.BLOCK.getLabel(computeKind), sharedMemPerBlock, null, "The amount of shared memory required for each block executing the kernel");
        }
        this.addNode(subTree, "Launch Type", CuptiLaunchType.getDescription(kernel.getLaunchType()), null, "Whether the kernel was executed via a regular launch or via a single/multi device cooperative launch");
        Analysis analysis = this.activeSession.getAnalysis();
        TreeItem effNode = null;
        if (analysis != null) {
            IValue memEfficiency;
            boolean foundGld = false;
            boolean foundGst = false;
            List<AnalysisResult> globalMemoryEffResults = analysis.getAnalysisResults(AnalysisStage.KERNELS_PERFORMANCE, AnalysisResultGlobalMemoryEfficiency.class);
            for (AnalysisResult result : globalMemoryEffResults) {
                boolean isLoad;
                AnalysisResultGlobalMemoryEfficiency gmemResult = (AnalysisResultGlobalMemoryEfficiency)result;
                if (!gmemResult.containsInterval(kernel) || (!(isLoad = gmemResult.isLoad()) || foundGld) && (isLoad || foundGst)) continue;
                memEfficiency = gmemResult.getValue(kernel);
                if (memEfficiency != null) {
                    if (effNode == null) {
                        effNode = this.addNode(subTree, "Efficiency", null, null, null);
                    }
                    if (memEfficiency.equals(new ValuePercent(0.0))) {
                        this.addNode(effNode, "Global " + (isLoad ? "Load" : "Store") + " Efficiency", "n/a", null, gmemResult.getValueDescription(kernel));
                    } else {
                        this.addNode(effNode, "Global " + (isLoad ? "Load" : "Store") + " Efficiency", memEfficiency, this.getAnalysisImage(result.getSeverity()), gmemResult.getValueDescription(kernel));
                    }
                }
                if ((foundGld |= isLoad) && (foundGst |= !isLoad)) break;
            }
            List<AnalysisResult> sharedMemoryEffResults = analysis.getAnalysisResults(AnalysisStage.KERNELS_PERFORMANCE, AnalysisResultSharedMemoryEfficiency.class);
            for (AnalysisResult result : sharedMemoryEffResults) {
                AnalysisResultSharedMemoryEfficiency sharedResult = (AnalysisResultSharedMemoryEfficiency)result;
                if (!sharedResult.containsInterval(kernel)) continue;
                memEfficiency = sharedResult.getValue(kernel);
                if (memEfficiency == null) break;
                if (effNode == null) {
                    effNode = this.addNode(subTree, "Efficiency", null, null, null);
                }
                if (memEfficiency.equals(new ValuePercent(0.0))) {
                    this.addNode(effNode, "Shared Efficiency", "n/a", null, sharedResult.getValueDescription(kernel));
                    break;
                }
                this.addNode(effNode, "Shared Efficiency", memEfficiency, this.getAnalysisImage(result.getSeverity()), sharedResult.getValueDescription(kernel));
                break;
            }
            List<AnalysisResult> lmemOverheadResults = analysis.getAnalysisResults(AnalysisStage.KERNEL_INSTANCE_MEMORY, AnalysisResultLocalMemoryOverhead.class);
            for (AnalysisResult result : lmemOverheadResults) {
                AnalysisResultLocalMemoryOverhead overheadResult = (AnalysisResultLocalMemoryOverhead)result;
                if (overheadResult.getKernel() != kernel) continue;
                IValue overhead = overheadResult.getOverheadValue();
                if (overhead == null) break;
                if (effNode == null) {
                    effNode = this.addNode(subTree, "Efficiency", null, null, null);
                }
                this.addNode(effNode, "Local Memory Overhead", overhead, this.getAnalysisImage(result.getSeverity()), overheadResult.getOverheadValueDescription());
                break;
            }
            IValue execEffValue = null;
            IValue nonpredExecEffValue = null;
            AnalysisDescriptor.Severity execEffSeverity = AnalysisDescriptor.Severity.OK;
            String execEffDesc = null;
            String nonpredExecEffDesc = null;
            List<AnalysisResult> warpExecResults = analysis.getAnalysisResults(AnalysisStage.KERNELS_PERFORMANCE, AnalysisResultWarpExecutionEfficiency.class);
            for (AnalysisResult result : warpExecResults) {
                AnalysisResultWarpExecutionEfficiency weeResult = (AnalysisResultWarpExecutionEfficiency)result;
                if (!weeResult.containsInterval(kernel)) continue;
                execEffValue = weeResult.getValue(kernel);
                nonpredExecEffValue = weeResult.getNonPredicatedValue(kernel);
                execEffDesc = weeResult.getValueDescription(kernel);
                nonpredExecEffDesc = weeResult.getNonPredicatedValueDescription(kernel);
                execEffSeverity = weeResult.getSeverity();
                break;
            }
            if (execEffValue == null) {
                List<AnalysisResult> kernelWarpExecResults = analysis.getAnalysisResults(AnalysisStage.KERNEL_INSTANCE_SM, AnalysisResultKernelExecutionEfficiency.class);
                for (AnalysisResult result : kernelWarpExecResults) {
                    AnalysisResultKernelExecutionEfficiency weeResult = (AnalysisResultKernelExecutionEfficiency)result;
                    if (weeResult.getKernel() != kernel) continue;
                    execEffValue = weeResult.getValue();
                    nonpredExecEffValue = weeResult.getNonPredicatedValue();
                    execEffDesc = weeResult.getValueDescription();
                    nonpredExecEffDesc = weeResult.getNonPredicatedValueDescription();
                    execEffSeverity = weeResult.getSeverity();
                    break;
                }
            }
            if (execEffValue != null) {
                if (effNode == null) {
                    effNode = this.addNode(subTree, "Efficiency", null, null, null);
                }
                this.addNode(effNode, "Warp Execution Efficiency", execEffValue, this.getAnalysisImage(execEffSeverity), execEffDesc);
                if (nonpredExecEffValue != null) {
                    this.addNode(effNode, "Not-Predicated-Off Warp Execution Efficiency", nonpredExecEffValue, this.getAnalysisImage(execEffSeverity), nonpredExecEffDesc);
                }
            }
        }
        TreeItem occupancyNode = null;
        Double occupancy = null;
        if (analysis != null) {
            AnalysisResult occupancyResult;
            IValue occupancyValue = null;
            AnalysisDescriptor.Severity occupancySeverity = AnalysisDescriptor.Severity.OK;
            String occupancyDesc = null;
            List<AnalysisResult> occupancyResults = analysis.getAnalysisResults(AnalysisStage.KERNELS, AnalysisResultOccupancy.class);
            for (AnalysisResult result : occupancyResults) {
                occupancyResult = (AnalysisResultOccupancy)result;
                if (!((AnalysisResultInterval)occupancyResult).containsInterval(kernel)) continue;
                occupancy = (Double)((AnalysisResultInterval)occupancyResult).getData(kernel);
                occupancyValue = ((AnalysisResultOccupancy)occupancyResult).getValue(kernel);
                occupancySeverity = occupancyResult.getSeverity();
                occupancyDesc = ((AnalysisResultOccupancy)occupancyResult).getValueDescription(kernel);
                break;
            }
            if (occupancyValue == null) {
                occupancyResults = analysis.getAnalysisResults(AnalysisStage.KERNEL_INSTANCE_LATENCY, AnalysisResultKernelOccupancy.class);
                for (AnalysisResult result : occupancyResults) {
                    occupancyResult = (AnalysisResultKernelOccupancy)result;
                    if (((AnalysisResultKernelOccupancy)occupancyResult).getKernel() != kernel) continue;
                    occupancy = ((AnalysisResultKernelOccupancy)occupancyResult).getAchievedOccupancy();
                    occupancyValue = new ValuePercent(occupancy * 100.0);
                    break;
                }
            }
            if (occupancyValue != null) {
                if (occupancyNode == null) {
                    occupancyNode = this.addNode(subTree, "Occupancy", null, null, null);
                }
                this.addNode(occupancyNode, "Achieved", occupancyValue, this.getAnalysisImage(occupancySeverity), occupancyDesc);
            }
        }
        if (timeline != null && deviceTimeline != null) {
            OccupancyCalculator.Limiter limiter;
            OccupancyCalculator oc = new OccupancyCalculator(kernel, deviceTimeline, false);
            Double theoreticalOccupancy = oc.getTheoreticOccupancy();
            if (theoreticalOccupancy != null) {
                ValuePercent toc = new ValuePercent(theoreticalOccupancy * 100.0);
                if (occupancyNode == null) {
                    occupancyNode = this.addNode(subTree, "Occupancy", null, null, null);
                }
                this.addNode(occupancyNode, "Theoretical", toc, null, "The peak occupancy based on block size, register usage, shared memory usage, etc.");
            }
            if ((limiter = oc.getLimiter()) != null && limiter.isKnownLimit() && occupancy != null && occupancy < 0.5) {
                if (occupancyNode == null) {
                    occupancyNode = this.addNode(subTree, "Occupancy", null, null, null);
                }
                this.addNode(occupancyNode, "Limiter", oc.isGridSizeLimited() ? "Grid Size" : limiter, null, null);
            }
        }
        if (kernel.getParent() instanceof TimelineIntervalKernel) {
            TimelineIntervalKernel parent = (TimelineIntervalKernel)kernel.getParent();
            TreeItem parentNode = this.addNode(subTree, "Parent Kernel", null, null, null);
            this.addNode(parentNode, "Name", parent.getDisplayName(), null, null);
            Integer[] parentBlock = kernel.getParentBlock();
            if (parentBlock != null && parentBlock[0] != null && parentBlock[1] != null && parentBlock[2] != null) {
                this.addNode(parentNode, "Launch " + ViperComputeDictionary.BLOCK.getLabel(computeKind), "[ " + parentBlock[0] + "," + parentBlock[1] + "," + parentBlock[2] + " ]", null, "The parent block containing the thread that launched this kernel");
            }
            parentNode.setExpanded(true);
        }
        if (deviceTimeline != null) {
            Long smemRequested;
            Long smemExecuted = kernel.getSharedMemoryExecuted();
            Integer smemConfig = kernel.getSharedMemoryBankSize();
            if (deviceTimeline.getComputeCapabilityMajor() >= 7 && kernel.getIsSharedMemoryCarveoutRequested() != 0) {
                long maxSharedMemory = deviceTimeline.getMaxSharedMemory(CuCacheConfig.CU_FUNC_CACHE_PREFER_NONE);
                smemRequested = kernel.getSharedMemoryCarveoutSizeRequested(maxSharedMemory);
            } else {
                CuCacheConfig ccRequested = kernel.getCacheConfigRequested();
                smemRequested = ccRequested == null || ccRequested == CuCacheConfig.CU_FUNC_CACHE_PREFER_NONE ? null : deviceTimeline.getMaxSharedMemory(ccRequested);
            }
            if (smemRequested != null || smemExecuted != null || smemConfig != null) {
                TreeItem smemConfigNode = this.addNode(subTree, String.valueOf(ViperComputeDictionary.SHARED.getLabel(computeKind)) + " Memory Configuration", null, null, null);
                if (smemRequested != null) {
                    this.addNode(smemConfigNode, String.valueOf(ViperComputeDictionary.SHARED.getLabel(computeKind)) + " Memory Requested", new ByteSizeFormatter(ByteSizeFormatter.Base.KIBIBYTE).format(smemRequested), null, null);
                }
                if (smemExecuted != null) {
                    this.addNode(smemConfigNode, String.valueOf(ViperComputeDictionary.SHARED.getLabel(computeKind)) + " Memory Executed", new ByteSizeFormatter(ByteSizeFormatter.Base.KIBIBYTE).format(smemExecuted), null, null);
                }
                if (smemConfig != null) {
                    this.addNode(smemConfigNode, String.valueOf(ViperComputeDictionary.SHARED.getLabel(computeKind)) + " Memory Bank Size", new ByteSizeFormatter(ByteSizeFormatter.Base.KIBIBYTE).format(smemConfig.intValue()), null, null);
                }
                smemConfigNode.setExpanded(true);
            }
        }
        if (deviceTimeline != null) {
            CuptiActivityPartitionedGlobalCacheConfigKind requested = CuptiActivityPartitionedGlobalCacheConfigKind.valueOf(kernel.getPartitionedGlobalCacheConfigRequested());
            CuptiActivityPartitionedGlobalCacheConfigKind executed = CuptiActivityPartitionedGlobalCacheConfigKind.valueOf(kernel.getPartitionedGlobalCacheConfigExecuted());
            if (CuptiActivityPartitionedGlobalCacheConfigKind.CUPTI_ACTIVITY_PARTITIONED_GLOBAL_CACHE_CONFIG_ON.equals((Object)requested) || CuptiActivityPartitionedGlobalCacheConfigKind.CUPTI_ACTIVITY_PARTITIONED_GLOBAL_CACHE_CONFIG_OFF.equals((Object)requested)) {
                TreeItem partitionedGlobalCacheNode = this.addNode(subTree, String.valueOf(ViperComputeDictionary.GLOBAL_CACHE.getLabel(computeKind)) + " Configuration", null, null, null);
                this.addNode(partitionedGlobalCacheNode, String.valueOf(ViperComputeDictionary.GLOBAL_CACHE.getLabel(computeKind)) + " Requested ", requested.getName(), null, null);
                if (CuptiActivityPartitionedGlobalCacheConfigKind.CUPTI_ACTIVITY_PARTITIONED_GLOBAL_CACHE_CONFIG_ON.equals((Object)executed) || CuptiActivityPartitionedGlobalCacheConfigKind.CUPTI_ACTIVITY_PARTITIONED_GLOBAL_CACHE_CONFIG_OFF.equals((Object)executed)) {
                    this.addNode(partitionedGlobalCacheNode, String.valueOf(ViperComputeDictionary.GLOBAL_CACHE.getLabel(computeKind)) + " Executed ", executed.getName(), null, null);
                }
                partitionedGlobalCacheNode.setExpanded(true);
            }
        }
        if (effNode != null) {
            effNode.setExpanded(true);
        }
        if (occupancyNode != null) {
            occupancyNode.setExpanded(true);
        }
    }

    protected void showMemcpyInterval(Timeline timeline, TimelineIntervalMemcpy memcpy, TreeItem subTree) {
        String name = memcpy.getDisplayName();
        String tooltip = String.valueOf(memcpy.isAsync() ? "Asynchronous " : "Synchronous ") + memcpy.getCopyKind().getLongName().toLowerCase(Locale.ENGLISH) + " memory copy";
        if (subTree == null) {
            this.setTitle(name, tooltip);
        } else {
            this.addNode(subTree, "Description", name, null, tooltip);
        }
        this.addNode(subTree, "Start", new PreciseTimeFormatter(memcpy.getStart()), null, "The start time for the memory copy");
        this.addNode(subTree, "End", new PreciseTimeFormatter(memcpy.getEnd()), null, "The end time for the memory copy");
        this.addNode(subTree, "Duration", new PreciseTimeFormatter(memcpy.getDuration()), null, "The time required to complete the memory copy");
        Analysis analysis = this.activeSession.getAnalysis();
        long bytes = memcpy.getBytes();
        if (bytes >= 0L) {
            CuptiActivityMemoryKind dstKind;
            Image sizeAnalysisImage = null;
            if (analysis != null) {
                List<AnalysisResult> sizeResults = analysis.getAnalysisResults(AnalysisStage.TIMELINE, AnalysisResultMemcpySize.class);
                for (AnalysisResult result : sizeResults) {
                    AnalysisResultMemcpySize sizeResult = (AnalysisResultMemcpySize)result;
                    if (!sizeResult.containsInterval(memcpy)) continue;
                    sizeAnalysisImage = this.getAnalysisImage(result.getSeverity());
                    break;
                }
            }
            this.addNode(subTree, "Size", new ValueByteSize(ByteSizeFormatter.Base.KILOBYTE, bytes), sizeAnalysisImage, null);
            Image bwAnalysisImage = null;
            if (analysis != null) {
                List<AnalysisResult> bwResults = analysis.getAnalysisResults(AnalysisStage.TIMELINE, AnalysisResultMemcpyThroughput.class);
                for (AnalysisResult result : bwResults) {
                    AnalysisResultMemcpyThroughput bwResult = (AnalysisResultMemcpyThroughput)result;
                    if (!bwResult.containsInterval(memcpy)) continue;
                    bwAnalysisImage = this.getAnalysisImage(result.getSeverity());
                    break;
                }
            }
            ValueBandwidth bwValue = new ValueBandwidth(ByteSizeFormatter.Base.KILOBYTE, memcpy.getThroughput());
            this.addNode(subTree, "Throughput", bwValue, bwAnalysisImage, null);
            this.addNode(subTree, "Stream", memcpy.getStreamName(), null, "The stream on which this memcopy was launched");
            TreeItem memKindNode = null;
            CuptiActivityMemoryKind srcKind = memcpy.getSrcMemoryKind();
            if (!srcKind.equals((Object)CuptiActivityMemoryKind.CUPTI_ACTIVITY_MEMORY_KIND_UNKNOWN)) {
                if (memKindNode == null) {
                    memKindNode = this.addNode(subTree, "Memory Type", null, null, null);
                }
                this.addNode(memKindNode, "Source", srcKind.getShortName(), null, srcKind.getLongName());
            }
            if (!(dstKind = memcpy.getDstMemoryKind()).equals((Object)CuptiActivityMemoryKind.CUPTI_ACTIVITY_MEMORY_KIND_UNKNOWN)) {
                if (memKindNode == null) {
                    memKindNode = this.addNode(subTree, "Memory Type", null, null, null);
                }
                this.addNode(memKindNode, "Destination", dstKind.getShortName(), null, dstKind.getLongName());
            }
            if (memKindNode != null) {
                memKindNode.setExpanded(true);
            }
            if (memcpy.getSourceDeviceId() > -1) {
                this.addNode(subTree, "Source Device", "[" + memcpy.getSourceDeviceId() + "]" + " " + this.activeSession.getDeviceName(memcpy.getSourceDeviceId()), null, null);
            }
            if (memcpy.getDestinationDeviceId() > -1) {
                this.addNode(subTree, "Destination Device", "[" + memcpy.getDestinationDeviceId() + "]" + " " + this.activeSession.getDeviceName(memcpy.getDestinationDeviceId()), null, null);
            }
        }
    }

    protected void showMemsetInterval(Timeline timeline, TimelineIntervalMemset memset, TreeItem subTree) {
        String tooltip = memset.getTooltip();
        String name = memset.getDisplayName();
        if (subTree == null) {
            this.setTitle(name, tooltip);
        } else {
            this.addNode(subTree, "Description", name, null, tooltip);
        }
        this.addNode(subTree, "Start", new PreciseTimeFormatter(memset.getStart()), null, "The start time for the memory set operation");
        this.addNode(subTree, "End", new PreciseTimeFormatter(memset.getEnd()), null, "The end time for the memory set operation");
        this.addNode(subTree, "Duration", new PreciseTimeFormatter(memset.getDuration()), null, "The time required to complete the memory set operation");
        this.addNode(subTree, "Value", memset.getValue(), null, null);
        this.addNode(subTree, "Size", new ValueByteSize(ByteSizeFormatter.Base.KILOBYTE, memset.getBytes()), null, null);
        ValueBandwidth bwValue = new ValueBandwidth(ByteSizeFormatter.Base.KILOBYTE, memset.getThroughput());
        this.addNode(subTree, "Throughput", bwValue, null, null);
        this.addNode(subTree, "Stream", memset.getStreamName(), null, "The stream on which this memset was launched");
        if (!memset.getMemoryKind().equals((Object)CuptiActivityMemoryKind.CUPTI_ACTIVITY_MEMORY_KIND_UNKNOWN)) {
            this.addNode(subTree, "Memory Type", memset.getMemoryKind().getShortName(), null, null);
        }
    }

    protected void showTimeline(Timeline timeline) {
        this.setTitle(timeline.getDisplayName(false), timeline.getDisplayName(false));
        this.addDuration(null);
    }

    protected void showAPITimeline(Timeline timeline) {
        Timeline threadTimeline = timeline.getParent();
        if (threadTimeline != null && TimelineKind.THREAD.equals((Object)threadTimeline.getKind())) {
            this.setTitle(String.valueOf(timeline.getDisplayName(false)) + " [ " + threadTimeline.getDisplayName(false) + " ]", String.valueOf(timeline.getDisplayName(false)) + " invoked from " + threadTimeline.getDisplayName(false));
        } else {
            this.setTitle(timeline.getDisplayName(false), timeline.getDisplayName(false));
        }
        this.addDuration(null);
    }

    protected void showNvlinkTimeline(TimelineNvlink timeline) {
        Timeline deviceTL = timeline.getAncestor(TimelineKind.DEVICE);
        if (timeline.getKind().equals((Object)TimelineKind.NVLINK)) {
            this.setTitle(timeline.getDisplayName(false), "NVlink timelines for device " + deviceTL.getDisplayName(false));
            this.addDuration(null);
        } else {
            this.setTitle("NVlink " + deviceTL.getDisplayName(false) + " => " + timeline.getDisplayName(false), "");
            this.addDuration(null);
            this.addNode(null, "Theoretical maximum throughput", new BandwidthFormatter(ByteSizeFormatter.Base.KILOBYTE).format(timeline.getMaxValue()), null, null);
            TreeItem transmitNode = this.addNode(null, "Transmit", null, null, null);
            this.addNode(transmitNode, "Average Throughput", new BandwidthFormatter(ByteSizeFormatter.Base.KILOBYTE).format(timeline.getAvgTransmitThroughput()), null, "Average throughput");
            this.addNode(transmitNode, "Maximum Throughput", new BandwidthFormatter(ByteSizeFormatter.Base.KILOBYTE).format(timeline.getMaxTransmitThroughput()), null, "Maximum throughput");
            this.addNode(transmitNode, "Idle time", new PreciseTimeFormatter(timeline.getTransmitIdleTime()), null, "Idle time");
            transmitNode.setExpanded(true);
            TreeItem receiveNode = this.addNode(null, "Receive", null, null, null);
            this.addNode(receiveNode, "Average Throughput", new BandwidthFormatter(ByteSizeFormatter.Base.KILOBYTE).format(timeline.getAvgReceiveThroughput()), null, "Average transmit throughput");
            this.addNode(receiveNode, "Maximum Throughput", new BandwidthFormatter(ByteSizeFormatter.Base.KILOBYTE).format(timeline.getMaxReceiveThroughput()), null, "Maximum transmit throughput");
            this.addNode(receiveNode, "Idle time", new PreciseTimeFormatter(timeline.getReceiveIdleTime()), null, "Idle time");
            receiveNode.setExpanded(true);
        }
    }

    protected void showComputeTimeline(Timeline timeline) {
        this.setTitle(timeline.getDisplayName(false), timeline.getDisplayName(false));
        CuptiActivityComputeApiKind computeKind = CuptiActivityComputeApiKind.CUPTI_ACTIVITY_COMPUTE_API_CUDA;
        TimelineContext ctxTimeline = (TimelineContext)timeline.getAncestor(TimelineKind.CONTEXT);
        if (ctxTimeline != null) {
            computeKind = ctxTimeline.getComputeKind();
            long totalExecTime = ctxTimeline.getTotalKernelExecutionTime();
            int totalInvocationCount = ctxTimeline.getTotalKernelInvocationCount();
            TreeItem duration = this.addDuration(null);
            this.addNode(duration, String.valueOf(ViperComputeDictionary.KERNEL.getLabel(computeKind)) + "s", new PreciseTimeFormatter(totalExecTime), null, "The total execution time for all kernels");
            ValuePercent utilValue = new ValuePercent(100.0 * ctxTimeline.getComputeUtilization());
            this.addNode(null, "Compute Utilization", utilValue, null, "The percentage of time that any kernel was executing");
            this.addNode(null, String.valueOf(ViperComputeDictionary.KERNEL.getLabel(computeKind)) + " Invocations", totalInvocationCount, null, "The total number of kernel invocations");
        }
    }

    protected void showKernelTimeline(TimelineKernel timeline) {
        this.setTitle(timeline.getDisplayName(false), timeline.getDisplayName(false));
        CuptiActivityComputeApiKind computeKind = CuptiActivityComputeApiKind.CUPTI_ACTIVITY_COMPUTE_API_CUDA;
        TimelineContext ctxTimeline = (TimelineContext)timeline.getAncestor(TimelineKind.CONTEXT);
        if (ctxTimeline != null) {
            computeKind = ctxTimeline.getComputeKind();
        }
        TreeItem duration = this.addDuration(null);
        long selfExecTime = timeline.getSelfExecutionTime();
        long totalExecTime = timeline.getTotalExecutionTime();
        if (timeline.isContainer()) {
            this.addNode(duration, String.valueOf(ViperComputeDictionary.KERNEL.getLabel(computeKind)) + " (self)", new PreciseTimeFormatter(selfExecTime), null, "The total execution time for all instances of the kernel, not including descendant kernels");
            this.addNode(duration, String.valueOf(ViperComputeDictionary.KERNEL.getLabel(computeKind)) + " (total)", new PreciseTimeFormatter(totalExecTime), null, "The total execution time for all instances of the kernel and all instances of descendant kernels");
        } else {
            this.addNode(duration, ViperComputeDictionary.KERNEL.getLabel(computeKind), new PreciseTimeFormatter(totalExecTime), null, "The total execution time for all instances of the kernel");
        }
        int selfInvocations = timeline.getSelfInvocationCount();
        int totalInvocations = timeline.getTotalInvocationCount();
        if (timeline.isContainer()) {
            TreeItem invocations = this.addNode(null, "Invocations", null, null, null);
            this.addNode(invocations, "Self", selfInvocations, null, "The number of times this kernel was invoked, not including descendant kernels");
            this.addNode(invocations, "Total", totalInvocations, null, "The number of times this kernel and all descendant kernels were invoked");
            invocations.setExpanded(true);
        } else {
            this.addNode(null, "Invocations", totalInvocations, null, "The number of times this kernel was invoked");
        }
        ValuePercent selfExecRatioValue = new ValuePercent(100.0 * timeline.getSelfExecutionRatio());
        ValuePercent totalExecRatioValue = new ValuePercent(100.0 * timeline.getTotalExecutionRatio());
        if (timeline.isContainer()) {
            TreeItem execRatio = this.addNode(null, "Importance", null, null, null);
            this.addNode(execRatio, "Self", selfExecRatioValue, null, "The percentage of total GPU compute time spent executing instances of this kernel, not including descendant kernels");
            this.addNode(execRatio, "Total", totalExecRatioValue, null, "The percentage of total GPU compute time spent executing instances of this kernel and all descendant kernels");
            execRatio.setExpanded(true);
        } else {
            this.addNode(null, "Importance", totalExecRatioValue, null, "The percentage of total GPU compute time spent executing instances of this kernel");
        }
    }

    protected void showMemcpyTimeline(TimelineMemcpy timeline) {
        long totalExecTime = timeline.getTotalExecTime();
        long totalBytes = timeline.getTotalBytes();
        int invocations = timeline.getNumIntervals();
        this.setTitle(timeline.getDisplayName(false), timeline.getDisplayName(false));
        TreeItem duration = this.addDuration(null);
        this.addNode(duration, "Memcpys", new PreciseTimeFormatter(totalExecTime), null, "The total duration of all memory copies");
        this.addNode(null, "Invocations", invocations, null, "The total number of memory copies");
        if (totalBytes > 0L) {
            this.addNode(null, "Total Bytes", new ByteSizeFormatter(ByteSizeFormatter.Base.KILOBYTE).format(totalBytes), null, "The total number of bytes copied");
        }
        if (totalBytes > 0L) {
            ValueBandwidth bwValue = new ValueBandwidth(ByteSizeFormatter.Base.KILOBYTE, totalBytes, totalExecTime);
            this.addNode(null, "Avg. Throughput", bwValue, null, "The average memory copy throughput");
        }
    }

    private void showUVMParentTimeline(TimelineUVM timeline) {
        List<Timeline> uvmTimelines = timeline.getChildren();
        for (Timeline uvmTimeline : uvmTimelines) {
            TimelineUVM uvmTl;
            long totalValue;
            if (!(uvmTimeline instanceof TimelineUVM) || (totalValue = (uvmTl = (TimelineUVM)uvmTimeline).getTotalValue()) <= 0L) continue;
            switch (uvmTimeline.getKind()) {
                case UVM_GPU_PAGE_FAULT: {
                    this.addNode(null, "GPU Page Faults", totalValue, null, "The total number of gpu page faults");
                    this.addNode(null, "GPU Page Fault groups", uvmTl.getNumRecords(), null, "The total number of gpu page fault groups");
                    break;
                }
                case UVM_PAGE_FAULT: {
                    this.addNode(null, "Total CPU Page Faults", totalValue, null, "The total number of cpu page faults");
                    break;
                }
                case UVM_MEMCPY_HTOD: {
                    this.addNode(null, "Total Bytes (HtoD)", new ByteSizeFormatter(ByteSizeFormatter.Base.KILOBYTE).format(totalValue), null, "The total number of bytes migrated from host to device");
                    break;
                }
                case UVM_MEMCPY_DTOH: {
                    this.addNode(null, "Total Bytes (DtoH)", new ByteSizeFormatter(ByteSizeFormatter.Base.KILOBYTE).format(totalValue), null, "The total number of bytes migrated from device to host");
                }
                case UVM_MEMCPY_DTOD: {
                    this.addNode(null, "Total Bytes (DtoD)", new ByteSizeFormatter(ByteSizeFormatter.Base.KILOBYTE).format(totalValue), null, "The total number of bytes migrated from device to device");
                }
            }
        }
    }

    protected void showUVMTimeline(TimelineUVM timeline) {
        this.setTitle(timeline.getDisplayName(false), timeline.getDisplayName(false));
        TreeItem duration = this.addDuration(null);
        if (timeline.getKind().equals((Object)TimelineKind.UVM_MEMCPY_DTOH) || timeline.getKind().equals((Object)TimelineKind.UVM_MEMCPY_HTOD) || timeline.getKind().equals((Object)TimelineKind.UVM_MEMCPY_DTOD)) {
            this.addNode(duration, "Data Migration", new PreciseTimeFormatter(timeline.getTotalDuration()), null, "The total duration of all UVM transfers");
            int samples = timeline.getNumIntervals();
            if (samples > 0) {
                this.addNode(null, "Count", samples, null, "The total number of samples for unified memory data migration");
            }
        }
        if (timeline.getKind().equals((Object)TimelineKind.UVM)) {
            this.showUVMParentTimeline(timeline);
        } else {
            switch (timeline.getKind()) {
                case UVM_PAGE_FAULT: {
                    this.addNode(null, "Total CPU Page Faults", timeline.getTotalValue(), null, "The total number of CPU page faults");
                    break;
                }
                case UVM_GPU_PAGE_FAULT: {
                    this.addNode(null, "GPU Page Faults", timeline.getTotalValue(), null, "The total number of GPU page faults");
                    this.addNode(null, "GPU Page Fault groups", timeline.getNumRecords(), null, "The total number of GPU page fault groups");
                    break;
                }
                case UVM_MEMCPY_HTOD: 
                case UVM_MEMCPY_DTOH: {
                    ValueBandwidth bwValue;
                    long totalValue = timeline.getTotalValue();
                    this.addNode(null, "Total Bytes", new ByteSizeFormatter(ByteSizeFormatter.Base.KILOBYTE).format(totalValue), null, "The total number of bytes migrated");
                    if (totalValue > 0L) {
                        bwValue = new ValueBandwidth(ByteSizeFormatter.Base.KILOBYTE, totalValue, timeline.getTotalDuration());
                        this.addNode(null, "Avg. Throughput", bwValue, null, "The average throughput of data migrations");
                    }
                }
                case UVM_MEMCPY_DTOD: {
                    ValueBandwidth bwValue;
                    long totalValue = timeline.getTotalDtoDSrcSize();
                    if (totalValue > 0L) {
                        this.addNode(null, "Total Bytes transferred from device", new ByteSizeFormatter(ByteSizeFormatter.Base.KILOBYTE).format(totalValue), null, "The total number of bytes migrated from this device");
                        bwValue = new ValueBandwidth(ByteSizeFormatter.Base.KILOBYTE, totalValue, timeline.getTotalDtoDSrcDuration());
                        this.addNode(null, "Avg. Transfer Throughput", bwValue, null, "The average transfer throughput of data migrations");
                    }
                    if ((totalValue = timeline.getTotalDtoDDstSize()) <= 0L) break;
                    this.addNode(null, "Total Bytes received by device", new ByteSizeFormatter(ByteSizeFormatter.Base.KILOBYTE).format(totalValue), null, "The total number of bytes migrated to this device");
                    bwValue = new ValueBandwidth(ByteSizeFormatter.Base.KILOBYTE, totalValue, timeline.getTotalDtoDDstDuration());
                    this.addNode(null, "Avg. Receive Throughput", bwValue, null, "The average receive throughput of data migrations");
                    break;
                }
                case UVM_THRASHING_THROTTLING: {
                    this.addNode(null, "Total thrashing size", new ByteSizeFormatter(ByteSizeFormatter.Base.KILOBYTE).format(timeline.getTotalThrashingSize()), null, "The total size of thrashed memory");
                    this.addNode(null, "Number of throttles", timeline.getTotalPageThrottles(), null, "The total number of page throttles");
                    this.addNode(null, "Source remote mapping size", new ByteSizeFormatter(ByteSizeFormatter.Base.KILOBYTE).format(timeline.getTotalRemoteMapSourceSize()), null, "The total size of memory mapped remotely from this device");
                    this.addNode(null, "Destination remote mapping size", new ByteSizeFormatter(ByteSizeFormatter.Base.KILOBYTE).format(timeline.getTotalRemoteMapDestSize()), null, "The total size of memory mapped remotely to this device");
                    break;
                }
                case UVM_THRASHING: {
                    this.addNode(null, "Total thrashes", timeline.getTotalThrashes(), null, "The total number of thrashes occured on the processor");
                    this.addNode(null, "Total thrashing size", new ByteSizeFormatter(ByteSizeFormatter.Base.KILOBYTE).format(timeline.getTotalThrashingSize()), null, "The total size of thrashed memory");
                    break;
                }
                case UVM_PAGE_THROTTLING: {
                    this.addNode(duration, "Page throttling", new PreciseTimeFormatter(timeline.getTotalDuration()), null, "The total duration of page throttles");
                    this.addNode(null, "Number of throttles", timeline.getTotalPageThrottles(), null, "The total number of page throttles");
                    break;
                }
                case UVM_REMOTE_MAP: {
                    TreeItem srcMapping = this.addNode(null, "Source Remote Mapping", null, null, "Memory mapped remotely from this device");
                    this.addNode(srcMapping, "Count", timeline.getTotalRemoteMapSource(), null, "The number of times memory was mapped remotely from this device");
                    this.addNode(srcMapping, "Size", new ByteSizeFormatter(ByteSizeFormatter.Base.KILOBYTE).format(timeline.getTotalRemoteMapSourceSize()), null, "The total size of memory mapped remotely from this device");
                    srcMapping.setExpanded(true);
                    TreeItem dstMapping = this.addNode(null, "Destination Remote Mapping", null, null, "Memory mapped remotely to this device");
                    this.addNode(dstMapping, "Count", timeline.getTotalRemoteMapDest(), null, "The number of times memory was mapped remotely to this device");
                    this.addNode(dstMapping, "Size", new ByteSizeFormatter(ByteSizeFormatter.Base.KILOBYTE).format(timeline.getTotalRemoteMapDestSize()), null, "The total size of memory mapped remotely to this device");
                    dstMapping.setExpanded(true);
                    break;
                }
            }
        }
    }

    protected void showOverheadTimeline(TimelineOverhead timeline) {
        this.setTitle(timeline.getDisplayName(false), timeline.getDisplayName(false));
        TreeItem duration = this.addDuration(null);
        this.addNode(duration, "Overhead", new PreciseTimeFormatter(timeline.getTotalTime()), null, null);
        TreeItem numberOfIntervals = this.addNode(null, "Number of Intervals", null, null, null);
        this.addNode(numberOfIntervals, "Compiler(JIT) Overhead", timeline.getCompilerOverhead(), null, "The number of intervals for compiler overhead");
        this.addNode(numberOfIntervals, "Activity Buffer Flush Overhead", timeline.getActivityBufferFlushOverhead(), null, "The number of intervals for activity buffer flush overhead");
        this.addNode(numberOfIntervals, "CUPTI Instrumentation Overhead", timeline.getCuptiInstrumentationOverhead(), null, "The number of intervals for CUPTI instrumentation overhead");
        this.addNode(numberOfIntervals, "CUPTI Resource Overhead", timeline.getCuptiResourceOverhead(), null, "The number of intervals for CUPTI resource creation and destruction overhead");
        this.addNode(numberOfIntervals, "Total number of Intervals", timeline.getIntervalIds().length, null, null);
        numberOfIntervals.setExpanded(true);
        this.addNode(null, "Min Time", new PreciseTimeFormatter(timeline.getMinTime()), null, "The min time for overhead");
        this.addNode(null, "Max Time", new PreciseTimeFormatter(timeline.getMaxTime()), null, "The max time for overhead");
        this.addNode(null, "Average Time", new PreciseTimeFormatter(timeline.getAverageTime()), null, "The average time for overhead");
    }

    protected void showDeviceTimeline(TimelineDevice timeline) {
        Number pciWidth;
        Number pciRate;
        Number flopDp;
        Number flopSp;
        Integer[] block;
        CuptiActivityComputeApiKind computeKind = CuptiActivityComputeApiKind.CUPTI_ACTIVITY_COMPUTE_API_CUDA;
        this.setTitle(timeline.getDisplayName(false), timeline.getDisplayName(false));
        StringBuilder uuidLabel = timeline.getUuidSHA_1Format();
        if (uuidLabel != null) {
            this.addNode(null, "GPU UUID", uuidLabel, null, null);
        }
        this.addDuration(null);
        Analysis analysis = this.activeSession.getAnalysis();
        if (analysis != null) {
            TreeItem overlapNode = null;
            List<AnalysisResult> computeResults = analysis.getAnalysisResults(AnalysisStage.KERNELS, AnalysisResultGPUCompute.class);
            for (AnalysisResult result : computeResults) {
                AnalysisResultGPUCompute timelineResult = (AnalysisResultGPUCompute)result;
                if (!timelineResult.containsTimeline(timeline)) continue;
                IValue util = timelineResult.getValue(timeline);
                if (util == null) break;
                this.addNode(null, "Compute Utilization", util, this.getAnalysisImage(result.getSeverity()), null);
                break;
            }
            List<AnalysisResult> memcpyResults = analysis.getAnalysisResults(AnalysisStage.TIMELINE, AnalysisResultGPUComputeEfficiency.class);
            for (AnalysisResult result : memcpyResults) {
                AnalysisResultGPUComputeEfficiency timelineResult = (AnalysisResultGPUComputeEfficiency)result;
                if (!timelineResult.containsTimeline(timeline)) continue;
                IValue util = timelineResult.getValue(timeline);
                if (util == null) break;
                this.addNode(null, "Kernel/Memcpy", util, this.getAnalysisImage(result.getSeverity()), timelineResult.getValueDescription(timeline));
                break;
            }
            List<AnalysisResult> kmOverlapResults = analysis.getAnalysisResults(AnalysisStage.TIMELINE, AnalysisResultGPUOverlap.class);
            for (AnalysisResult result : kmOverlapResults) {
                AnalysisResultGPUOverlap timelineResult = (AnalysisResultGPUOverlap)result;
                if (!timelineResult.containsTimeline(timeline)) continue;
                IValue overlap = timelineResult.getValue(timeline);
                if (overlap == null) break;
                if (overlapNode == null) {
                    overlapNode = this.addNode(null, "Overlap", null, null, null);
                }
                this.addNode(overlapNode, "Memcpy/" + ViperComputeDictionary.KERNEL.getLabel(computeKind), overlap, this.getAnalysisImage(result.getSeverity()), timelineResult.getValueDescription(timeline));
                break;
            }
            List<AnalysisResult> kkOverlapResults = analysis.getAnalysisResults(AnalysisStage.TIMELINE, AnalysisResultKernelConcurrency.class);
            for (AnalysisResult result : kkOverlapResults) {
                AnalysisResultKernelConcurrency timelineResult = (AnalysisResultKernelConcurrency)result;
                if (!timelineResult.containsTimeline(timeline)) continue;
                IValue overlap = timelineResult.getValue(timeline);
                if (overlap == null) break;
                if (overlapNode == null) {
                    overlapNode = this.addNode(null, "Overlap", null, null, null);
                }
                this.addNode(overlapNode, "Kernel/Kernel", overlap, this.getAnalysisImage(result.getSeverity()), timelineResult.getValueDescription(timeline));
                break;
            }
            List<AnalysisResult> mmOverlapResults = analysis.getAnalysisResults(AnalysisStage.TIMELINE, AnalysisResultMemcpyOverlap.class);
            for (AnalysisResult result : mmOverlapResults) {
                AnalysisResultMemcpyOverlap timelineResult = (AnalysisResultMemcpyOverlap)result;
                if (!timelineResult.containsTimeline(timeline)) continue;
                IValue overlap = timelineResult.getValue(timeline);
                if (overlap == null) break;
                if (overlapNode == null) {
                    overlapNode = this.addNode(null, "Overlap", null, null, null);
                }
                this.addNode(overlapNode, "Memcpy/Memcpy", overlap, this.getAnalysisImage(result.getSeverity()), timelineResult.getValueDescription(timeline));
                break;
            }
            if (overlapNode != null) {
                overlapNode.setExpanded(true);
            }
        }
        TreeItem attributesNode = this.addNode(null, "Attributes", null, null, null);
        if (timeline.getComputeCapabilityMajor() > 0) {
            this.addNode(attributesNode, "Compute Capability", String.valueOf(timeline.getComputeCapabilityMajor()) + "." + timeline.getComputeCapabilityMinor(), null, null);
        }
        TreeItem maximumsNode = this.addNode(attributesNode, "Maximums", null, null, null);
        if (timeline.getMaxThreadsPerBlock() > 0) {
            this.addNode(maximumsNode, String.valueOf(ViperComputeDictionary.THREAD.getLabel(computeKind)) + "s per " + ViperComputeDictionary.BLOCK.getLabel(computeKind), timeline.getMaxThreadsPerBlock(), null, null);
        }
        this.addNode(maximumsNode, String.valueOf(ViperComputeDictionary.THREAD.getLabel(computeKind)) + "s per " + ViperComputeDictionary.MULTIPROCESSOR.getLabel(computeKind), String.valueOf(OccupancyCalculator.getMaxThreadsPerMultiprocessor(timeline)), null, null);
        if (timeline.getMaxSharedMemoryPerBlock() > 0) {
            this.addNode(maximumsNode, String.valueOf(ViperComputeDictionary.SHARED.getLabel(computeKind)) + " Memory per " + ViperComputeDictionary.BLOCK.getLabel(computeKind), new ByteSizeFormatter(ByteSizeFormatter.Base.KIBIBYTE).format(timeline.getMaxSharedMemoryPerBlock()), null, null);
        }
        this.addNode(maximumsNode, String.valueOf(ViperComputeDictionary.SHARED.getLabel(computeKind)) + " Memory per " + ViperComputeDictionary.MULTIPROCESSOR.getLabel(computeKind), new ByteSizeFormatter(ByteSizeFormatter.Base.KIBIBYTE).format(OccupancyCalculator.getMaxSharedMemoryPerMultiprocessor(timeline)), null, null);
        if (timeline.getMaxRegistersPerBlock() > 0) {
            this.addNode(maximumsNode, "Registers per " + ViperComputeDictionary.BLOCK.getLabel(computeKind), timeline.getMaxRegistersPerBlock(), null, null);
        }
        this.addNode(maximumsNode, "Registers per " + ViperComputeDictionary.MULTIPROCESSOR.getLabel(computeKind), OccupancyCalculator.getMaxRegistersPerMultiprocessor(timeline), null, null);
        Integer[] grid = timeline.getMaxGridDims();
        if (grid != null && grid.length == 3 && grid[0] > 0 && grid[1] > 0 && grid[2] > 0) {
            this.addNode(maximumsNode, String.valueOf(ViperComputeDictionary.GRID.getLabel(computeKind)) + " Dimensions", "[ " + grid[0] + ", " + grid[1] + ", " + grid[2] + " ]", null, null);
        }
        if ((block = timeline.getMaxBlockDims()) != null && block.length == 3 && block[0] > 0 && block[1] > 0 && block[2] > 0) {
            this.addNode(maximumsNode, String.valueOf(ViperComputeDictionary.BLOCK.getLabel(computeKind)) + " Dimensions", "[ " + block[0] + ", " + block[1] + ", " + block[2] + " ]", null, null);
        }
        if (timeline.getMaxWarpsPerMultiprocessor() > 0) {
            this.addNode(maximumsNode, "Warps per " + ViperComputeDictionary.MULTIPROCESSOR.getLabel(computeKind), timeline.getMaxWarpsPerMultiprocessor(), null, null);
        }
        if (timeline.getMaxBlocksPerMultiprocessor() > 0) {
            this.addNode(maximumsNode, "Blocks per " + ViperComputeDictionary.MULTIPROCESSOR.getLabel(computeKind), timeline.getMaxBlocksPerMultiprocessor(), null, null);
        }
        long tepidClockRate = timeline.getComputeCapabilityMajor() == 2 ? timeline.getCoreClockRate() / 2L : timeline.getCoreClockRate();
        Number flopHp = timeline.getAttributeValue(CuptiDeviceAttribute.CUPTI_DEVICE_ATTR_FLOP_HP);
        if (flopHp != null && flopHp instanceof Long) {
            long flopsHp = flopHp.longValue() * tepidClockRate;
            this.addNode(maximumsNode, "Half Precision FLOP/s", new FlopsFormatter().format(flopsHp), null, "Half Precision floating point operations per second");
        }
        if ((flopSp = timeline.getAttributeValue(CuptiDeviceAttribute.CUPTI_DEVICE_ATTR_FLOP_SP)) != null && flopSp instanceof Long) {
            long flopsSp = flopSp.longValue() * tepidClockRate;
            this.addNode(maximumsNode, "Single Precision FLOP/s", new FlopsFormatter().format(flopsSp), null, "Single Precision floating point operations per second");
        }
        if ((flopDp = timeline.getAttributeValue(CuptiDeviceAttribute.CUPTI_DEVICE_ATTR_FLOP_DP)) != null && flopDp instanceof Long) {
            long flopsDp = flopDp.longValue() * tepidClockRate;
            this.addNode(maximumsNode, "Double Precision FLOP/s", new FlopsFormatter().format(flopsDp), null, "Double Precision floating point operations per second");
        }
        TreeItem smNode = this.addNode(attributesNode, ViperComputeDictionary.MULTIPROCESSOR.getLabel(computeKind), null, null, null);
        if (timeline.getNumMultiprocessors() > 0) {
            this.addNode(smNode, String.valueOf(ViperComputeDictionary.MULTIPROCESSOR.getLabel(computeKind)) + "s", timeline.getNumMultiprocessors(), null, null);
        }
        if (timeline.getCoreClockRate() > 0L) {
            this.addNode(smNode, "Clock Rate", new FrequencyFormatter().format(timeline.getCoreClockRate()), null, null);
        }
        if (timeline.getComputeCapabilityMajor() > 0) {
            this.addNode(smNode, "Concurrent " + ViperComputeDictionary.KERNEL.getLabel(computeKind), timeline.supportsConcurrentKernels(), null, null);
        }
        if (timeline.getMaxIPC() > 0) {
            this.addNode(smNode, "Max IPC", timeline.getMaxIPC(), null, null);
        }
        if (timeline.getNumThreadsPerWarp() > 0) {
            this.addNode(smNode, String.valueOf(ViperComputeDictionary.THREAD.getLabel(computeKind)) + "s per Warp", timeline.getNumThreadsPerWarp(), null, null);
        }
        TreeItem memoryNode = this.addNode(attributesNode, "Memory", null, null, null);
        if (timeline.getGlobalMemoryBandwidth() > 0L) {
            this.addNode(memoryNode, "Global Memory Bandwidth", new BandwidthFormatter(ByteSizeFormatter.Base.KILOBYTE).format(timeline.getGlobalMemoryBandwidth()), null, null);
        }
        if (timeline.getGlobalMemorySize() > 0L) {
            this.addNode(memoryNode, "Global Memory Size", new ByteSizeFormatter(ByteSizeFormatter.Base.KIBIBYTE).format(timeline.getGlobalMemorySize()), null, null);
        }
        if (timeline.getConstantMemorySize() > 0) {
            this.addNode(memoryNode, "Constant Memory Size", new ByteSizeFormatter(ByteSizeFormatter.Base.KIBIBYTE).format(timeline.getConstantMemorySize()), null, null);
        }
        if (timeline.getL2CacheSize() > 0) {
            this.addNode(memoryNode, "L2 Cache Size", new ByteSizeFormatter(ByteSizeFormatter.Base.KIBIBYTE).format(timeline.getL2CacheSize()), null, null);
        }
        if (timeline.getNumMemcpyEngines() > 0) {
            this.addNode(memoryNode, "Memcpy Engines", timeline.getNumMemcpyEngines(), null, null);
        }
        TreeItem pciNode = this.addNode(attributesNode, "PCIe", null, null, null);
        Number pciGen = timeline.getAttributeValue(CuptiDeviceAttribute.CUPTI_DEVICE_ATTR_PCIE_GEN);
        if (pciGen instanceof Long) {
            this.addNode(pciNode, "Generation", pciGen.longValue(), null, null);
        }
        if ((pciRate = timeline.getAttributeValue(CuptiDeviceAttribute.CUPTI_DEVICE_ATTR_PCIE_LINK_RATE)) instanceof Long) {
            this.addNode(pciNode, "Link Rate", new BandwidthFormatter(ByteSizeFormatter.Base.KILOBIT).format(pciRate.longValue() * 1000L * 1000L), null, null);
        }
        if ((pciWidth = timeline.getAttributeValue(CuptiDeviceAttribute.CUPTI_DEVICE_ATTR_PCIE_LINK_WIDTH)) instanceof Long) {
            this.addNode(pciNode, "Link Width", pciWidth.longValue(), null, null);
        }
        TreeItem environmentNode = this.addNode(null, "Environment", null, null, null);
        TreeItem smClockNode = this.addNode(environmentNode, "SM Clock", null, null, null);
        if (timeline.getSmClockAvg() > 0.0) {
            this.addNode(smClockNode, "Avg", new FrequencyFormatter().format((long)timeline.getSmClockAvg() * 1000000L), null, null);
        }
        if (timeline.getSmClockMin() > 0) {
            this.addNode(smClockNode, "Min", new FrequencyFormatter().format((long)timeline.getSmClockMin() * 1000000L), null, null);
        }
        if (timeline.getSmClockMax() > 0) {
            this.addNode(smClockNode, "Max", new FrequencyFormatter().format((long)timeline.getSmClockMax() * 1000000L), null, null);
        }
        if (timeline.getNumClockSamples() > 0) {
            this.addNode(smClockNode, "Samples", timeline.getNumClockSamples(), null, null);
        }
        TreeItem memClockNode = this.addNode(environmentNode, "Memory Clock", null, null, null);
        if (timeline.getMemoryClockAvg() > 0.0) {
            this.addNode(memClockNode, "Avg", new FrequencyFormatter().format((long)timeline.getMemoryClockAvg() * 1000000L), null, null);
        }
        if (timeline.getMemoryClockMin() > 0) {
            this.addNode(memClockNode, "Min", new FrequencyFormatter().format((long)timeline.getMemoryClockMin() * 1000000L), null, null);
        }
        if (timeline.getMemoryClockMax() > 0) {
            this.addNode(memClockNode, "Max", new FrequencyFormatter().format((long)timeline.getMemoryClockMax() * 1000000L), null, null);
        }
        if (timeline.getNumClockSamples() > 0) {
            this.addNode(memClockNode, "Samples", timeline.getNumClockSamples(), null, null);
        }
        TreeItem temperatureNode = this.addNode(environmentNode, "Temperature", null, null, null);
        if (timeline.getTemperatureAvg() > 0) {
            this.addNode(temperatureNode, "Avg", String.valueOf(timeline.getTemperatureAvg()) + " " + SYMBOL_DEGREE_CELSIUS, null, null);
        }
        if (timeline.getTemperatureMin() > 0) {
            this.addNode(temperatureNode, "Min", String.valueOf(timeline.getTemperatureMin()) + " " + SYMBOL_DEGREE_CELSIUS, null, null);
        }
        if (timeline.getTemperatureMax() > 0) {
            this.addNode(temperatureNode, "Max", String.valueOf(timeline.getTemperatureMax()) + " " + SYMBOL_DEGREE_CELSIUS, null, null);
        }
        if (timeline.getNumTemperatureSamples() > 0) {
            this.addNode(temperatureNode, "Samples", timeline.getNumTemperatureSamples(), null, null);
        }
        TreeItem powerNode = this.addNode(environmentNode, "Power", null, null, null);
        if (timeline.getPowerAvg() > 0.0) {
            this.addNode(powerNode, "Avg", new PowerFormatter().format(timeline.getPowerAvg() / 1000.0), null, null);
        }
        if (timeline.getPowerMin() > 0) {
            this.addNode(powerNode, "Min", new PowerFormatter().format((double)timeline.getPowerMin() / 1000.0), null, null);
        }
        if (timeline.getPowerMax() > 0) {
            this.addNode(powerNode, "Max", new PowerFormatter().format((double)timeline.getPowerMax() / 1000.0), null, null);
        }
        if (timeline.getNumPowerSamples() > 0) {
            this.addNode(powerNode, "Samples", timeline.getNumPowerSamples(), null, null);
        }
        TreeItem fanNode = this.addNode(environmentNode, "Fan", null, null, null);
        if (timeline.getFanSpeedAvg() > 0.0) {
            this.addNode(fanNode, "Avg", percentIntegerFormatter.format(timeline.getFanSpeedAvg() / 100.0), null, null);
        }
        if (timeline.getFanSpeedMin() > 0) {
            this.addNode(fanNode, "Min", percentIntegerFormatter.format((double)timeline.getFanSpeedMin() / 100.0), null, null);
        }
        if (timeline.getFanSpeedMax() > 0) {
            this.addNode(fanNode, "Max", percentIntegerFormatter.format((double)timeline.getFanSpeedMax() / 100.0), null, null);
        }
        if (timeline.getNumFanSpeedSamples() > 0) {
            this.addNode(fanNode, "Samples", timeline.getNumFanSpeedSamples(), null, null);
        }
        if (attributesNode.getItemCount() > 0) {
            attributesNode.setExpanded(true);
        } else {
            attributesNode.dispose();
        }
        if (memoryNode.getItemCount() > 0) {
            memoryNode.setExpanded(true);
        } else {
            memoryNode.dispose();
        }
        if (smNode.getItemCount() > 0) {
            smNode.setExpanded(true);
        } else {
            smNode.dispose();
        }
        if (pciNode.getItemCount() > 0) {
            pciNode.setExpanded(true);
        } else {
            pciNode.dispose();
        }
        if (maximumsNode.getItemCount() > 0) {
            maximumsNode.setExpanded(true);
        } else {
            maximumsNode.dispose();
        }
        if (environmentNode.getItemCount() > 0) {
            environmentNode.setExpanded(true);
        } else {
            environmentNode.dispose();
        }
        if (smClockNode.getItemCount() > 0) {
            smClockNode.setExpanded(true);
        } else {
            smClockNode.dispose();
        }
        if (memClockNode.getItemCount() > 0) {
            memClockNode.setExpanded(true);
        } else {
            memClockNode.dispose();
        }
        if (temperatureNode.getItemCount() > 0) {
            temperatureNode.setExpanded(true);
        } else {
            temperatureNode.dispose();
        }
        if (powerNode.getItemCount() > 0) {
            powerNode.setExpanded(true);
        } else {
            powerNode.dispose();
        }
        if (fanNode.getItemCount() > 0) {
            fanNode.setExpanded(true);
        } else {
            fanNode.dispose();
        }
    }

    protected TreeItem addNode(TreeItem parent, String label, Object value, Image image, String tooltip) {
        TreeItem item = parent != null ? new TreeItem(parent, 0) : new TreeItem(this.tree, 0);
        item.setText(new String[]{label, value == null ? null : value.toString()});
        if (image != null) {
            Image[] imageArray = new Image[2];
            imageArray[1] = image;
            item.setImage(imageArray);
        }
        if (tooltip != null) {
            this.nodeTooltips.put(item, tooltip);
        }
        return item;
    }

    protected Image getAnalysisImage(AnalysisDescriptor.Severity severity) {
        switch (severity) {
            case INFO: 
            case OK: {
                return null;
            }
        }
        return ViperImages.getAnalysisImageForSeverity(severity);
    }

    protected TreeItem addDuration(TreeItem parent) {
        TreeItem duration = this.addNode(parent, "Duration", null, null, "the total duration of the session");
        this.addNode(duration, "Session", new PreciseTimeFormatter(this.activeSession.getDuration()), null, null);
        duration.setExpanded(true);
        return duration;
    }

    protected TreeItem addMarkerData(TreeItem parent, CuptiActivityMarkerData data) {
        TreeItem node = this.addNode(parent, "Extended", null, null, null);
        this.addNode(node, "Category", new Integer(data.category), null, null);
        String valueString = null;
        Number value = data.getPayload();
        if (value != null) {
            valueString = CuptiMetricValueKind.CUPTI_METRIC_VALUE_KIND_PERCENT.equals((Object)data.getPayloadKind()) ? percentFormatter.format(value.doubleValue() / 100.0) : (CuptiMetricValueKind.CUPTI_METRIC_VALUE_KIND_THROUGHPUT.equals((Object)data.getPayloadKind()) ? new BandwidthFormatter(ByteSizeFormatter.Base.KILOBYTE).format(value.longValue()) : numberFormatter.format(value));
        }
        if (valueString != null) {
            this.addNode(node, "Payload", valueString, null, null);
        }
        node.setExpanded(true);
        return node;
    }

    public void setSession(Session session) {
        if (this.activeSession != session) {
            if (this.activeSession != null) {
                this.activeSession.removePropertyChangeListener(this);
            }
            this.activeSession = session;
            if (session != null) {
                this.activeSession.addPropertyChangeListener(this);
                this.setInput(this.activeSession.getPrimarySelected(), false);
            } else {
                this.setInput(null, false);
            }
        }
    }

    @Override
    public void propertyChange(IModel model, String propertyName) {
        if ("session:sInterval".equals(propertyName)) {
            this.handleSelectedInterval(((Session)model).getPrimarySelected(), ((Session)model).getSecondarySelected());
            this.handleHighlightedInterval(this.activeSession.getPrimaryHighlighted());
        } else if ("session:hInterval".equals(propertyName)) {
            this.handleHighlightedInterval(this.activeSession.getPrimaryHighlighted());
        } else if ("session:analysis".equals(propertyName)) {
            this.setInput(this.input, true);
        }
    }

    public Session getSession() {
        return this.activeSession;
    }

    protected void handleHighlightedInterval(TimelineIntervalPair pair) {
        if (pair == null) {
            this.setInput(this.activeSession.getSecondarySelected() == null ? this.activeSession.getPrimarySelected() : null, false);
        } else if (this.activeSession.getPrimarySelected() == null) {
            this.setInput(pair, false);
        } else {
            Collection<Long> selected = this.activeSession.getAllSelectedIntervalIds();
            if (selected != null && pair.getInterval(this.activeSession) != null && selected.contains(pair.getInterval(this.activeSession).getID())) {
                this.setInput(pair, false);
            } else {
                this.setInput(this.activeSession.getSecondarySelected() == null ? this.activeSession.getPrimarySelected() : null, false);
            }
        }
    }

    protected void handleSelectedInterval(TimelineIntervalPair primary, Collection<TimelineIntervalPair> secondary) {
        if (secondary != null && !secondary.isEmpty()) {
            this.setInput(null, false);
        } else {
            this.setInput(primary, false);
        }
    }

    public boolean setFocus() {
        if (this.tree != null) {
            return this.tree.setFocus();
        }
        return super.setFocus();
    }
}

