/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.ide.launch;

import com.nvidia.viper.ide.ViperIDEUtil;
import com.nvidia.viper.ide.launch.LaunchConfigurationAdapter;
import com.nvidia.viper.model.Session;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;

public final class LaunchConfigurationEditorInput
implements IEditorInput,
IPersistableElement {
    private final String name;
    private Session session;
    private final boolean remote;

    public LaunchConfigurationEditorInput(String name, boolean remote) {
        this.name = name;
        this.remote = remote;
    }

    public boolean exists() {
        return LaunchConfigurationAdapter.getLaunchConfigurationAdapter(this.name, this.isRemote()) != null;
    }

    public boolean isRemote() {
        return this.session == null ? this.remote : ViperIDEUtil.isRemote(this.session);
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public String getFactoryId() {
        return "com.nvidia.viper.ide.editorInputFactory";
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getName() {
        return this.name;
    }

    public IPersistableElement getPersistable() {
        return this;
    }

    public Session getSession() {
        return this.session;
    }

    public String getToolTipText() {
        return String.format("Timeline for session %s", this.name);
    }

    public void saveState(IMemento memento) {
        memento.putString("launchConfiguration", this.name);
        memento.putBoolean("isRemote", this.isRemote());
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LaunchConfigurationEditorInput other = (LaunchConfigurationEditorInput)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public static final class Factory
    implements IElementFactory {
        private static final String ATTR_LAUNCH_CONFIGURATION = "launchConfiguration";
        private static final String ATTR_IS_REMOTE = "isRemote";
        public static final String ID = "com.nvidia.viper.ide.editorInputFactory";

        public IAdaptable createElement(IMemento memento) {
            boolean isRemote;
            String name = memento.getString(ATTR_LAUNCH_CONFIGURATION);
            LaunchConfigurationAdapter configuration = LaunchConfigurationAdapter.getLaunchConfigurationAdapter(name, isRemote = Boolean.TRUE.equals(memento.getBoolean(ATTR_IS_REMOTE)));
            if (configuration != null) {
                return new LaunchConfigurationEditorInput(name, isRemote);
            }
            return null;
        }
    }
}

