/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.model.query;

import com.nvidia.cuda.ide.debug.model.Block;
import com.nvidia.cuda.ide.debug.model.CudaCoord;
import com.nvidia.cuda.ide.debug.model.Device;
import com.nvidia.cuda.ide.debug.model.ElementType;
import com.nvidia.cuda.ide.debug.model.ICudaRuntimeObject;
import com.nvidia.cuda.ide.debug.model.Kernel;
import com.nvidia.cuda.ide.debug.model.StreamingMultiprocessor;
import com.nvidia.cuda.ide.debug.model.Warp;
import com.nvidia.cuda.ide.debug.model.query.AndQuery;
import com.nvidia.cuda.ide.debug.model.query.IElementQuery;
import com.nvidia.cuda.ide.debug.model.query.IFilterCondition;
import com.nvidia.cuda.ide.debug.model.query.NoneElementQuery;
import com.nvidia.cuda.ide.debug.model.query.OrQuery;
import com.nvidia.cuda.ide.debug.ui.viewmodel.filters.parser.FilterStringLexer;
import com.nvidia.cuda.ide.debug.ui.viewmodel.filters.parser.FilterStringParser;
import com.nvidia.cuda.ide.debug.util.DebugUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.TreeSet;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;

public class ElementQuery
implements IElementQuery {
    public static final IElementQuery ALL_ELEMENTS = new ElementQuery();
    public static final String PROPERTY = ElementQuery.class.getName();
    public static final IElementQuery NONE = NoneElementQuery.INSTANCE;
    private final Collection<IFilterCondition> conditions = new HashSet<IFilterCondition>();

    public ElementQuery() {
    }

    public ElementQuery(IFilterCondition ... conditions) {
        this(Arrays.asList(conditions));
    }

    private ElementQuery(Collection<IFilterCondition> conditions) {
        this.conditions.addAll(conditions);
    }

    public void add(IFilterCondition condition) {
        this.conditions.add(condition);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.conditions == null ? 0 : this.conditions.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ElementQuery other = (ElementQuery)obj;
        if (this.conditions == null) {
            if (other.conditions != null) {
                return false;
            }
        } else {
            Collection<IFilterCondition> otherConditions = other.conditions;
            if (otherConditions.size() != this.conditions.size()) {
                return false;
            }
            for (IFilterCondition condition : otherConditions) {
                if (this.conditions.contains(condition)) continue;
                return false;
            }
        }
        return true;
    }

    public static IElementQuery parse(String queryString) throws RecognitionException {
        if (DebugUtil.isNullOrEmpty(queryString)) {
            return ALL_ELEMENTS;
        }
        ANTLRStringStream stream = new ANTLRStringStream(queryString.trim().toLowerCase());
        FilterStringLexer lexer = new FilterStringLexer((CharStream)stream);
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
        FilterStringParser parser = new FilterStringParser((TokenStream)tokenStream);
        try {
            parser.filters();
        }
        catch (IllegalArgumentException e) {
            if (e.getCause() instanceof RecognitionException) {
                throw (RecognitionException)e.getCause();
            }
            throw e;
        }
        return parser.factory.getQuery();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        for (IFilterCondition condition : this.conditions) {
            buffer.append(condition).append(' ');
        }
        return buffer.toString().trim();
    }

    @Override
    public boolean hasNoFilters() {
        return this.hasConditions(this.conditions);
    }

    private boolean hasConditions(Collection<IFilterCondition> c) {
        if (!c.isEmpty()) {
            for (IFilterCondition condition : c) {
                if (condition.isAllElements()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean hasHardwareFilters() {
        for (IFilterCondition condition : this.conditions) {
            if (!condition.isHardware()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasLogicalFilters() {
        for (IFilterCondition condition : this.conditions) {
            if (condition.isHardware()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean match(ICudaRuntimeObject object) {
        if (this.conditions.size() == 0) {
            return true;
        }
        for (IFilterCondition condition : this.conditions) {
            if (!condition.matches(object)) continue;
            return true;
        }
        return false;
    }

    @Override
    public CudaCoord[] filterBlocks(Kernel kernel) {
        TreeSet<CudaCoord> blocks = new TreeSet<CudaCoord>();
        if (this.conditions.isEmpty()) {
            return null;
        }
        for (IFilterCondition condition : this.conditions) {
            CudaCoord[] array = condition.filterBlocks(kernel);
            if (array == null) {
                return null;
            }
            blocks.addAll(Arrays.asList(array));
        }
        return blocks.toArray(new CudaCoord[blocks.size()]);
    }

    @Override
    public CudaCoord[] filterThreads(Block block) {
        TreeSet<CudaCoord> threads = new TreeSet<CudaCoord>();
        if (this.conditions.isEmpty()) {
            return null;
        }
        for (IFilterCondition condition : this.conditions) {
            CudaCoord[] filterThreads = condition.filterThreads(block);
            if (filterThreads != null) {
                threads.addAll(Arrays.asList(filterThreads));
                continue;
            }
            return null;
        }
        return threads.toArray(new CudaCoord[threads.size()]);
    }

    @Override
    public IElementQuery getHardwareQuery() {
        return this.createCopy(true);
    }

    private IElementQuery createCopy(boolean hw) {
        HashSet<IFilterCondition> newConditions = new HashSet<IFilterCondition>();
        for (IFilterCondition condition : this.conditions) {
            if (condition.isHardware() != hw) continue;
            newConditions.add(condition);
        }
        return new ElementQuery(newConditions);
    }

    @Override
    public IElementQuery getLogicalQuery() {
        return this.createCopy(false);
    }

    public static IElementQuery or(IElementQuery[] queries) {
        return ElementQuery.or(queries, 0, queries.length);
    }

    private static IElementQuery or(IElementQuery[] queries, int from, int length) {
        IElementQuery q2;
        IElementQuery q1;
        if (length == 0) {
            return NONE;
        }
        if (length == 1) {
            return queries[from];
        }
        if (length == 2) {
            q1 = queries[from];
            q2 = queries[from + 1];
        } else {
            int l = length / 2;
            q1 = ElementQuery.or(queries, from, l);
            q2 = ElementQuery.or(queries, from + l, length - l);
        }
        if (q1.hasNoFilters() || q2.hasNoFilters()) {
            return ALL_ELEMENTS;
        }
        if (q1 == NONE) {
            return q2;
        }
        if (q2 == NONE) {
            return q1;
        }
        return new OrQuery(q1, q2);
    }

    public static IElementQuery and(IElementQuery ... queries) {
        return ElementQuery.and(queries, 0, queries.length);
    }

    private static IElementQuery and(IElementQuery[] queries, int offset, int length) {
        IElementQuery q2;
        IElementQuery q1;
        if (length == 1) {
            return queries[offset];
        }
        if (length == 2) {
            q1 = queries[offset];
            q2 = queries[offset + 1];
        } else {
            int l = length / 2;
            q1 = ElementQuery.and(queries, offset, l);
            q2 = ElementQuery.and(queries, offset + l, length);
        }
        if (q1 == NONE || q2 == NONE) {
            return NONE;
        }
        if (q1.hasNoFilters()) {
            return q2;
        }
        if (q2.hasNoFilters()) {
            return q1;
        }
        return new AndQuery(q1, q2);
    }

    @Override
    public byte[] filterWarps(StreamingMultiprocessor sm) {
        if (this.conditions.isEmpty()) {
            return null;
        }
        long flags = 0L;
        for (IFilterCondition condition : this.conditions) {
            flags |= condition.getEnabledWarps(sm);
        }
        if ((flags & Long.MIN_VALUE) != 0L) {
            return null;
        }
        return DebugUtil.bitmaskToArray(flags);
    }

    @Override
    public byte[] filterSMs(Device device) {
        if (this.conditions.isEmpty()) {
            return null;
        }
        long flags = 0L;
        for (IFilterCondition condition : this.conditions) {
            flags |= condition.getEnabledSMs(device);
        }
        if ((flags & Long.MIN_VALUE) != 0L) {
            return null;
        }
        return DebugUtil.bitmaskToArray(flags);
    }

    @Override
    public byte[] filterLanes(Warp warp) {
        if (this.conditions.isEmpty()) {
            return null;
        }
        long flags = 0L;
        for (IFilterCondition condition : this.conditions) {
            flags |= condition.getEnabledLanes(warp);
        }
        if ((flags & Long.MIN_VALUE) != 0L) {
            return null;
        }
        return DebugUtil.bitmaskToArray(flags);
    }

    @Override
    public ElementType getElementType() {
        ElementType type = ElementType.application;
        for (IFilterCondition condition : this.conditions) {
            ElementType type2 = condition.getElementType();
            if (type2.ordinal() >= type.ordinal()) continue;
            type = type2;
        }
        return type;
    }
}

