/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.model;

import com.nvidia.viper.model.TimelineIntervalBase;
import com.nvidia.viper.model.TimelineIntervalKind;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public class TimelineIntervalHierarchy
extends TimelineIntervalBase {
    protected TimelineIntervalHierarchy parent = null;
    protected List<TimelineIntervalHierarchy> children = null;

    public TimelineIntervalHierarchy(TimelineIntervalKind kind, long start, long end, long id) {
        super(kind, start, end, id);
    }

    public long getGridId() {
        return 0L;
    }

    public long getParentGridId() {
        return 0L;
    }

    public TimelineIntervalHierarchy getParent() {
        return this.parent;
    }

    public List<TimelineIntervalHierarchy> getChildren() {
        return this.children;
    }

    public boolean hasChildren() {
        if (this.children != null) {
            return this.children.size() > 0;
        }
        return false;
    }

    public void getAncestors(Collection<TimelineIntervalHierarchy> ancestors) {
        if (this.parent != null) {
            ancestors.add(this.parent);
            this.parent.getAncestors(ancestors);
        }
    }

    public TimelineIntervalHierarchy getOldestAncestor() {
        if (this.parent == null) {
            return this;
        }
        return this.parent.getOldestAncestor();
    }

    public void getDescendants(Collection<TimelineIntervalHierarchy> descendants) {
        if (this.children != null) {
            for (TimelineIntervalHierarchy child : this.children) {
                descendants.add(child);
                child.getDescendants(descendants);
            }
        }
    }

    public TimelineIntervalHierarchy findFirstDescendant(List<TimelineIntervalKind> kinds) {
        if (this.children == null) {
            return null;
        }
        for (TimelineIntervalHierarchy child : this.children) {
            if (!kinds.contains((Object)child.getKind())) continue;
            return child;
        }
        for (TimelineIntervalHierarchy child : this.children) {
            TimelineIntervalHierarchy desc = child.findFirstDescendant(kinds);
            if (desc == null) continue;
            return desc;
        }
        return null;
    }

    public boolean addChild(TimelineIntervalHierarchy child) {
        TimelineIntervalHierarchy parent = child.getParent();
        if (parent != null) {
            parent.removeChild(child);
        }
        if (this.children == null) {
            this.children = new LinkedList<TimelineIntervalHierarchy>();
        }
        this.children.add(child);
        child.parent = this;
        return true;
    }

    public boolean removeChild(TimelineIntervalHierarchy child) {
        TimelineIntervalHierarchy parent = child.parent;
        if (parent != this || this.children == null) {
            return false;
        }
        boolean ret = this.children.remove(child);
        if (ret) {
            child.parent = null;
        }
        return ret;
    }
}

