/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import java.util.Arrays;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTDeleteExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNewExpression;

public enum OverloadableOperator {
    GT(">"),
    LT("<"),
    NOT("!"),
    BITCOMPLEMENT("~"),
    BITOR("|"),
    AMPER("&"),
    XOR("^"),
    MOD("%"),
    DIV("/"),
    STAR("*"),
    PLUS("+"),
    BRACKET("[]"),
    PAREN("()"),
    ARROW("->"),
    ARROWSTAR("->*"),
    COMMA(","),
    MINUS("-"),
    DECR("--"),
    INCR("++"),
    OR("||"),
    AND("&&"),
    ASSIGN("="),
    GTEQUAL(">="),
    LTEQUAL("<="),
    NOTEQUAL("!="),
    EQUAL("=="),
    SHIFTR(">>"),
    SHIFTL("<<"),
    SHIFTLASSIGN("<<="),
    SHIFTRASSIGN(">>="),
    BITORASSIGN("|="),
    AMPERASSIGN("&="),
    XORASSIGN("^="),
    MODASSIGN("%="),
    DIVASSIGN("/="),
    STARASSIGN("*="),
    MINUSASSIGN("-="),
    PLUSASSIGN("+="),
    NEW("new"),
    DELETE_ARRAY("delete[]"),
    DELETE("delete"),
    NEW_ARRAY("new[]"),
    CONDITIONAL_OPERATOR("?");

    private final char[] rep;

    private OverloadableOperator(String rep) {
        this.rep = ("operator " + rep).toCharArray();
    }

    public char[] toCharArray() {
        return this.rep;
    }

    public static boolean isNew(char[] name) {
        return Arrays.equals(name, OverloadableOperator.NEW.rep) || Arrays.equals(name, OverloadableOperator.NEW_ARRAY.rep);
    }

    public static boolean isDelete(char[] name) {
        return Arrays.equals(name, OverloadableOperator.DELETE.rep) || Arrays.equals(name, OverloadableOperator.DELETE_ARRAY.rep);
    }

    public static OverloadableOperator fromBinaryExpression(int binaryOp) {
        switch (binaryOp) {
            case 12: {
                return AMPER;
            }
            case 25: {
                return AMPERASSIGN;
            }
            case 31: {
                return ARROW;
            }
            case 14: {
                return BITOR;
            }
            case 27: {
                return BITORASSIGN;
            }
            case 6: {
                return SHIFTL;
            }
            case 23: {
                return SHIFTLASSIGN;
            }
            case 7: {
                return SHIFTR;
            }
            case 24: {
                return SHIFTRASSIGN;
            }
            case 13: {
                return XOR;
            }
            case 26: {
                return XORASSIGN;
            }
            case 15: {
                return AND;
            }
            case 16: {
                return OR;
            }
            case 2: {
                return DIV;
            }
            case 19: {
                return DIVASSIGN;
            }
            case 5: {
                return MINUS;
            }
            case 22: {
                return MINUSASSIGN;
            }
            case 3: {
                return MOD;
            }
            case 20: {
                return MODASSIGN;
            }
            case 4: {
                return PLUS;
            }
            case 21: {
                return PLUSASSIGN;
            }
            case 1: {
                return STAR;
            }
            case 18: {
                return STARASSIGN;
            }
            case 28: {
                return EQUAL;
            }
            case 29: {
                return NOTEQUAL;
            }
            case 9: {
                return GT;
            }
            case 11: {
                return GTEQUAL;
            }
            case 8: {
                return LT;
            }
            case 10: {
                return LTEQUAL;
            }
            case 17: {
                return ASSIGN;
            }
        }
        return null;
    }

    public static OverloadableOperator fromUnaryExpression(int unaryOp) {
        switch (unaryOp) {
            case 0: {
                return INCR;
            }
            case 1: {
                return DECR;
            }
            case 2: {
                return PLUS;
            }
            case 3: {
                return MINUS;
            }
            case 4: {
                return STAR;
            }
            case 5: {
                return AMPER;
            }
            case 6: {
                return BITCOMPLEMENT;
            }
            case 7: {
                return NOT;
            }
            case 9: {
                return INCR;
            }
            case 10: {
                return DECR;
            }
        }
        return null;
    }

    public static OverloadableOperator fromDeleteExpression(ICPPASTDeleteExpression expression) {
        return expression.isVectored() ? DELETE_ARRAY : DELETE;
    }

    public static OverloadableOperator fromNewExpression(ICPPASTNewExpression expression) {
        return expression.isArrayAllocation() ? NEW_ARRAY : NEW;
    }

    public static OverloadableOperator valueOf(String string) {
        return Enum.valueOf(OverloadableOperator.class, string);
    }
}

