/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper;

import java.text.NumberFormat;

public class TimeFormatter {
    public static final String FORMAT_NS = "ns";
    public static final String FORMAT_US = "\u00b5s";
    public static final String FORMAT_MS = "ms";
    public static final String FORMAT_S = "s";
    private String format = null;
    private long divisor = 1L;
    private static NumberFormat formatter = NumberFormat.getInstance();

    static {
        formatter.setMaximumFractionDigits(3);
    }

    public TimeFormatter() {
    }

    public TimeFormatter(long ns) {
        this.initFormat(ns);
    }

    public String format(long ns) {
        return this.format(ns, true);
    }

    public String format(long ns, boolean group) {
        if (this.format == null) {
            this.initFormat(ns);
        }
        formatter.setGroupingUsed(group);
        double fns = (double)ns / (double)this.divisor;
        return String.valueOf(formatter.format(fns)) + " " + this.format;
    }

    protected void initFormat(long ns) {
        if (ns < 1000L) {
            this.format = FORMAT_NS;
            this.divisor = 1L;
        } else if (ns < 1000000L) {
            this.format = FORMAT_US;
            this.divisor = 1000L;
        } else if (ns < 1000000000L) {
            this.format = FORMAT_MS;
            this.divisor = 1000000L;
        } else {
            this.format = FORMAT_S;
            this.divisor = 1000000000L;
        }
    }

    public TimeFormatter(double ns) {
        this.initFormat(ns);
    }

    private void initFormat(double ns) {
        if (ns < 1000.0) {
            this.format = FORMAT_NS;
            this.divisor = 1L;
        } else if (ns < 1000000.0) {
            this.format = FORMAT_US;
            this.divisor = 1000L;
        } else if (ns < 1.0E9) {
            this.format = FORMAT_MS;
            this.divisor = 1000000L;
        } else {
            this.format = FORMAT_S;
            this.divisor = 1000000000L;
        }
    }

    public String format(double ns, boolean group) {
        if (this.format == null) {
            this.initFormat(ns);
        }
        formatter.setGroupingUsed(group);
        double fns = ns / (double)this.divisor;
        return String.valueOf(formatter.format(fns)) + " " + this.format;
    }

    public void setFractionDigits(int digits) {
        formatter.setMaximumFractionDigits(digits);
    }
}

