/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.core.subscribers;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.internal.core.Policy;
import org.eclipse.team.internal.core.TeamPlugin;

public abstract class AbstractContentComparator {
    private boolean ignoreWhitespace = false;

    public AbstractContentComparator(boolean ignoreWhitespace) {
        this.ignoreWhitespace = ignoreWhitespace;
    }

    public boolean compare(IResource e1, IResourceVariant e2, IProgressMonitor monitor) {
        return this.compareObjects(e1, e2, monitor);
    }

    public boolean compare(IResource e1, IFileRevision e2, IProgressMonitor monitor) {
        return this.compareObjects(e1, e2, monitor);
    }

    /*
     * Loose catch block
     */
    private boolean compareObjects(Object e1, Object e2, IProgressMonitor monitor) {
        InputStream is1 = null;
        InputStream is2 = null;
        monitor.beginTask(null, 100);
        is1 = this.getContents(e1, Policy.subMonitorFor(monitor, 30));
        is2 = this.getContents(e2, Policy.subMonitorFor(monitor, 30));
        boolean bl = this.contentsEqual(Policy.subMonitorFor(monitor, 40), is1, is2, this.shouldIgnoreWhitespace());
        try {
            try {
                if (is1 != null) {
                    is1.close();
                }
            }
            finally {
                if (is2 != null) {
                    is2.close();
                }
            }
        }
        catch (IOException iOException) {}
        monitor.done();
        return bl;
        catch (TeamException e) {
            try {
                TeamPlugin.log(e);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        if (is1 != null) {
                            is1.close();
                        }
                    }
                    finally {
                        if (is2 != null) {
                            is2.close();
                        }
                    }
                }
                catch (IOException iOException) {}
                monitor.done();
                throw throwable;
            }
            try {
                try {
                    if (is1 != null) {
                        is1.close();
                    }
                }
                finally {
                    if (is2 != null) {
                        is2.close();
                    }
                }
            }
            catch (IOException iOException) {}
            monitor.done();
            return false;
        }
    }

    protected boolean shouldIgnoreWhitespace() {
        return this.ignoreWhitespace;
    }

    protected abstract boolean contentsEqual(IProgressMonitor var1, InputStream var2, InputStream var3, boolean var4);

    private InputStream getContents(Object resource, IProgressMonitor monitor) throws TeamException {
        try {
            if (resource instanceof IFile) {
                return new BufferedInputStream(((IFile)resource).getContents());
            }
            if (resource instanceof IResourceVariant) {
                IResourceVariant remote = (IResourceVariant)resource;
                if (!remote.isContainer()) {
                    return new BufferedInputStream(remote.getStorage(monitor).getContents());
                }
            } else if (resource instanceof IFileRevision) {
                IFileRevision remote = (IFileRevision)resource;
                return new BufferedInputStream(remote.getStorage(monitor).getContents());
            }
            return null;
        }
        catch (CoreException e) {
            throw TeamException.asTeamException(e);
        }
    }
}

