#!/usr/bin/env python

# SPDX-FileCopyrightText: Copyright (c) 2021-2023 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
# SPDX-License-Identifier: LicenseRef-NvidiaProprietary
#
# NVIDIA CORPORATION, its affiliates and licensors retain all intellectual
# property and proprietary rights in and to this material, related
# documentation and any modifications thereto. Any use, reproduction,
# disclosure or distribution of this material and related documentation
# without an express license agreement from NVIDIA CORPORATION or
# its affiliates is strictly prohibited.

import nsysstats

class UmCpuPageFaultsSum(nsysstats.StatsReport):

    display_name = 'Unified Memory CPU Page Faults Summary'
    usage = f"""{{SCRIPT}} -- {{DISPLAY_NAME}}

    Output:
        CPU Page Faults : Number of CPU page faults that occurred
        CPU Instruction Address : Address of the CPU instruction that caused the CPU page faults

    This report provides a summary of CPU page faults for unified memory.
"""

    query = """
WITH
    summary AS (
        SELECT
            CpuInstruction AS sourceId,
            count(*) AS num
        FROM
            CUDA_UM_CPU_PAGE_FAULT_EVENTS
        GROUP BY 1
    )
SELECT
    summary.num AS "CPU Page Faults",
    ids.value AS "CPU Instruction Address"
FROM
    summary
LEFT JOIN
    StringIds AS ids
    ON ids.id == summary.sourceId
ORDER BY 1 DESC -- CPU Page Faults
;
"""

    table_checks = {
        'StringIds': '{DBFILE} file does not contain StringIds table.',
        'CUDA_UM_CPU_PAGE_FAULT_EVENTS':
            "{DBFILE} does not contain CUDA Unified Memory CPU page faults data."
    }

if __name__ == "__main__":
    UmCpuPageFaultsSum.Main()
