/*###############################################################################
# Linux Management Providers (LMP), Boot provider package
# Copyright (C) 2009 Nodir Nazarov <nazarov.nodir@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#include "OpenDRIM_BootServiceAccess.h"

const string systemCreationClassName = "OpenDRIM_ComputerSystem";
const string creationClassName = "OpenDRIM_BootService";
const string Name = "/usr/sbin/grub";
string systemName;

int Boot_OpenDRIM_BootService_load(const CMPIBroker* broker, string& errorMessage) {
	_E_;
	CF_assert(CF_getSystemName(systemName, errorMessage));
	_L_;
	return OK;
}

int Boot_OpenDRIM_BootService_unload(string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return OK;
}

int Boot_OpenDRIM_BootService_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_BootService>& result, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	if(!CF_isExist(Name))
		return OK;
	
	OpenDRIM_BootService instance;
	instance.setSystemCreationClassName(systemCreationClassName);
	instance.setSystemName(systemName);
	instance.setCreationClassName(creationClassName);
	instance.setName(Name);

	if(discriminant=="ei")
		CF_assert(Boot_OpenDRIM_BootService_populate(instance, errorMessage));
	
	result.push_back(instance);
	_L_;
	return OK;
}

int Boot_OpenDRIM_BootService_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_BootService& instance, const char** properties, string& errorMessage) {
	_E_;
	if (instance.SystemCreationClassName != systemCreationClassName ||
			instance.CreationClassName != creationClassName ||
			instance.SystemName != systemName ||
			instance.Name != Name ||
			!CF_isExist(Name))
	{
		errorMessage = "Invalid path";
		return NOT_FOUND;
	}
	
	CF_assert(Boot_OpenDRIM_BootService_populate(instance, errorMessage));
	_L_;
	return OK;
}

int Boot_OpenDRIM_BootService_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_BootService& newInstance, const OpenDRIM_BootService& oldInstance, const char** properties, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int Boot_OpenDRIM_BootService_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_BootService& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int Boot_OpenDRIM_BootService_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_BootService& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int Boot_OpenDRIM_BootService_RequestStateChange(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_BootService& instance, unsigned int& returnValue, const OpenDRIM_BootService_RequestStateChange_In& in, OpenDRIM_BootService_RequestStateChange_Out& out, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int Boot_OpenDRIM_BootService_StartService(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_BootService& instance, unsigned int& returnValue, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int Boot_OpenDRIM_BootService_StopService(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_BootService& instance, unsigned int& returnValue, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int Boot_OpenDRIM_BootService_CreateBootConfigSetting(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_BootService& instance, unsigned int& returnValue, const OpenDRIM_BootService_CreateBootConfigSetting_In& in, OpenDRIM_BootService_CreateBootConfigSetting_Out& out, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int Boot_OpenDRIM_BootService_SetBootConfigRole(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_BootService& instance, unsigned int& returnValue, const OpenDRIM_BootService_SetBootConfigRole_In& in, OpenDRIM_BootService_SetBootConfigRole_Out& out, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int Boot_OpenDRIM_BootService_SetBootConfigUsage(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_BootService& instance, unsigned int& returnValue, const OpenDRIM_BootService_SetBootConfigUsage_In& in, OpenDRIM_BootService_SetBootConfigUsage_Out& out, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int Boot_OpenDRIM_BootService_ApplyBootConfigSetting(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_BootService& instance, unsigned int& returnValue, const OpenDRIM_BootService_ApplyBootConfigSetting_In& in, OpenDRIM_BootService_ApplyBootConfigSetting_Out& out, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int Boot_OpenDRIM_BootService_populate(OpenDRIM_BootService& instance, string& errorMessage) {
	_E_;
	string elementName;
	
	CF_getWhatisFL("grub", elementName, errorMessage);;
	instance.setElementName(elementName);
	_L_;
	return OK;
}

